/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Optional;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.VoidNamespaceSerializer;
import org.apache.flink.streaming.api.SimpleTimerService;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.streaming.api.operators.Triggerable;
import org.apache.flink.streaming.api.operators.TwoInputStreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.runtime.CRowWrappingCollector;
import org.apache.flink.table.runtime.join.RowtimeComparator;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.typeutils.TypeCheckUtils$;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConversions$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015h\u0001B\u0001\u0003\u0001=\u00111\u0003V3na>\u0014\u0018\r\u001c*poRLW.\u001a&pS:T!a\u0001\u0003\u0002\t)|\u0017N\u001c\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\r\u0001\u0001\u0002eI\u001aH!\r\t\u0002DG\u0007\u0002%)\u00111\u0003F\u0001\n_B,'/\u0019;peNT!!\u0006\f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0018\u0011\u0005I1\u000f\u001e:fC6LgnZ\u0005\u00033I\u0011a#\u00112tiJ\f7\r^*ue\u0016\fWn\u00149fe\u0006$xN\u001d\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0011\tQ\u0001^=qKNL!a\b\u000f\u0003\t\r\u0013vn\u001e\t\u0006#\u0005R\"DG\u0005\u0003EI\u0011a\u0003V<p\u0013:\u0004X\u000f^*ue\u0016\fWn\u00149fe\u0006$xN\u001d\t\u0005#\u00112C&\u0003\u0002&%\tYAK]5hO\u0016\u0014\u0018M\u00197f!\t9#&D\u0001)\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0005\r\te.\u001f\t\u0003[Ej\u0011A\f\u0006\u0003_A\nQa\u001d;bi\u0016T!!\u0002\u0005\n\u0005Ir#!\u0004,pS\u0012t\u0015-\\3ta\u0006\u001cW\rE\u00025oej\u0011!\u000e\u0006\u0003m\u0019\tqaY8eK\u001e,g.\u0003\u00029k\tA1i\\7qS2,'\u000fE\u0003;\u0001\n\u0013%)D\u0001<\u0015\taT(A\u0005gk:\u001cG/[8og*\u0011ahP\u0001\u0007G>lWn\u001c8\u000b\u0005UA\u0011BA!<\u0005A1E.\u0019;K_&tg)\u001e8di&|g\u000e\u0005\u0002D\u000b6\tAI\u0003\u0002\u001e\u0011%\u0011a\t\u0012\u0002\u0004%><\bC\u0001%L\u001b\u0005I%B\u0001&\u0007\u0003\u0011)H/\u001b7\n\u00051K%a\u0002'pO\u001eLgn\u001a\u0005\t\u001d\u0002\u0011\t\u0011)A\u0005\u001f\u0006AA.\u001a4u)f\u0004X\rE\u0002Q'\nk\u0011!\u0015\u0006\u0003%v\n\u0001\u0002^=qK&tgm\\\u0005\u0003)F\u0013q\u0002V=qK&sgm\u001c:nCRLwN\u001c\u0005\t-\u0002\u0011\t\u0011)A\u0005\u001f\u0006I!/[4iiRK\b/\u001a\u0005\t1\u0002\u0011\t\u0011)A\u00053\u0006yq-\u001a8K_&tg)\u001e8d\u001d\u0006lW\r\u0005\u0002[C:\u00111l\u0018\t\u00039\"j\u0011!\u0018\u0006\u0003=:\ta\u0001\u0010:p_Rt\u0014B\u00011)\u0003\u0019\u0001&/\u001a3fM&\u0011!m\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0001D\u0003\u0002C3\u0001\u0005\u0003\u0005\u000b\u0011B-\u0002\u001f\u001d,gNS8j]\u001a+hnY\"pI\u0016D\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001[\u0001\fcV,'/_\"p]\u001aLw\r\u0005\u0002jW6\t!N\u0003\u0002\u0016\r%\u0011AN\u001b\u0002\u0012'R\u0014X-Y7Rk\u0016\u0014\u0018pQ8oM&<\u0007\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011B8\u0002#1,g\r\u001e+j[\u0016\fE\u000f\u001e:jEV$X\r\u0005\u0002(a&\u0011\u0011\u000f\u000b\u0002\u0004\u0013:$\b\u0002C:\u0001\u0005\u0003\u0005\u000b\u0011B8\u0002%ILw\r\u001b;US6,\u0017\t\u001e;sS\n,H/\u001a\u0005\u0006k\u0002!\tA^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011]L(p\u001f?~}~\u0004\"\u0001\u001f\u0001\u000e\u0003\tAQA\u0014;A\u0002=CQA\u0016;A\u0002=CQ\u0001\u0017;A\u0002eCQ!\u001a;A\u0002eCQa\u001a;A\u0002!DQA\u001c;A\u0002=DQa\u001d;A\u0002=D\u0011\"a\u0001\u0001\u0005\u0004%I!!\u0002\u000259+\u0005\fV0M\u000b\u001a#v,\u0013(E\u000bb{6\u000bV!U\u000b~s\u0015)T#\u0016\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u0012\u0005!!.\u0019<b\u0013\r\u0011\u00171\u0002\u0005\t\u0003/\u0001\u0001\u0015!\u0003\u0002\b\u0005Yb*\u0012-U?2+e\tV0J\u001d\u0012+\u0005lX*U\u0003R+uLT!N\u000b\u0002B\u0011\"a\u0007\u0001\u0005\u0004%I!!\u0002\u0002\u001f1+e\tV0T)\u0006#Vi\u0018(B\u001b\u0016C\u0001\"a\b\u0001A\u0003%\u0011qA\u0001\u0011\u0019\u00163EkX*U\u0003R+uLT!N\u000b\u0002B\u0011\"a\t\u0001\u0005\u0004%I!!\u0002\u0002!IKu\t\u0013+`'R\u000bE+R0O\u00036+\u0005\u0002CA\u0014\u0001\u0001\u0006I!a\u0002\u0002#IKu\t\u0013+`'R\u000bE+R0O\u00036+\u0005\u0005C\u0005\u0002,\u0001\u0011\r\u0011\"\u0003\u0002\u0006\u0005Y\"+R$J'R+%+\u0012#`)&kUIU0T)\u0006#Vi\u0018(B\u001b\u0016C\u0001\"a\f\u0001A\u0003%\u0011qA\u0001\u001d%\u0016;\u0015j\u0015+F%\u0016#u\fV%N\u000bJ{6\u000bV!U\u000b~s\u0015)T#!\u0011%\t\u0019\u0004\u0001b\u0001\n\u0013\t)!A\tU\u00136+%kU0T)\u0006#Vi\u0018(B\u001b\u0016C\u0001\"a\u000e\u0001A\u0003%\u0011qA\u0001\u0013)&kUIU*`'R\u000bE+R0O\u00036+\u0005\u0005C\u0005\u0002<\u0001\u0011\r\u0011\"\u0003\u0002>\u00051\"/[4iiJ{w\u000f^5nK\u000e{W\u000e]1sCR|'/\u0006\u0002\u0002@A\u0019\u00010!\u0011\n\u0007\u0005\r#AA\tS_^$\u0018.\\3D_6\u0004\u0018M]1u_JD\u0001\"a\u0012\u0001A\u0003%\u0011qH\u0001\u0018e&<\u0007\u000e\u001e*poRLW.Z\"p[B\f'/\u0019;pe\u0002B1\"a\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N\u0005ia.\u001a=u\u0019\u00164G/\u00138eKb,\"!a\u0014\u0011\r\u0005E\u0013QKA-\u001b\t\t\u0019F\u0003\u00020{%!\u0011qKA*\u0005)1\u0016\r\\;f'R\fG/\u001a\t\u0005\u0003\u0013\tY&\u0003\u0003\u0002^\u0005-!\u0001\u0002'p]\u001eD1\"!\u0019\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002d\u0005\tb.\u001a=u\u0019\u00164G/\u00138eKb|F%Z9\u0015\t\u0005\u0015\u00141\u000e\t\u0004O\u0005\u001d\u0014bAA5Q\t!QK\\5u\u0011)\ti'a\u0018\u0002\u0002\u0003\u0007\u0011qJ\u0001\u0004q\u0012\n\u0004bCA9\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u001f\naB\\3yi2+g\r^%oI\u0016D\b\u0005C\u0006\u0002v\u0001\u0001\r\u00111A\u0005\n\u0005]\u0014!\u00037fMR\u001cF/\u0019;f+\t\tI\bE\u0004\u0002R\u0005m\u0014\u0011\f\"\n\t\u0005u\u00141\u000b\u0002\t\u001b\u0006\u00048\u000b^1uK\"Y\u0011\u0011\u0011\u0001A\u0002\u0003\u0007I\u0011BAB\u00035aWM\u001a;Ti\u0006$Xm\u0018\u0013fcR!\u0011QMAC\u0011)\ti'a \u0002\u0002\u0003\u0007\u0011\u0011\u0010\u0005\f\u0003\u0013\u0003\u0001\u0019!A!B\u0013\tI(\u0001\u0006mK\u001a$8\u000b^1uK\u0002B1\"!$\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002x\u0005Q!/[4iiN#\u0018\r^3\t\u0017\u0005E\u0005\u00011AA\u0002\u0013%\u00111S\u0001\u000fe&<\u0007\u000e^*uCR,w\fJ3r)\u0011\t)'!&\t\u0015\u00055\u0014qRA\u0001\u0002\u0004\tI\bC\u0006\u0002\u001a\u0002\u0001\r\u0011!Q!\n\u0005e\u0014a\u0003:jO\"$8\u000b^1uK\u0002B1\"!(\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N\u0005y!/Z4jgR,'/\u001a3US6,'\u000fC\u0006\u0002\"\u0002\u0001\r\u00111A\u0005\n\u0005\r\u0016a\u0005:fO&\u001cH/\u001a:fIRKW.\u001a:`I\u0015\fH\u0003BA3\u0003KC!\"!\u001c\u0002 \u0006\u0005\t\u0019AA(\u0011-\tI\u000b\u0001a\u0001\u0002\u0003\u0006K!a\u0014\u0002!I,w-[:uKJ,G\rV5nKJ\u0004\u0003bCAW\u0001\u0001\u0007\t\u0019!C\u0005\u0003_\u000b1b\u0019*po^\u0013\u0018\r\u001d9feV\u0011\u0011\u0011\u0017\t\u0005\u0003g\u000b),D\u0001\u0005\u0013\r\t9\f\u0002\u0002\u0016\u0007J{wo\u0016:baBLgnZ\"pY2,7\r^8s\u0011-\tY\f\u0001a\u0001\u0002\u0004%I!!0\u0002\u001f\r\u0014vn^,sCB\u0004XM]0%KF$B!!\u001a\u0002@\"Q\u0011QNA]\u0003\u0003\u0005\r!!-\t\u0017\u0005\r\u0007\u00011A\u0001B\u0003&\u0011\u0011W\u0001\rGJ{wo\u0016:baB,'\u000f\t\u0005\f\u0003\u000f\u0004\u0001\u0019!a\u0001\n\u0013\tI-A\u0005d_2dWm\u0019;peV\u0011\u00111\u001a\t\u0005#\u00055'$C\u0002\u0002PJ\u0011A\u0003V5nKN$\u0018-\u001c9fI\u000e{G\u000e\\3di>\u0014\bbCAj\u0001\u0001\u0007\t\u0019!C\u0005\u0003+\fQbY8mY\u0016\u001cGo\u001c:`I\u0015\fH\u0003BA3\u0003/D!\"!\u001c\u0002R\u0006\u0005\t\u0019AAf\u0011-\tY\u000e\u0001a\u0001\u0002\u0003\u0006K!a3\u0002\u0015\r|G\u000e\\3di>\u0014\b\u0005C\u0006\u0002`\u0002\u0001\r\u00111A\u0005\n\u0005\u0005\u0018\u0001\u0004;j[\u0016\u00148+\u001a:wS\u000e,WCAAr!\u0011\t)/a:\u000e\u0003QI1!!;\u0015\u0005I\u0019\u0016.\u001c9mKRKW.\u001a:TKJ4\u0018nY3\t\u0017\u00055\b\u00011AA\u0002\u0013%\u0011q^\u0001\u0011i&lWM]*feZL7-Z0%KF$B!!\u001a\u0002r\"Q\u0011QNAv\u0003\u0003\u0005\r!a9\t\u0017\u0005U\b\u00011A\u0001B\u0003&\u00111]\u0001\u000ei&lWM]*feZL7-\u001a\u0011\t\u0017\u0005e\b\u00011AA\u0002\u0013%\u00111`\u0001\rU>LgNR;oGRLwN\\\u000b\u0002s!Y\u0011q \u0001A\u0002\u0003\u0007I\u0011\u0002B\u0001\u0003AQw.\u001b8Gk:\u001cG/[8o?\u0012*\u0017\u000f\u0006\u0003\u0002f\t\r\u0001\"CA7\u0003{\f\t\u00111\u0001:\u0011)\u00119\u0001\u0001a\u0001\u0002\u0003\u0006K!O\u0001\u000eU>LgNR;oGRLwN\u001c\u0011\t\u000f\t-\u0001\u0001\"\u0011\u0003\u000e\u0005!q\u000e]3o)\t\t)\u0007C\u0004\u0003\u0012\u0001!\tEa\u0005\u0002\u001fA\u0014xnY3tg\u0016cW-\\3oiF\"B!!\u001a\u0003\u0016!A!q\u0003B\b\u0001\u0004\u0011I\"A\u0004fY\u0016lWM\u001c;\u0011\u000b\tm!1\u0005\u000e\u000e\u0005\tu!\u0002\u0002B\u0010\u0005C\tAb\u001d;sK\u0006l'/Z2pe\u0012T!!\u0002\f\n\t\t\u0015\"Q\u0004\u0002\r'R\u0014X-Y7SK\u000e|'\u000f\u001a\u0005\b\u0005S\u0001A\u0011\tB\u0016\u0003=\u0001(o\\2fgN,E.Z7f]R\u0014D\u0003BA3\u0005[A\u0001Ba\u0006\u0003(\u0001\u0007!\u0011\u0004\u0005\b\u0005c\u0001A\u0011\tB\u001a\u0003Ayg\u000e\u0015:pG\u0016\u001c8/\u001b8h)&lW\r\u0006\u0003\u0002f\tU\u0002\u0002\u0003B\u001c\u0005_\u0001\rA!\u000f\u0002\u000bQLW.\u001a:\u0011\u000bE\u0011YD\n\u0017\n\u0007\tu\"CA\u0007J]R,'O\\1m)&lWM\u001d\u0005\b\u0005\u0003\u0002A\u0011\tB\"\u0003-yg.\u0012<f]R$\u0016.\\3\u0015\t\u0005\u0015$Q\t\u0005\t\u0005o\u0011y\u00041\u0001\u0003:!9!\u0011\n\u0001\u0005B\t5\u0011!B2m_N,\u0007b\u0002B'\u0001\u0011%!qJ\u0001\u0016e\u0016<\u0017n\u001d;feNk\u0017\r\u001c7fgR$\u0016.\\3s)\u0011\t)G!\u0015\t\u0011\tM#1\na\u0001\u0005+\n\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007\u001d\u00129&C\u0002\u0002^!BqAa\u0017\u0001\t\u0013\u0011i&A\u0007sK\u001eL7\u000f^3s)&lWM\u001d\u000b\u0005\u0003K\u0012y\u0006\u0003\u0005\u0003T\te\u0003\u0019\u0001B+\u0011\u001d\u0011\u0019\u0007\u0001C\u0005\u0005K\n\u0011$Z7jiJ+7/\u001e7u\u0003:$7\t\\3b]V\u00038\u000b^1uKR!!Q\u000bB4\u0011!\u0011IG!\u0019A\u0002\tU\u0013A\u0004;j[\u0016\u0014H+[7fgR\fW\u000e\u001d\u0005\b\u0005[\u0002A\u0011\u0002B8\u00031\u0019G.Z1o+B\u001cF/\u0019;f)\u0019\t)G!\u001d\u0003t!A!\u0011\u000eB6\u0001\u0004\u0011)\u0006\u0003\u0005\u0003v\t-\u0004\u0019\u0001B<\u0003=\u0011\u0018n\u001a5u%><8oU8si\u0016$\u0007#\u0002B=\u0005{\u0012UB\u0001B>\u0015\rQ\u0015qB\u0005\u0005\u0005\u007f\u0012YH\u0001\u0003MSN$\bb\u0002BB\u0001\u0011%!QQ\u0001\u0011M&\u00148\u000f^%oI\u0016DHk\\&fKB$Ra\u001cBD\u0005\u0013C\u0001B!\u001b\u0003\u0002\u0002\u0007!Q\u000b\u0005\t\u0005k\u0012\t\t1\u0001\u0003x!9!Q\u0012\u0001\u0005\n\t=\u0015!I5oI\u0016DxJ\u001a$jeN$X\t\\3nK:$h*Z<feRC\u0017M\u001c+j[\u0016\u0014H#B8\u0003\u0012\nM\u0005\u0002\u0003B5\u0005\u0017\u0003\rA!\u0016\t\u0011\tU%1\u0012a\u0001\u0005o\nA\u0001\\5ti\"9!\u0011\u0014\u0001\u0005\n\tm\u0015\u0001\u00067bi\u0016\u001cHOU5hQR\u0014vn\u001e+p\u0015>Lg\u000e\u0006\u0004\u0003\u001e\n\r&Q\u0015\t\u0006\u0005s\u0012yJQ\u0005\u0005\u0005C\u0013YH\u0001\u0005PaRLwN\\1m\u0011!\u0011)Ha&A\u0002\t]\u0004\u0002\u0003BT\u0005/\u0003\rA!\u0016\u0002\u00111,g\r\u001e+j[\u0016DqA!'\u0001\t\u0013\u0011Y\u000b\u0006\u0006\u0003\u001e\n5&q\u0016BZ\u0005oC\u0001B!\u001e\u0003*\u0002\u0007!q\u000f\u0005\b\u0005c\u0013I\u000b1\u0001p\u0003\rawn\u001e\u0005\b\u0005k\u0013I\u000b1\u0001p\u0003\u0011A\u0017n\u001a5\t\u0011\t\u001d&\u0011\u0016a\u0001\u0005+BqAa/\u0001\t\u0013\u0011i,\u0001\nhKR\u0014\u0016n\u001a5u%><8oU8si\u0016$G\u0003\u0002B<\u0005\u007fC\u0001B!1\u0003:\u0002\u0007\u0011qH\u0001\u0012e><H/[7f\u0007>l\u0007/\u0019:bi>\u0014\bb\u0002Bc\u0001\u0011%!qY\u0001\u0011O\u0016$h*\u001a=u\u0019\u00164G/\u00138eKb,\"!!\u0017\t\u000f\t-\u0007\u0001\"\u0003\u0003N\u0006Yq-\u001a;MK\u001a$H+[7f)\u0011\u0011)Fa4\t\u000f\tE'\u0011\u001aa\u0001\u0005\u00069A.\u001a4u%><\bb\u0002Bk\u0001\u0011%!q[\u0001\rO\u0016$(+[4iiRKW.\u001a\u000b\u0005\u0005+\u0012I\u000eC\u0004\u0003\\\nM\u0007\u0019\u0001\"\u0002\u0011ILw\r\u001b;S_^DqAa8\u0001\t\u0013\u0011\t/\u0001\ndQ\u0016\u001c7NT8u%\u0016$(/Y2uS>tG\u0003BA3\u0005GD\u0001Ba\u0006\u0003^\u0002\u0007!\u0011\u0004")
public class TemporalRowtimeJoin
extends AbstractStreamOperator<CRow>
implements TwoInputStreamOperator<CRow, CRow, CRow>,
Triggerable<Object, VoidNamespace>,
Compiler<FlatJoinFunction<Row, Row, Row>>,
Logging {
    private final TypeInformation<Row> leftType;
    private final TypeInformation<Row> rightType;
    private final String genJoinFuncName;
    private final String genJoinFuncCode;
    private final int leftTimeAttribute;
    private final int rightTimeAttribute;
    private final String NEXT_LEFT_INDEX_STATE_NAME;
    private final String LEFT_STATE_NAME;
    private final String RIGHT_STATE_NAME;
    private final String REGISTERED_TIMER_STATE_NAME;
    private final String TIMERS_STATE_NAME;
    private final RowtimeComparator rightRowtimeComparator;
    private ValueState<Long> nextLeftIndex;
    private MapState<Long, Row> leftState;
    private MapState<Long, Row> rightState;
    private ValueState<Long> registeredTimer;
    private CRowWrappingCollector cRowWrapper;
    private TimestampedCollector<CRow> collector;
    private SimpleTimerService timerService;
    private FlatJoinFunction<Row, Row, Row> joinFunction;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<FlatJoinFunction<Row, Row, Row>> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        TemporalRowtimeJoin temporalRowtimeJoin = this;
        synchronized (temporalRowtimeJoin) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private String NEXT_LEFT_INDEX_STATE_NAME() {
        return this.NEXT_LEFT_INDEX_STATE_NAME;
    }

    private String LEFT_STATE_NAME() {
        return this.LEFT_STATE_NAME;
    }

    private String RIGHT_STATE_NAME() {
        return this.RIGHT_STATE_NAME;
    }

    private String REGISTERED_TIMER_STATE_NAME() {
        return this.REGISTERED_TIMER_STATE_NAME;
    }

    private String TIMERS_STATE_NAME() {
        return this.TIMERS_STATE_NAME;
    }

    private RowtimeComparator rightRowtimeComparator() {
        return this.rightRowtimeComparator;
    }

    private ValueState<Long> nextLeftIndex() {
        return this.nextLeftIndex;
    }

    private void nextLeftIndex_$eq(ValueState<Long> x$1) {
        this.nextLeftIndex = x$1;
    }

    private MapState<Long, Row> leftState() {
        return this.leftState;
    }

    private void leftState_$eq(MapState<Long, Row> x$1) {
        this.leftState = x$1;
    }

    private MapState<Long, Row> rightState() {
        return this.rightState;
    }

    private void rightState_$eq(MapState<Long, Row> x$1) {
        this.rightState = x$1;
    }

    private ValueState<Long> registeredTimer() {
        return this.registeredTimer;
    }

    private void registeredTimer_$eq(ValueState<Long> x$1) {
        this.registeredTimer = x$1;
    }

    private CRowWrappingCollector cRowWrapper() {
        return this.cRowWrapper;
    }

    private void cRowWrapper_$eq(CRowWrappingCollector x$1) {
        this.cRowWrapper = x$1;
    }

    private TimestampedCollector<CRow> collector() {
        return this.collector;
    }

    private void collector_$eq(TimestampedCollector<CRow> x$1) {
        this.collector = x$1;
    }

    private SimpleTimerService timerService() {
        return this.timerService;
    }

    private void timerService_$eq(SimpleTimerService x$1) {
        this.timerService = x$1;
    }

    private FlatJoinFunction<Row, Row, Row> joinFunction() {
        return this.joinFunction;
    }

    private void joinFunction_$eq(FlatJoinFunction<Row, Row, Row> x$1) {
        this.joinFunction = x$1;
    }

    public void open() {
        this.LOG().debug(new StringBuilder(38).append("Compiling FlatJoinFunction: ").append(this.genJoinFuncName).append(" \n\n Code:\n").append(this.genJoinFuncCode).toString());
        Class<FlatJoinFunction<Row, Row, Row>> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genJoinFuncName, this.genJoinFuncCode);
        this.LOG().debug("Instantiating FlatJoinFunction.");
        this.joinFunction_$eq(clazz.newInstance());
        FunctionUtils.setFunctionRuntimeContext(this.joinFunction(), (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.joinFunction(), (Configuration)new Configuration());
        this.nextLeftIndex_$eq((ValueState<Long>)this.getRuntimeContext().getState(new ValueStateDescriptor(this.NEXT_LEFT_INDEX_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO)));
        this.leftState_$eq((MapState<Long, Row>)this.getRuntimeContext().getMapState(new MapStateDescriptor(this.LEFT_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, this.leftType)));
        this.rightState_$eq((MapState<Long, Row>)this.getRuntimeContext().getMapState(new MapStateDescriptor(this.RIGHT_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO, this.rightType)));
        this.registeredTimer_$eq((ValueState<Long>)this.getRuntimeContext().getState(new ValueStateDescriptor(this.REGISTERED_TIMER_STATE_NAME(), (TypeInformation)BasicTypeInfo.LONG_TYPE_INFO)));
        this.collector_$eq((TimestampedCollector<CRow>)new TimestampedCollector(this.output));
        this.cRowWrapper_$eq(new CRowWrappingCollector());
        this.cRowWrapper().out_$eq((Collector<CRow>)this.collector());
        this.cRowWrapper().setChange(true);
        InternalTimerService internalTimerService = this.getInternalTimerService(this.TIMERS_STATE_NAME(), (TypeSerializer)VoidNamespaceSerializer.INSTANCE, this);
        this.timerService_$eq(new SimpleTimerService(internalTimerService));
    }

    public void processElement1(StreamRecord<CRow> element) {
        this.checkNotRetraction(element);
        this.leftState().put((Object)this.getNextLeftIndex(), (Object)((CRow)element.getValue()).row());
        this.registerSmallestTimer(this.getLeftTime(((CRow)element.getValue()).row()));
    }

    public void processElement2(StreamRecord<CRow> element) {
        this.checkNotRetraction(element);
        long rowTime = this.getRightTime(((CRow)element.getValue()).row());
        this.rightState().put((Object)Predef$.MODULE$.long2Long(rowTime), (Object)((CRow)element.getValue()).row());
        this.registerSmallestTimer(rowTime);
    }

    public void onProcessingTime(InternalTimer<Object, VoidNamespace> timer) {
        throw new IllegalStateException("This should never happen");
    }

    public void onEventTime(InternalTimer<Object, VoidNamespace> timer) {
        block0: {
            this.registeredTimer().clear();
            long lastUnprocessedTime = this.emitResultAndCleanUpState(this.timerService().currentWatermark());
            if (lastUnprocessedTime >= Long.MAX_VALUE) break block0;
            this.registerTimer(lastUnprocessedTime);
        }
    }

    public void close() {
        FunctionUtils.closeFunction(this.joinFunction());
    }

    private void registerSmallestTimer(long timestamp) {
        block1: {
            Long currentRegisteredTimer;
            block0: {
                currentRegisteredTimer = (Long)this.registeredTimer().value();
                if (currentRegisteredTimer != null) break block0;
                this.registerTimer(timestamp);
                break block1;
            }
            if (currentRegisteredTimer == null || Predef$.MODULE$.Long2long(currentRegisteredTimer) <= timestamp) break block1;
            this.timerService().deleteEventTimeTimer(Predef$.MODULE$.Long2long(currentRegisteredTimer));
            this.registerTimer(timestamp);
        }
    }

    private void registerTimer(long timestamp) {
        this.registeredTimer().update((Object)Predef$.MODULE$.long2Long(timestamp));
        this.timerService().registerEventTimeTimer(timestamp);
    }

    private long emitResultAndCleanUpState(long timerTimestamp) {
        List<Row> rightRowsSorted = this.getRightRowsSorted(this.rightRowtimeComparator());
        long lastUnprocessedTime = Long.MAX_VALUE;
        Iterator leftIterator = this.leftState().entries().iterator();
        while (leftIterator.hasNext()) {
            Map.Entry leftEntry = (Map.Entry)leftIterator.next();
            Row leftRow = (Row)leftEntry.getValue();
            long leftTime = this.getLeftTime(leftRow);
            if (leftTime <= timerTimestamp) {
                Optional<Row> rightRow = this.latestRightRowToJoin(rightRowsSorted, leftTime);
                if (rightRow.isPresent()) {
                    this.joinFunction().join((Object)leftRow, (Object)rightRow.get(), (Collector)this.cRowWrapper());
                }
                leftIterator.remove();
                continue;
            }
            lastUnprocessedTime = Math.min(lastUnprocessedTime, leftTime);
        }
        this.cleanUpState(timerTimestamp, rightRowsSorted);
        return lastUnprocessedTime;
    }

    private void cleanUpState(long timerTimestamp, List<Row> rightRowsSorted) {
        int indexToKeep = this.firstIndexToKeep(timerTimestamp, rightRowsSorted);
        for (int i = 0; i < indexToKeep; ++i) {
            long rightTime = this.getRightTime(rightRowsSorted.get(i));
            this.rightState().remove((Object)Predef$.MODULE$.long2Long(rightTime));
        }
    }

    private int firstIndexToKeep(long timerTimestamp, List<Row> rightRowsSorted) {
        int firstIndexNewerThenTimer = this.indexOfFirstElementNewerThanTimer(timerTimestamp, rightRowsSorted);
        return firstIndexNewerThenTimer < 0 ? rightRowsSorted.size() - 1 : firstIndexNewerThenTimer - 1;
    }

    private int indexOfFirstElementNewerThanTimer(long timerTimestamp, List<Row> list) {
        ListIterator<Row> iter = list.listIterator();
        while (iter.hasNext()) {
            if (this.getRightTime(iter.next()) <= timerTimestamp) continue;
            return iter.previousIndex();
        }
        return -1;
    }

    private Optional<Row> latestRightRowToJoin(List<Row> rightRowsSorted, long leftTime) {
        return this.latestRightRowToJoin(rightRowsSorted, 0, rightRowsSorted.size() - 1, leftTime);
    }

    private Optional<Row> latestRightRowToJoin(List<Row> rightRowsSorted, int low, int high, long leftTime) {
        Optional<Row> optional;
        block3: {
            Row midRow;
            while (true) {
                if (low > high) {
                    optional = low - 1 < 0 ? Optional.empty() : Optional.of(rightRowsSorted.get(low - 1));
                    break block3;
                }
                int mid = low + high >>> 1;
                midRow = rightRowsSorted.get(mid);
                long midTime = this.getRightTime(midRow);
                int cmp = Predef$.MODULE$.long2Long(midTime).compareTo(Predef$.MODULE$.long2Long(leftTime));
                if (cmp < 0) {
                    low = mid + 1;
                    continue;
                }
                if (cmp <= 0) break;
                high = mid - 1;
            }
            optional = Optional.of(midRow);
        }
        return optional;
    }

    /*
     * WARNING - void declaration
     */
    private List<Row> getRightRowsSorted(RowtimeComparator rowtimeComparator) {
        void var2_2;
        ArrayList<Row> rightRows = new ArrayList<Row>();
        JavaConversions$.MODULE$.deprecated$u0020iterableAsScalaIterable(this.rightState().values()).foreach((Function1 & Serializable & scala.Serializable)row2 -> BoxesRunTime.boxToBoolean((boolean)rightRows.add(row2)));
        rightRows.sort(rowtimeComparator);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private Long getNextLeftIndex() {
        void var1_1;
        Long index = (Long)this.nextLeftIndex().value();
        if (index == null) {
            index = Predef$.MODULE$.long2Long(0L);
        }
        this.nextLeftIndex().update((Object)Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(index) + 1L));
        return var1_1;
    }

    private long getLeftTime(Row leftRow) {
        return BoxesRunTime.unboxToLong((Object)leftRow.getField(this.leftTimeAttribute));
    }

    private long getRightTime(Row rightRow) {
        return BoxesRunTime.unboxToLong((Object)rightRow.getField(this.rightTimeAttribute));
    }

    private void checkNotRetraction(StreamRecord<CRow> element) {
        if (!((CRow)element.getValue()).change()) {
            throw new IllegalStateException(new StringBuilder(95).append("Retractions are not supported by [").append(TemporalRowtimeJoin.class.getSimpleName()).append("]. ").append("If this can happen it should be validated during planning!").toString());
        }
    }

    public TemporalRowtimeJoin(TypeInformation<Row> leftType, TypeInformation<Row> rightType, String genJoinFuncName, String genJoinFuncCode, StreamQueryConfig queryConfig, int leftTimeAttribute, int rightTimeAttribute) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.genJoinFuncName = genJoinFuncName;
        this.genJoinFuncCode = genJoinFuncCode;
        this.leftTimeAttribute = leftTimeAttribute;
        this.rightTimeAttribute = rightTimeAttribute;
        Compiler.$init$(this);
        Logging.$init$(this);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", leftType);
        TypeCheckUtils$.MODULE$.validateEqualsHashCode("join", rightType);
        this.NEXT_LEFT_INDEX_STATE_NAME = "next-index";
        this.LEFT_STATE_NAME = "left";
        this.RIGHT_STATE_NAME = "right";
        this.REGISTERED_TIMER_STATE_NAME = "timer";
        this.TIMERS_STATE_NAME = "timers";
        this.rightRowtimeComparator = new RowtimeComparator(rightTimeAttribute);
    }
}

