/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u0001=\u0011qc\u0012:pkB\fum\u001a)s_\u000e,7o\u001d$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000e$!\u0011\t\"\u0003\u0006\u000b\u000e\u0003\tI!a\u0005\u0002\u0003?A\u0013xnY3tg\u001a+hn\u0019;j_:<\u0016\u000e\u001e5DY\u0016\fg.\u001e9Ti\u0006$X\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005)A/\u001f9fg&\u0011\u0011D\u0006\u0002\u0005\u0007J{w\u000fE\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0003;\u0019\tqaY8eK\u001e,g.\u0003\u0002 9\tA1i\\7qS2,'\u000f\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u0016\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t!\t!s%D\u0001&\u0015\t1c!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001eD\u0001B\u000b\u0001\u0003\u0006\u0004%IaK\u0001\u0010O\u0016t\u0017iZ4sK\u001e\fG/[8ogV\tA\u0006\u0005\u0002\u001c[%\u0011a\u0006\b\u0002\u001e\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t\rVt7\r^5p]\"A\u0001\u0007\u0001B\u0001B\u0003%A&\u0001\thK:\fum\u001a:fO\u0006$\u0018n\u001c8tA!A!\u0007\u0001BC\u0002\u0013%1'\u0001\u000bbO\u001e\u0014XmZ1uS>t7\u000b^1uKRK\b/Z\u000b\u0002iA\u0011Q\u0007P\u0007\u0002m)\u0011q\u0007O\u0001\nif\u0004X-\u001e;jYNT!!\u000f\u001e\u0002\t)\fg/\u0019\u0006\u0003w!\t1!\u00199j\u0013\tidGA\u0006S_^$\u0016\u0010]3J]\u001a|\u0007\u0002C \u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001b\u0002+\u0005<wM]3hCRLwN\\*uCR,G+\u001f9fA!A\u0011\t\u0001BC\u0002\u0013%!)\u0001\nhK:,'/\u0019;f%\u0016$(/Y2uS>tW#A\"\u0011\u0005\u0011;U\"A#\u000b\u0003\u0019\u000bQa]2bY\u0006L!\u0001S#\u0003\u000f\t{w\u000e\\3b]\"A!\n\u0001B\u0001B\u0003%1)A\nhK:,'/\u0019;f%\u0016$(/Y2uS>t\u0007\u0005\u0003\u0005M\u0001\t\u0015\r\u0011\"\u0003N\u0003-\tX/\u001a:z\u0007>tg-[4\u0016\u00039\u0003\"aT)\u000e\u0003AS!a\u000f\u0004\n\u0005I\u0003&!E*ue\u0016\fW.U;fef\u001cuN\u001c4jO\"AA\u000b\u0001B\u0001B\u0003%a*\u0001\u0007rk\u0016\u0014\u0018pQ8oM&<\u0007\u0005C\u0003W\u0001\u0011\u0005q+\u0001\u0004=S:LGO\u0010\u000b\u00061fS6\f\u0018\t\u0003#\u0001AQAK+A\u00021BQAM+A\u0002QBQ!Q+A\u0002\rCQ\u0001T+A\u00029C\u0011B\u0018\u0001A\u0002\u0003\u0007I\u0011B0\u0002\u0011\u0019,hn\u0019;j_:,\u0012\u0001\t\u0005\nC\u0002\u0001\r\u00111A\u0005\n\t\fABZ;oGRLwN\\0%KF$\"a\u00194\u0011\u0005\u0011#\u0017BA3F\u0005\u0011)f.\u001b;\t\u000f\u001d\u0004\u0017\u0011!a\u0001A\u0005\u0019\u0001\u0010J\u0019\t\u0013%\u0004\u0001\u0019!A!B\u0013\u0001\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011%Y\u0007\u00011AA\u0002\u0013%A.\u0001\u0004oK^\u0014vn^\u000b\u0002)!Ia\u000e\u0001a\u0001\u0002\u0004%Ia\\\u0001\u000b]\u0016<(k\\<`I\u0015\fHCA2q\u0011\u001d9W.!AA\u0002QA\u0011B\u001d\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u000b\u0002\u000f9,wOU8xA!IA\u000f\u0001a\u0001\u0002\u0004%I\u0001\\\u0001\baJ,gOU8x\u0011%1\b\u00011AA\u0002\u0013%q/A\u0006qe\u00164(k\\<`I\u0015\fHCA2y\u0011\u001d9W/!AA\u0002QA\u0011B\u001f\u0001A\u0002\u0003\u0005\u000b\u0015\u0002\u000b\u0002\u0011A\u0014XM\u001e*po\u0002B\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011\u0002\"\u0002\u0011\u0019L'o\u001d;S_^D\u0011B \u0001A\u0002\u0003\u0007I\u0011B@\u0002\u0019\u0019L'o\u001d;S_^|F%Z9\u0015\u0007\r\f\t\u0001C\u0004h{\u0006\u0005\t\u0019A\"\t\u0015\u0005\u0015\u0001\u00011A\u0001B\u0003&1)A\u0005gSJ\u001cHOU8xA!Y\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0006\u0003\u0015\u0019H/\u0019;f+\t\ti\u0001\u0005\u0004\u0002\u0010\u0005]\u00111D\u0007\u0003\u0003#QA!!\u0003\u0002\u0014)\u0019\u0011Q\u0003\u001e\u0002\r\r|W.\\8o\u0013\u0011\tI\"!\u0005\u0003\u0015Y\u000bG.^3Ti\u0006$X\r\u0005\u0003\u0002\u001e\u0005\u0005RBAA\u0010\u0015\t9\u0002\"\u0003\u0003\u0002$\u0005}!a\u0001*po\"Y\u0011q\u0005\u0001A\u0002\u0003\u0007I\u0011BA\u0015\u0003%\u0019H/\u0019;f?\u0012*\u0017\u000fF\u0002d\u0003WA\u0011bZA\u0013\u0003\u0003\u0005\r!!\u0004\t\u0017\u0005=\u0002\u00011A\u0001B\u0003&\u0011QB\u0001\u0007gR\fG/\u001a\u0011\t\u0017\u0005M\u0002\u00011AA\u0002\u0013%\u0011QG\u0001\tG:$8\u000b^1uKV\u0011\u0011q\u0007\t\u0007\u0003\u001f\t9\"!\u000f\u0011\t\u0005m\u00121I\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005!A.\u00198h\u0015\u0005I\u0014\u0002BA#\u0003{\u0011A\u0001T8oO\"Y\u0011\u0011\n\u0001A\u0002\u0003\u0007I\u0011BA&\u00031\u0019g\u000e^*uCR,w\fJ3r)\r\u0019\u0017Q\n\u0005\nO\u0006\u001d\u0013\u0011!a\u0001\u0003oA1\"!\u0015\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00028\u0005I1M\u001c;Ti\u0006$X\r\t\u0005\b\u0003+\u0002A\u0011IA,\u0003\u0011y\u0007/\u001a8\u0015\u0007\r\fI\u0006\u0003\u0005\u0002\\\u0005M\u0003\u0019AA/\u0003\u0019\u0019wN\u001c4jOB!\u0011qLA3\u001b\t\t\tGC\u0002\u0002d!\tQbY8oM&<WO]1uS>t\u0017\u0002BA4\u0003C\u0012QbQ8oM&<WO]1uS>t\u0007bBA6\u0001\u0011\u0005\u0013QN\u0001\u000faJ|7-Z:t\u000b2,W.\u001a8u)\u001d\u0019\u0017qNA:\u0003\u001fCq!!\u001d\u0002j\u0001\u0007A#\u0001\u0004j]B,Ho\u0011\u0005\t\u0003k\nI\u00071\u0001\u0002x\u0005\u00191\r\u001e=\u0011\t\u0005e\u00141\u0012\t\u0007\u0003w\n9\t\u0006\u000b\u000e\u0005\u0005u$\u0002BA@\u0003\u0003\u000b\u0011BZ;oGRLwN\\:\u000b\u0007m\n\u0019IC\u0002\u0002\u0006\"\t\u0011b\u001d;sK\u0006l\u0017N\\4\n\t\u0005%\u0015Q\u0010\u0002\u0010!J|7-Z:t\rVt7\r^5p]&!\u0011QRAD\u0005\u001d\u0019uN\u001c;fqRD\u0001\"!%\u0002j\u0001\u0007\u00111S\u0001\u0004_V$\b#BAK\u00033#RBAAL\u0015\t1\u0003\"\u0003\u0003\u0002\u001c\u0006]%!C\"pY2,7\r^8s\u0011\u001d\ty\n\u0001C!\u0003C\u000bqa\u001c8US6,'\u000fF\u0004d\u0003G\u000bY+a-\t\u0011\u0005\u0015\u0016Q\u0014a\u0001\u0003O\u000b\u0011\u0002^5nKN$\u0018-\u001c9\u0011\u0007\u0011\u000bI+C\u0002\u0002F\u0015C\u0001\"!\u001e\u0002\u001e\u0002\u0007\u0011Q\u0016\t\u0005\u0003s\ny+\u0003\u0003\u00022\u0006\u001d%AD(o)&lWM]\"p]R,\u0007\u0010\u001e\u0005\t\u0003#\u000bi\n1\u0001\u0002\u0014\"9\u0011q\u0017\u0001\u0005B\u0005e\u0016!B2m_N,G#A2")
public class GroupAggProcessFunction
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final boolean generateRetraction;
    private final StreamQueryConfig queryConfig;
    private GeneratedAggregations function;
    private CRow newRow;
    private CRow prevRow;
    private boolean firstRow;
    private ValueState<Row> state;
    private ValueState<Long> cntState;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        GroupAggProcessFunction groupAggProcessFunction = this;
        synchronized (groupAggProcessFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private GeneratedAggregationsFunction genAggregations() {
        return this.genAggregations;
    }

    private RowTypeInfo aggregationStateType() {
        return this.aggregationStateType;
    }

    private boolean generateRetraction() {
        return this.generateRetraction;
    }

    private StreamQueryConfig queryConfig() {
        return this.queryConfig;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    private CRow newRow() {
        return this.newRow;
    }

    private void newRow_$eq(CRow x$1) {
        this.newRow = x$1;
    }

    private CRow prevRow() {
        return this.prevRow;
    }

    private void prevRow_$eq(CRow x$1) {
        this.prevRow = x$1;
    }

    private boolean firstRow() {
        return this.firstRow;
    }

    private void firstRow_$eq(boolean x$1) {
        this.firstRow = x$1;
    }

    private ValueState<Row> state() {
        return this.state;
    }

    private void state_$eq(ValueState<Row> x$1) {
        this.state = x$1;
    }

    private ValueState<Long> cntState() {
        return this.cntState;
    }

    private void cntState_$eq(ValueState<Long> x$1) {
        this.cntState = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(36).append("Compiling AggregateHelper: ").append(this.genAggregations()).append(".name \n\n ").append(new StringBuilder(11).append("Code:\n").append(this.genAggregations()).append(".code").toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations().name(), this.genAggregations().code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.newRow_$eq(new CRow(this.function().createOutputRow(), true));
        this.prevRow_$eq(new CRow(this.function().createOutputRow(), false));
        ValueStateDescriptor stateDescriptor = new ValueStateDescriptor("GroupAggregateState", (TypeInformation)this.aggregationStateType());
        this.state_$eq((ValueState<Row>)this.getRuntimeContext().getState(stateDescriptor));
        ValueStateDescriptor inputCntDescriptor = new ValueStateDescriptor("GroupAggregateInputCounter", Types$.MODULE$.LONG());
        this.cntState_$eq((ValueState<Long>)this.getRuntimeContext().getState(inputCntDescriptor));
        this.initCleanupTimeState("GroupAggregateCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        long currentTime2 = ctx.timerService().currentProcessingTime();
        this.registerProcessingCleanupTimer(ctx, currentTime2);
        Row input = inputC.row();
        Row accumulators = (Row)this.state().value();
        Long inputCnt = (Long)this.cntState().value();
        if (accumulators == null) {
            if (!inputC.change()) {
                return;
            }
            this.firstRow_$eq(true);
            accumulators = this.function().createAccumulators();
        } else {
            this.firstRow_$eq(false);
        }
        if (inputCnt == null) {
            inputCnt = Predef$.MODULE$.long2Long(0L);
        }
        this.function().setForwardedFields(input, this.newRow().row());
        this.function().setForwardedFields(input, this.prevRow().row());
        this.function().setAggregationResults(accumulators, this.prevRow().row());
        if (inputC.change()) {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) + 1L);
            this.function().accumulate(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        } else {
            inputCnt = Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(inputCnt) - 1L);
            this.function().retract(accumulators, input);
            this.function().setAggregationResults(accumulators, this.newRow().row());
        }
        if (!BoxesRunTime.equalsNumObject((Number)inputCnt, (Object)BoxesRunTime.boxToInteger((int)0))) {
            this.state().update((Object)accumulators);
            this.cntState().update((Object)inputCnt);
            if (!this.firstRow()) {
                if (this.prevRow().row().equals((Object)this.newRow().row()) && !this.stateCleaningEnabled()) {
                    return;
                }
                if (this.generateRetraction()) {
                    out.collect((Object)this.prevRow());
                }
            }
            out.collect((Object)this.newRow());
        } else {
            out.collect((Object)this.prevRow());
            this.state().clear();
            this.cntState().clear();
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        block0: {
            if (!this.needToCleanupState(timestamp)) break block0;
            this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.state(), this.cntState()}));
            this.function().cleanup();
        }
    }

    public void close() {
        this.function().close();
    }

    public GroupAggProcessFunction(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, boolean generateRetraction, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.generateRetraction = generateRetraction;
        this.queryConfig = queryConfig;
        super(queryConfig);
        Compiler.$init$(this);
        Logging.$init$(this);
    }
}

