/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.Iterator;
import org.apache.flink.api.common.functions.CombineFunction;
import org.apache.flink.api.common.functions.RichGroupReduceFunction;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ResultTypeQueryable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.windowing.windows.TimeWindow;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.util.Logging;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u0001=\u0011A\u0006R1uCN+Go\u00157jI\u0016$\u0016.\\3XS:$wn^!hOJ+G-^2f\u000fJ|W\u000f\u001d$v]\u000e$\u0018n\u001c8\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M1\u0001\u0001\u0005\u0011$WU\u0002B!\u0005\r\u001b55\t!C\u0003\u0002\u0014)\u0005Ia-\u001e8di&|gn\u001d\u0006\u0003+Y\taaY8n[>t'BA\f\t\u0003\r\t\u0007/[\u0005\u00033I\u0011qCU5dQ\u001e\u0013x.\u001e9SK\u0012,8-\u001a$v]\u000e$\u0018n\u001c8\u0011\u0005mqR\"\u0001\u000f\u000b\u0005uA\u0011!\u0002;za\u0016\u001c\u0018BA\u0010\u001d\u0005\r\u0011vn\u001e\t\u0005#\u0005R\"$\u0003\u0002#%\ty1i\\7cS:,g)\u001e8di&|g\u000eE\u0002%Sii\u0011!\n\u0006\u0003M\u001d\n\u0011\u0002^=qKV$\u0018\u000e\\:\u000b\u0005!2\u0012\u0001\u00026bm\u0006L!AK\u0013\u0003'I+7/\u001e7u)f\u0004X-U;fef\f'\r\\3\u0011\u00071z\u0013'D\u0001.\u0015\tqc!A\u0004d_\u0012,w-\u001a8\n\u0005Aj#\u0001C\"p[BLG.\u001a:\u0011\u0005I\u001aT\"\u0001\u0002\n\u0005Q\u0012!!F$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d\t\u0003mej\u0011a\u000e\u0006\u0003q\u0019\tA!\u001e;jY&\u0011!h\u000e\u0002\b\u0019><w-\u001b8h\u0011!a\u0004A!b\u0001\n\u0013i\u0014aD4f]\u0006;wM]3hCRLwN\\:\u0016\u0003y\u0002\"\u0001L \n\u0005\u0001k#!H$f]\u0016\u0014\u0018\r^3e\u0003\u001e<'/Z4bi&|gn\u001d$v]\u000e$\u0018n\u001c8\t\u0011\t\u0003!\u0011!Q\u0001\ny\n\u0001cZ3o\u0003\u001e<'/Z4bi&|gn\u001d\u0011\t\u0011\u0011\u0003!Q1A\u0005\n\u0015\u000bac[3zg\u0006sG-Q4he\u0016<\u0017\r^3t\u0003JLG/_\u000b\u0002\rB\u0011qIS\u0007\u0002\u0011*\t\u0011*A\u0003tG\u0006d\u0017-\u0003\u0002L\u0011\n\u0019\u0011J\u001c;\t\u00115\u0003!\u0011!Q\u0001\n\u0019\u000bqc[3zg\u0006sG-Q4he\u0016<\u0017\r^3t\u0003JLG/\u001f\u0011\t\u0011=\u0003!Q1A\u0005\nA\u000b!b^5oI><8+\u001b>f+\u0005\t\u0006CA$S\u0013\t\u0019\u0006J\u0001\u0003M_:<\u0007\u0002C+\u0001\u0005\u0003\u0005\u000b\u0011B)\u0002\u0017]Lg\u000eZ8x'&TX\r\t\u0005\t/\u0002\u0011)\u0019!C\u0005!\u0006Yq/\u001b8e_^\u001cF.\u001b3f\u0011!I\u0006A!A!\u0002\u0013\t\u0016\u0001D<j]\u0012|wo\u00157jI\u0016\u0004\u0003\u0002C.\u0001\u0005\u000b\u0007I\u0011\u0002/\u0002\u0015I,G/\u001e:o)f\u0004X-F\u0001^!\rq\u0016MG\u0007\u0002?*\u0011\u0001\rF\u0001\tif\u0004X-\u001b8g_&\u0011!m\u0018\u0002\u0010)f\u0004X-\u00138g_Jl\u0017\r^5p]\"AA\r\u0001B\u0001B\u0003%Q,A\u0006sKR,(O\u001c+za\u0016\u0004\u0003FA2g!\t9u-\u0003\u0002i\u0011\nIAO]1og&,g\u000e\u001e\u0005\u0006U\u0002!\ta[\u0001\u0007y%t\u0017\u000e\u001e \u0015\r1lgn\u001c9r!\t\u0011\u0004\u0001C\u0003=S\u0002\u0007a\bC\u0003ES\u0002\u0007a\tC\u0003PS\u0002\u0007\u0011\u000bC\u0003XS\u0002\u0007\u0011\u000bC\u0003\\S\u0002\u0007Q\fC\u0004t\u0001\t\u0007I\u0011B#\u0002\u0019QLW.\u001a$jK2$\u0007k\\:\t\rU\u0004\u0001\u0015!\u0003G\u00035!\u0018.\\3GS\u0016dG\rU8tA!9q\u000f\u0001b\u0001\n\u0013)\u0015AG5oi\u0016\u0014X.\u001a3jCR,w+\u001b8e_^\u001cF/\u0019:u!>\u001c\bBB=\u0001A\u0003%a)A\u000ej]R,'/\\3eS\u0006$XmV5oI><8\u000b^1siB{7\u000f\t\u0005\nw\u0002\u0001\r\u00111A\u0005\u0012q\fq\"\u001b8uKJlW\rZ5bi\u0016\u0014vn^\u000b\u00025!Ia\u0010\u0001a\u0001\u0002\u0004%\tb`\u0001\u0014S:$XM]7fI&\fG/\u001a*po~#S-\u001d\u000b\u0005\u0003\u0003\t9\u0001E\u0002H\u0003\u0007I1!!\u0002I\u0005\u0011)f.\u001b;\t\u0011\u0005%Q0!AA\u0002i\t1\u0001\u001f\u00132\u0011)\ti\u0001\u0001a\u0001\u0002\u0003\u0006KAG\u0001\u0011S:$XM]7fI&\fG/\u001a*po\u0002B!\"!\u0005\u0001\u0001\u0004\u0005\r\u0011\"\u0003}\u00031\t7mY;nk2\fGo\u001c:t\u0011-\t)\u0002\u0001a\u0001\u0002\u0004%I!a\u0006\u0002!\u0005\u001c7-^7vY\u0006$xN]:`I\u0015\fH\u0003BA\u0001\u00033A\u0011\"!\u0003\u0002\u0014\u0005\u0005\t\u0019\u0001\u000e\t\u0015\u0005u\u0001\u00011A\u0001B\u0003&!$A\u0007bG\u000e,X.\u001e7bi>\u00148\u000f\t\u0005\f\u0003C\u0001\u0001\u0019!a\u0001\n\u0013\t\u0019#\u0001\u0005gk:\u001cG/[8o+\u0005\t\u0004bCA\u0014\u0001\u0001\u0007\t\u0019!C\u0005\u0003S\tABZ;oGRLwN\\0%KF$B!!\u0001\u0002,!I\u0011\u0011BA\u0013\u0003\u0003\u0005\r!\r\u0005\u000b\u0003_\u0001\u0001\u0019!A!B\u0013\t\u0014!\u00034v]\u000e$\u0018n\u001c8!\u0011\u001d\t\u0019\u0004\u0001C!\u0003k\tAa\u001c9f]R!\u0011\u0011AA\u001c\u0011!\tI$!\rA\u0002\u0005m\u0012AB2p]\u001aLw\r\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005C\u0001\u000eG>tg-[4ve\u0006$\u0018n\u001c8\n\t\u0005\u0015\u0013q\b\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000f\u0005%\u0003\u0001\"\u0011\u0002L\u00051!/\u001a3vG\u0016$b!!\u0001\u0002N\u0005}\u0003\u0002CA(\u0003\u000f\u0002\r!!\u0015\u0002\u000fI,7m\u001c:egB)\u00111KA.55\u0011\u0011Q\u000b\u0006\u0005\u0003/\nI&\u0001\u0003mC:<'\"\u0001\u0015\n\t\u0005u\u0013Q\u000b\u0002\t\u0013R,'/\u00192mK\"A\u0011\u0011MA$\u0001\u0004\t\u0019'A\u0002pkR\u0004R!!\u001a\u0002jii!!a\u001a\u000b\u0005aB\u0011\u0002BA6\u0003O\u0012\u0011bQ8mY\u0016\u001cGo\u001c:\t\u000f\u0005=\u0004\u0001\"\u0011\u0002r\u000591m\\7cS:,Gc\u0001\u000e\u0002t!A\u0011qJA7\u0001\u0004\t\t\u0006C\u0004\u0002x\u0001!\t%!\u001f\u0002\u001f\u001d,G\u000f\u0015:pIV\u001cW\r\u001a+za\u0016$\u0012!\u0018")
public class DataSetSlideTimeWindowAggReduceGroupFunction
extends RichGroupReduceFunction<Row, Row>
implements CombineFunction<Row, Row>,
ResultTypeQueryable<Row>,
Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final int keysAndAggregatesArity;
    private final long windowSize;
    private final long windowSlide;
    private final transient TypeInformation<Row> returnType;
    private final int timeFieldPos;
    private final int intermediateWindowStartPos;
    private Row intermediateRow;
    private Row accumulators;
    private GeneratedAggregations function;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler.compile$(this, cl, name, code);
    }

    private Logger LOG$lzycompute() {
        DataSetSlideTimeWindowAggReduceGroupFunction dataSetSlideTimeWindowAggReduceGroupFunction = this;
        synchronized (dataSetSlideTimeWindowAggReduceGroupFunction) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    private GeneratedAggregationsFunction genAggregations() {
        return this.genAggregations;
    }

    private int keysAndAggregatesArity() {
        return this.keysAndAggregatesArity;
    }

    private long windowSize() {
        return this.windowSize;
    }

    private long windowSlide() {
        return this.windowSlide;
    }

    private TypeInformation<Row> returnType() {
        return this.returnType;
    }

    private int timeFieldPos() {
        return this.timeFieldPos;
    }

    private int intermediateWindowStartPos() {
        return this.intermediateWindowStartPos;
    }

    public Row intermediateRow() {
        return this.intermediateRow;
    }

    public void intermediateRow_$eq(Row x$1) {
        this.intermediateRow = x$1;
    }

    private Row accumulators() {
        return this.accumulators;
    }

    private void accumulators_$eq(Row x$1) {
        this.accumulators = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder(36).append("Compiling AggregateHelper: ").append(this.genAggregations()).append(".name \n\n ").append(new StringBuilder(11).append("Code:\n").append(this.genAggregations()).append(".code").toString()).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations().name(), this.genAggregations().code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.accumulators_$eq(this.function().createAccumulators());
        this.intermediateRow_$eq(this.function().createOutputRow());
    }

    public void reduce(Iterable<Row> records, Collector<Row> out) {
        this.function().resetAccumulator(this.accumulators());
        Iterator<Row> iterator = records.iterator();
        Row record = null;
        while (iterator.hasNext()) {
            record = iterator.next();
            this.function().mergeAccumulatorsPair(this.accumulators(), record);
        }
        long windowStart = BoxesRunTime.unboxToLong((Object)record.getField(this.timeFieldPos()));
        long start = TimeWindow.getWindowStartWithOffset((long)windowStart, (long)0L, (long)this.windowSlide());
        if (start > windowStart - this.windowSize()) {
            this.function().setAggregationResults(this.accumulators(), this.intermediateRow());
            this.function().setForwardedFields(record, this.intermediateRow());
            while (start > windowStart - this.windowSize()) {
                this.intermediateRow().setField(this.intermediateWindowStartPos(), (Object)BoxesRunTime.boxToLong((long)start));
                out.collect((Object)this.intermediateRow());
                start -= this.windowSlide();
            }
        }
    }

    public Row combine(Iterable<Row> records) {
        this.function().resetAccumulator(this.accumulators());
        Iterator<Row> iterator = records.iterator();
        Row record = null;
        while (iterator.hasNext()) {
            record = iterator.next();
            this.function().mergeAccumulatorsPair(this.accumulators(), record);
        }
        this.function().setAggregationResults(this.accumulators(), this.intermediateRow());
        this.function().setForwardedFields(record, this.intermediateRow());
        this.intermediateRow().setField(this.timeFieldPos(), record.getField(this.timeFieldPos()));
        return this.intermediateRow();
    }

    public TypeInformation<Row> getProducedType() {
        return this.returnType();
    }

    public DataSetSlideTimeWindowAggReduceGroupFunction(GeneratedAggregationsFunction genAggregations, int keysAndAggregatesArity, long windowSize, long windowSlide, TypeInformation<Row> returnType) {
        this.genAggregations = genAggregations;
        this.keysAndAggregatesArity = keysAndAggregatesArity;
        this.windowSize = windowSize;
        this.windowSlide = windowSlide;
        this.returnType = returnType;
        Compiler.$init$(this);
        Logging.$init$(this);
        this.timeFieldPos = returnType.getArity() - 1;
        this.intermediateWindowStartPos = keysAndAggregatesArity;
    }
}

