/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes.datastream;

import java.io.Serializable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.StreamTableEnvironment;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.calcite.RelTimeIndicatorConverter$;
import org.apache.flink.table.codegen.FunctionCodeGenerator;
import org.apache.flink.table.codegen.FunctionCodeGenerator$;
import org.apache.flink.table.codegen.GeneratedFunction;
import org.apache.flink.table.plan.nodes.CommonCalc;
import org.apache.flink.table.plan.nodes.FlinkRelNode;
import org.apache.flink.table.plan.nodes.datastream.DataStreamRel;
import org.apache.flink.table.plan.schema.RowSchema;
import org.apache.flink.table.runtime.CRowProcessRunner;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo$;
import org.apache.flink.types.Row;
import scala.Function1;
import scala.Function3;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=d\u0001B\u0001\u0003\u0001E\u0011a\u0002R1uCN#(/Z1n\u0007\u0006d7M\u0003\u0002\u0004\t\u0005QA-\u0019;bgR\u0014X-Y7\u000b\u0005\u00151\u0011!\u00028pI\u0016\u001c(BA\u0004\t\u0003\u0011\u0001H.\u00198\u000b\u0005%Q\u0011!\u0002;bE2,'BA\u0006\r\u0003\u00151G.\u001b8l\u0015\tia\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001f\u0005\u0019qN]4\u0004\u0001M!\u0001A\u0005\u000f!!\t\u0019\"$D\u0001\u0015\u0015\t)b#\u0001\u0003d_J,'BA\f\u0019\u0003\r\u0011X\r\u001c\u0006\u000331\tqaY1mG&$X-\u0003\u0002\u001c)\t!1)\u00197d!\tib$D\u0001\u0005\u0013\tyBA\u0001\u0006D_6lwN\\\"bY\u000e\u0004\"!\t\u0012\u000e\u0003\tI!a\t\u0002\u0003\u001b\u0011\u000bG/Y*ue\u0016\fWNU3m\u0011!)\u0003A!A!\u0002\u00131\u0013aB2mkN$XM\u001d\t\u0003O%j\u0011\u0001\u000b\u0006\u0003\u000faI!A\u000b\u0015\u0003\u001bI+Gn\u00149u\u00072,8\u000f^3s\u0011!a\u0003A!A!\u0002\u0013i\u0013\u0001\u0003;sC&$8+\u001a;\u0011\u0005\u001dr\u0013BA\u0018)\u0005-\u0011V\r\u001c+sC&$8+\u001a;\t\u0011E\u0002!\u0011!Q\u0001\nI\nQ!\u001b8qkR\u0004\"a\r\u001b\u000e\u0003YI!!\u000e\f\u0003\u000fI+GNT8eK\"Aq\u0007\u0001B\u0001B\u0003%\u0001(A\u0006j]B,HoU2iK6\f\u0007CA\u001d=\u001b\u0005Q$BA\u001e\u0007\u0003\u0019\u00198\r[3nC&\u0011QH\u000f\u0002\n%><8k\u00195f[\u0006D\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I\u0001\u000f\u0005\t\u0001\u0002\u0011\t\u0011)A\u0005\u0003\u0006Y1-\u00197d!J|wM]1n!\t\u0011U)D\u0001D\u0015\t!\u0005$A\u0002sKbL!AR\"\u0003\u0015I+\u0007\u0010\u0015:pOJ\fW\u000e\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0003=\u0011X\u000f\\3EKN\u001c'/\u001b9uS>t\u0007C\u0001&T\u001d\tY\u0015\u000b\u0005\u0002M\u001f6\tQJ\u0003\u0002O!\u00051AH]8pizR\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u000ba\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\u0019\u0019FO]5oO*\u0011!k\u0014\u0005\u0006/\u0002!\t\u0001W\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011eS6\fX/_?\u0002\u0004\"!\t\u0001\t\u000b\u00152\u0006\u0019\u0001\u0014\t\u000b12\u0006\u0019A\u0017\t\u000bE2\u0006\u0019\u0001\u001a\t\u000b]2\u0006\u0019\u0001\u001d\t\u000bm2\u0006\u0019\u0001\u001d\t\u000b\u00013\u0006\u0019A!\t\u000b!3\u0006\u0019A%\t\u000b\t\u0004A\u0011I2\u0002\u001b\u0011,'/\u001b<f%><H+\u001f9f)\u0005!\u0007CA3i\u001b\u00051'BA4\u0017\u0003\u0011!\u0018\u0010]3\n\u0005%4'a\u0003*fY\u0012\u000bG/\u0019+za\u0016DQa\u001b\u0001\u0005B1\fAaY8qsR!!#\u001c8q\u0011\u0015a#\u000e1\u0001.\u0011\u0015y'\u000e1\u00013\u0003\u0015\u0019\u0007.\u001b7e\u0011\u0015\t(\u000e1\u0001B\u0003\u001d\u0001(o\\4sC6DQa\u001d\u0001\u0005BQ\f\u0001\u0002^8TiJLgn\u001a\u000b\u0002\u0013\")a\u000f\u0001C!o\u0006aQ\r\u001f9mC&tG+\u001a:ngR\u0011\u0001p\u001f\t\u0003geL!A\u001f\f\u0003\u0013I+Gn\u0016:ji\u0016\u0014\b\"\u0002?v\u0001\u0004A\u0018A\u00019x\u0011\u0015q\b\u0001\"\u0011\u0000\u0003=\u0019w.\u001c9vi\u0016\u001cV\r\u001c4D_N$HCBA\u0001\u0003\u000f\t\t\u0002E\u0002(\u0003\u0007I1!!\u0002)\u0005)\u0011V\r\\(qi\u000e{7\u000f\u001e\u0005\b\u0003\u0013i\b\u0019AA\u0006\u0003\u001d\u0001H.\u00198oKJ\u00042aJA\u0007\u0013\r\ty\u0001\u000b\u0002\u000e%\u0016dw\n\u001d;QY\u0006tg.\u001a:\t\u000f\u0005MQ\u00101\u0001\u0002\u0016\u0005AQ.\u001a;bI\u0006$\u0018\r\u0005\u0003\u0002\u0018\u0005mQBAA\r\u0015\r\t\u0019BF\u0005\u0005\u0003;\tIB\u0001\tSK2lU\r^1eCR\f\u0017+^3ss\"9\u0011\u0011\u0005\u0001\u0005B\u0005\r\u0012\u0001E3ti&l\u0017\r^3S_^\u001cu.\u001e8u)\u0011\t)#!\f\u0011\t\u0005\u001d\u0012\u0011F\u0007\u0002\u001f&\u0019\u00111F(\u0003\r\u0011{WO\u00197f\u0011!\t\u0019\"a\bA\u0002\u0005U\u0001bBA\u0019\u0001\u0011\u0005\u00131G\u0001\u0010iJ\fgn\u001d7bi\u0016$v\u000e\u00157b]R1\u0011QGA,\u0003K\u0002b!a\u000e\u0002D\u0005\u001dSBAA\u001d\u0015\r\u0019\u00111\b\u0006\u0005\u0003{\ty$A\u0002ba&T1!!\u0011\u000b\u0003%\u0019HO]3b[&tw-\u0003\u0003\u0002F\u0005e\"A\u0003#bi\u0006\u001cFO]3b[B!\u0011\u0011JA*\u001b\t\tYE\u0003\u0003\u0002N\u0005=\u0013!\u0002;za\u0016\u001c(bAA)\u0011\u00059!/\u001e8uS6,\u0017\u0002BA+\u0003\u0017\u0012Aa\u0011*po\"A\u0011\u0011LA\u0018\u0001\u0004\tY&\u0001\u0005uC\ndW-\u00128w!\u0011\ti&!\u0019\u000e\u0005\u0005}#bAA\u001f\u0011%!\u00111MA0\u0005Y\u0019FO]3b[R\u000b'\r\\3F]ZL'o\u001c8nK:$\b\u0002CA4\u0003_\u0001\r!!\u001b\u0002\u0017E,XM]=D_:4\u0017n\u001a\t\u0005\u0003;\nY'\u0003\u0003\u0002n\u0005}#!E*ue\u0016\fW.U;fef\u001cuN\u001c4jO\u0002")
public class DataStreamCalc
extends Calc
implements CommonCalc,
DataStreamRel {
    private final RelOptCluster cluster;
    private final RowSchema inputSchema;
    private final RowSchema schema;
    private final RexProgram calcProgram;
    private final String ruleDescription;

    @Override
    public boolean needsUpdatesAsRetraction() {
        return DataStreamRel.needsUpdatesAsRetraction$(this);
    }

    @Override
    public boolean producesUpdates() {
        return DataStreamRel.producesUpdates$(this);
    }

    @Override
    public boolean consumesRetractions() {
        return DataStreamRel.consumesRetractions$(this);
    }

    @Override
    public boolean producesRetractions() {
        return DataStreamRel.producesRetractions$(this);
    }

    @Override
    public String getExpressionString(RexNode expr, Seq<String> inFields, Option<Seq<RexNode>> localExprsTable) {
        return FlinkRelNode.getExpressionString$(this, expr, inFields, localExprsTable);
    }

    @Override
    public double estimateRowSize(RelDataType rowType) {
        return FlinkRelNode.estimateRowSize$(this, rowType);
    }

    @Override
    public double estimateDataTypeSize(RelDataType t) {
        return FlinkRelNode.estimateDataTypeSize$(this, t);
    }

    @Override
    public <T extends Function> GeneratedFunction<T, Row> generateFunction(FunctionCodeGenerator generator, String ruleDescription, RowSchema inputSchema, RowSchema returnSchema, Seq<RexNode> calcProjection, Option<RexNode> calcCondition, TableConfig config, Class<T> functionClass) {
        return CommonCalc.generateFunction$(this, generator, ruleDescription, inputSchema, returnSchema, calcProjection, calcCondition, config, functionClass);
    }

    @Override
    public String conditionToString(RexProgram calcProgram, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonCalc.conditionToString$(this, calcProgram, expression);
    }

    @Override
    public String selectionToString(RexProgram calcProgram, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonCalc.selectionToString$(this, calcProgram, expression);
    }

    @Override
    public String calcOpName(RexProgram calcProgram, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonCalc.calcOpName$(this, calcProgram, expression);
    }

    @Override
    public String calcToString(RexProgram calcProgram, Function3<RexNode, List<String>, Option<List<RexNode>>, String> expression) {
        return CommonCalc.calcToString$(this, calcProgram, expression);
    }

    @Override
    public RelOptCost computeSelfCost(RexProgram calcProgram, RelOptPlanner planner, double rowCnt) {
        return CommonCalc.computeSelfCost$(this, calcProgram, planner, rowCnt);
    }

    @Override
    public double estimateRowCount(RexProgram calcProgram, double rowCnt) {
        return CommonCalc.estimateRowCount$(this, calcProgram, rowCnt);
    }

    @Override
    public boolean isComputation(RexNode rexNode) {
        return CommonCalc.isComputation$(this, rexNode);
    }

    @Override
    public RelDataType deriveRowType() {
        return this.schema.relDataType();
    }

    @Override
    public Calc copy(RelTraitSet traitSet, RelNode child, RexProgram program) {
        return new DataStreamCalc(this.cluster, traitSet, child, this.inputSchema, this.schema, program, this.ruleDescription);
    }

    @Override
    public String toString() {
        return this.calcToString(this.calcProgram, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable));
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return pw.input("input", this.getInput()).item("select", this.selectionToString(this.calcProgram, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable))).itemIf("where", this.conditionToString(this.calcProgram, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable)), this.calcProgram.getCondition() != null);
    }

    @Override
    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery metadata) {
        RelNode child = this.getInput();
        Double rowCnt = metadata.getRowCount(child);
        return this.computeSelfCost(this.calcProgram, planner, Predef$.MODULE$.Double2double(rowCnt));
    }

    @Override
    public double estimateRowCount(RelMetadataQuery metadata) {
        RelNode child = this.getInput();
        Double rowCnt = metadata.getRowCount(child);
        return this.estimateRowCount(this.calcProgram, Predef$.MODULE$.Double2double(rowCnt));
    }

    @Override
    public DataStream<CRow> translateToPlan(StreamTableEnvironment tableEnv, StreamQueryConfig queryConfig) {
        None$ none$;
        TableConfig config = tableEnv.getConfig();
        DataStream<CRow> inputDataStream = ((DataStreamRel)this.getInput()).translateToPlan(tableEnv, queryConfig);
        if (this.calcProgram.getCondition() != null) {
            RexNode materializedCondition = RelTimeIndicatorConverter$.MODULE$.convertExpression(this.calcProgram.expandLocalRef(this.calcProgram.getCondition()), this.inputSchema.relDataType(), this.cluster.getRexBuilder());
            none$ = new Some((Object)materializedCondition);
        } else {
            none$ = None$.MODULE$;
        }
        None$ condition = none$;
        Buffer projection = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.calcProgram.getProjectList()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> $this.calcProgram.expandLocalRef((RexLocalRef)x$1), Buffer$.MODULE$.canBuildFrom());
        FunctionCodeGenerator generator = new FunctionCodeGenerator(config, false, this.inputSchema.typeInfo(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$4(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$5(), FunctionCodeGenerator$.MODULE$.$lessinit$greater$default$6());
        GeneratedFunction<ProcessFunction, Row> genFunction = this.generateFunction(generator, this.ruleDescription, this.inputSchema, this.schema, (Seq<RexNode>)projection, (Option<RexNode>)condition, config, ProcessFunction.class);
        int inputParallelism = inputDataStream.getParallelism();
        CRowProcessRunner processFunc = new CRowProcessRunner(genFunction.name(), genFunction.code(), (TypeInformation<CRow>)CRowTypeInfo$.MODULE$.apply(this.schema.typeInfo()));
        return inputDataStream.process((ProcessFunction)processFunc).name(this.calcOpName(this.calcProgram, (Function3<RexNode, List<String>, Option<List<RexNode>>, String>)(Function3 & Serializable & scala.Serializable)(expr, inFields, localExprsTable) -> this.getExpressionString((RexNode)expr, (Seq<String>)inFields, (Option<Seq<RexNode>>)localExprsTable))).setParallelism(inputParallelism);
    }

    public DataStreamCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RowSchema inputSchema, RowSchema schema, RexProgram calcProgram, String ruleDescription) {
        this.cluster = cluster;
        this.inputSchema = inputSchema;
        this.schema = schema;
        this.calcProgram = calcProgram;
        this.ruleDescription = ruleDescription;
        super(cluster, traitSet, input, calcProgram);
        CommonCalc.$init$(this);
        FlinkRelNode.$init$(this);
        DataStreamRel.$init$(this);
    }
}

