/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.plan.nodes;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlMatchRecognize;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableMap;
import org.apache.flink.table.plan.logical.MatchRecognize;
import org.apache.flink.table.runtime.aggregate.SortUtil$;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ubaB\u0001\u0003!\u0003\r\ta\u0004\u0002\u0015\u0007>lWn\u001c8NCR\u001c\u0007NU3d_\u001et\u0017N_3\u000b\u0005\r!\u0011!\u00028pI\u0016\u001c(BA\u0003\u0007\u0003\u0011\u0001H.\u00198\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0011\u0001\u0001\u0005\t\u0003#Qi\u0011A\u0005\u0006\u0002'\u0005)1oY1mC&\u0011QC\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000b]\u0001A\u0011\u0001\r\u0002\r\u0011Jg.\u001b;%)\u0005I\u0002CA\t\u001b\u0013\tY\"C\u0001\u0003V]&$\b\"B\u000f\u0001\t\u0013q\u0012!\u00069beRLG/[8o\u0017\u0016L8\u000fV8TiJLgn\u001a\u000b\u0005?)bt\t\u0005\u0002!O9\u0011\u0011%\n\t\u0003EIi\u0011a\t\u0006\u0003I9\ta\u0001\u0010:p_Rt\u0014B\u0001\u0014\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001&\u000b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0019\u0012\u0002\"B\u0016\u001d\u0001\u0004a\u0013\u0001B6fsN\u00042!\f\u001a5\u001b\u0005q#BA\u00181\u0003\u0011)H/\u001b7\u000b\u0003E\nAA[1wC&\u00111G\f\u0002\u0005\u0019&\u001cH\u000f\u0005\u00026u5\taG\u0003\u00028q\u0005\u0019!/\u001a=\u000b\u0005eR\u0011aB2bY\u000eLG/Z\u0005\u0003wY\u0012qAU3y\u001d>$W\rC\u0003>9\u0001\u0007a(\u0001\u0006gS\u0016dGMT1nKN\u00042a\u0010# \u001d\t\u0001%I\u0004\u0002#\u0003&\t1#\u0003\u0002D%\u00059\u0001/Y2lC\u001e,\u0017BA#G\u0005\r\u0019V-\u001d\u0006\u0003\u0007JAQ\u0001\u0013\u000fA\u0002%\u000b!\"\u001a=qe\u0016\u001c8/[8o!\u0019\t\"\n\u000e M?%\u00111J\u0005\u0002\n\rVt7\r^5p]N\u00022!E'P\u0013\tq%C\u0001\u0004PaRLwN\u001c\t\u0004\u007f\u0011#\u0004\"B)\u0001\t\u0013\u0011\u0016\u0001E8sI\u0016\u0014\u0018N\\4U_N#(/\u001b8h)\ry2k\u0017\u0005\u0006)B\u0003\r!V\u0001\u0007_J$WM]:\u0011\u0005YKV\"A,\u000b\u0005aC\u0014a\u0001:fY&\u0011!l\u0016\u0002\r%\u0016d7i\u001c7mCRLwN\u001c\u0005\u0006{A\u0003\rA\u0010\u0005\u0006;\u0002!IAX\u0001\u0017[\u0016\f7/\u001e:fg\u0012+g-\u001b8f)>\u001cFO]5oOR!qdX7o\u0011\u0015\u0001G\f1\u0001b\u0003!iW-Y:ve\u0016\u001c\b\u0003\u00022l?Qj\u0011a\u0019\u0006\u0003I\u0016\fqaY8mY\u0016\u001cGO\u0003\u0002gO\u000611m\\7n_:T!\u0001[5\u0002\r\u001d|wn\u001a7f\u0015\u0005Q\u0017aA2p[&\u0011An\u0019\u0002\r\u00136lW\u000f^1cY\u0016l\u0015\r\u001d\u0005\u0006{q\u0003\rA\u0010\u0005\u0006\u0011r\u0003\r!\u0013\u0005\u0006a\u0002!I!]\u0001\u0015e><8\u000fU3s\u001b\u0006$8\r\u001b+p'R\u0014\u0018N\\4\u0015\u0005}\u0011\b\"B:p\u0001\u0004!\u0018!B5t\u00032d\u0007CA\tv\u0013\t1(CA\u0004C_>dW-\u00198\t\u000ba\u0004A\u0011B=\u0002\u001dM,(m]3u)>\u001cFO]5oOR\u0011qD\u001f\u0005\u0006w^\u0004\r\u0001`\u0001\u0007gV\u00147/\u001a;\u0011\t\t\\w$ \t\u0004[y|\u0012BA@/\u0005%\u0019vN\u001d;fIN+G\u000fC\u0004\u0002\u0004\u0001!I!!\u0002\u0002%\u00054G/\u001a:NCR\u001c\u0007\u000eV8TiJLgn\u001a\u000b\u0006?\u0005\u001d\u00111\u0002\u0005\b\u0003\u0013\t\t\u00011\u00015\u0003\u0015\tg\r^3s\u0011\u0019i\u0014\u0011\u0001a\u0001}!A\u0011q\u0002\u0001\u0005\u0002!\t\t\"A\u0007nCR\u001c\u0007\u000eV8TiJLgn\u001a\u000b\b?\u0005M\u00111EA\u0013\u0011!\t)\"!\u0004A\u0002\u0005]\u0011\u0001\u00047pO&\u001c\u0017\r\\'bi\u000eD\u0007\u0003BA\r\u0003?i!!a\u0007\u000b\u0007\u0005uA!A\u0004m_\u001eL7-\u00197\n\t\u0005\u0005\u00121\u0004\u0002\u000f\u001b\u0006$8\r\u001b*fG><g.\u001b>f\u0011\u0019i\u0014Q\u0002a\u0001}!1\u0001*!\u0004A\u0002%C\u0001\"!\u000b\u0001\t\u0003A\u00111F\u0001\rKb\u0004H.Y5o\u001b\u0006$8\r\u001b\u000b\u000b\u0003[\t\u0019$a\u000e\u0002:\u0005m\u0002c\u0001,\u00020%\u0019\u0011\u0011G,\u0003\u0013I+Gn\u0016:ji\u0016\u0014\b\u0002CA\u001b\u0003O\u0001\r!!\f\u0002\u0005A<\b\u0002CA\u000b\u0003O\u0001\r!a\u0006\t\ru\n9\u00031\u0001?\u0011\u0019A\u0015q\u0005a\u0001\u0013\u0002")
public interface CommonMatchRecognize {
    private String partitionKeysToString(List<RexNode> keys, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(keys).asScala()).map((Function1 & Serializable & scala.Serializable)k -> (String)expression.apply(k, (Object)fieldNames, (Object)None$.MODULE$), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String orderingToString(RelCollation orders, Seq<String> fieldNames) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(orders.getFieldCollations()).asScala()).map((Function1 & Serializable & scala.Serializable)x -> new StringBuilder(1).append(fieldNames.apply(x.getFieldIndex())).append(" ").append(SortUtil$.MODULE$.directionToOrder(x.direction).getShortName()).toString(), Buffer$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String measuresDefineToString(ImmutableMap<String, RexNode> measures, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(measures).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            RexNode v = (RexNode)tuple2._2();
            String string = new StringBuilder(4).append(expression.apply((Object)v, (Object)fieldNames, (Object)None$.MODULE$)).append(" AS ").append(k).toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String rowsPerMatchToString(boolean isAll) {
        return isAll ? "ALL ROWS PER MATCH" : "ONE ROW PER MATCH";
    }

    private String subsetToString(ImmutableMap<String, SortedSet<String>> subset) {
        return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(subset).asScala()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String k = (String)tuple2._1();
            SortedSet v = (SortedSet)tuple2._2();
            String string = new StringBuilder(5).append(k).append(" = (").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter((Set)v).asScala()).mkString(", ")).append(")").toString();
            return string;
        }, Iterable$.MODULE$.canBuildFrom())).mkString(", ");
    }

    private String afterMatchToString(RexNode after, Seq<String> fieldNames) {
        String string;
        SqlKind sqlKind = after.getKind();
        if (((Object)((Object)SqlKind.SKIP_TO_FIRST)).equals((Object)sqlKind)) {
            string = new StringBuilder(14).append("SKIP TO FIRST ").append(((RexNode)((RexCall)after).operands.get(0)).toString()).toString();
        } else if (((Object)((Object)SqlKind.SKIP_TO_LAST)).equals((Object)sqlKind)) {
            string = new StringBuilder(13).append("SKIP TO LAST ").append(((RexNode)((RexCall)after).operands.get(0)).toString()).toString();
        } else if (((Object)((Object)SqlKind.LITERAL)).equals((Object)sqlKind)) {
            String string2;
            SqlMatchRecognize.AfterOption afterOption = ((RexLiteral)after).getValueAs(SqlMatchRecognize.AfterOption.class);
            if (((Object)((Object)SqlMatchRecognize.AfterOption.SKIP_PAST_LAST_ROW)).equals((Object)afterOption)) {
                string2 = "SKIP PAST LAST ROW";
            } else if (((Object)((Object)SqlMatchRecognize.AfterOption.SKIP_TO_NEXT_ROW)).equals((Object)afterOption)) {
                string2 = "SKIP TO NEXT ROW";
            } else {
                throw new MatchError((Object)afterOption);
            }
            string = string2;
        } else {
            throw new IllegalStateException(new StringBuilder(59).append("Corrupted query tree. Unexpected ").append(after).append(" for ").append("after match strategy.").toString());
        }
        return string;
    }

    public static /* synthetic */ String matchToString$(CommonMatchRecognize $this, MatchRecognize logicalMatch, Seq fieldNames, Function3 expression) {
        return $this.matchToString(logicalMatch, (Seq<String>)fieldNames, (Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String>)expression);
    }

    default public String matchToString(MatchRecognize logicalMatch, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression) {
        String partitionBy = !logicalMatch.partitionKeys().isEmpty() ? new StringBuilder(14).append("PARTITION BY: ").append(this.partitionKeysToString(logicalMatch.partitionKeys(), fieldNames, expression)).toString() : "";
        String orderBy = !logicalMatch.orderKeys().getFieldCollations().isEmpty() ? new StringBuilder(10).append("ORDER BY: ").append(this.orderingToString(logicalMatch.orderKeys(), fieldNames)).toString() : "";
        String measures = !logicalMatch.measures().isEmpty() ? new StringBuilder(10).append("MEASURES: ").append(this.measuresDefineToString(logicalMatch.measures(), fieldNames, expression)).toString() : "";
        String afterMatch = String.valueOf(this.afterMatchToString(logicalMatch.after(), fieldNames));
        String allRows = this.rowsPerMatchToString(logicalMatch.allRows());
        String pattern = new StringBuilder(11).append("PATTERN: (").append(logicalMatch.pattern().toString()).append(")").toString();
        String subset = !logicalMatch.subsets().isEmpty() ? new StringBuilder(9).append("SUBSET: ").append(this.subsetToString(logicalMatch.subsets())).append(" ").toString() : "";
        String define = new StringBuilder(8).append("DEFINE: ").append(this.measuresDefineToString(logicalMatch.patternDefinitions(), fieldNames, expression)).toString();
        String body = ((TraversableOnce)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{partitionBy, orderBy, measures, allRows, afterMatch, pattern, subset, define}))).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.isEmpty()))).mkString(", ");
        return new StringBuilder(7).append("Match(").append(body).append(")").toString();
    }

    public static /* synthetic */ RelWriter explainMatch$(CommonMatchRecognize $this, RelWriter pw, MatchRecognize logicalMatch, Seq fieldNames, Function3 expression) {
        return $this.explainMatch(pw, logicalMatch, (Seq<String>)fieldNames, (Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String>)expression);
    }

    default public RelWriter explainMatch(RelWriter pw, MatchRecognize logicalMatch, Seq<String> fieldNames, Function3<RexNode, Seq<String>, Option<Seq<RexNode>>, String> expression) {
        return pw.itemIf("partitionBy", this.partitionKeysToString(logicalMatch.partitionKeys(), fieldNames, expression), !logicalMatch.partitionKeys().isEmpty()).itemIf("orderBy", this.orderingToString(logicalMatch.orderKeys(), fieldNames), !logicalMatch.orderKeys().getFieldCollations().isEmpty()).itemIf("measures", this.measuresDefineToString(logicalMatch.measures(), fieldNames, expression), !logicalMatch.measures().isEmpty()).item("rowsPerMatch", this.rowsPerMatchToString(logicalMatch.allRows())).item("after", this.afterMatchToString(logicalMatch.after(), fieldNames)).item("pattern", logicalMatch.pattern().toString()).itemIf("subset", this.subsetToString(logicalMatch.subsets()), !logicalMatch.subsets().isEmpty()).item("define", logicalMatch.patternDefinitions());
    }

    public static void $init$(CommonMatchRecognize $this) {
    }
}

