/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.functions;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.descriptors.ClassInstanceValidator$;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FunctionDescriptor;
import org.apache.flink.table.descriptors.FunctionDescriptorValidator;
import org.apache.flink.table.descriptors.HierarchyDescriptorValidator$;
import org.apache.flink.table.descriptors.LiteralValueValidator$;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.util.Logging;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ClassTag$;

public final class FunctionService$
implements Logging {
    public static FunctionService$ MODULE$;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new FunctionService$();
    }

    private Logger LOG$lzycompute() {
        FunctionService$ functionService$ = this;
        synchronized (functionService$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    public UserDefinedFunction createFunction(FunctionDescriptor descriptor) {
        return this.createFunction(descriptor, Thread.currentThread().getContextClassLoader(), this.createFunction$default$3());
    }

    public UserDefinedFunction createFunction(FunctionDescriptor descriptor, ClassLoader classLoader, boolean performValidation) {
        Tuple2 tuple2;
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(descriptor.toProperties());
        if (performValidation) {
            new FunctionDescriptorValidator().validate(properties);
        }
        if ((tuple2 = this.generateInstance(HierarchyDescriptorValidator$.MODULE$.EMPTY_PREFIX(), properties, classLoader)) == null) {
            throw new MatchError(tuple2);
        }
        Class instanceClass = (Class)tuple2._1();
        Object instance = tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)instanceClass, instance);
        Tuple2 tuple23 = tuple22;
        Class instanceClass2 = (Class)tuple23._1();
        Object instance2 = tuple23._2();
        if (!UserDefinedFunction.class.isAssignableFrom(instanceClass2)) {
            throw new ValidationException(new StringBuilder(53).append("Instantiated class '").append(instanceClass2.getName()).append("' is not a user-defined function.").toString());
        }
        return (UserDefinedFunction)instance2;
    }

    public boolean createFunction$default$3() {
        return true;
    }

    private <T> Tuple2<Class<T>, T> generateInstance(String keyPrefix, DescriptorProperties descriptorProperties, ClassLoader classLoader) {
        Object obj;
        Constructor<?> constructor;
        Class<?> clazz;
        String instanceClassName = descriptorProperties.getString(new StringBuilder(0).append(keyPrefix).append(ClassInstanceValidator$.MODULE$.CLASS()).toString());
        try {
            clazz = Class.forName(descriptorProperties.getString(new StringBuilder(0).append(keyPrefix).append(ClassInstanceValidator$.MODULE$.CLASS()).toString()), true, classLoader);
        }
        catch (Exception e2) {
            String msg = new StringBuilder(49).append("Could not find class '").append(instanceClassName).append("' for creating an instance.").toString();
            this.LOG().error(msg, (Throwable)e2);
            throw new ValidationException(msg);
        }
        Class<?> instanceClass = clazz;
        String constructorPrefix = new StringBuilder(0).append(keyPrefix).append(ClassInstanceValidator$.MODULE$.CONSTRUCTOR()).toString();
        List<Map<String, String>> constructorProps = descriptorProperties.getVariableIndexedProperties(constructorPrefix, JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)Nil$.MODULE$));
        ArrayBuffer parameterList = new ArrayBuffer();
        for (int i = 0; i < constructorProps.size(); ++i) {
            ArrayBuffer arrayBuffer;
            if (((Map)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(constructorProps).apply(i)).containsKey(ClassInstanceValidator$.MODULE$.CLASS())) {
                arrayBuffer = parameterList.$plus$eq(this.generateInstance(new StringBuilder(2).append(constructorPrefix).append(".").append(i).append(".").toString(), descriptorProperties, classLoader));
                continue;
            }
            Object literalValue = LiteralValueValidator$.MODULE$.getValue(new StringBuilder(2).append(constructorPrefix).append(".").append(i).append(".").toString(), descriptorProperties);
            arrayBuffer = parameterList.$plus$eq((Object)new Tuple2(literalValue.getClass(), literalValue));
        }
        try {
            constructor = instanceClass.getConstructor((Class[])((TraversableOnce)parameterList.map((Function1 & Serializable & scala.Serializable)x$2 -> (Class)x$2._1(), ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Class.class)));
        }
        catch (Exception e3) {
            String msg = new StringBuilder(54).append("Cannot find a public constructor with parameter types ").append(new StringBuilder(10).append("'").append(((TraversableOnce)parameterList.map((Function1 & Serializable & scala.Serializable)x$3 -> ((Class)x$3._1()).getName(), ArrayBuffer$.MODULE$.canBuildFrom())).mkString(", ")).append("' for '").append(instanceClassName).append("'.").toString()).toString();
            this.LOG().error(msg, (Throwable)e3);
            throw new ValidationException(msg);
        }
        Constructor<?> constructor2 = constructor;
        try {
            obj = constructor2.newInstance((Object[])((TraversableOnce)parameterList.map((Function1 & Serializable & scala.Serializable)x$4 -> x$4._2(), ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.AnyRef()));
        }
        catch (Exception e4) {
            String msg = new StringBuilder(42).append("Error while creating instance of class '").append(instanceClassName).append("' ").append(new StringBuilder(24).append("with parameter types '").append(((TraversableOnce)parameterList.map((Function1 & Serializable & scala.Serializable)x$5 -> ((Class)x$5._1()).getName(), ArrayBuffer$.MODULE$.canBuildFrom())).mkString(", ")).append("'.").toString()).toString();
            this.LOG().error(msg, (Throwable)e4);
            throw new ValidationException(msg);
        }
        Object instance = obj;
        return new Tuple2(instanceClass, instance);
    }

    private FunctionService$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

