/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.factories;

import java.util.Map;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.StreamTableEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.descriptors.Descriptor;
import org.apache.flink.table.factories.BatchTableSinkFactory;
import org.apache.flink.table.factories.BatchTableSourceFactory;
import org.apache.flink.table.factories.StreamTableSinkFactory;
import org.apache.flink.table.factories.StreamTableSourceFactory;
import org.apache.flink.table.factories.TableFactoryService$;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.TableSource;

public final class TableFactoryUtil$ {
    public static TableFactoryUtil$ MODULE$;

    static {
        new TableFactoryUtil$();
    }

    public <T> TableSource<T> findAndCreateTableSource(TableEnvironment tableEnvironment, Descriptor descriptor) {
        TableSource tableSource;
        Map<String, String> javaMap = descriptor.toProperties();
        TableEnvironment tableEnvironment2 = tableEnvironment;
        if (tableEnvironment2 instanceof BatchTableEnvironment) {
            tableSource = TableFactoryService$.MODULE$.find(BatchTableSourceFactory.class, javaMap).createBatchTableSource(javaMap);
        } else if (tableEnvironment2 instanceof StreamTableEnvironment) {
            tableSource = TableFactoryService$.MODULE$.find(StreamTableSourceFactory.class, javaMap).createStreamTableSource(javaMap);
        } else {
            throw new TableException(new StringBuilder(31).append("Unsupported table environment: ").append(tableEnvironment2.getClass().getName()).toString());
        }
        return tableSource;
    }

    public <T> TableSink<T> findAndCreateTableSink(TableEnvironment tableEnvironment, Descriptor descriptor) {
        TableSink tableSink;
        Map<String, String> javaMap = descriptor.toProperties();
        TableEnvironment tableEnvironment2 = tableEnvironment;
        if (tableEnvironment2 instanceof BatchTableEnvironment) {
            tableSink = TableFactoryService$.MODULE$.find(BatchTableSinkFactory.class, javaMap).createBatchTableSink(javaMap);
        } else if (tableEnvironment2 instanceof StreamTableEnvironment) {
            tableSink = TableFactoryService$.MODULE$.find(StreamTableSinkFactory.class, javaMap).createStreamTableSink(javaMap);
        } else {
            throw new TableException(new StringBuilder(31).append("Unsupported table environment: ").append(tableEnvironment2.getClass().getName()).toString());
        }
        return tableSink;
    }

    private TableFactoryUtil$() {
        MODULE$ = this;
    }
}

