/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.dataview;

import java.io.IOException;
import java.util.List;
import org.apache.flink.api.common.typeutils.CompositeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSchemaCompatibility;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.table.api.dataview.ListView;
import org.apache.flink.table.dataview.ListViewSerializer;
import org.apache.flink.util.Preconditions;

public final class ListViewSerializerSnapshot<T>
implements TypeSerializerSnapshot<ListView<T>> {
    private static final int CURRENT_VERSION = 1;
    private CompositeSerializerSnapshot nestedListSerializerSnapshot;

    public ListViewSerializerSnapshot() {
    }

    public ListViewSerializerSnapshot(TypeSerializer<List<T>> listSerializer) {
        this.nestedListSerializerSnapshot = new CompositeSerializerSnapshot(new TypeSerializer[]{(TypeSerializer)Preconditions.checkNotNull(listSerializer)});
    }

    public int getCurrentVersion() {
        return 1;
    }

    public TypeSerializer<ListView<T>> restoreSerializer() {
        return new ListViewSerializer(this.nestedListSerializerSnapshot.getRestoreSerializer(0));
    }

    public TypeSerializerSchemaCompatibility<ListView<T>> resolveSchemaCompatibility(TypeSerializer<ListView<T>> newSerializer) {
        Preconditions.checkState((this.nestedListSerializerSnapshot != null ? 1 : 0) != 0);
        if (newSerializer instanceof ListViewSerializer) {
            ListViewSerializer serializer = (ListViewSerializer)newSerializer;
            return this.nestedListSerializerSnapshot.resolveCompatibilityWithNested(TypeSerializerSchemaCompatibility.compatibleAsIs(), new TypeSerializer[]{serializer.getListSerializer()});
        }
        return TypeSerializerSchemaCompatibility.incompatible();
    }

    public void writeSnapshot(DataOutputView out) throws IOException {
        this.nestedListSerializerSnapshot.writeCompositeSnapshot(out);
    }

    public void readSnapshot(int readVersion, DataInputView in, ClassLoader userCodeClassLoader) throws IOException {
        this.nestedListSerializerSnapshot = CompositeSerializerSnapshot.readCompositeSnapshot((DataInputView)in, (ClassLoader)userCodeClassLoader);
    }
}

