/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.Utils;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.types.Row;

public class CollectBatchTableSink
implements BatchTableSink<Row> {
    private final String accumulatorName;
    private final TypeSerializer<Row> serializer;
    private String[] fieldNames;
    private TypeInformation<?>[] fieldTypes;

    public CollectBatchTableSink(String accumulatorName, TypeSerializer<Row> serializer) {
        this.accumulatorName = accumulatorName;
        this.serializer = serializer;
    }

    @Override
    public TypeInformation<Row> getOutputType() {
        return Types.ROW_NAMED((String[])this.fieldNames, this.fieldTypes);
    }

    @Override
    public String[] getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public TypeInformation<?>[] getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public TableSink<Row> configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        CollectBatchTableSink copy = new CollectBatchTableSink(this.accumulatorName, this.serializer);
        copy.fieldNames = fieldNames;
        copy.fieldTypes = fieldTypes;
        return copy;
    }

    @Override
    public void emitDataSet(DataSet<Row> dataSet) {
        dataSet.output((OutputFormat)new Utils.CollectHelper(this.accumulatorName, this.serializer)).name("SQL Client Batch Collect Sink");
    }

    public TypeSerializer<Row> getSerializer() {
        return this.serializer;
    }
}

