/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.flink.table.client.config.Environment;
import org.apache.flink.table.client.config.entries.ViewEntry;

public class SessionContext {
    private final String name;
    private final Environment defaultEnvironment;
    private final Map<String, String> sessionProperties;
    private final Map<String, ViewEntry> views;

    public SessionContext(String name, Environment defaultEnvironment) {
        this.name = name;
        this.defaultEnvironment = defaultEnvironment;
        this.sessionProperties = new HashMap<String, String>();
        this.views = new LinkedHashMap<String, ViewEntry>();
    }

    public void setSessionProperty(String key, String value) {
        this.sessionProperties.put(key, value);
    }

    public void resetSessionProperties() {
        this.sessionProperties.clear();
    }

    public void addView(ViewEntry viewEntry) {
        this.views.put(viewEntry.getName(), viewEntry);
    }

    public void removeView(String name) {
        this.views.remove(name);
    }

    public Map<String, ViewEntry> getViews() {
        return Collections.unmodifiableMap(this.views);
    }

    public String getName() {
        return this.name;
    }

    public Environment getEnvironment() {
        return Environment.enrich(this.defaultEnvironment, this.sessionProperties, this.views);
    }

    public SessionContext copy() {
        SessionContext session = new SessionContext(this.name, this.defaultEnvironment);
        session.sessionProperties.putAll(this.sessionProperties);
        session.views.putAll(this.views);
        return session;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SessionContext)) {
            return false;
        }
        SessionContext context = (SessionContext)o;
        return Objects.equals(this.name, context.name) && Objects.equals(this.defaultEnvironment, context.defaultEnvironment) && Objects.equals(this.sessionProperties, context.sessionProperties) && Objects.equals(this.views, context.views);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.defaultEnvironment, this.sessionProperties, this.views);
    }
}

