/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.io.IOContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import org.apache.flink.table.descriptors.DescriptorProperties;

public class ConfigUtil {
    private ConfigUtil() {
    }

    public static DescriptorProperties normalizeYaml(Map<String, Object> yamlMap) {
        HashMap<String, String> normalized = new HashMap<String, String>();
        yamlMap.forEach((k, v) -> ConfigUtil.normalizeYamlObject(normalized, k, v));
        DescriptorProperties properties = new DescriptorProperties(true);
        properties.putProperties(normalized);
        return properties;
    }

    private static void normalizeYamlObject(Map<String, String> normalized, String key, Object value) {
        if (value instanceof Map) {
            Map map2 = (Map)value;
            map2.forEach((k, v) -> ConfigUtil.normalizeYamlObject(normalized, key + "." + k, v));
        } else if (value instanceof List) {
            List list = (List)value;
            for (int i = 0; i < list.size(); ++i) {
                ConfigUtil.normalizeYamlObject(normalized, key + "." + i, list.get(i));
            }
        } else {
            normalized.put(key, value.toString());
        }
    }

    public static class LowerCaseYamlMapper
    extends ObjectMapper {
        public LowerCaseYamlMapper() {
            super((JsonFactory)new YAMLFactory(){

                protected YAMLParser _createParser(InputStream in, IOContext ctxt) throws IOException {
                    Reader r = this._createReader(in, null, ctxt);
                    return new YAMLParser(ctxt, this._getBufferRecycler(), this._parserFeatures, this._yamlParserFeatures, this._objectCodec, r){

                        public String getCurrentName() throws IOException {
                            if (this._currToken == JsonToken.FIELD_NAME) {
                                return this._currentFieldName.toLowerCase();
                            }
                            return super.getCurrentName();
                        }

                        public String getText() throws IOException {
                            if (this._currToken == JsonToken.FIELD_NAME) {
                                return this._currentFieldName.toLowerCase();
                            }
                            return super.getText();
                        }
                    };
                }
            });
        }
    }
}

