/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.StreamTableEnvironment;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.ExternalCatalogTable;
import org.apache.flink.table.factories.TableFactoryUtil$;
import org.apache.flink.table.plan.schema.BatchTableSourceTable;
import org.apache.flink.table.plan.schema.StreamTableSourceTable;
import org.apache.flink.table.plan.schema.TableSinkTable;
import org.apache.flink.table.plan.schema.TableSourceSinkTable;
import org.apache.flink.table.plan.schema.TableSourceTable;
import org.apache.flink.table.plan.stats.FlinkStatistic;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.StreamTableSink;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.table.sources.BatchTableSource;
import org.apache.flink.table.sources.StreamTableSource;
import org.apache.flink.table.sources.TableSource;
import org.apache.flink.table.util.Logging;
import org.slf4j.Logger;
import scala.None$;
import scala.Some;

public final class ExternalTableUtil$
implements Logging {
    public static ExternalTableUtil$ MODULE$;
    private transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    static {
        new ExternalTableUtil$();
    }

    private Logger LOG$lzycompute() {
        ExternalTableUtil$ externalTableUtil$ = this;
        synchronized (externalTableUtil$) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging.LOG$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.LOG;
    }

    @Override
    public Logger LOG() {
        return !this.bitmap$trans$0 ? this.LOG$lzycompute() : this.LOG;
    }

    public <T1, T2> TableSourceSinkTable<T1, T2> fromExternalCatalogTable(TableEnvironment tableEnv, ExternalCatalogTable externalTable) {
        FlinkStatistic statistics = new FlinkStatistic(externalTable.getTableStats());
        None$ source = externalTable.isTableSource() ? new Some(this.createTableSource(tableEnv, externalTable, statistics)) : None$.MODULE$;
        None$ sink = externalTable.isTableSink() ? new Some(this.createTableSink(tableEnv, externalTable, statistics)) : None$.MODULE$;
        return new TableSourceSinkTable(source, sink);
    }

    private <T> TableSourceTable<T> createTableSource(TableEnvironment tableEnv, ExternalCatalogTable externalTable, FlinkStatistic statistics) {
        TableSourceTable tableSourceTable;
        TableEnvironment tableEnvironment = tableEnv;
        if (tableEnvironment instanceof BatchTableEnvironment && externalTable.isBatchTable()) {
            TableSource source = TableFactoryUtil$.MODULE$.findAndCreateTableSource(tableEnv, externalTable);
            tableSourceTable = new BatchTableSourceTable((BatchTableSource)source, statistics);
        } else if (tableEnvironment instanceof StreamTableEnvironment && externalTable.isStreamTable()) {
            TableSource source = TableFactoryUtil$.MODULE$.findAndCreateTableSource(tableEnv, externalTable);
            tableSourceTable = new StreamTableSourceTable((StreamTableSource)source, statistics);
        } else {
            throw new ValidationException("External catalog table does not support the current environment for a table source.");
        }
        return tableSourceTable;
    }

    private <T> TableSinkTable<T> createTableSink(TableEnvironment tableEnv, ExternalCatalogTable externalTable, FlinkStatistic statistics) {
        TableSinkTable tableSinkTable;
        TableEnvironment tableEnvironment = tableEnv;
        if (tableEnvironment instanceof BatchTableEnvironment && externalTable.isBatchTable()) {
            TableSink sink = TableFactoryUtil$.MODULE$.findAndCreateTableSink(tableEnv, externalTable);
            tableSinkTable = new TableSinkTable((BatchTableSink)sink, statistics);
        } else if (tableEnvironment instanceof StreamTableEnvironment && externalTable.isStreamTable()) {
            TableSink sink = TableFactoryUtil$.MODULE$.findAndCreateTableSink(tableEnv, externalTable);
            tableSinkTable = new TableSinkTable((StreamTableSink)sink, statistics);
        } else {
            throw new ValidationException("External catalog table does not support the current environment for a table sink.");
        }
        return tableSinkTable;
    }

    private ExternalTableUtil$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

