/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.operator;

import org.apache.flink.annotation.Internal;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.Collector;
import org.apache.flink.util.OutputTag;

@Internal
public class TimestampedSideOutputCollector<T>
implements Collector<T> {
    private final Output<?> output;
    private final StreamRecord<T> reuse;
    private final OutputTag<T> outputTag;

    public TimestampedSideOutputCollector(OutputTag<T> outputTag, Output<?> output) {
        this.output = output;
        this.outputTag = outputTag;
        this.reuse = new StreamRecord(null);
    }

    public void collect(T record) {
        this.output.collect(this.outputTag, this.reuse.replace(record));
    }

    public void setTimestamp(StreamRecord<?> timestampBase) {
        if (timestampBase.hasTimestamp()) {
            this.reuse.setTimestamp(timestampBase.getTimestamp());
        } else {
            this.reuse.eraseTimestamp();
        }
    }

    public void setAbsoluteTimestamp(long timestamp) {
        this.reuse.setTimestamp(timestamp);
    }

    public void eraseTimestamp() {
        this.reuse.eraseTimestamp();
    }

    public void close() {
        this.output.close();
    }
}

