/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.operator;

import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.EventComparator;
import org.apache.flink.cep.PatternSelectFunction;
import org.apache.flink.cep.PatternTimeoutFunction;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.AbstractKeyedCEPPatternOperator;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.util.OutputTag;

public class SelectTimeoutCepOperator<IN, OUT1, OUT2, KEY>
extends AbstractKeyedCEPPatternOperator<IN, KEY, OUT1, SelectWrapper<IN, OUT1, OUT2>> {
    private OutputTag<OUT2> timedOutOutputTag;

    public SelectTimeoutCepOperator(TypeSerializer<IN> inputSerializer, boolean isProcessingTime, NFACompiler.NFAFactory<IN> nfaFactory, EventComparator<IN> comparator, AfterMatchSkipStrategy skipStrategy, PatternSelectFunction<IN, OUT1> flatSelectFunction, PatternTimeoutFunction<IN, OUT2> flatTimeoutFunction, OutputTag<OUT2> outputTag, OutputTag<IN> lateDataOutputTag) {
        super(inputSerializer, isProcessingTime, nfaFactory, comparator, skipStrategy, new SelectWrapper<IN, OUT1, OUT2>(flatSelectFunction, flatTimeoutFunction), lateDataOutputTag);
        this.timedOutOutputTag = outputTag;
    }

    @Override
    protected void processMatchedSequences(Iterable<Map<String, List<IN>>> matchingSequences, long timestamp) throws Exception {
        for (Map<String, List<IN>> match : matchingSequences) {
            this.output.collect((Object)new StreamRecord(((SelectWrapper)this.getUserFunction()).getFlatSelectFunction().select(match), timestamp));
        }
    }

    @Override
    protected void processTimedOutSequences(Iterable<Tuple2<Map<String, List<IN>>, Long>> timedOutSequences, long timestamp) throws Exception {
        for (Tuple2<Map<String, List<IN>>, Long> match : timedOutSequences) {
            this.output.collect(this.timedOutOutputTag, new StreamRecord(((SelectWrapper)this.getUserFunction()).getFlatTimeoutFunction().timeout((Map)match.f0, (Long)match.f1), timestamp));
        }
    }

    @Internal
    public static class SelectWrapper<IN, OUT1, OUT2>
    implements Function {
        private static final long serialVersionUID = -8320546120157150202L;
        private PatternSelectFunction<IN, OUT1> flatSelectFunction;
        private PatternTimeoutFunction<IN, OUT2> flatTimeoutFunction;

        PatternSelectFunction<IN, OUT1> getFlatSelectFunction() {
            return this.flatSelectFunction;
        }

        PatternTimeoutFunction<IN, OUT2> getFlatTimeoutFunction() {
            return this.flatTimeoutFunction;
        }

        public SelectWrapper(PatternSelectFunction<IN, OUT1> flatSelectFunction, PatternTimeoutFunction<IN, OUT2> flatTimeoutFunction) {
            this.flatSelectFunction = flatSelectFunction;
            this.flatTimeoutFunction = flatTimeoutFunction;
        }
    }
}

