/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.cep.operator;

import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.functions.Function;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.cep.EventComparator;
import org.apache.flink.cep.PatternFlatSelectFunction;
import org.apache.flink.cep.PatternFlatTimeoutFunction;
import org.apache.flink.cep.nfa.aftermatch.AfterMatchSkipStrategy;
import org.apache.flink.cep.nfa.compiler.NFACompiler;
import org.apache.flink.cep.operator.AbstractKeyedCEPPatternOperator;
import org.apache.flink.cep.operator.TimestampedSideOutputCollector;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.util.OutputTag;

public class FlatSelectTimeoutCepOperator<IN, OUT1, OUT2, KEY>
extends AbstractKeyedCEPPatternOperator<IN, KEY, OUT1, FlatSelectWrapper<IN, OUT1, OUT2>> {
    private transient TimestampedCollector<OUT1> collector;
    private transient TimestampedSideOutputCollector<OUT2> sideOutputCollector;
    private OutputTag<OUT2> timedOutOutputTag;

    public FlatSelectTimeoutCepOperator(TypeSerializer<IN> inputSerializer, boolean isProcessingTime, NFACompiler.NFAFactory<IN> nfaFactory, EventComparator<IN> comparator, AfterMatchSkipStrategy skipStrategy, PatternFlatSelectFunction<IN, OUT1> flatSelectFunction, PatternFlatTimeoutFunction<IN, OUT2> flatTimeoutFunction, OutputTag<OUT2> outputTag, OutputTag<IN> lateDataOutputTag) {
        super(inputSerializer, isProcessingTime, nfaFactory, comparator, skipStrategy, new FlatSelectWrapper<IN, OUT1, OUT2>(flatSelectFunction, flatTimeoutFunction), lateDataOutputTag);
        this.timedOutOutputTag = outputTag;
    }

    @Override
    public void open() throws Exception {
        super.open();
        this.collector = new TimestampedCollector(this.output);
        this.sideOutputCollector = new TimestampedSideOutputCollector<OUT2>(this.timedOutOutputTag, this.output);
    }

    @Override
    protected void processMatchedSequences(Iterable<Map<String, List<IN>>> matchingSequences, long timestamp) throws Exception {
        for (Map<String, List<IN>> match : matchingSequences) {
            ((FlatSelectWrapper)this.getUserFunction()).getFlatSelectFunction().flatSelect(match, this.collector);
        }
    }

    @Override
    protected void processTimedOutSequences(Iterable<Tuple2<Map<String, List<IN>>, Long>> timedOutSequences, long timestamp) throws Exception {
        for (Tuple2<Map<String, List<IN>>, Long> match : timedOutSequences) {
            this.sideOutputCollector.setAbsoluteTimestamp(timestamp);
            ((FlatSelectWrapper)this.getUserFunction()).getFlatTimeoutFunction().timeout((Map)match.f0, (Long)match.f1, this.sideOutputCollector);
        }
    }

    @Internal
    public static class FlatSelectWrapper<IN, OUT1, OUT2>
    implements Function {
        private static final long serialVersionUID = -8320546120157150202L;
        private PatternFlatSelectFunction<IN, OUT1> flatSelectFunction;
        private PatternFlatTimeoutFunction<IN, OUT2> flatTimeoutFunction;

        @VisibleForTesting
        public PatternFlatSelectFunction<IN, OUT1> getFlatSelectFunction() {
            return this.flatSelectFunction;
        }

        @VisibleForTesting
        public PatternFlatTimeoutFunction<IN, OUT2> getFlatTimeoutFunction() {
            return this.flatTimeoutFunction;
        }

        public FlatSelectWrapper(PatternFlatSelectFunction<IN, OUT1> flatSelectFunction, PatternFlatTimeoutFunction<IN, OUT2> flatTimeoutFunction) {
            this.flatSelectFunction = flatSelectFunction;
            this.flatTimeoutFunction = flatTimeoutFunction;
        }
    }
}

