/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.Algorithm;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.AggregateImpl;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.AlgorithmImpl;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.Cost;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.Lattice;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.LatticeImpl;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Attribute;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Schema;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.util.AggDesUtil;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.util.BitSetPlus;

public class MonteCarloLatticeImpl
extends LatticeImpl {
    private final int queryCount = 1000;
    private final Random random = new Random(12345L);
    private final List<BitSetPlus> ancestorClosure = new ArrayList<BitSetPlus>();

    public MonteCarloLatticeImpl(Schema schema) {
        super(schema);
        int n;
        int ordinal;
        int attributeCount = schema.getAttributes().size();
        IdentityHashMap<Attribute, Integer> attributeOrdinals = new IdentityHashMap<Attribute, Integer>();
        for (Attribute attribute : schema.getAttributes()) {
            ordinal = this.ancestorClosure.size();
            attributeOrdinals.put(attribute, ordinal);
            BitSetPlus ancestorBitSet = new BitSetPlus(attributeCount);
            ancestorBitSet.set(ordinal);
            this.ancestorClosure.add(ancestorBitSet);
        }
        int changeCount = 0;
        do {
            n = changeCount;
            for (ordinal = 0; ordinal < attributeCount; ++ordinal) {
                BitSetPlus bitSet = this.ancestorClosure.get(ordinal);
                Attribute attribute = schema.getAttributes().get(ordinal);
                for (Attribute ancestorAttribute : attribute.getAncestorAttributes()) {
                    int ancestorOrdinal = (Integer)attributeOrdinals.get(ancestorAttribute);
                    BitSetPlus ancestorBitSet = this.ancestorClosure.get(ancestorOrdinal);
                    if (bitSet.contains(ancestorBitSet)) continue;
                    ++changeCount;
                    bitSet.or(ancestorBitSet);
                }
            }
        } while (changeCount > n);
    }

    @Override
    public Lattice copy() {
        return new MonteCarloLatticeImpl(this.schema);
    }

    @Override
    public AggregateImpl chooseAggregate(double maxCost, double minCostBenefitRatio, Cost cost) {
        int bitCount = this.schema.getAttributes().size();
        HashSet<BitSetPlus> queryBitSets = new HashSet<BitSetPlus>();
        HashMap<AggregateImpl, Cost> aggregateCosts = new HashMap<AggregateImpl, Cost>();
        ArrayList<AggregateImpl> aggregates = new ArrayList<AggregateImpl>();
        double aggCostLimit = maxCost / (double)bitCount;
        int maxRetryCount = 10;
        int retry = 0;
        for (int i = 0; i < 1000; ++i) {
            boolean b = this.costQuery(minCostBenefitRatio, bitCount, queryBitSets, aggregates, aggregateCosts, aggCostLimit);
            if (!b || ++retry >= 10) continue;
            --i;
        }
        AggregateImpl best = null;
        Cost bestCost = null;
        for (AggregateImpl agg : aggregates) {
            Cost aggCost = (Cost)aggregateCosts.get(agg);
            if (aggCost.cost > maxCost || aggCost.benefit <= 0.0 || best != null && !(aggCost.benefit > bestCost.benefit) && (aggCost.benefit != bestCost.benefit || !(aggCost.cost < bestCost.cost))) continue;
            bestCost = aggCost;
            best = agg;
        }
        if (best != null) {
            cost.copyFrom(bestCost);
        }
        return best;
    }

    private boolean costQuery(double minCostBenefitRatio, int bitCount, Set<BitSetPlus> queryBitSets, List<AggregateImpl> aggregates, Map<AggregateImpl, Cost> aggregateCosts, double aggCostLimit) {
        BitSetPlus queryBitSet = new BitSetPlus(bitCount);
        int setBitCount = this.random.nextInt(bitCount);
        if (setBitCount > 0) {
            double density = 1.0 / (double)setBitCount;
            for (int j = 0; j < bitCount; ++j) {
                if (!(this.random.nextDouble() < density)) continue;
                queryBitSet.set(j);
            }
        }
        if (!queryBitSets.add(queryBitSet)) {
            return false;
        }
        AggregateImpl queryAgg = this.getAggregate(queryBitSet);
        ArrayDeque<AggregateImpl> aggQueue = new ArrayDeque<AggregateImpl>();
        HashSet<AggregateImpl> seen = new HashSet<AggregateImpl>();
        seen.addAll(this.materializedAggregates);
        List<AggregateImpl> parents = this.getParents(queryAgg);
        this.addAllUnseen(parents, aggQueue, seen);
        while (!aggQueue.isEmpty()) {
            AggregateImpl agg = (AggregateImpl)aggQueue.poll();
            assert (seen.contains(agg));
            Cost aggCost = aggregateCosts.get(agg);
            if (aggCost == null) {
                double v = this.estimateCost(agg.rowCount, this.schema.getStatisticsProvider().getFactRowCount());
                if (v > aggCostLimit) continue;
                aggCost = new Cost();
                aggCost.cost = v;
                aggregates.add(agg);
                aggregateCosts.put(agg, aggCost);
            }
            if (agg.hasCompleteAncestors(this.ancestorClosure)) {
                AggregateImpl nearestDescendant = this.findNearestMaterializedDescendant(agg);
                double benefit = nearestDescendant.rowCount - queryAgg.rowCount;
                assert (benefit >= 0.0);
                if (benefit / aggCost.cost < minCostBenefitRatio) continue;
                aggCost.benefit += benefit;
                ++aggCost.benefitCount;
            }
            this.addAllUnseen(this.getParents(agg), aggQueue, seen);
        }
        return true;
    }

    private void addAllUnseen(List<AggregateImpl> list, Queue<AggregateImpl> queue, Set<AggregateImpl> seen) {
        for (AggregateImpl parent : list) {
            if (!seen.add(parent)) continue;
            queue.add(parent);
        }
    }

    @Override
    public void materialize(AggregateImpl aggregate) {
        super.materialize(aggregate);
        aggregate.queryLoad = this.computeQueryLoad(aggregate);
        assert (aggregate.queryLoad >= 0.0) : aggregate.queryLoad;
        assert (aggregate.queryLoad <= 1.0) : aggregate.queryLoad;
    }

    @Override
    public Algorithm.CostBenefit costBenefitOf(AggregateImpl aggregate) {
        AggregateImpl best = this.findNearestMaterializedDescendant(aggregate);
        double savedRowCount = best.estimateRowCount() - aggregate.estimateRowCount();
        assert (savedRowCount > 0.0);
        this.materialize(aggregate);
        return new AlgorithmImpl.CostBenefitImpl(this.schema, aggregate, aggregate.queryLoad * savedRowCount);
    }

    private double computeQueryLoad(AggregateImpl aggregate) {
        int n = this.schema.getAttributes().size();
        int b = aggregate.getAttributes().size();
        double load = 0.0;
        for (int r = 0; r <= b; ++r) {
            double x = AggDesUtil.countCombinations(b, r).doubleValue();
            load += (x /= AggDesUtil.countCombinations(n, r).doubleValue());
        }
        load /= (double)(n + 1);
        for (AggregateImpl ascendant : this.findMaterializedDirectAscendants(aggregate)) {
            assert (ascendant.queryLoad > 0.0) : "queryLoad should be been initialized on materialize";
            load -= ascendant.queryLoad;
        }
        for (AggregateImpl descendant : this.findMaterializedDirectDescendants(aggregate)) {
            assert (descendant.queryLoad > 0.0) : "queryLoad should be been initialized on materialize";
        }
        return Math.max(load, 0.0);
    }
}

