/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.Algorithm;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.Progress;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.Result;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.AggregateImpl;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.AlgorithmImpl;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.MonteCarloLatticeImpl;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.algorithm.impl.ResultImpl;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Aggregate;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Parameter;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.model.Schema;
import org.apache.flink.calcite.shaded.org.pentaho.aggdes.util.AggDesUtil;

public class AdaptiveMonteCarloAlgorithm
extends AlgorithmImpl {
    private double costLimit;
    private int aggregateLimit;

    @Override
    public Result run(Schema schema, Map<Parameter, Object> parameterValues, Progress progress) {
        this.onStart(parameterValues, progress);
        this.schema = schema;
        Double d = (Double)parameterValues.get(Algorithm.ParameterEnum.costLimit);
        this.costLimit = d == null ? Double.MAX_VALUE : d;
        Integer i = (Integer)parameterValues.get(Algorithm.ParameterEnum.aggregateLimit);
        this.aggregateLimit = i == null ? Integer.MAX_VALUE : i;
        return this.adaptiveMonteCarlo();
    }

    private Result adaptiveMonteCarlo() {
        PrintWriter pw = new PrintWriter(System.out);
        double localCostLimit = 1.0;
        ArrayList<ResultImpl> results = new ArrayList<ResultImpl>();
        ArrayList<Double> costLimits = new ArrayList<Double>();
        double factRowCount = this.schema.getStatisticsProvider().getFactRowCount();
        while (!this.checkCancelTimeout()) {
            pw.println("Try with cost=" + localCostLimit);
            double costBenefitRatio = 1.0;
            ResultImpl result = this.runAlgorithm(new MonteCarloLatticeImpl(this.schema), localCostLimit, 1.0, this.aggregateLimit);
            result.describe(pw);
            pw.flush();
            costLimits.add(localCostLimit);
            results.add(result);
            if (localCostLimit > factRowCount && result.benefit > result.cost * 0.1 || localCostLimit >= this.costLimit) break;
            localCostLimit *= 5.0;
        }
        return results.isEmpty() ? null : (Result)results.get(results.size() - 1);
    }

    @Override
    public List<Algorithm.CostBenefit> computeAggregateCosts(Schema schema, Map<Parameter, Object> parameterValues, List<Aggregate> aggregateList) {
        MonteCarloLatticeImpl lattice = new MonteCarloLatticeImpl(schema);
        List<AggregateImpl> aggregateImplList = AggDesUtil.cast(aggregateList);
        return lattice.computeAggregateCosts(aggregateImplList);
    }
}

