/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.util.UnmodifiableArrayList;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterators;

public class ImmutableNullableList<E>
extends AbstractList<E> {
    private static final List SINGLETON_NULL = Collections.singletonList(null);
    private final E[] elements;

    private ImmutableNullableList(E[] elements) {
        this.elements = elements;
    }

    public static <E> List<E> copyOf(Collection<? extends E> elements) {
        if (elements instanceof ImmutableNullableList || elements instanceof ImmutableList || elements == SINGLETON_NULL) {
            return (List)elements;
        }
        if (elements == Collections.EMPTY_LIST) {
            return ImmutableList.of();
        }
        for (E object : elements) {
            if (object != null) continue;
            Object[] objects = elements.toArray();
            return new ImmutableNullableList<Object>(objects);
        }
        return ImmutableList.copyOf(elements);
    }

    public static <E> List<E> copyOf(Iterable<? extends E> elements) {
        if (elements instanceof ImmutableNullableList || elements instanceof ImmutableList || elements == SINGLETON_NULL) {
            return (List)elements;
        }
        if (elements instanceof Collection) {
            return ImmutableNullableList.copyOf((Collection)elements);
        }
        ArrayList list = new ArrayList();
        Iterables.addAll(list, elements);
        if (list.contains(null)) {
            return ImmutableNullableList.copyOf(list);
        }
        return ImmutableList.copyOf(elements);
    }

    public static <E> List<E> copyOf(E[] elements) {
        for (E object : elements) {
            if (object != null) continue;
            return new ImmutableNullableList<Object>((Object[])elements.clone());
        }
        return ImmutableList.copyOf(elements);
    }

    public static <E> List<E> of(E e1) {
        return e1 == null ? SINGLETON_NULL : ImmutableList.of(e1);
    }

    public static <E> List<E> of(E e1, E e2) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2});
    }

    public static <E> List<E> of(E e1, E e2, E e3) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2, e3});
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2, e3, e4});
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2, e3, e4, e5});
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2, e3, e4, e5, e6});
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7) {
        return UnmodifiableArrayList.of(new Object[]{e1, e2, e3, e4, e5, e6, e7});
    }

    public static <E> List<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E ... others) {
        Object[] array2 = new Object[8 + others.length];
        array2[0] = e1;
        array2[1] = e2;
        array2[2] = e3;
        array2[3] = e4;
        array2[4] = e5;
        array2[5] = e6;
        array2[6] = e7;
        array2[7] = e8;
        System.arraycopy(others, 0, array2, 8, others.length);
        return new ImmutableNullableList<Object>(array2);
    }

    @Override
    public E get(int index) {
        return this.elements[index];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    public static final class Builder<E> {
        private final List<E> contents = new ArrayList();

        public Builder<E> add(E element) {
            this.contents.add(element);
            return this;
        }

        public Builder<E> addAll(Iterable<? extends E> elements) {
            Iterables.addAll(this.contents, elements);
            return this;
        }

        public Builder<E> add(E ... elements) {
            for (E element : elements) {
                this.add(element);
            }
            return this;
        }

        public Builder<E> addAll(Iterator<? extends E> elements) {
            Iterators.addAll(this.contents, elements);
            return this;
        }

        public List<E> build() {
            return ImmutableNullableList.copyOf(this.contents);
        }
    }
}

