/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaSite;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.MetaImpl;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.util.ArrayFactoryImpl;
import org.apache.calcite.avatica.util.Cursor;

public class AvaticaResultSet
extends ArrayFactoryImpl
implements ResultSet {
    protected final AvaticaStatement statement;
    protected final QueryState state;
    protected final Meta.Signature signature;
    protected final Meta.Frame firstFrame;
    protected final List<ColumnMetaData> columnMetaDataList;
    protected final ResultSetMetaData resultSetMetaData;
    protected final Calendar localCalendar;
    protected Cursor cursor;
    protected List<Cursor.Accessor> accessorList;
    private int row;
    private boolean beforeFirst;
    private boolean afterLast;
    private int fetchDirection;
    private int fetchSize;
    private int type;
    private int concurrency;
    private int holdability;
    private boolean closed;

    public AvaticaResultSet(AvaticaStatement statement, QueryState state, Meta.Signature signature, ResultSetMetaData resultSetMetaData, TimeZone timeZone, Meta.Frame firstFrame) throws SQLException {
        super(timeZone);
        this.statement = statement;
        this.state = state;
        this.signature = signature;
        this.firstFrame = firstFrame;
        this.columnMetaDataList = signature.columns;
        if (null != statement) {
            this.type = statement.resultSetType;
            this.concurrency = statement.resultSetConcurrency;
            this.holdability = statement.resultSetHoldability;
            this.fetchSize = statement.getFetchSize();
            this.fetchDirection = statement.getFetchDirection();
        } else {
            this.type = 0;
            this.concurrency = 0;
            this.holdability = 0;
            this.fetchSize = 100;
            this.fetchDirection = 0;
        }
        this.resultSetMetaData = resultSetMetaData;
        this.localCalendar = Calendar.getInstance(timeZone, Locale.ROOT);
    }

    private int findColumn0(String columnLabel) throws SQLException {
        for (ColumnMetaData columnMetaData : this.columnMetaDataList) {
            if (!columnMetaData.label.equalsIgnoreCase(columnLabel)) continue;
            return columnMetaData.ordinal;
        }
        throw AvaticaConnection.HELPER.createException("column '" + columnLabel + "' not found");
    }

    protected void checkOpen() throws SQLException {
        if (this.isClosed()) {
            throw AvaticaConnection.HELPER.createException("ResultSet closed");
        }
    }

    private Cursor.Accessor getAccessor(int columnIndex) throws SQLException {
        this.checkOpen();
        try {
            return this.accessorList.get(columnIndex - 1);
        }
        catch (IndexOutOfBoundsException e2) {
            throw AvaticaConnection.HELPER.createException("invalid column ordinal: " + columnIndex);
        }
    }

    private Cursor.Accessor getAccessor(String columnLabel) throws SQLException {
        this.checkOpen();
        return this.accessorList.get(this.findColumn0(columnLabel));
    }

    @Override
    public void close() {
        this.closed = true;
        Cursor cursor = this.cursor;
        if (cursor != null) {
            this.cursor = null;
            cursor.close();
        }
        this.statement.onResultSetClose(this);
    }

    protected void cancel() {
        this.statement.cancelFlag.compareAndSet(false, true);
    }

    protected AvaticaResultSet execute() throws SQLException {
        Iterable<Object> iterable1 = this.statement.connection.meta.createIterable(this.statement.handle, this.state, this.signature, Collections.emptyList(), this.firstFrame);
        this.cursor = MetaImpl.createCursor(this.signature.cursorFactory, iterable1);
        this.accessorList = this.cursor.createAccessors(this.columnMetaDataList, this.localCalendar, this);
        this.row = 0;
        this.beforeFirst = true;
        this.afterLast = false;
        return this;
    }

    public AvaticaResultSet execute2(Cursor cursor, List<ColumnMetaData> columnMetaDataList) {
        this.cursor = cursor;
        this.accessorList = cursor.createAccessors(columnMetaDataList, this.localCalendar, this);
        this.row = 0;
        this.beforeFirst = true;
        this.afterLast = false;
        return this;
    }

    public Calendar getLocalCalendar() {
        return this.localCalendar;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkOpen();
        if (null != this.statement && this.statement.cancelFlag.get()) {
            throw AvaticaConnection.HELPER.createException("Statement canceled");
        }
        if (this.cursor.next()) {
            ++this.row;
            this.beforeFirst = false;
            return true;
        }
        this.row = 0;
        this.afterLast = true;
        return false;
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        this.checkOpen();
        return this.findColumn0(columnLabel) + 1;
    }

    @Override
    public boolean wasNull() throws SQLException {
        this.checkOpen();
        return this.cursor.wasNull();
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getString();
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getBoolean();
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getByte();
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getShort();
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getInt();
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getLong();
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getFloat();
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        return this.getAccessor(columnIndex).getBigDecimal(scale);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getDate(this.localCalendar);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getTime(this.localCalendar);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getTimestamp(this.localCalendar);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getAsciiStream();
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getUnicodeStream();
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getBinaryStream();
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getString();
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getBoolean();
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getByte();
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getShort();
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getInt();
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getLong();
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getFloat();
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getDouble();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getAccessor(columnLabel).getBigDecimal(scale);
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getBytes();
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getDate(this.localCalendar);
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getTime(this.localCalendar);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getTimestamp(this.localCalendar);
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getAsciiStream();
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getUnicodeStream();
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getBinaryStream();
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkOpen();
    }

    @Override
    public String getCursorName() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return this.resultSetMetaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        Cursor.Accessor accessor = this.getAccessor(columnIndex);
        ColumnMetaData metaData = this.columnMetaDataList.get(columnIndex - 1);
        return AvaticaSite.get(accessor, metaData.type.id, this.localCalendar);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getObject();
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getCharacterStream();
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getCharacterStream();
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getBigDecimal();
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getBigDecimal();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.checkOpen();
        return this.beforeFirst;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.checkOpen();
        return this.afterLast;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.checkOpen();
        return this.row == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void afterLast() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public boolean first() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public boolean last() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public int getRow() throws SQLException {
        this.checkOpen();
        return this.row;
    }

    @Override
    public boolean absolute(int row2) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public boolean previous() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkOpen();
        this.fetchDirection = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkOpen();
        return this.fetchDirection;
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.checkOpen();
        this.fetchSize = fetchSize;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkOpen();
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.checkOpen();
        return this.type;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.checkOpen();
        return this.concurrency;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkOpen();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void insertRow() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateRow() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void deleteRow() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public AvaticaStatement getStatement() throws SQLException {
        this.checkOpen();
        return this.statement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map2) throws SQLException {
        return this.getAccessor(columnIndex).getObject(map2);
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getRef();
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getBlob();
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getClob();
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getArray();
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map2) throws SQLException {
        return this.getAccessor(columnLabel).getObject(map2);
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getRef();
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getBlob();
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getClob();
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getArray();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        return this.getAccessor(columnIndex).getDate(cal);
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        return this.getAccessor(columnLabel).getDate(cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        return this.getAccessor(columnIndex).getTime(cal);
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        return this.getAccessor(columnLabel).getTime(cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        return this.getAccessor(columnIndex).getTimestamp(cal);
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        return this.getAccessor(columnLabel).getTimestamp(cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getURL();
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getURL();
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public int getHoldability() throws SQLException {
        this.checkOpen();
        return this.holdability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getNClob();
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getNClob();
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getSQLXML();
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getSQLXML();
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getNString();
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getNString();
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getAccessor(columnIndex).getNCharacterStream();
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getAccessor(columnLabel).getNCharacterStream();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw AvaticaConnection.HELPER.unsupported();
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        return this.getAccessor(columnIndex).getObject(type);
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        return this.getAccessor(columnLabel).getObject(type);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw AvaticaConnection.HELPER.createException("does not implement '" + iface + "'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }
}

