/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.runtime.net.ConnectionUtils;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.config.Environment;
import org.apache.flink.table.client.config.entries.DeploymentEntry;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.local.result.ChangelogCollectStreamResult;
import org.apache.flink.table.client.gateway.local.result.DynamicResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedCollectBatchResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedCollectStreamResult;

public class ResultStore {
    private final Configuration flinkConfig;
    private final Map<String, DynamicResult<?>> results;

    public ResultStore(Configuration flinkConfig) {
        this.flinkConfig = flinkConfig;
        this.results = new HashMap();
    }

    public <T> DynamicResult<T> createResult(Environment env, TableSchema schema, ExecutionConfig config) {
        if (env.getExecution().inStreamingMode()) {
            InetAddress gatewayAddress = this.getGatewayAddress(env.getDeployment());
            int gatewayPort = this.getGatewayPort(env.getDeployment());
            if (env.getExecution().isChangelogMode() || env.getExecution().isTableauMode()) {
                return new ChangelogCollectStreamResult(schema, config, gatewayAddress, gatewayPort);
            }
            return new MaterializedCollectStreamResult(schema, config, gatewayAddress, gatewayPort, env.getExecution().getMaxTableResultRows());
        }
        if (env.getExecution().isTableMode() || env.getExecution().isTableauMode()) {
            return new MaterializedCollectBatchResult(schema, config);
        }
        throw new SqlExecutionException("Results of batch queries can only be served in table or tableau mode.");
    }

    public void storeResult(String resultId, DynamicResult result) {
        this.results.put(resultId, result);
    }

    public <T> DynamicResult<T> getResult(String resultId) {
        return this.results.get(resultId);
    }

    public void removeResult(String resultId) {
        this.results.remove(resultId);
    }

    public List<String> getResults() {
        return new ArrayList<String>(this.results.keySet());
    }

    private int getGatewayPort(DeploymentEntry deploy) {
        return deploy.getGatewayPort();
    }

    private InetAddress getGatewayAddress(DeploymentEntry deploy) {
        String address = deploy.getGatewayAddress();
        if (!address.isEmpty()) {
            try {
                return InetAddress.getByName(address);
            }
            catch (UnknownHostException e) {
                throw new SqlClientException("Invalid gateway address '" + address + "' for result retrieval.", e);
            }
        }
        String jobManagerAddress = this.flinkConfig.getString(JobManagerOptions.ADDRESS);
        int jobManagerPort = this.flinkConfig.getInteger(JobManagerOptions.PORT);
        if (jobManagerAddress != null && !jobManagerAddress.isEmpty()) {
            try {
                return ConnectionUtils.findConnectingAddress((InetSocketAddress)new InetSocketAddress(jobManagerAddress, jobManagerPort), (long)deploy.getResponseTimeout(), (long)400L);
            }
            catch (Exception e) {
                throw new SqlClientException("Could not determine address of the gateway for result retrieval by connecting to the job manager. Please specify the gateway address manually.", e);
            }
        }
        try {
            return InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new SqlClientException("Could not determine address of the gateway for result retrieval. Please specify the gateway address manually.", e);
        }
    }
}

