/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.util.concurrent.CompletableFuture;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.core.execution.DefaultExecutorServiceLoader;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.execution.PipelineExecutor;
import org.apache.flink.core.execution.PipelineExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgramDeployer {
    private static final Logger LOG = LoggerFactory.getLogger(ProgramDeployer.class);
    private final Configuration configuration;
    private final Pipeline pipeline;
    private final String jobName;
    private final ClassLoader userCodeClassloader;

    public ProgramDeployer(Configuration configuration, String jobName, Pipeline pipeline, ClassLoader userCodeClassloader) {
        this.configuration = configuration;
        this.pipeline = pipeline;
        this.jobName = jobName;
        this.userCodeClassloader = userCodeClassloader;
    }

    public CompletableFuture<JobClient> deploy() {
        CompletableFuture jobClient;
        PipelineExecutorFactory executorFactory;
        LOG.info("Submitting job {} for query {}`", (Object)this.pipeline, (Object)this.jobName);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Submitting job {} with configuration: \n{}", (Object)this.pipeline, (Object)this.configuration);
        }
        if (this.configuration.get(DeploymentOptions.TARGET) == null) {
            throw new RuntimeException("No execution.target specified in your configuration file.");
        }
        DefaultExecutorServiceLoader executorServiceLoader = new DefaultExecutorServiceLoader();
        try {
            executorFactory = executorServiceLoader.getExecutorFactory(this.configuration);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not retrieve ExecutorFactory.", e);
        }
        PipelineExecutor executor = executorFactory.getExecutor(this.configuration);
        try {
            jobClient = executor.execute(this.pipeline, this.configuration, this.userCodeClassloader);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not execute program.", e);
        }
        return jobClient;
    }
}

