/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.io.PrintWriter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.table.api.TableColumn;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.utils.PrintUtils;
import org.apache.flink.types.Row;
import org.jline.terminal.Terminal;

public class CliTableauResultView
implements AutoCloseable {
    private static final int DEFAULT_COLUMN_WIDTH = 20;
    private static final String CHANGEFLAG_COLUMN_NAME = "+/-";
    private final Terminal terminal;
    private final Executor sqlExecutor;
    private final String sessionId;
    private final ResultDescriptor resultDescriptor;
    private final ExecutorService displayResultExecutorService;

    public CliTableauResultView(Terminal terminal, Executor sqlExecutor, String sessionId, ResultDescriptor resultDescriptor) {
        this.terminal = terminal;
        this.sqlExecutor = sqlExecutor;
        this.sessionId = sessionId;
        this.resultDescriptor = resultDescriptor;
        this.displayResultExecutorService = Executors.newSingleThreadExecutor((ThreadFactory)new ExecutorThreadFactory("CliTableauResultView"));
    }

    public void displayStreamResults() throws SqlExecutionException {
        AtomicInteger receivedRowCount = new AtomicInteger(0);
        Future<?> resultFuture = this.displayResultExecutorService.submit(() -> this.printStreamResults(receivedRowCount));
        this.terminal.handle(Terminal.Signal.INT, signal -> resultFuture.cancel(true));
        boolean cleanUpQuery = true;
        try {
            resultFuture.get();
            cleanUpQuery = false;
        }
        catch (CancellationException e) {
            this.terminal.writer().println("Query terminated, received a total of " + receivedRowCount.get() + " rows");
            this.terminal.flush();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SqlExecutionException) {
                throw (SqlExecutionException)e.getCause();
            }
            throw new SqlExecutionException("unknown exception", e.getCause());
        }
        catch (InterruptedException e) {
            throw new SqlExecutionException("Query interrupted", e);
        }
        finally {
            this.checkAndCleanUpQuery(cleanUpQuery);
        }
    }

    public void displayBatchResults() throws SqlExecutionException {
        Future<?> resultFuture = this.displayResultExecutorService.submit(() -> {
            List<Row> resultRows = this.waitBatchResults();
            PrintUtils.printAsTableauForm((TableSchema)this.resultDescriptor.getResultSchema(), resultRows.iterator(), (PrintWriter)this.terminal.writer());
        });
        this.terminal.handle(Terminal.Signal.INT, signal -> resultFuture.cancel(true));
        boolean cleanUpQuery = true;
        try {
            resultFuture.get();
            cleanUpQuery = false;
        }
        catch (CancellationException e) {
            this.terminal.writer().println("Query terminated");
            this.terminal.flush();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof SqlExecutionException) {
                throw (SqlExecutionException)e.getCause();
            }
            throw new SqlExecutionException("unknown exception", e.getCause());
        }
        catch (InterruptedException e) {
            throw new SqlExecutionException("Query interrupted", e);
        }
        finally {
            this.checkAndCleanUpQuery(cleanUpQuery);
        }
    }

    @Override
    public void close() {
        this.displayResultExecutorService.shutdown();
    }

    private void checkAndCleanUpQuery(boolean cleanUpQuery) {
        if (cleanUpQuery) {
            try {
                this.sqlExecutor.cancelQuery(this.sessionId, this.resultDescriptor.getResultId());
            }
            catch (SqlExecutionException sqlExecutionException) {
                // empty catch block
            }
        }
    }

    private List<Row> waitBatchResults() {
        List<Row> resultRows;
        block3: {
            TypedResult<Integer> result;
            do {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                result = this.sqlExecutor.snapshotResult(this.sessionId, this.resultDescriptor.getResultId(), Integer.MAX_VALUE);
                if (result.getType() != TypedResult.ResultType.EOS) continue;
                resultRows = Collections.emptyList();
                break block3;
            } while (result.getType() != TypedResult.ResultType.PAYLOAD);
            resultRows = this.sqlExecutor.retrieveResultPage(this.resultDescriptor.getResultId(), 1);
        }
        return resultRows;
    }

    private void printStreamResults(AtomicInteger receivedRowCount) {
        List columns = this.resultDescriptor.getResultSchema().getTableColumns();
        String[] fieldNames = (String[])Stream.concat(Stream.of(CHANGEFLAG_COLUMN_NAME), columns.stream().map(TableColumn::getName)).toArray(String[]::new);
        int[] colWidths = PrintUtils.columnWidthsByType((List)columns, (int)20, (String)"(NULL)", (String)CHANGEFLAG_COLUMN_NAME);
        String borderline = PrintUtils.genBorderLine((int[])colWidths);
        this.terminal.writer().println(borderline);
        PrintUtils.printSingleRow((int[])colWidths, (String[])fieldNames, (PrintWriter)this.terminal.writer());
        this.terminal.writer().println(borderline);
        this.terminal.flush();
        block5: while (true) {
            TypedResult<List<Tuple2<Boolean, Row>>> result = this.sqlExecutor.retrieveResultChanges(this.sessionId, this.resultDescriptor.getResultId());
            switch (result.getType()) {
                case EMPTY: {
                    break;
                }
                case EOS: {
                    if (receivedRowCount.get() > 0) {
                        this.terminal.writer().println(borderline);
                    }
                    this.terminal.writer().println("Received a total of " + receivedRowCount.get() + " rows");
                    this.terminal.flush();
                    return;
                }
                case PAYLOAD: {
                    List<Tuple2<Boolean, Row>> changes = result.getPayload();
                    Iterator<Tuple2<Boolean, Row>> iterator = changes.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block5;
                        Tuple2<Boolean, Row> change = iterator.next();
                        String[] cols = PrintUtils.rowToString((Row)((Row)change.f1));
                        String[] row = new String[cols.length + 1];
                        row[0] = (Boolean)change.f0 != false ? "+" : "-";
                        System.arraycopy(cols, 0, row, 1, cols.length);
                        PrintUtils.printSingleRow((int[])colWidths, (String[])row, (PrintWriter)this.terminal.writer());
                        receivedRowCount.incrementAndGet();
                    }
                }
                default: {
                    throw new SqlExecutionException("Unknown result type: " + (Object)((Object)result.getType()));
                }
            }
        }
    }
}

