/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliClient;
import org.apache.flink.table.client.cli.CliOptions;
import org.apache.flink.table.client.cli.CliOptionsParser;
import org.apache.flink.table.client.config.Environment;
import org.apache.flink.table.client.config.entries.ConfigurationEntry;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.SessionContext;
import org.apache.flink.table.client.gateway.local.LocalExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlClient {
    private static final Logger LOG = LoggerFactory.getLogger(SqlClient.class);
    private final boolean isEmbedded;
    private final CliOptions options;
    public static final String MODE_EMBEDDED = "embedded";
    public static final String MODE_GATEWAY = "gateway";
    public static final String DEFAULT_SESSION_ID = "default";

    public SqlClient(boolean isEmbedded, CliOptions options) {
        this.isEmbedded = isEmbedded;
        this.options = options;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        if (this.isEmbedded) {
            List<URL> jars = this.options.getJars() != null ? this.options.getJars() : Collections.emptyList();
            List<URL> libDirs = this.options.getLibraryDirs() != null ? this.options.getLibraryDirs() : Collections.emptyList();
            LocalExecutor executor = new LocalExecutor(this.options.getDefaults(), jars, libDirs);
            executor.start();
            Environment sessionEnv = SqlClient.readSessionEnvironment(this.options.getEnvironment());
            SqlClient.appendPythonConfig(sessionEnv, this.options.getPythonConfiguration());
            SessionContext context = this.options.getSessionId() == null ? new SessionContext(DEFAULT_SESSION_ID, sessionEnv) : new SessionContext(this.options.getSessionId(), sessionEnv);
            String sessionId = executor.openSession(context);
            try {
                Runtime.getRuntime().addShutdownHook(new EmbeddedShutdownThread(sessionId, executor));
                this.openCli(sessionId, executor);
            }
            finally {
                executor.closeSession(sessionId);
            }
        } else {
            throw new SqlClientException("Gateway mode is not supported yet.");
        }
    }

    private void openCli(String sessionId, Executor executor) {
        Path historyFilePath = this.options.getHistoryFilePath() != null ? Paths.get(this.options.getHistoryFilePath(), new String[0]) : Paths.get(System.getProperty("user.home"), SystemUtils.IS_OS_WINDOWS ? "flink-sql-history" : ".flink-sql-history");
        try (CliClient cli = new CliClient(sessionId, executor, historyFilePath);){
            if (this.options.getUpdateStatement() == null) {
                cli.open();
            } else {
                boolean success = cli.submitUpdate(this.options.getUpdateStatement());
                if (!success) {
                    throw new SqlClientException("Could not submit given SQL update statement to cluster.");
                }
            }
        }
    }

    private static Environment readSessionEnvironment(URL envUrl) {
        if (envUrl == null) {
            System.out.println("No session environment specified.");
            return new Environment();
        }
        System.out.println("Reading session environment from: " + envUrl);
        LOG.info("Using session environment file: {}", (Object)envUrl);
        try {
            return Environment.parse(envUrl);
        }
        catch (IOException e) {
            throw new SqlClientException("Could not read session environment file at: " + envUrl, e);
        }
    }

    private static void appendPythonConfig(Environment env, Configuration pythonConfiguration) {
        HashMap<String, Object> pythonConfig = new HashMap<String, Object>(pythonConfiguration.toMap());
        HashMap<String, Object> combinedConfig = new HashMap<String, Object>(ConfigurationEntry.merge(env.getConfiguration(), ConfigurationEntry.create(pythonConfig)).asMap());
        env.setConfiguration(combinedConfig);
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            CliOptionsParser.printHelpClient();
            return;
        }
        switch (args[0]) {
            case "embedded": {
                String[] modeArgs = Arrays.copyOfRange(args, 1, args.length);
                CliOptions options = CliOptionsParser.parseEmbeddedModeClient(modeArgs);
                if (options.isPrintHelp()) {
                    CliOptionsParser.printHelpEmbeddedModeClient();
                    break;
                }
                try {
                    SqlClient client = new SqlClient(true, options);
                    client.start();
                    break;
                }
                catch (SqlClientException e) {
                    System.out.println();
                    System.out.println();
                    LOG.error("SQL Client must stop.", (Throwable)e);
                    throw e;
                }
                catch (Throwable t) {
                    System.out.println();
                    System.out.println();
                    LOG.error("SQL Client must stop. Unexpected exception. This is a bug. Please consider filing an issue.", t);
                    throw new SqlClientException("Unexpected exception. This is a bug. Please consider filing an issue.", t);
                }
            }
            case "gateway": {
                throw new SqlClientException("Gateway mode is not supported yet.");
            }
            default: {
                CliOptionsParser.printHelpClient();
            }
        }
    }

    private static class EmbeddedShutdownThread
    extends Thread {
        private final String sessionId;
        private final Executor executor;

        public EmbeddedShutdownThread(String sessionId, Executor executor) {
            this.sessionId = sessionId;
            this.executor = executor;
        }

        @Override
        public void run() {
            System.out.println("\nShutting down the session...");
            this.executor.closeSession(this.sessionId);
            System.out.println("done.");
        }
    }
}

