/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.net.InetAddress;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.TupleTypeInfo;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.streaming.api.functions.sink.SinkFunction;
import org.apache.flink.streaming.experimental.CollectSink;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;

public class CollectStreamTableSink
implements RetractStreamTableSink<Row> {
    private final InetAddress targetAddress;
    private final int targetPort;
    private final TypeSerializer<Tuple2<Boolean, Row>> serializer;
    private final TableSchema tableSchema;

    public CollectStreamTableSink(InetAddress targetAddress, int targetPort, TypeSerializer<Tuple2<Boolean, Row>> serializer, TableSchema tableSchema) {
        this.targetAddress = targetAddress;
        this.targetPort = targetPort;
        this.serializer = serializer;
        this.tableSchema = TableSchemaUtils.checkNoGeneratedColumns((TableSchema)tableSchema);
    }

    public CollectStreamTableSink configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        return new CollectStreamTableSink(this.targetAddress, this.targetPort, this.serializer, this.tableSchema);
    }

    public String[] getFieldNames() {
        return this.tableSchema.getFieldNames();
    }

    public TypeInformation<?>[] getFieldTypes() {
        return this.tableSchema.getFieldTypes();
    }

    public TypeInformation<Row> getRecordType() {
        return this.getTableSchema().toRowType();
    }

    public DataStreamSink<?> consumeDataStream(DataStream<Tuple2<Boolean, Row>> stream) {
        return stream.addSink((SinkFunction)new CollectSink(this.targetAddress, this.targetPort, this.serializer)).name("SQL Client Stream Collect Sink").setParallelism(1);
    }

    public TupleTypeInfo<Tuple2<Boolean, Row>> getOutputType() {
        return new TupleTypeInfo(new TypeInformation[]{Types.BOOLEAN, this.getRecordType()});
    }
}

