/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.cli;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.delegation.Parser;
import org.apache.flink.table.operations.CatalogSinkModifyOperation;
import org.apache.flink.table.operations.DescribeTableOperation;
import org.apache.flink.table.operations.ExplainOperation;
import org.apache.flink.table.operations.Operation;
import org.apache.flink.table.operations.QueryOperation;
import org.apache.flink.table.operations.ShowCatalogsOperation;
import org.apache.flink.table.operations.ShowDatabasesOperation;
import org.apache.flink.table.operations.ShowFunctionsOperation;
import org.apache.flink.table.operations.ShowTablesOperation;
import org.apache.flink.table.operations.UseCatalogOperation;
import org.apache.flink.table.operations.UseDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.AlterDatabaseOperation;
import org.apache.flink.table.operations.ddl.AlterTableOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateCatalogOperation;
import org.apache.flink.table.operations.ddl.CreateDatabaseOperation;
import org.apache.flink.table.operations.ddl.CreateTableOperation;
import org.apache.flink.table.operations.ddl.CreateTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.CreateViewOperation;
import org.apache.flink.table.operations.ddl.DropCatalogFunctionOperation;
import org.apache.flink.table.operations.ddl.DropCatalogOperation;
import org.apache.flink.table.operations.ddl.DropDatabaseOperation;
import org.apache.flink.table.operations.ddl.DropTableOperation;
import org.apache.flink.table.operations.ddl.DropTempSystemFunctionOperation;
import org.apache.flink.table.operations.ddl.DropViewOperation;

public final class SqlCommandParser {
    private static final Function<String[], Optional<String[]>> NO_OPERANDS = operands -> Optional.of(new String[0]);
    private static final Function<String[], Optional<String[]>> SINGLE_OPERAND = operands -> Optional.of(new String[]{operands[0]});
    private static final int DEFAULT_PATTERN_FLAGS = 34;

    private SqlCommandParser() {
    }

    public static SqlCommandCall parse(Parser sqlParser, String stmt) {
        Optional<SqlCommandCall> callOpt;
        if ((stmt = stmt.trim()).endsWith(";")) {
            stmt = stmt.substring(0, stmt.length() - 1).trim();
        }
        if ((callOpt = SqlCommandParser.parseByRegexMatching(stmt)).isPresent()) {
            return callOpt.get();
        }
        return SqlCommandParser.parseBySqlParser(sqlParser, stmt);
    }

    private static SqlCommandCall parseBySqlParser(Parser sqlParser, String stmt) {
        SqlCommand cmd;
        List operations;
        try {
            operations = sqlParser.parse(stmt);
        }
        catch (Throwable e) {
            throw new SqlExecutionException("Invalidate SQL statement.", e);
        }
        if (operations.size() != 1) {
            throw new SqlExecutionException("Only single statement is supported now.");
        }
        String[] operands = new String[]{stmt};
        Operation operation = (Operation)operations.get(0);
        if (operation instanceof CatalogSinkModifyOperation) {
            boolean overwrite = ((CatalogSinkModifyOperation)operation).isOverwrite();
            cmd = overwrite ? SqlCommand.INSERT_OVERWRITE : SqlCommand.INSERT_INTO;
        } else if (operation instanceof CreateTableOperation) {
            cmd = SqlCommand.CREATE_TABLE;
        } else if (operation instanceof DropTableOperation) {
            cmd = SqlCommand.DROP_TABLE;
        } else if (operation instanceof AlterTableOperation) {
            cmd = SqlCommand.ALTER_TABLE;
        } else if (operation instanceof CreateViewOperation) {
            cmd = SqlCommand.CREATE_VIEW;
        } else if (operation instanceof DropViewOperation) {
            cmd = SqlCommand.DROP_VIEW;
        } else if (operation instanceof CreateDatabaseOperation) {
            cmd = SqlCommand.CREATE_DATABASE;
        } else if (operation instanceof DropDatabaseOperation) {
            cmd = SqlCommand.DROP_DATABASE;
        } else if (operation instanceof AlterDatabaseOperation) {
            cmd = SqlCommand.ALTER_DATABASE;
        } else if (operation instanceof CreateCatalogOperation) {
            cmd = SqlCommand.CREATE_CATALOG;
        } else if (operation instanceof DropCatalogOperation) {
            cmd = SqlCommand.DROP_CATALOG;
        } else if (operation instanceof UseCatalogOperation) {
            cmd = SqlCommand.USE_CATALOG;
            operands = new String[]{((UseCatalogOperation)operation).getCatalogName()};
        } else if (operation instanceof UseDatabaseOperation) {
            cmd = SqlCommand.USE;
            operands = new String[]{((UseDatabaseOperation)operation).getDatabaseName()};
        } else if (operation instanceof ShowCatalogsOperation) {
            cmd = SqlCommand.SHOW_CATALOGS;
            operands = new String[]{};
        } else if (operation instanceof ShowDatabasesOperation) {
            cmd = SqlCommand.SHOW_DATABASES;
            operands = new String[]{};
        } else if (operation instanceof ShowTablesOperation) {
            cmd = SqlCommand.SHOW_TABLES;
            operands = new String[]{};
        } else if (operation instanceof ShowFunctionsOperation) {
            cmd = SqlCommand.SHOW_FUNCTIONS;
            operands = new String[]{};
        } else if (operation instanceof CreateCatalogFunctionOperation || operation instanceof CreateTempSystemFunctionOperation) {
            cmd = SqlCommand.CREATE_FUNCTION;
        } else if (operation instanceof DropCatalogFunctionOperation || operation instanceof DropTempSystemFunctionOperation) {
            cmd = SqlCommand.DROP_FUNCTION;
        } else if (operation instanceof AlterCatalogFunctionOperation) {
            cmd = SqlCommand.ALTER_FUNCTION;
        } else if (operation instanceof ExplainOperation) {
            cmd = SqlCommand.EXPLAIN;
        } else if (operation instanceof DescribeTableOperation) {
            cmd = SqlCommand.DESCRIBE;
            operands = new String[]{((DescribeTableOperation)operation).getSqlIdentifier().asSerializableString()};
        } else if (operation instanceof QueryOperation) {
            cmd = SqlCommand.SELECT;
        } else {
            throw new SqlExecutionException("Unknown operation: " + operation.asSummaryString());
        }
        return new SqlCommandCall(cmd, operands);
    }

    private static Optional<SqlCommandCall> parseByRegexMatching(String stmt) {
        for (SqlCommand cmd : SqlCommand.values()) {
            Matcher matcher;
            if (!cmd.hasRegexPattern() || !(matcher = cmd.pattern.matcher(stmt)).matches()) continue;
            String[] groups = new String[matcher.groupCount()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = matcher.group(i + 1);
            }
            return cmd.operandConverter.apply(groups).map(operands -> {
                String[] newOperands = operands;
                if (cmd == SqlCommand.EXPLAIN) {
                    newOperands = new String[]{"EXPLAIN PLAN FOR " + operands[0] + " " + operands[1]};
                }
                return new SqlCommandCall(cmd, newOperands);
            });
        }
        return Optional.empty();
    }

    static /* synthetic */ Function access$100() {
        return SINGLE_OPERAND;
    }

    public static class SqlCommandCall {
        public final SqlCommand command;
        public final String[] operands;

        public SqlCommandCall(SqlCommand command, String[] operands) {
            this.command = command;
            this.operands = operands;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SqlCommandCall that = (SqlCommandCall)o;
            return this.command == that.command && Arrays.equals(this.operands, that.operands);
        }

        public int hashCode() {
            int result = Objects.hash(new Object[]{this.command});
            result = 31 * result + Arrays.hashCode(this.operands);
            return result;
        }

        public String toString() {
            return (Object)((Object)this.command) + "(" + Arrays.toString(this.operands) + ")";
        }
    }

    static enum SqlCommand {
        QUIT("(QUIT|EXIT)", SqlCommandParser.access$000()),
        CLEAR("CLEAR", SqlCommandParser.access$000()),
        HELP("HELP", SqlCommandParser.access$000()),
        SHOW_CATALOGS,
        SHOW_DATABASES,
        SHOW_TABLES,
        SHOW_FUNCTIONS,
        SHOW_MODULES("SHOW\\s+MODULES", SqlCommandParser.access$000()),
        USE_CATALOG,
        USE,
        CREATE_CATALOG,
        DROP_CATALOG,
        DESC("DESC\\s+(.*)", SqlCommandParser.access$100()),
        DESCRIBE,
        EXPLAIN("EXPLAIN\\s+(SELECT|INSERT)\\s+(.*)", operands -> Optional.of(new String[]{operands[0], operands[1]})),
        CREATE_DATABASE,
        DROP_DATABASE,
        ALTER_DATABASE,
        CREATE_TABLE,
        DROP_TABLE,
        ALTER_TABLE,
        CREATE_VIEW,
        DROP_VIEW,
        CREATE_FUNCTION,
        DROP_FUNCTION,
        ALTER_FUNCTION,
        SELECT,
        INSERT_INTO,
        INSERT_OVERWRITE,
        SET("SET(\\s+(\\S+)\\s*=(.*))?", operands -> {
            if (((String[])operands).length < 3) {
                return Optional.empty();
            }
            if (operands[0] == null) {
                return Optional.of(new String[0]);
            }
            return Optional.of(new String[]{operands[1], operands[2]});
        }),
        RESET("RESET", SqlCommandParser.access$000()),
        SOURCE("SOURCE\\s+(.*)", SqlCommandParser.access$100());

        @Nullable
        public final Pattern pattern;
        @Nullable
        public final Function<String[], Optional<String[]>> operandConverter;

        private SqlCommand() {
            this.pattern = null;
            this.operandConverter = null;
        }

        private SqlCommand(String matchingRegex, Function<String[], Optional<String[]>> operandConverter) {
            this.pattern = Pattern.compile(matchingRegex, 34);
            this.operandConverter = operandConverter;
        }

        public String toString() {
            return super.toString().replace('_', ' ');
        }

        public boolean hasOperands() {
            return this.operandConverter != NO_OPERANDS;
        }

        public boolean hasRegexPattern() {
            return this.pattern != null;
        }
    }
}

