/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.SerializedListAccumulator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.local.CollectBatchTableSink;
import org.apache.flink.table.client.gateway.local.result.BasicResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedResult;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.types.Row;
import org.apache.flink.util.AbstractID;
import org.apache.flink.util.Preconditions;

public class MaterializedCollectBatchResult<C>
extends BasicResult<C>
implements MaterializedResult<C> {
    private final String accumulatorName;
    private final CollectBatchTableSink tableSink;
    private final Object resultLock;
    private final ClassLoader classLoader;
    private int pageSize;
    private int pageCount;
    private AtomicReference<SqlExecutionException> executionException = new AtomicReference();
    private List<Row> resultTable;
    private volatile boolean snapshotted = false;

    public MaterializedCollectBatchResult(TableSchema tableSchema, ExecutionConfig config, ClassLoader classLoader) {
        this.accumulatorName = new AbstractID().toString();
        TypeSerializer serializer = tableSchema.toRowType().createSerializer(config);
        this.tableSink = new CollectBatchTableSink(this.accumulatorName, (TypeSerializer<Row>)serializer, tableSchema);
        this.resultLock = new Object();
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        this.pageCount = 0;
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public void startRetrieval(JobClient jobClient) {
        ((CompletableFuture)jobClient.getJobExecutionResult(this.classLoader).thenAccept((Consumer)new ResultRetrievalHandler())).whenComplete((unused, throwable) -> {
            if (throwable != null) {
                this.executionException.compareAndSet(null, new SqlExecutionException("Error while retrieving result.", (Throwable)throwable));
            }
        });
    }

    @Override
    public TableSink<?> getTableSink() {
        return this.tableSink;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Row> retrievePage(int page) {
        Object object = this.resultLock;
        synchronized (object) {
            if (page <= 0 || page > this.pageCount) {
                throw new SqlExecutionException("Invalid page '" + page + "'.");
            }
            return this.resultTable.subList(this.pageSize * (page - 1), Math.min(this.resultTable.size(), page * this.pageSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedResult<Integer> snapshot(int pageSize) {
        Object object = this.resultLock;
        synchronized (object) {
            SqlExecutionException e = this.executionException.get();
            if (e != null) {
                throw e;
            }
            if (null == this.resultTable) {
                return TypedResult.empty();
            }
            if (!this.snapshotted) {
                this.snapshotted = true;
                this.pageSize = pageSize;
                this.pageCount = Math.max(1, (int)Math.ceil((double)this.resultTable.size() / (double)pageSize));
                return TypedResult.payload(this.pageCount);
            }
            return TypedResult.endOfStream();
        }
    }

    private class ResultRetrievalHandler
    implements Consumer<JobExecutionResult> {
        private ResultRetrievalHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(JobExecutionResult jobExecutionResult) {
            try {
                ArrayList accResult = (ArrayList)jobExecutionResult.getAccumulatorResult(MaterializedCollectBatchResult.this.accumulatorName);
                if (accResult == null) {
                    throw new SqlExecutionException("The accumulator could not retrieve the result.");
                }
                List resultTable = SerializedListAccumulator.deserializeList((ArrayList)accResult, MaterializedCollectBatchResult.this.tableSink.getSerializer());
                Object object = MaterializedCollectBatchResult.this.resultLock;
                synchronized (object) {
                    MaterializedCollectBatchResult.this.resultTable = resultTable;
                }
            }
            catch (IOException | ClassNotFoundException e) {
                throw new SqlExecutionException("Serialization error while deserializing collected data.", e);
            }
        }
    }
}

