/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.commons.cli.Options;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.dag.Pipeline;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.client.cli.CliFrontend;
import org.apache.flink.client.cli.CliFrontendParser;
import org.apache.flink.client.cli.CustomCommandLine;
import org.apache.flink.client.deployment.ClusterClientServiceLoader;
import org.apache.flink.client.deployment.ClusterDescriptor;
import org.apache.flink.client.deployment.DefaultClusterClientServiceLoader;
import org.apache.flink.client.program.ClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.DeploymentOptions;
import org.apache.flink.configuration.GlobalConfiguration;
import org.apache.flink.core.execution.JobClient;
import org.apache.flink.core.fs.FileSystem;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.core.plugin.PluginUtils;
import org.apache.flink.table.api.QueryConfig;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.java.StreamTableEnvironment;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.config.Environment;
import org.apache.flink.table.client.config.entries.TableEntry;
import org.apache.flink.table.client.config.entries.ViewEntry;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.ProgramTargetDescriptor;
import org.apache.flink.table.client.gateway.ResultDescriptor;
import org.apache.flink.table.client.gateway.SessionContext;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.local.ExecutionContext;
import org.apache.flink.table.client.gateway.local.ProgramDeployer;
import org.apache.flink.table.client.gateway.local.ResultStore;
import org.apache.flink.table.client.gateway.local.result.ChangelogResult;
import org.apache.flink.table.client.gateway.local.result.DynamicResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedResult;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeUtils;
import org.apache.flink.table.types.utils.DataTypeUtils;
import org.apache.flink.types.Row;
import org.apache.flink.util.JarUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalExecutor
implements Executor {
    private static final Logger LOG = LoggerFactory.getLogger(LocalExecutor.class);
    private static final String DEFAULT_ENV_FILE = "sql-client-defaults.yaml";
    private final ConcurrentHashMap<String, ExecutionContext<?>> contextMap;
    private final ClusterClientServiceLoader clusterClientServiceLoader;
    private final Environment defaultEnvironment;
    private final List<URL> dependencies;
    private final Configuration flinkConfig;
    private final List<CustomCommandLine> commandLines;
    private final Options commandLineOptions;
    private final ResultStore resultStore;
    private static final Pattern INSERT_SQL_PATTERN = Pattern.compile("(INSERT\\s+(INTO|OVERWRITE).*)", 34);

    public LocalExecutor(URL defaultEnv, List<URL> jars, List<URL> libraries) {
        String flinkConfigDir;
        try {
            flinkConfigDir = CliFrontend.getConfigurationDirectoryFromEnv();
            this.flinkConfig = GlobalConfiguration.loadConfiguration((String)flinkConfigDir);
            FileSystem.initialize((Configuration)this.flinkConfig, (PluginManager)PluginUtils.createPluginManagerFromRootFolder((Configuration)this.flinkConfig));
            this.commandLines = CliFrontend.loadCustomCommandLines((Configuration)this.flinkConfig, (String)flinkConfigDir);
            this.commandLineOptions = LocalExecutor.collectCommandLineOptions(this.commandLines);
        }
        catch (Exception e) {
            throw new SqlClientException("Could not load Flink configuration.", e);
        }
        if (defaultEnv == null) {
            String defaultFilePath = flinkConfigDir + "/" + DEFAULT_ENV_FILE;
            System.out.println("No default environment specified.");
            System.out.print("Searching for '" + defaultFilePath + "'...");
            File file = new File(defaultFilePath);
            if (file.exists()) {
                System.out.println("found.");
                try {
                    defaultEnv = Path.fromLocalFile((File)file).toUri().toURL();
                }
                catch (MalformedURLException e) {
                    throw new SqlClientException(e);
                }
                LOG.info("Using default environment file: {}", (Object)defaultEnv);
            } else {
                System.out.println("not found.");
            }
        }
        if (defaultEnv != null) {
            System.out.println("Reading default environment from: " + defaultEnv);
            try {
                this.defaultEnvironment = Environment.parse(defaultEnv);
            }
            catch (IOException e) {
                throw new SqlClientException("Could not read default environment file at: " + defaultEnv, e);
            }
        } else {
            this.defaultEnvironment = new Environment();
        }
        this.contextMap = new ConcurrentHashMap();
        this.dependencies = LocalExecutor.discoverDependencies(jars, libraries);
        this.resultStore = new ResultStore(this.flinkConfig);
        this.clusterClientServiceLoader = new DefaultClusterClientServiceLoader();
    }

    public LocalExecutor(Environment defaultEnvironment, List<URL> dependencies, Configuration flinkConfig, CustomCommandLine commandLine, ClusterClientServiceLoader clusterClientServiceLoader) {
        this.defaultEnvironment = defaultEnvironment;
        this.dependencies = dependencies;
        this.flinkConfig = flinkConfig;
        this.commandLines = Collections.singletonList(commandLine);
        this.commandLineOptions = LocalExecutor.collectCommandLineOptions(this.commandLines);
        this.contextMap = new ConcurrentHashMap();
        this.resultStore = new ResultStore(flinkConfig);
        this.clusterClientServiceLoader = (ClusterClientServiceLoader)Preconditions.checkNotNull((Object)clusterClientServiceLoader);
    }

    @Override
    public void start() {
    }

    private ExecutionContext.Builder createExecutionContextBuilder(SessionContext sessionContext) {
        return ExecutionContext.builder(this.defaultEnvironment, sessionContext, this.dependencies, this.flinkConfig, this.clusterClientServiceLoader, this.commandLineOptions, this.commandLines);
    }

    @Override
    public String openSession(SessionContext sessionContext) throws SqlExecutionException {
        String sessionId = sessionContext.getSessionId();
        if (this.contextMap.containsKey(sessionId)) {
            throw new SqlExecutionException("Found another session with the same session identifier: " + sessionId);
        }
        this.contextMap.put(sessionId, this.createExecutionContextBuilder(sessionContext).build());
        return sessionId;
    }

    @Override
    public void closeSession(String sessionId) throws SqlExecutionException {
        this.resultStore.getResults().forEach(resultId -> {
            try {
                this.cancelQuery(sessionId, (String)resultId);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
        this.contextMap.remove(sessionId);
    }

    @VisibleForTesting
    protected ExecutionContext<?> getExecutionContext(String sessionId) throws SqlExecutionException {
        ExecutionContext<?> context = this.contextMap.get(sessionId);
        if (context == null) {
            throw new SqlExecutionException("Invalid session identifier: " + sessionId);
        }
        return context;
    }

    @Override
    public Map<String, String> getSessionProperties(String sessionId) throws SqlExecutionException {
        Environment env = this.getExecutionContext(sessionId).getEnvironment();
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.putAll(env.getExecution().asTopLevelMap());
        properties.putAll(env.getDeployment().asTopLevelMap());
        properties.putAll(env.getConfiguration().asMap());
        return properties;
    }

    @Override
    public void resetSessionProperties(String sessionId) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        ExecutionContext<?> newContext = this.createExecutionContextBuilder(context.getOriginalSessionContext()).sessionState(context.getSessionState()).build();
        this.contextMap.put(sessionId, newContext);
    }

    @Override
    public void setSessionProperty(String sessionId, String key, String value) throws SqlExecutionException {
        Environment newEnv;
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        Environment env = context.getEnvironment();
        try {
            newEnv = Environment.enrich(env, Collections.singletonMap(key, value), Collections.emptyMap());
        }
        catch (Throwable t) {
            throw new SqlExecutionException("Could not set session property.", t);
        }
        ExecutionContext<?> newContext = this.createExecutionContextBuilder(context.getOriginalSessionContext()).env(newEnv).sessionState(context.getSessionState()).build();
        this.contextMap.put(sessionId, newContext);
    }

    @Override
    public void addView(String sessionId, String name, String query) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        tableEnv.createTemporaryView(name, tableEnv.sqlQuery(query));
        context.getEnvironment().getTables().put(name, ViewEntry.create(name, query));
    }

    @Override
    public void removeView(String sessionId, String name) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        Environment env = context.getEnvironment();
        Environment newEnv = env.clone();
        if (newEnv.getTables().remove(name) != null) {
            this.contextMap.put(sessionId, this.createExecutionContextBuilder(context.getOriginalSessionContext()).env(newEnv).build());
        }
    }

    @Override
    public Map<String, ViewEntry> listViews(String sessionId) throws SqlExecutionException {
        HashMap<String, ViewEntry> views = new HashMap<String, ViewEntry>();
        Map<String, TableEntry> tables = this.getExecutionContext(sessionId).getEnvironment().getTables();
        for (Map.Entry<String, TableEntry> entry : tables.entrySet()) {
            if (!(entry.getValue() instanceof ViewEntry)) continue;
            views.put(entry.getKey(), (ViewEntry)entry.getValue());
        }
        return views;
    }

    @Override
    public List<String> listCatalogs(String sessionId) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        return context.wrapClassLoader(() -> Arrays.asList(tableEnv.listCatalogs()));
    }

    @Override
    public List<String> listDatabases(String sessionId) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        return context.wrapClassLoader(() -> Arrays.asList(tableEnv.listDatabases()));
    }

    @Override
    public void createTable(String sessionId, String ddl) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tEnv = context.getTableEnvironment();
        try {
            context.wrapClassLoader(() -> tEnv.sqlUpdate(ddl));
        }
        catch (Exception e) {
            throw new SqlExecutionException("Could not create a table from statement: " + ddl, e);
        }
    }

    @Override
    public void dropTable(String sessionId, String ddl) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tEnv = context.getTableEnvironment();
        try {
            context.wrapClassLoader(() -> tEnv.sqlUpdate(ddl));
        }
        catch (Exception e) {
            throw new SqlExecutionException("Could not drop table from statement: " + ddl, e);
        }
    }

    @Override
    public List<String> listTables(String sessionId) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        return context.wrapClassLoader(() -> Arrays.asList(tableEnv.listTables()));
    }

    @Override
    public List<String> listUserDefinedFunctions(String sessionId) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        return context.wrapClassLoader(() -> Arrays.asList(tableEnv.listUserDefinedFunctions()));
    }

    @Override
    public List<String> listFunctions(String sessionId) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        return context.wrapClassLoader(() -> Arrays.asList(tableEnv.listFunctions()));
    }

    @Override
    public List<String> listModules(String sessionId) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        return context.wrapClassLoader(() -> Arrays.asList(tableEnv.listModules()));
    }

    @Override
    public void useCatalog(String sessionId, String catalogName) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        context.wrapClassLoader(() -> {
            try {
                tableEnv.useCatalog(catalogName);
            }
            catch (CatalogException e) {
                throw new SqlExecutionException("Failed to switch to catalog " + catalogName, e);
            }
        });
    }

    @Override
    public void useDatabase(String sessionId, String databaseName) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        context.wrapClassLoader(() -> {
            try {
                tableEnv.useDatabase(databaseName);
            }
            catch (CatalogException e) {
                throw new SqlExecutionException("Failed to switch to database " + databaseName, e);
            }
        });
    }

    @Override
    public TableSchema getTableSchema(String sessionId, String name) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        try {
            return context.wrapClassLoader(() -> tableEnv.scan(new String[]{name}).getSchema());
        }
        catch (Throwable t) {
            throw new SqlExecutionException("No table with this name could be found.", t);
        }
    }

    @Override
    public String explainStatement(String sessionId, String statement) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        try {
            Table table = this.createTable(context, tableEnv, statement);
            return context.wrapClassLoader(() -> tableEnv.explain(table));
        }
        catch (Throwable t) {
            throw new SqlExecutionException("Invalid SQL statement.", t);
        }
    }

    @Override
    public List<String> completeStatement(String sessionId, String statement, int position) {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        TableEnvironment tableEnv = context.getTableEnvironment();
        try {
            return context.wrapClassLoader(() -> Arrays.asList(tableEnv.getCompletionHints(statement, position)));
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not complete statement at " + position + ":" + statement, t);
            }
            return Collections.emptyList();
        }
    }

    @Override
    public ResultDescriptor executeQuery(String sessionId, String query) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        return this.executeQueryInternal(sessionId, context, query);
    }

    @Override
    public TypedResult<List<Tuple2<Boolean, Row>>> retrieveResultChanges(String sessionId, String resultId) throws SqlExecutionException {
        DynamicResult result = this.resultStore.getResult(resultId);
        if (result == null) {
            throw new SqlExecutionException("Could not find a result with result identifier '" + resultId + "'.");
        }
        if (result.isMaterialized()) {
            throw new SqlExecutionException("Invalid result retrieval mode.");
        }
        return ((ChangelogResult)result).retrieveChanges();
    }

    @Override
    public TypedResult<Integer> snapshotResult(String sessionId, String resultId, int pageSize) throws SqlExecutionException {
        DynamicResult result = this.resultStore.getResult(resultId);
        if (result == null) {
            throw new SqlExecutionException("Could not find a result with result identifier '" + resultId + "'.");
        }
        if (!result.isMaterialized()) {
            throw new SqlExecutionException("Invalid result retrieval mode.");
        }
        return ((MaterializedResult)result).snapshot(pageSize);
    }

    @Override
    public List<Row> retrieveResultPage(String resultId, int page) throws SqlExecutionException {
        DynamicResult result = this.resultStore.getResult(resultId);
        if (result == null) {
            throw new SqlExecutionException("Could not find a result with result identifier '" + resultId + "'.");
        }
        if (!result.isMaterialized()) {
            throw new SqlExecutionException("Invalid result retrieval mode.");
        }
        return ((MaterializedResult)result).retrievePage(page);
    }

    @Override
    public void cancelQuery(String sessionId, String resultId) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        this.cancelQueryInternal(context, resultId);
    }

    @Override
    public ProgramTargetDescriptor executeUpdate(String sessionId, String statement) throws SqlExecutionException {
        ExecutionContext<?> context = this.getExecutionContext(sessionId);
        return this.executeUpdateInternal(sessionId, context, statement);
    }

    private <T> void cancelQueryInternal(ExecutionContext<T> context, String resultId) {
        DynamicResult result = this.resultStore.getResult(resultId);
        if (result == null) {
            throw new SqlExecutionException("Could not find a result with result identifier '" + resultId + "'.");
        }
        LOG.info("Cancelling job {} and result retrieval.", (Object)resultId);
        result.close();
        this.resultStore.removeResult(resultId);
        try (ClusterDescriptor<T> clusterDescriptor = context.createClusterDescriptor();){
            ClusterClient clusterClient = null;
            try {
                clusterClient = clusterDescriptor.retrieve(context.getClusterId()).getClusterClient();
                try {
                    clusterClient.cancel(new JobID(StringUtils.hexStringToByte((String)resultId))).get();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            catch (Exception e) {
                throw new SqlExecutionException("Could not retrieve or create a cluster.", e);
            }
            finally {
                try {
                    if (clusterClient != null) {
                        clusterClient.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (SqlExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SqlExecutionException("Could not locate a cluster.", e);
        }
    }

    private <C> ProgramTargetDescriptor executeUpdateInternal(String sessionId, ExecutionContext<C> context, String statement) {
        Pipeline pipeline;
        this.applyUpdate(context, context.getTableEnvironment(), context.getQueryConfig(), statement);
        if (!INSERT_SQL_PATTERN.matcher(statement.trim()).matches()) {
            return null;
        }
        String jobName = sessionId + ": " + statement;
        try {
            pipeline = context.createPipeline(jobName);
        }
        catch (Throwable t) {
            throw new SqlExecutionException("Invalid SQL statement.", t);
        }
        Configuration configuration = new Configuration(context.getFlinkConfig());
        configuration.set(DeploymentOptions.ATTACHED, (Object)false);
        ProgramDeployer deployer = new ProgramDeployer(configuration, jobName, pipeline);
        try {
            JobClient jobClient = deployer.deploy().get();
            return ProgramTargetDescriptor.of(jobClient.getJobID());
        }
        catch (Exception e) {
            throw new RuntimeException("Error running SQL job.", e);
        }
    }

    private <C> ResultDescriptor executeQueryInternal(String sessionId, ExecutionContext<C> context, String query) {
        JobClient jobClient;
        Pipeline pipeline;
        Table table = this.createTable(context, context.getTableEnvironment(), query);
        DynamicResult result = this.resultStore.createResult(context.getEnvironment(), LocalExecutor.removeTimeAttributes(table.getSchema()), context.getExecutionConfig(), context.getClassLoader());
        String jobName = sessionId + ": " + query;
        String tableName = String.format("_tmp_table_%s", Math.abs(query.hashCode()));
        try {
            context.wrapClassLoader(() -> {
                context.getTableEnvironment().registerTableSink(tableName, result.getTableSink());
                table.insertInto(context.getQueryConfig(), tableName, new String[0]);
            });
            pipeline = context.createPipeline(jobName);
        }
        catch (Throwable t) {
            result.close();
            throw new SqlExecutionException("Invalid SQL query.", t);
        }
        finally {
            context.wrapClassLoader(() -> context.getTableEnvironment().dropTemporaryTable(tableName));
        }
        Configuration configuration = new Configuration(context.getFlinkConfig());
        configuration.set(DeploymentOptions.ATTACHED, (Object)true);
        configuration.set(DeploymentOptions.SHUTDOWN_IF_ATTACHED, (Object)true);
        ProgramDeployer deployer = new ProgramDeployer(configuration, jobName, pipeline);
        try {
            jobClient = deployer.deploy().get();
        }
        catch (Exception e) {
            throw new SqlExecutionException("Error while submitting job.", e);
        }
        String jobId = jobClient.getJobID().toString();
        this.resultStore.storeResult(jobId, result);
        result.startRetrieval(jobClient);
        return new ResultDescriptor(jobId, LocalExecutor.removeTimeAttributes(table.getSchema()), result.isMaterialized());
    }

    private <C> Table createTable(ExecutionContext<C> context, TableEnvironment tableEnv, String selectQuery) {
        try {
            return context.wrapClassLoader(() -> tableEnv.sqlQuery(selectQuery));
        }
        catch (Throwable t) {
            throw new SqlExecutionException("Invalid SQL statement.", t);
        }
    }

    private <C> void applyUpdate(ExecutionContext<C> context, TableEnvironment tableEnv, QueryConfig queryConfig, String updateStatement) {
        try {
            context.wrapClassLoader(() -> {
                if (tableEnv instanceof StreamTableEnvironment) {
                    ((StreamTableEnvironment)tableEnv).sqlUpdate(updateStatement, (StreamQueryConfig)queryConfig);
                } else {
                    tableEnv.sqlUpdate(updateStatement);
                }
            });
        }
        catch (Throwable t) {
            throw new SqlExecutionException("Invalid SQL update statement.", t);
        }
    }

    private static List<URL> discoverDependencies(List<URL> jars, List<URL> libraries) {
        ArrayList<URL> dependencies = new ArrayList<URL>();
        try {
            for (URL url : jars) {
                JarUtils.checkJarFile((URL)url);
                dependencies.add(url);
            }
            for (URL libUrl : libraries) {
                File dir = new File(libUrl.toURI());
                if (!dir.isDirectory()) {
                    throw new SqlClientException("Directory expected: " + dir);
                }
                if (!dir.canRead()) {
                    throw new SqlClientException("Directory cannot be read: " + dir);
                }
                File[] files = dir.listFiles();
                if (files == null) {
                    throw new SqlClientException("Directory cannot be read: " + dir);
                }
                for (File f : files) {
                    if (!f.isFile() || !f.getAbsolutePath().toLowerCase().endsWith(".jar")) continue;
                    URL url = f.toURI().toURL();
                    JarUtils.checkJarFile((URL)url);
                    dependencies.add(url);
                }
            }
        }
        catch (Exception e) {
            throw new SqlClientException("Could not load all required JAR files.", e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using the following dependencies: {}", dependencies);
        }
        return dependencies;
    }

    private static Options collectCommandLineOptions(List<CustomCommandLine> commandLines) {
        Options customOptions = new Options();
        for (CustomCommandLine customCommandLine : commandLines) {
            customCommandLine.addGeneralOptions(customOptions);
            customCommandLine.addRunOptions(customOptions);
        }
        return CliFrontendParser.mergeOptions((Options)CliFrontendParser.getRunCommandOptions(), (Options)customOptions);
    }

    private static TableSchema removeTimeAttributes(TableSchema schema) {
        TableSchema.Builder builder = TableSchema.builder();
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            DataType dataType = schema.getFieldDataTypes()[i];
            DataType convertedType = DataTypeUtils.replaceLogicalType((DataType)dataType, (LogicalType)LogicalTypeUtils.removeTimeAttributes((LogicalType)dataType.getLogicalType()));
            builder.field(schema.getFieldNames()[i], convertedType);
        }
        return builder.build();
    }
}

