/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local.result;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.local.result.CollectStreamResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedResult;
import org.apache.flink.types.Row;

public class MaterializedCollectStreamResult<C>
extends CollectStreamResult<C>
implements MaterializedResult<C> {
    public static final int MATERIALIZED_TABLE_MAX_INITIAL_CAPACITY = 1000000;
    public static final int MATERIALIZED_TABLE_MAX_OVERCOMMIT = 1000000;
    public static final double MATERIALIZED_TABLE_CAPACITY_FACTOR = 0.05;
    public static final double MATERIALIZED_TABLE_OVERCOMMIT_FACTOR = 0.01;
    private final int maxRowCount;
    private final int overcommitThreshold;
    private final List<Row> materializedTable;
    private final Map<Row, Integer> rowPositionCache;
    private final List<Row> snapshot;
    private int validRowPosition;
    private int pageCount;
    private int pageSize;
    private boolean isLastSnapshot;

    @VisibleForTesting
    public MaterializedCollectStreamResult(TableSchema tableSchema, ExecutionConfig config, InetAddress gatewayAddress, int gatewayPort, int maxRowCount, int overcommitThreshold, ClassLoader classLoader) {
        super(tableSchema, config, gatewayAddress, gatewayPort, classLoader);
        this.maxRowCount = maxRowCount <= 0 ? Integer.MAX_VALUE : maxRowCount;
        this.overcommitThreshold = overcommitThreshold;
        int initialCapacity = MaterializedCollectStreamResult.computeMaterializedTableCapacity(maxRowCount);
        this.materializedTable = new ArrayList<Row>(initialCapacity);
        this.rowPositionCache = new HashMap<Row, Integer>(initialCapacity);
        this.snapshot = new ArrayList<Row>();
        this.validRowPosition = 0;
        this.isLastSnapshot = false;
        this.pageCount = 0;
    }

    public MaterializedCollectStreamResult(TableSchema tableSchema, ExecutionConfig config, InetAddress gatewayAddress, int gatewayPort, int maxRowCount, ClassLoader classLoader) {
        this(tableSchema, config, gatewayAddress, gatewayPort, maxRowCount, MaterializedCollectStreamResult.computeMaterializedTableOvercommit(maxRowCount), classLoader);
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedResult<Integer> snapshot(int pageSize) {
        if (pageSize < 1) {
            throw new SqlExecutionException("Page size must be greater than 0.");
        }
        Object object = this.resultLock;
        synchronized (object) {
            if (!this.isRetrieving() && this.isLastSnapshot || this.executionException.get() != null) {
                return this.handleMissingResult();
            }
            if (!this.isRetrieving()) {
                this.isLastSnapshot = true;
            }
            this.pageSize = pageSize;
            this.snapshot.clear();
            for (int i = this.validRowPosition; i < this.materializedTable.size(); ++i) {
                this.snapshot.add(this.materializedTable.get(i));
            }
            this.pageCount = Math.max(1, (int)Math.ceil((double)this.snapshot.size() / (double)pageSize));
            return TypedResult.payload(this.pageCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Row> retrievePage(int page) {
        Object object = this.resultLock;
        synchronized (object) {
            if (page <= 0 || page > this.pageCount) {
                throw new SqlExecutionException("Invalid page '" + page + "'.");
            }
            return this.snapshot.subList(this.pageSize * (page - 1), Math.min(this.snapshot.size(), this.pageSize * page));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRecord(Tuple2<Boolean, Row> change) {
        Object object = this.resultLock;
        synchronized (object) {
            if (((Boolean)change.f0).booleanValue()) {
                this.processInsert((Row)change.f1);
            } else {
                this.processDelete((Row)change.f1);
            }
        }
    }

    @VisibleForTesting
    protected List<Row> getMaterializedTable() {
        return this.materializedTable;
    }

    private void processInsert(Row row) {
        if (this.materializedTable.size() - this.validRowPosition >= this.maxRowCount) {
            this.cleanUp();
        }
        this.materializedTable.add(row);
        this.rowPositionCache.put(row, this.materializedTable.size() - 1);
    }

    private void processDelete(Row row) {
        Integer cachedPos = this.rowPositionCache.get(row);
        int startSearchPos = cachedPos != null ? Math.min(cachedPos, this.materializedTable.size() - 1) : this.materializedTable.size() - 1;
        for (int i = startSearchPos; i >= this.validRowPosition; --i) {
            if (!this.materializedTable.get(i).equals((Object)row)) continue;
            this.materializedTable.remove(i);
            this.rowPositionCache.remove(row);
            break;
        }
    }

    private void cleanUp() {
        Row deleteRow = this.materializedTable.get(this.validRowPosition);
        if (this.rowPositionCache.get(deleteRow) == this.validRowPosition) {
            this.rowPositionCache.remove(deleteRow);
        }
        this.materializedTable.set(this.validRowPosition, null);
        ++this.validRowPosition;
        if (this.validRowPosition >= this.overcommitThreshold) {
            this.materializedTable.subList(0, this.validRowPosition).clear();
            this.rowPositionCache.replaceAll((k, v) -> v - this.validRowPosition);
            this.validRowPosition = 0;
        }
    }

    private static int computeMaterializedTableCapacity(int maxRowCount) {
        return Math.min(1000000, Math.max(1, (int)((double)maxRowCount * 0.05)));
    }

    private static int computeMaterializedTableOvercommit(int maxRowCount) {
        return Math.min(1000000, (int)((double)maxRowCount * 0.01));
    }
}

