/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local;

import org.apache.flink.api.common.io.OutputFormat;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.Utils;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sinks.BatchTableSink;
import org.apache.flink.table.sinks.OutputFormatTableSink;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.TableSchemaUtils;
import org.apache.flink.types.Row;

public class CollectBatchTableSink
extends OutputFormatTableSink<Row>
implements BatchTableSink<Row> {
    private final String accumulatorName;
    private final TypeSerializer<Row> serializer;
    private final TableSchema tableSchema;

    public CollectBatchTableSink(String accumulatorName, TypeSerializer<Row> serializer, TableSchema tableSchema) {
        this.accumulatorName = accumulatorName;
        this.serializer = serializer;
        this.tableSchema = TableSchemaUtils.checkNoGeneratedColumns((TableSchema)tableSchema);
    }

    public TypeSerializer<Row> getSerializer() {
        return this.serializer;
    }

    public DataType getConsumedDataType() {
        return this.getTableSchema().toRowDataType();
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public CollectBatchTableSink configure(String[] fieldNames, TypeInformation<?>[] fieldTypes) {
        return new CollectBatchTableSink(this.accumulatorName, this.serializer, this.tableSchema);
    }

    public void emitDataSet(DataSet<Row> dataSet) {
        dataSet.output((OutputFormat)new Utils.CollectHelper(this.accumulatorName, this.serializer)).name("SQL Client Batch Collect Sink");
    }

    public OutputFormat<Row> getOutputFormat() {
        return new Utils.CollectHelper(this.accumulatorName, this.serializer);
    }
}

