/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.config.ConfigUtil;
import org.apache.flink.table.client.config.entries.CatalogEntry;
import org.apache.flink.table.client.config.entries.ConfigurationEntry;
import org.apache.flink.table.client.config.entries.DeploymentEntry;
import org.apache.flink.table.client.config.entries.ExecutionEntry;
import org.apache.flink.table.client.config.entries.FunctionEntry;
import org.apache.flink.table.client.config.entries.ModuleEntry;
import org.apache.flink.table.client.config.entries.TableEntry;
import org.apache.flink.table.client.config.entries.ViewEntry;

public class Environment {
    public static final String EXECUTION_ENTRY = "execution";
    public static final String CONFIGURATION_ENTRY = "table";
    public static final String DEPLOYMENT_ENTRY = "deployment";
    private Map<String, ModuleEntry> modules = new LinkedHashMap<String, ModuleEntry>();
    private Map<String, CatalogEntry> catalogs = Collections.emptyMap();
    private Map<String, TableEntry> tables = Collections.emptyMap();
    private Map<String, FunctionEntry> functions = Collections.emptyMap();
    private ExecutionEntry execution = ExecutionEntry.DEFAULT_INSTANCE;
    private ConfigurationEntry configuration = ConfigurationEntry.DEFAULT_INSTANCE;
    private DeploymentEntry deployment = DeploymentEntry.DEFAULT_INSTANCE;

    public Map<String, ModuleEntry> getModules() {
        return this.modules;
    }

    public void setModules(List<Map<String, Object>> modules) {
        this.modules = new LinkedHashMap<String, ModuleEntry>(modules.size());
        modules.forEach(config -> {
            ModuleEntry entry = ModuleEntry.create(config);
            if (this.modules.containsKey(entry.getName())) {
                throw new SqlClientException(String.format("Cannot register module '%s' because a module with this name is already registered.", entry.getName()));
            }
            this.modules.put(entry.getName(), entry);
        });
    }

    public Map<String, CatalogEntry> getCatalogs() {
        return this.catalogs;
    }

    public void setCatalogs(List<Map<String, Object>> catalogs) {
        this.catalogs = new HashMap<String, CatalogEntry>(catalogs.size());
        catalogs.forEach(config -> {
            CatalogEntry catalog = CatalogEntry.create(config);
            if (this.catalogs.containsKey(catalog.getName())) {
                throw new SqlClientException(String.format("Cannot create catalog '%s' because a catalog with this name is already registered.", catalog.getName()));
            }
            this.catalogs.put(catalog.getName(), catalog);
        });
    }

    public Map<String, TableEntry> getTables() {
        return this.tables;
    }

    public void setTables(List<Map<String, Object>> tables) {
        this.tables = new LinkedHashMap<String, TableEntry>(tables.size());
        tables.forEach(config -> {
            TableEntry table = TableEntry.create(config);
            if (this.tables.containsKey(table.getName())) {
                throw new SqlClientException("Cannot create table '" + table.getName() + "' because a table with this name is already registered.");
            }
            this.tables.put(table.getName(), table);
        });
    }

    public Map<String, FunctionEntry> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<Map<String, Object>> functions) {
        this.functions = new HashMap<String, FunctionEntry>(functions.size());
        functions.forEach(config -> {
            FunctionEntry function = FunctionEntry.create(config);
            if (this.functions.containsKey(function.getName())) {
                throw new SqlClientException("Cannot create function '" + function.getName() + "' because a function with this name is already registered.");
            }
            this.functions.put(function.getName(), function);
        });
    }

    public void setExecution(Map<String, Object> config) {
        this.execution = ExecutionEntry.create(config);
    }

    public ExecutionEntry getExecution() {
        return this.execution;
    }

    public void setConfiguration(Map<String, Object> config) {
        this.configuration = ConfigurationEntry.create(config);
    }

    public ConfigurationEntry getConfiguration() {
        return this.configuration;
    }

    public void setDeployment(Map<String, Object> config) {
        this.deployment = DeploymentEntry.create(config);
    }

    public DeploymentEntry getDeployment() {
        return this.deployment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("===================== Modules =====================\n");
        this.modules.forEach((name, module) -> {
            sb.append("- ").append("name").append(": ").append((String)name).append("\n");
            module.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("===================== Catalogs =====================\n");
        this.catalogs.forEach((name, catalog) -> {
            sb.append("- ").append("name").append(": ").append((String)name).append("\n");
            catalog.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("===================== Tables =====================\n");
        this.tables.forEach((name, table) -> {
            sb.append("- ").append("name").append(": ").append((String)name).append("\n");
            table.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("=================== Functions ====================\n");
        this.functions.forEach((name, function) -> {
            sb.append("- ").append("name").append(": ").append((String)name).append("\n");
            function.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("=================== Execution ====================\n");
        this.execution.asTopLevelMap().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        sb.append("================== Configuration =================\n");
        this.configuration.asMap().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        sb.append("=================== Deployment ===================\n");
        this.deployment.asTopLevelMap().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        return sb.toString();
    }

    public static Environment parse(URL url) throws IOException {
        try {
            return (Environment)new ConfigUtil.LowerCaseYamlMapper().readValue(url, Environment.class);
        }
        catch (JsonMappingException e) {
            throw new SqlClientException("Could not parse environment file. Cause: " + e.getMessage());
        }
    }

    public static Environment parse(String content) throws IOException {
        try {
            return (Environment)new ConfigUtil.LowerCaseYamlMapper().readValue(content, Environment.class);
        }
        catch (JsonMappingException e) {
            throw new SqlClientException("Could not parse environment file. Cause: " + e.getMessage());
        }
    }

    public static Environment merge(Environment env1, Environment env2) {
        Environment mergedEnv = new Environment();
        LinkedHashMap<String, ModuleEntry> modules = new LinkedHashMap<String, ModuleEntry>(env1.getModules());
        modules.putAll(env2.getModules());
        mergedEnv.modules = modules;
        HashMap<String, CatalogEntry> catalogs = new HashMap<String, CatalogEntry>(env1.getCatalogs());
        catalogs.putAll(env2.getCatalogs());
        mergedEnv.catalogs = catalogs;
        LinkedHashMap<String, TableEntry> tables = new LinkedHashMap<String, TableEntry>(env1.getTables());
        tables.putAll(env2.getTables());
        mergedEnv.tables = tables;
        HashMap<String, FunctionEntry> functions = new HashMap<String, FunctionEntry>(env1.getFunctions());
        functions.putAll(env2.getFunctions());
        mergedEnv.functions = functions;
        mergedEnv.execution = ExecutionEntry.merge(env1.getExecution(), env2.getExecution());
        mergedEnv.configuration = ConfigurationEntry.merge(env1.getConfiguration(), env2.getConfiguration());
        mergedEnv.deployment = DeploymentEntry.merge(env1.getDeployment(), env2.getDeployment());
        return mergedEnv;
    }

    public Environment clone() {
        return Environment.enrich(this, Collections.emptyMap(), Collections.emptyMap());
    }

    public static Environment enrich(Environment env, Map<String, String> properties, Map<String, ViewEntry> views) {
        Environment enrichedEnv = new Environment();
        enrichedEnv.modules = new LinkedHashMap<String, ModuleEntry>(env.getModules());
        enrichedEnv.catalogs = new LinkedHashMap<String, CatalogEntry>(env.getCatalogs());
        enrichedEnv.tables = new LinkedHashMap<String, TableEntry>(env.getTables());
        enrichedEnv.tables.putAll(views);
        enrichedEnv.functions = new HashMap<String, FunctionEntry>(env.getFunctions());
        enrichedEnv.execution = ExecutionEntry.enrich(env.execution, properties);
        enrichedEnv.configuration = ConfigurationEntry.enrich(env.configuration, properties);
        enrichedEnv.deployment = DeploymentEntry.enrich(env.deployment, properties);
        return enrichedEnv;
    }
}

