/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.EOFException;
import java.io.IOError;
import java.io.IOException;
import java.util.EnumSet;
import java.util.function.IntSupplier;
import org.jline.terminal.MouseEvent;
import org.jline.terminal.Terminal;
import org.jline.utils.InfoCmp;

public class MouseSupport {
    public static boolean hasMouseSupport(Terminal terminal) {
        return terminal.getStringCapability(InfoCmp.Capability.key_mouse) != null;
    }

    public static boolean trackMouse(Terminal terminal, Terminal.MouseTracking tracking) {
        if (MouseSupport.hasMouseSupport(terminal)) {
            switch (tracking) {
                case Off: {
                    terminal.writer().write("\u001b[?1000l");
                    break;
                }
                case Normal: {
                    terminal.writer().write("\u001b[?1005h\u001b[?1000h");
                    break;
                }
                case Button: {
                    terminal.writer().write("\u001b[?1005h\u001b[?1002h");
                    break;
                }
                case Any: {
                    terminal.writer().write("\u001b[?1005h\u001b[?1003h");
                }
            }
            terminal.flush();
            return true;
        }
        return false;
    }

    public static MouseEvent readMouse(Terminal terminal, MouseEvent last) {
        return MouseSupport.readMouse(() -> MouseSupport.readExt(terminal), last);
    }

    public static MouseEvent readMouse(IntSupplier reader, MouseEvent last) {
        MouseEvent.Button button;
        MouseEvent.Type type;
        int cb = reader.getAsInt() - 32;
        int cx = reader.getAsInt() - 32 - 1;
        int cy = reader.getAsInt() - 32 - 1;
        EnumSet<MouseEvent.Modifier> modifiers = EnumSet.noneOf(MouseEvent.Modifier.class);
        if ((cb & 4) == 4) {
            modifiers.add(MouseEvent.Modifier.Shift);
        }
        if ((cb & 8) == 8) {
            modifiers.add(MouseEvent.Modifier.Alt);
        }
        if ((cb & 0x10) == 16) {
            modifiers.add(MouseEvent.Modifier.Control);
        }
        if ((cb & 0x40) == 64) {
            type = MouseEvent.Type.Wheel;
            button = (cb & 1) == 1 ? MouseEvent.Button.WheelDown : MouseEvent.Button.WheelUp;
        } else {
            int b = cb & 3;
            switch (b) {
                case 0: {
                    button = MouseEvent.Button.Button1;
                    type = last.getButton() == button ? MouseEvent.Type.Dragged : MouseEvent.Type.Pressed;
                    break;
                }
                case 1: {
                    button = MouseEvent.Button.Button2;
                    type = last.getButton() == button ? MouseEvent.Type.Dragged : MouseEvent.Type.Pressed;
                    break;
                }
                case 2: {
                    button = MouseEvent.Button.Button3;
                    type = last.getButton() == button ? MouseEvent.Type.Dragged : MouseEvent.Type.Pressed;
                    break;
                }
                default: {
                    if (last.getType() == MouseEvent.Type.Pressed || last.getType() == MouseEvent.Type.Dragged) {
                        button = last.getButton();
                        type = MouseEvent.Type.Released;
                        break;
                    }
                    button = MouseEvent.Button.NoButton;
                    type = MouseEvent.Type.Moved;
                }
            }
        }
        return new MouseEvent(type, button, modifiers, cx, cy);
    }

    private static int readExt(Terminal terminal) {
        try {
            int c = terminal.reader().read();
            if (c < 0) {
                throw new EOFException();
            }
            return c;
        }
        catch (IOException e2) {
            throw new IOError(e2);
        }
    }
}

