/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.sources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.descriptors.ConnectorDescriptorValidator$;
import org.apache.flink.table.descriptors.CsvValidator;
import org.apache.flink.table.descriptors.CsvValidator$;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.DescriptorProperties$;
import org.apache.flink.table.descriptors.FileSystemValidator;
import org.apache.flink.table.descriptors.FileSystemValidator$;
import org.apache.flink.table.descriptors.FormatDescriptorValidator$;
import org.apache.flink.table.descriptors.SchemaValidator;
import org.apache.flink.table.descriptors.SchemaValidator$;
import org.apache.flink.table.factories.TableFactory;
import org.apache.flink.table.sources.CsvTableSource;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u00113Q!\u0001\u0002\u0002\u00025\u0011\u0011dQ:w)\u0006\u0014G.Z*pkJ\u001cWMR1di>\u0014\u0018PQ1tK*\u00111\u0001B\u0001\bg>,(oY3t\u0015\t)a!A\u0003uC\ndWM\u0003\u0002\b\u0011\u0005)a\r\\5oW*\u0011\u0011BC\u0001\u0007CB\f7\r[3\u000b\u0003-\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\b\u0015!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fMB\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\nM\u0006\u001cGo\u001c:jKNL!!\u0007\f\u0003\u0019Q\u000b'\r\\3GC\u000e$xN]=\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001\"\u0002\u0011\u0001\t\u0003\n\u0013a\u0004:fcVL'/\u001a3D_:$X\r\u001f;\u0015\u0003\t\u0002Ba\t\u0015+U5\tAE\u0003\u0002&M\u0005!Q\u000f^5m\u0015\u00059\u0013\u0001\u00026bm\u0006L!!\u000b\u0013\u0003\u00075\u000b\u0007\u000f\u0005\u0002,]9\u0011q\u0002L\u0005\u0003[A\ta\u0001\u0015:fI\u00164\u0017BA\u00181\u0005\u0019\u0019FO]5oO*\u0011Q\u0006\u0005\u0005\u0006e\u0001!\teM\u0001\u0014gV\u0004\bo\u001c:uK\u0012\u0004&o\u001c9feRLWm\u001d\u000b\u0002iA\u00191%\u000e\u0016\n\u0005Y\"#\u0001\u0002'jgRDQ\u0001\u000f\u0001\u0005\u0012e\n\u0011c\u0019:fCR,G+\u00192mKN{WO]2f)\rQTH\u0011\t\u0003=mJ!\u0001\u0010\u0002\u0003\u001d\r\u001bh\u000fV1cY\u0016\u001cv.\u001e:dK\")ah\u000ea\u0001\u007f\u0005Y\u0011n]*ue\u0016\fW.\u001b8h!\ty\u0001)\u0003\u0002B!\t9!i\\8mK\u0006t\u0007\"B\"8\u0001\u0004\u0011\u0013A\u00039s_B,'\u000f^5fg\u0002")
public abstract class CsvTableSourceFactoryBase
implements TableFactory {
    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, String> requiredContext() {
        void var1_1;
        HashMap<String, String> context = new HashMap<String, String>();
        context.put(ConnectorDescriptorValidator$.MODULE$.CONNECTOR_TYPE(), FileSystemValidator$.MODULE$.CONNECTOR_TYPE_VALUE());
        context.put(FormatDescriptorValidator$.MODULE$.FORMAT_TYPE(), CsvValidator$.MODULE$.FORMAT_TYPE_VALUE());
        context.put(ConnectorDescriptorValidator$.MODULE$.CONNECTOR_PROPERTY_VERSION(), "1");
        context.put(FormatDescriptorValidator$.MODULE$.FORMAT_PROPERTY_VERSION(), "1");
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<String> supportedProperties() {
        void var1_1;
        ArrayList<String> properties = new ArrayList<String>();
        properties.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CsvValidator$.MODULE$.FORMAT_FIELDS(), DescriptorProperties$.MODULE$.TYPE()})));
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{CsvValidator$.MODULE$.FORMAT_FIELDS(), DescriptorProperties$.MODULE$.NAME()})));
        properties.add(CsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER());
        properties.add(CsvValidator$.MODULE$.FORMAT_LINE_DELIMITER());
        properties.add(CsvValidator$.MODULE$.FORMAT_QUOTE_CHARACTER());
        properties.add(CsvValidator$.MODULE$.FORMAT_COMMENT_PREFIX());
        properties.add(CsvValidator$.MODULE$.FORMAT_IGNORE_FIRST_LINE());
        properties.add(CsvValidator$.MODULE$.FORMAT_IGNORE_PARSE_ERRORS());
        properties.add(FileSystemValidator$.MODULE$.CONNECTOR_PATH());
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaValidator$.MODULE$.SCHEMA(), DescriptorProperties$.MODULE$.TYPE()})));
        properties.add(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".#.", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SchemaValidator$.MODULE$.SCHEMA(), DescriptorProperties$.MODULE$.NAME()})));
        return var1_1;
    }

    public CsvTableSource createTableSource(boolean isStreaming, Map<String, String> properties) {
        DescriptorProperties params = new DescriptorProperties(DescriptorProperties$.MODULE$.$lessinit$greater$default$1());
        params.putProperties(properties);
        new FileSystemValidator().validate(params);
        new CsvValidator().validate(params);
        new SchemaValidator(isStreaming, false, false).validate(params);
        CsvTableSource.Builder csvTableSourceBuilder = new CsvTableSource.Builder();
        TableSchema formatSchema = params.getTableSchema(CsvValidator$.MODULE$.FORMAT_FIELDS());
        TableSchema tableSchema2 = params.getTableSchema(SchemaValidator$.MODULE$.SCHEMA());
        if (formatSchema.equals(tableSchema2)) {
            DescriptorProperties$.MODULE$.toScala(params.getOptionalString(FileSystemValidator$.MODULE$.CONNECTOR_PATH())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String path) {
                    return this.csvTableSourceBuilder$1.path(path);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_FIELD_DELIMITER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String delim) {
                    return this.csvTableSourceBuilder$1.fieldDelimiter(delim);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_LINE_DELIMITER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String delim) {
                    return this.csvTableSourceBuilder$1.lineDelimiter(delim);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])formatSchema.getColumnNames()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])formatSchema.getTypes()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(Tuple2<String, TypeInformation<?>> x0$1) {
                    Tuple2<String, TypeInformation<?>> tuple2 = x0$1;
                    if (tuple2 != null) {
                        String name = (String)tuple2._1();
                        TypeInformation tpe = (TypeInformation)tuple2._2();
                        CsvTableSource.Builder builder = this.csvTableSourceBuilder$1.field(name, tpe);
                        return builder;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalCharacter(CsvValidator$.MODULE$.FORMAT_QUOTE_CHARACTER())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(Character quote) {
                    return this.csvTableSourceBuilder$1.quoteCharacter(quote);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalString(CsvValidator$.MODULE$.FORMAT_COMMENT_PREFIX())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final CsvTableSource.Builder apply(String prefix) {
                    return this.csvTableSourceBuilder$1.commentPrefix(prefix);
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalBoolean(CsvValidator$.MODULE$.FORMAT_IGNORE_FIRST_LINE())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final Object apply(Boolean flag) {
                    return Predef$.MODULE$.Boolean2boolean(flag) ? this.csvTableSourceBuilder$1.ignoreFirstLine() : BoxedUnit.UNIT;
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            DescriptorProperties$.MODULE$.toScala(params.getOptionalBoolean(CsvValidator$.MODULE$.FORMAT_IGNORE_PARSE_ERRORS())).foreach((Function1)new Serializable(this, csvTableSourceBuilder){
                public static final long serialVersionUID = 0L;
                private final CsvTableSource.Builder csvTableSourceBuilder$1;

                public final Object apply(Boolean flag) {
                    return Predef$.MODULE$.Boolean2boolean(flag) ? this.csvTableSourceBuilder$1.ignoreParseErrors() : BoxedUnit.UNIT;
                }
                {
                    this.csvTableSourceBuilder$1 = csvTableSourceBuilder$1;
                }
            });
            return csvTableSourceBuilder.build();
        }
        throw new TableException("Encodings that differ from the schema are not supported yet for CsvTableSources.");
    }
}

