/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import java.util.Iterator;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.runtime.join.CountingCollector;
import org.apache.flink.table.runtime.join.NonWindowOuterJoin;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.types.Row;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!B\u0001\u0003\u0003\u0003y!a\n(p]^Kg\u000eZ8x\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5O_:,\u0015/^5Qe\u0016$\u0017nY1uKNT!a\u0001\u0003\u0002\t)|\u0017N\u001c\u0006\u0003\u000b\u0019\tqA];oi&lWM\u0003\u0002\b\u0011\u0005)A/\u00192mK*\u0011\u0011BC\u0001\u0006M2Lgn\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\u0001\u0002CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005IquN\\,j]\u0012|woT;uKJTu.\u001b8\t\u0011U\u0001!\u0011!Q\u0001\nY\t\u0001\u0002\\3giRK\b/\u001a\t\u0004/y\u0001S\"\u0001\r\u000b\u0005eQ\u0012\u0001\u0003;za\u0016LgNZ8\u000b\u0005ma\u0012AB2p[6|gN\u0003\u0002\u001e\u0011\u0005\u0019\u0011\r]5\n\u0005}A\"a\u0004+za\u0016LeNZ8s[\u0006$\u0018n\u001c8\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0005\rB\u0011!\u0002;za\u0016\u001c\u0018BA\u0013#\u0005\r\u0011vn\u001e\u0005\tO\u0001\u0011\t\u0011)A\u0005-\u0005I!/[4iiRK\b/\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005U\u0005Q!/Z:vYR$\u0016\u0010]3\u0011\u0007]q2\u0006\u0005\u0002-]5\tQF\u0003\u0002$\t%\u0011q&\f\u0002\u0005\u0007J{w\u000f\u0003\u00052\u0001\t\u0005\t\u0015!\u00033\u0003=9WM\u001c&pS:4UO\\2OC6,\u0007CA\u001a:\u001d\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a*\u0004\u0002C\u001f\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u001f\u001d,gNS8j]\u001a+hnY\"pI\u0016D\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001Q\u0001\u000bSNdUM\u001a;K_&t\u0007C\u0001\u001bB\u0013\t\u0011UGA\u0004C_>dW-\u00198\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0015\u000b1\"];fef\u001cuN\u001c4jOB\u0011a\tS\u0007\u0002\u000f*\u0011QDB\u0005\u0003\u0013\u001e\u0013\u0011c\u0015;sK\u0006l\u0017+^3ss\u000e{gNZ5h\u0011\u0015Y\u0005\u0001\"\u0001M\u0003\u0019a\u0014N\\5u}QAQJT(Q#J\u001bF\u000b\u0005\u0002\u0012\u0001!)QC\u0013a\u0001-!)qE\u0013a\u0001-!)\u0011F\u0013a\u0001U!)\u0011G\u0013a\u0001e!)QH\u0013a\u0001e!)qH\u0013a\u0001\u0001\")AI\u0013a\u0001\u000b\"Ia\u000b\u0001a\u0001\u0002\u0004%\tbV\u0001\rU>Lgn\u00118u'R\fG/Z\u000b\u00021B\u0019A'W.\n\u0005i+$!B!se\u0006L\b\u0003\u0002/`A\u0005l\u0011!\u0018\u0006\u0003=j\tQa\u001d;bi\u0016L!\u0001Y/\u0003\u00115\u000b\u0007o\u0015;bi\u0016\u0004\"\u0001\u000e2\n\u0005\r,$\u0001\u0002'p]\u001eD\u0011\"\u001a\u0001A\u0002\u0003\u0007I\u0011\u00034\u0002!)|\u0017N\\\"oiN#\u0018\r^3`I\u0015\fHCA4k!\t!\u0004.\u0003\u0002jk\t!QK\\5u\u0011\u001dYG-!AA\u0002a\u000b1\u0001\u001f\u00132\u0011\u0019i\u0007\u0001)Q\u00051\u0006i!n\\5o\u0007:$8\u000b^1uK\u0002B\u0011b\u001c\u0001A\u0002\u0003\u0007I\u0011\u00039\u0002#\r|WO\u001c;j]\u001e\u001cu\u000e\u001c7fGR|'/F\u0001r!\t\t\"/\u0003\u0002t\u0005\t\t2i\\;oi&twmQ8mY\u0016\u001cGo\u001c:\t\u0013U\u0004\u0001\u0019!a\u0001\n#1\u0018!F2pk:$\u0018N\\4D_2dWm\u0019;pe~#S-\u001d\u000b\u0003O^Dqa\u001b;\u0002\u0002\u0003\u0007\u0011\u000f\u0003\u0004z\u0001\u0001\u0006K!]\u0001\u0013G>,h\u000e^5oO\u000e{G\u000e\\3di>\u0014\b\u0005C\u0003|\u0001\u0011\u0005C0\u0001\u0003pa\u0016tGCA4~\u0011\u0015q(\u00101\u0001\u0000\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0005\u0003\u0003\t9!\u0004\u0002\u0002\u0004)\u0019\u0011Q\u0001\u0005\u0002\u001b\r|gNZ5hkJ\fG/[8o\u0013\u0011\tI!a\u0001\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\t1D]3ue\u0006\u001cGOS8j]^KG\u000f\u001b(p]\u0016\u000bX/\u001b)sK\u0012\u001cH#C4\u0002\u0012\u0005U\u0011\u0011DA\u0018\u0011\u001d\t\u0019\"a\u0003A\u0002-\nQA^1mk\u0016Dq!a\u0006\u0002\f\u0001\u0007\u0001)\u0001\tj]B,HOU8x\rJ|W\u000eT3gi\"A\u00111DA\u0006\u0001\u0004\ti\"\u0001\bpi\",'oU5eKN#\u0018\r^3\u0011\u000bq{\u0006%a\b\u0011\r\u0005\u0005\u00121F1b\u001b\t\t\u0019C\u0003\u0003\u0002&\u0005\u001d\u0012!\u0002;va2,'bAA\u00159\u0005!!.\u0019<b\u0013\u0011\ti#a\t\u0003\rQ+\b\u000f\\33\u0011\u001d\t\t$a\u0003A\u0002m\u000bQc\u001c;iKJ\u001c\u0016\u000eZ3K_&t7I\u001c;Ti\u0006$X\rC\u0004\u00026\u0001!\t!a\u000e\u0002!\u0015D\b/\u001b:f\u001fV$H+[7f%><H#D4\u0002:\u0005u\u0012\u0011IA&\u0003\u001f\n\t\u0006C\u0004\u0002<\u0005M\u0002\u0019A1\u0002\u000f\r,(\u000fV5nK\"A\u0011qHA\u001a\u0001\u0004\ti\"A\u0006s_^l\u0015\r]*uCR,\u0007\u0002CA\"\u0003g\u0001\r!!\u0012\u0002\u0015QLW.\u001a:Ti\u0006$X\r\u0005\u0003]\u0003\u000f\n\u0017bAA%;\nQa+\u00197vKN#\u0018\r^3\t\u000f\u00055\u00131\u0007a\u0001\u0001\u00061\u0011n\u001d'fMRDaAVA\u001a\u0001\u0004A\u0006\u0002CA*\u0003g\u0001\r!!\u0016\u0002\u0007\r$\b\u0010\u0005\u0003\u0002X\u00055\u0004cBA-\u0003SZ3fK\u0007\u0003\u00037RA!!\u0018\u0002`\u0005\u00111m\u001c\u0006\u0005\u0003C\n\u0019'A\u0005gk:\u001cG/[8og*\u0019Q$!\u001a\u000b\u0007\u0005\u001d\u0004\"A\u0005tiJ,\u0017-\\5oO&!\u00111NA.\u0005E\u0019u\u000e\u0015:pG\u0016\u001c8OR;oGRLwN\\\u0005\u0005\u0003_\nIG\u0001\bP]RKW.\u001a:D_:$X\r\u001f;\t\u000f\u0005M\u0004\u0001\"\u0001\u0002v\u0005yq-\u001a;K_&t7I\u001c;Ti\u0006$X\rF\u0003\\\u0003o\nI\b\u0003\u0004W\u0003c\u0002\r\u0001\u0017\u0005\b\u0003w\n\t\b1\u0001A\u00039I7\u000fT3gi\u000esGo\u0015;bi\u0016\u0004")
public abstract class NonWindowOuterJoinWithNonEquiPredicates
extends NonWindowOuterJoin {
    private final TypeInformation<Row> leftType;
    private final TypeInformation<Row> rightType;
    private final TypeInformation<CRow> resultType;
    private final boolean isLeftJoin;
    private MapState<Row, Object>[] joinCntState;
    private CountingCollector countingCollector;

    public MapState<Row, Object>[] joinCntState() {
        return this.joinCntState;
    }

    public void joinCntState_$eq(MapState<Row, Object>[] x$1) {
        this.joinCntState = x$1;
    }

    public CountingCollector countingCollector() {
        return this.countingCollector;
    }

    public void countingCollector_$eq(CountingCollector x$1) {
        this.countingCollector = x$1;
    }

    @Override
    public void open(Configuration parameters) {
        super.open(parameters);
        this.leftResultRow_$eq(new Row(this.resultType.getArity()));
        this.rightResultRow_$eq(new Row(this.resultType.getArity()));
        this.joinCntState_$eq(new MapState[2]);
        MapStateDescriptor leftJoinCntStateDescriptor = new MapStateDescriptor("leftJoinCnt", this.leftType, Types$.MODULE$.LONG());
        this.joinCntState()[0] = this.getRuntimeContext().getMapState(leftJoinCntStateDescriptor);
        MapStateDescriptor rightJoinCntStateDescriptor = new MapStateDescriptor("rightJoinCnt", this.rightType, Types$.MODULE$.LONG());
        this.joinCntState()[1] = this.getRuntimeContext().getMapState(rightJoinCntStateDescriptor);
        this.countingCollector_$eq(new CountingCollector());
        this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Instantiating NonWindowOuterJoin"})).s((Seq)Nil$.MODULE$));
    }

    public void retractJoinWithNonEquiPreds(CRow value, boolean inputRowFromLeft, MapState<Row, Tuple2<Object, Object>> otherSideState, MapState<Row, Object> otherSideJoinCntState) {
        Row inputRow = value.row();
        Iterator otherSideIterator = otherSideState.iterator();
        while (otherSideIterator.hasNext()) {
            Map.Entry otherSideEntry = (Map.Entry)otherSideIterator.next();
            Row otherSideRow = (Row)otherSideEntry.getKey();
            Tuple2 otherSideCntAndExpiredTime = (Tuple2)otherSideEntry.getValue();
            this.countingCollector().reset();
            this.callJoinFunction(inputRow, inputRowFromLeft, otherSideRow, this.countingCollector());
            if (this.countingCollector().getEmitCnt() > 0L) {
                this.cRowWrapper().setTimes(BoxesRunTime.unboxToLong((Object)otherSideCntAndExpiredTime.f0));
                long joinCnt = BoxesRunTime.unboxToLong((Object)otherSideJoinCntState.get((Object)otherSideRow));
                if (value.change()) {
                    otherSideJoinCntState.put((Object)otherSideRow, (Object)BoxesRunTime.boxToLong((long)(joinCnt + 1L)));
                    if (joinCnt == 0L) {
                        this.cRowWrapper().setChange(false);
                        this.collectAppendNull(otherSideRow, !inputRowFromLeft, this.cRowWrapper());
                        this.cRowWrapper().setChange(true);
                    }
                    this.callJoinFunction(inputRow, inputRowFromLeft, otherSideRow, this.cRowWrapper());
                } else {
                    otherSideJoinCntState.put((Object)otherSideRow, (Object)BoxesRunTime.boxToLong((long)(joinCnt - 1L)));
                    this.callJoinFunction(inputRow, inputRowFromLeft, otherSideRow, this.cRowWrapper());
                    if (joinCnt == 1L) {
                        this.cRowWrapper().setChange(true);
                        this.collectAppendNull(otherSideRow, !inputRowFromLeft, this.cRowWrapper());
                        this.cRowWrapper().setChange(false);
                    }
                }
            }
            if (!this.stateCleaningEnabled() || this.curProcessTime() < BoxesRunTime.unboxToLong((Object)otherSideCntAndExpiredTime.f1)) continue;
            otherSideIterator.remove();
        }
    }

    public void expireOutTimeRow(long curTime, MapState<Row, Tuple2<Object, Object>> rowMapState, ValueState<Object> timerState, boolean isLeft, MapState<Row, Object>[] joinCntState, CoProcessFunction.OnTimerContext ctx) {
        MapState<Row, Object> currentJoinCntState = this.getJoinCntState(joinCntState, isLeft);
        Iterator rowMapIter = rowMapState.iterator();
        boolean validTimestamp = false;
        while (rowMapIter.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)rowMapIter.next();
            long recordExpiredTime = BoxesRunTime.unboxToLong((Object)((Tuple2)mapEntry.getValue()).f1);
            if (recordExpiredTime <= curTime) {
                rowMapIter.remove();
                currentJoinCntState.remove(mapEntry.getKey());
                continue;
            }
            validTimestamp = true;
        }
        if (validTimestamp) {
            long cleanupTime = curTime + this.maxRetentionTime();
            ctx.timerService().registerProcessingTimeTimer(cleanupTime);
            timerState.update((Object)BoxesRunTime.boxToLong((long)cleanupTime));
        } else {
            timerState.clear();
            rowMapState.clear();
            if (isLeft == this.isLeftJoin) {
                currentJoinCntState.clear();
            }
        }
    }

    public MapState<Row, Object> getJoinCntState(MapState<Row, Object>[] joinCntState, boolean isLeftCntState) {
        return isLeftCntState ? joinCntState[0] : joinCntState[1];
    }

    public NonWindowOuterJoinWithNonEquiPredicates(TypeInformation<Row> leftType, TypeInformation<Row> rightType, TypeInformation<CRow> resultType2, String genJoinFuncName, String genJoinFuncCode, boolean isLeftJoin, StreamQueryConfig queryConfig) {
        this.leftType = leftType;
        this.rightType = rightType;
        this.resultType = resultType2;
        this.isLeftJoin = isLeftJoin;
        super(leftType, rightType, resultType2, genJoinFuncName, genJoinFuncCode, isLeftJoin, queryConfig);
    }
}

