/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.join;

import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.co.CoProcessFunction;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.runtime.join.NonWindowOuterJoinWithNonEquiPredicates;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001=\u00111FT8o/&tGm\\<MK\u001a$(+[4ii*{\u0017N\\,ji\"tuN\\#rk&\u0004&/\u001a3jG\u0006$Xm\u001d\u0006\u0003\u0007\u0011\tAA[8j]*\u0011QAB\u0001\beVtG/[7f\u0015\t9\u0001\"A\u0003uC\ndWM\u0003\u0002\n\u0015\u0005)a\r\\5oW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!a\n(p]^Kg\u000eZ8x\u001fV$XM\u001d&pS:<\u0016\u000e\u001e5O_:,\u0015/^5Qe\u0016$\u0017nY1uKND\u0001\"\u0006\u0001\u0003\u0002\u0003\u0006IAF\u0001\tY\u00164G\u000fV=qKB\u0019qC\b\u0011\u000e\u0003aQ!!\u0007\u000e\u0002\u0011QL\b/Z5oM>T!a\u0007\u000f\u0002\r\r|W.\\8o\u0015\ti\u0002\"A\u0002ba&L!a\b\r\u0003\u001fQK\b/Z%oM>\u0014X.\u0019;j_:\u0004\"!\t\u0013\u000e\u0003\tR!a\t\u0005\u0002\u000bQL\b/Z:\n\u0005\u0015\u0012#a\u0001*po\"Aq\u0005\u0001B\u0001B\u0003%a#A\u0005sS\u001eDG\u000fV=qK\"A\u0011\u0006\u0001B\u0001B\u0003%!&\u0001\u0006sKN,H\u000e\u001e+za\u0016\u00042a\u0006\u0010,!\tac&D\u0001.\u0015\t\u0019C!\u0003\u00020[\t!1IU8x\u0011!\t\u0004A!A!\u0002\u0013\u0011\u0014aD4f]*{\u0017N\u001c$v]\u000et\u0015-\\3\u0011\u0005MJdB\u0001\u001b8\u001b\u0005)$\"\u0001\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005a*\u0014A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001O\u001b\t\u0011u\u0002!\u0011!Q\u0001\nI\nqbZ3o\u0015>LgNR;oG\u000e{G-\u001a\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005\u0001\u0006Q\u0011n\u001d'fMRTu.\u001b8\u0011\u0005Q\n\u0015B\u0001\"6\u0005\u001d\u0011un\u001c7fC:D\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!R\u0001\fcV,'/_\"p]\u001aLw\r\u0005\u0002G\u00116\tqI\u0003\u0002\u001e\r%\u0011\u0011j\u0012\u0002\u0012'R\u0014X-Y7Rk\u0016\u0014\u0018pQ8oM&<\u0007\"B&\u0001\t\u0003a\u0015A\u0002\u001fj]&$h\b\u0006\u0005N\u001d>\u0003\u0016KU*U!\t\t\u0002\u0001C\u0003\u0016\u0015\u0002\u0007a\u0003C\u0003(\u0015\u0002\u0007a\u0003C\u0003*\u0015\u0002\u0007!\u0006C\u00032\u0015\u0002\u0007!\u0007C\u0003>\u0015\u0002\u0007!\u0007C\u0003@\u0015\u0002\u0007\u0001\tC\u0003E\u0015\u0002\u0007Q\tC\u0003W\u0001\u0011\u0005s+\u0001\u0003pa\u0016tGC\u0001-\\!\t!\u0014,\u0003\u0002[k\t!QK\\5u\u0011\u0015aV\u000b1\u0001^\u0003)\u0001\u0018M]1nKR,'o\u001d\t\u0003=\u0006l\u0011a\u0018\u0006\u0003A\"\tQbY8oM&<WO]1uS>t\u0017B\u00012`\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")A\r\u0001C!K\u0006q\u0001O]8dKN\u001cX\t\\3nK:$H\u0003\u0004-gQb\f\t!a\u0006\u00022\u0005U\u0002\"B4d\u0001\u0004Y\u0013!\u0002<bYV,\u0007\"B5d\u0001\u0004Q\u0017aA2uqB\u00111N\u001e\t\u0006YR\\3fK\u0007\u0002[*\u0011an\\\u0001\u0003G>T!\u0001]9\u0002\u0013\u0019,hn\u0019;j_:\u001c(BA\u000fs\u0015\t\u0019\b\"A\u0005tiJ,\u0017-\\5oO&\u0011Q/\u001c\u0002\u0012\u0007>\u0004&o\\2fgN4UO\\2uS>t\u0017BA<u\u0005\u001d\u0019uN\u001c;fqRDQ!_2A\u0002i\f1a\\;u!\rYhpK\u0007\u0002y*\u0011Q\u0010C\u0001\u0005kRLG.\u0003\u0002\u0000y\nI1i\u001c7mK\u000e$xN\u001d\u0005\b\u0003\u0007\u0019\u0007\u0019AA\u0003\u0003)!\u0018.\\3s'R\fG/\u001a\t\u0007\u0003\u000f\ti!!\u0005\u000e\u0005\u0005%!bAA\u00065\u0005)1\u000f^1uK&!\u0011qBA\u0005\u0005)1\u0016\r\\;f'R\fG/\u001a\t\u0004i\u0005M\u0011bAA\u000bk\t!Aj\u001c8h\u0011\u001d\tIb\u0019a\u0001\u00037\t\u0001cY;se\u0016tGoU5eKN#\u0018\r^3\u0011\u000f\u0005\u001d\u0011Q\u0004\u0011\u0002\"%!\u0011qDA\u0005\u0005!i\u0015\r]*uCR,\u0007\u0003CA\u0012\u0003[\t\t\"!\u0005\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tQ\u0001^;qY\u0016T1!a\u000b\u001d\u0003\u0011Q\u0017M^1\n\t\u0005=\u0012Q\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005M2\r1\u0001\u0002\u001c\u0005qq\u000e\u001e5feNKG-Z*uCR,\u0007BBA\u001cG\u0002\u0007\u0001)\u0001\bsK\u000e|'\u000f\u001a$s_6dUM\u001a;\t\u000f\u0005m\u0002\u0001\"\u0011\u0002>\u0005\u0001R\r\u001f9je\u0016|U\u000f\u001e+j[\u0016\u0014vn\u001e\u000b\f1\u0006}\u00121IA$\u0003\u0013\ni\u0005\u0003\u0005\u0002B\u0005e\u0002\u0019AA\t\u0003\u001d\u0019WO\u001d+j[\u0016D\u0001\"!\u0012\u0002:\u0001\u0007\u00111D\u0001\fe><X*\u00199Ti\u0006$X\r\u0003\u0005\u0002\u0004\u0005e\u0002\u0019AA\u0003\u0011\u001d\tY%!\u000fA\u0002\u0001\u000ba![:MK\u001a$\bbB5\u0002:\u0001\u0007\u0011q\n\t\u0004W\u0006E\u0013bAA*i\nqqJ\u001c+j[\u0016\u00148i\u001c8uKb$\b")
public class NonWindowLeftRightJoinWithNonEquiPredicates
extends NonWindowOuterJoinWithNonEquiPredicates {
    private final boolean isLeftJoin;

    @Override
    public void open(Configuration parameters) {
        super.open(parameters);
        String joinType = this.isLeftJoin ? "Left" : "Right";
        this.LOG().debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Instantiating NonWindow", "JoinWithNonEquiPredicates."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{joinType})));
    }

    @Override
    public void processElement(CRow value, CoProcessFunction.Context ctx, Collector<CRow> out, ValueState<Object> timerState, MapState<Row, Tuple2<Object, Object>> currentSideState, MapState<Row, Tuple2<Object, Object>> otherSideState, boolean recordFromLeft) {
        MapState<Row, Object> currentJoinCntState = this.getJoinCntState(this.joinCntState(), recordFromLeft);
        Row inputRow = value.row();
        Tuple2<Object, Object> cntAndExpiredTime = this.updateCurrentSide(value, ctx, timerState, currentSideState);
        if (!value.change() && BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f0) <= 0L && recordFromLeft == this.isLeftJoin) {
            currentJoinCntState.remove((Object)inputRow);
        }
        this.cRowWrapper().reset();
        this.cRowWrapper().setCollector(out);
        this.cRowWrapper().setChange(value.change());
        if (recordFromLeft == this.isLeftJoin) {
            long joinCnt = this.preservedJoin(inputRow, recordFromLeft, otherSideState);
            if (BoxesRunTime.unboxToLong((Object)cntAndExpiredTime.f0) == 1L && value.change()) {
                currentJoinCntState.put((Object)inputRow, (Object)BoxesRunTime.boxToLong((long)joinCnt));
            }
        } else {
            MapState<Row, Object> otherSideJoinCntState = this.getJoinCntState(this.joinCntState(), !recordFromLeft);
            this.retractJoinWithNonEquiPreds(value, recordFromLeft, otherSideState, otherSideJoinCntState);
        }
    }

    @Override
    public void expireOutTimeRow(long curTime, MapState<Row, Tuple2<Object, Object>> rowMapState, ValueState<Object> timerState, boolean isLeft, CoProcessFunction.OnTimerContext ctx) {
        this.expireOutTimeRow(curTime, rowMapState, timerState, isLeft, this.joinCntState(), ctx);
    }

    public NonWindowLeftRightJoinWithNonEquiPredicates(TypeInformation<Row> leftType, TypeInformation<Row> rightType, TypeInformation<CRow> resultType2, String genJoinFuncName, String genJoinFuncCode, boolean isLeftJoin, StreamQueryConfig queryConfig) {
        this.isLeftJoin = isLeftJoin;
        super(leftType, rightType, resultType2, genJoinFuncName, genJoinFuncCode, isLeftJoin, queryConfig);
    }
}

