/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions;

import java.math.BigDecimal;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class ScalarFunctions$ {
    public static final ScalarFunctions$ MODULE$;

    static {
        new ScalarFunctions$();
    }

    public String concat(String ... args) {
        return this.concat((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
    }

    public String concat_ws(String separator, String ... args) {
        return this.concat_ws(separator, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args));
    }

    public double power(double a, BigDecimal b) {
        return Math.pow(a, b.doubleValue());
    }

    public String concat(Seq<String> args) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < args.length(); ++i) {
            if (args.apply(i) == null) {
                return null;
            }
            sb.append((String)args.apply(i));
        }
        return sb.toString();
    }

    public String concat_ws(String separator, Seq<String> args) {
        if (separator == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean hasValueAppended = false;
        for (int i = 0; i < args.length(); ++i) {
            if (args.apply(i) == null) continue;
            Object object = hasValueAppended ? sb.append(separator) : BoxedUnit.UNIT;
            sb.append((String)args.apply(i));
            hasValueAppended = true;
        }
        return sb.toString();
    }

    public double log(double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x of 'log(x)' must be > 0, but x = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)x)})));
        }
        return Math.log(x);
    }

    public double log(double base, double x) {
        if (x <= 0.0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"x of 'log(base, x)' must be > 0, but x = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)x)})));
        }
        if (base <= 1.0) {
            throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"base of 'log(base, x)' must be > 1, but base = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)base)})));
        }
        return Math.log(x) / Math.log(base);
    }

    public String lpad(String base, Integer len, String pad) {
        int i;
        if (Predef$.MODULE$.Integer2int(len) < 0) {
            return null;
        }
        if (BoxesRunTime.equalsNumObject((Number)len, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return "";
        }
        char[] data = new char[Predef$.MODULE$.Integer2int(len)];
        char[] baseChars = base.toCharArray();
        char[] padChars = pad.toCharArray();
        int pos = Math.max(Predef$.MODULE$.Integer2int(len) - base.length(), 0);
        for (i = 0; i < pos; i += pad.length()) {
            for (int j2 = 0; j2 < pad.length() && j2 < pos - i; ++j2) {
                data[i + j2] = padChars[j2];
            }
        }
        for (i = 0; pos + i < Predef$.MODULE$.Integer2int(len) && i < base.length(); ++i) {
            data[pos + i] = baseChars[i];
        }
        return new String(data);
    }

    public String rpad(String base, Integer len, String pad) {
        int pos;
        if (Predef$.MODULE$.Integer2int(len) < 0) {
            return null;
        }
        if (BoxesRunTime.equalsNumObject((Number)len, (Object)BoxesRunTime.boxToInteger((int)0))) {
            return "";
        }
        char[] data = new char[Predef$.MODULE$.Integer2int(len)];
        char[] baseChars = base.toCharArray();
        char[] padChars = pad.toCharArray();
        for (pos = 0; pos < base.length() && pos < Predef$.MODULE$.Integer2int(len); ++pos) {
            data[pos] = baseChars[pos];
        }
        while (pos < Predef$.MODULE$.Integer2int(len)) {
            for (int i = 0; i < pad.length() && i < Predef$.MODULE$.Integer2int(len) - pos; ++i) {
                data[pos + i] = padChars[i];
            }
            pos += pad.length();
        }
        return new String(data);
    }

    private ScalarFunctions$() {
        MODULE$ = this;
    }
}

