/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}f\u0001B\u0001\u0003\u0001=\u0011aCU8x)&lWMQ8v]\u0012,GMU8xg>3XM\u001d\u0006\u0003\u0007\u0011\t\u0011\"Y4he\u0016<\u0017\r^3\u000b\u0005\u00151\u0011a\u0002:v]RLW.\u001a\u0006\u0003\u000f!\tQ\u0001^1cY\u0016T!!\u0003\u0006\u0002\u000b\u0019d\u0017N\\6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001CG\u0012\u0011\tE\u0011B\u0003F\u0007\u0002\u0005%\u00111C\u0001\u0002 !J|7-Z:t\rVt7\r^5p]^KG\u000f[\"mK\u0006tW\u000f]*uCR,\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u0015!\u0018\u0010]3t\u0013\tIbC\u0001\u0003D%><\bcA\u000e\u001fA5\tAD\u0003\u0002\u001e\r\u000591m\u001c3fO\u0016t\u0017BA\u0010\u001d\u0005!\u0019u.\u001c9jY\u0016\u0014\bCA\t\"\u0013\t\u0011#AA\u000bHK:,'/\u0019;fI\u0006;wM]3hCRLwN\\:\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u00192\u0011\u0001B;uS2L!\u0001K\u0013\u0003\u000f1{wmZ5oO\"A!\u0006\u0001B\u0001B\u0003%1&A\bhK:\fum\u001a:fO\u0006$\u0018n\u001c8t!\tYB&\u0003\u0002.9\tir)\u001a8fe\u0006$X\rZ!hOJ,w-\u0019;j_:\u001ch)\u001e8di&|g\u000e\u0003\u00050\u0001\t\u0005\t\u0015!\u00031\u0003Q\twm\u001a:fO\u0006$\u0018n\u001c8Ti\u0006$X\rV=qKB\u0011\u0011\u0007O\u0007\u0002e)\u00111\u0007N\u0001\nif\u0004X-\u001e;jYNT!!\u000e\u001c\u0002\t)\fg/\u0019\u0006\u0003o!\t1!\u00199j\u0013\tI$GA\u0006S_^$\u0016\u0010]3J]\u001a|\u0007\u0002C\u001e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001f\u0002\u0019%t\u0007/\u001e;S_^$\u0016\u0010]3\u0011\u0005Ui\u0014B\u0001 \u0017\u00051\u0019%k\\<UsB,\u0017J\u001c4p\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0015a\u00049sK\u000e,G-\u001b8h\u001f\u001a47/\u001a;\u0011\u0005\t+U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\t1{gn\u001a\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\u0006Q!o\\<US6,\u0017\n\u001a=\u0011\u0005\tS\u0015BA&D\u0005\rIe\u000e\u001e\u0005\t\u001b\u0002\u0011\t\u0011)A\u0005\u001d\u0006Y\u0011/^3ss\u000e{gNZ5h!\ty\u0015+D\u0001Q\u0015\t9d!\u0003\u0002S!\n\t2\u000b\u001e:fC6\fV/\u001a:z\u0007>tg-[4\t\u000bQ\u0003A\u0011A+\u0002\rqJg.\u001b;?)\u001d1v\u000bW-[7r\u0003\"!\u0005\u0001\t\u000b)\u001a\u0006\u0019A\u0016\t\u000b=\u001a\u0006\u0019\u0001\u0019\t\u000bm\u001a\u0006\u0019\u0001\u001f\t\u000b\u0001\u001b\u0006\u0019A!\t\u000b!\u001b\u0006\u0019A%\t\u000b5\u001b\u0006\u0019\u0001(\t\u0013y\u0003\u0001\u0019!a\u0001\n\u0013y\u0016AB8viB,H/F\u0001\u0015\u0011%\t\u0007\u00011AA\u0002\u0013%!-\u0001\u0006pkR\u0004X\u000f^0%KF$\"a\u00194\u0011\u0005\t#\u0017BA3D\u0005\u0011)f.\u001b;\t\u000f\u001d\u0004\u0017\u0011!a\u0001)\u0005\u0019\u0001\u0010J\u0019\t\r%\u0004\u0001\u0015)\u0003\u0015\u0003\u001dyW\u000f\u001e9vi\u0002B\u0011b\u001b\u0001A\u0002\u0003\u0007I\u0011\u00027\u0002+1\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uKV\tQ\u000eE\u0002og\u0006k\u0011a\u001c\u0006\u0003aF\fQa\u001d;bi\u0016T!A\u001d\u001c\u0002\r\r|W.\\8o\u0013\t!xN\u0001\u0006WC2,Xm\u0015;bi\u0016D\u0011B\u001e\u0001A\u0002\u0003\u0007I\u0011B<\u000231\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uK~#S-\u001d\u000b\u0003GbDqaZ;\u0002\u0002\u0003\u0007Q\u000e\u0003\u0004{\u0001\u0001\u0006K!\\\u0001\u0017Y\u0006\u001cH\u000f\u0016:jO\u001e,'/\u001b8h)N\u001cF/\u0019;fA!IA\u0010\u0001a\u0001\u0002\u0004%I\u0001\\\u0001\u000fI\u0006$\u0018mQ8v]R\u001cF/\u0019;f\u0011%q\b\u00011AA\u0002\u0013%q0\u0001\neCR\f7i\\;oiN#\u0018\r^3`I\u0015\fHcA2\u0002\u0002!9q-`A\u0001\u0002\u0004i\u0007bBA\u0003\u0001\u0001\u0006K!\\\u0001\u0010I\u0006$\u0018mQ8v]R\u001cF/\u0019;fA!Y\u0011\u0011\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0006\u0003A\t7mY;nk2\fGo\u001c:Ti\u0006$X-\u0006\u0002\u0002\u000eA!an]A\b!\u0011\t\t\"!\u0006\u000e\u0005\u0005M!BA\f\t\u0013\u0011\t9\"a\u0005\u0003\u0007I{w\u000fC\u0006\u0002\u001c\u0001\u0001\r\u00111A\u0005\n\u0005u\u0011\u0001F1dGVlW\u000f\\1u_J\u001cF/\u0019;f?\u0012*\u0017\u000fF\u0002d\u0003?A\u0011bZA\r\u0003\u0003\u0005\r!!\u0004\t\u0011\u0005\r\u0002\u0001)Q\u0005\u0003\u001b\t\u0011#Y2dk6,H.\u0019;peN#\u0018\r^3!\u0011-\t9\u0003\u0001a\u0001\u0002\u0004%I!!\u000b\u0002\u0013\u0011\fG/Y*uCR,WCAA\u0016!\u0019q\u0017QF!\u00022%\u0019\u0011qF8\u0003\u00115\u000b\u0007o\u0015;bi\u0016\u0004b!a\r\u0002:\u0005=QBAA\u001b\u0015\r1\u0013q\u0007\u0006\u0002k%!\u00111HA\u001b\u0005\u0011a\u0015n\u001d;\t\u0017\u0005}\u0002\u00011AA\u0002\u0013%\u0011\u0011I\u0001\u000eI\u0006$\u0018m\u0015;bi\u0016|F%Z9\u0015\u0007\r\f\u0019\u0005C\u0005h\u0003{\t\t\u00111\u0001\u0002,!A\u0011q\t\u0001!B\u0013\tY#\u0001\u0006eCR\f7\u000b^1uK\u0002B1\"a\u0013\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002N\u0005Aa-\u001e8di&|g.F\u0001!\u0011-\t\t\u0006\u0001a\u0001\u0002\u0004%I!a\u0015\u0002\u0019\u0019,hn\u0019;j_:|F%Z9\u0015\u0007\r\f)\u0006\u0003\u0005h\u0003\u001f\n\t\u00111\u0001!\u0011\u001d\tI\u0006\u0001Q!\n\u0001\n\u0011BZ;oGRLwN\u001c\u0011\t\u000f\u0005u\u0003\u0001\"\u0011\u0002`\u0005!q\u000e]3o)\r\u0019\u0017\u0011\r\u0005\t\u0003G\nY\u00061\u0001\u0002f\u000511m\u001c8gS\u001e\u0004B!a\u001a\u0002n5\u0011\u0011\u0011\u000e\u0006\u0004\u0003WB\u0011!D2p]\u001aLw-\u001e:bi&|g.\u0003\u0003\u0002p\u0005%$!D\"p]\u001aLw-\u001e:bi&|g\u000eC\u0004\u0002t\u0001!\t%!\u001e\u0002\u001dA\u0014xnY3tg\u0016cW-\\3oiR91-a\u001e\u0002|\u0005]\u0005bBA=\u0003c\u0002\r\u0001F\u0001\u0007S:\u0004X\u000f^\"\t\u0011\u0005u\u0014\u0011\u000fa\u0001\u0003\u007f\n1a\u0019;y!\u0011\t\t)a%\u0011\r\u0005\r\u0015q\u0012\u000b\u0015\u001b\t\t)I\u0003\u0003\u0002\b\u0006%\u0015!\u00034v]\u000e$\u0018n\u001c8t\u0015\r9\u00141\u0012\u0006\u0004\u0003\u001bC\u0011!C:ue\u0016\fW.\u001b8h\u0013\u0011\t\t*!\"\u0003\u001fA\u0013xnY3tg\u001a+hn\u0019;j_:LA!!&\u0002\u0010\n91i\u001c8uKb$\b\u0002CAM\u0003c\u0002\r!a'\u0002\u0007=,H\u000fE\u0003\u0002\u001e\u0006\u0005F#\u0004\u0002\u0002 *\u0011a\u0005C\u0005\u0005\u0003G\u000byJA\u0005D_2dWm\u0019;pe\"9\u0011q\u0015\u0001\u0005B\u0005%\u0016aB8o)&lWM\u001d\u000b\bG\u0006-\u0016qVA\\\u0011\u001d\ti+!*A\u0002\u0005\u000b\u0011\u0002^5nKN$\u0018-\u001c9\t\u0011\u0005u\u0014Q\u0015a\u0001\u0003c\u0003B!!!\u00024&!\u0011QWAH\u00059ye\u000eV5nKJ\u001cuN\u001c;fqRD\u0001\"!'\u0002&\u0002\u0007\u00111\u0014\u0005\b\u0003w\u0003A\u0011IA_\u0003\u0015\u0019Gn\\:f)\u0005\u0019\u0007")
public class RowTimeBoundedRowsOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Object> dataCountState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeBoundedRowsOver rowTimeBoundedRowsOver = this;
        synchronized (rowTimeBoundedRowsOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Object> dataCountState() {
        return this.dataCountState;
    }

    private void dataCountState_$eq(ValueState<Object> x$1) {
        this.dataCountState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor dataCountStateDescriptor = new ValueStateDescriptor("dataCountState", Long.TYPE);
        this.dataCountState_$eq((ValueState<Object>)this.getRuntimeContext().getState(dataCountStateDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRowsOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
        long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
        if (triggeringTs > lastTriggeringTs) {
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data == null) {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            } else {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            }
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.dataCountState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            long dataCount = BoxesRunTime.unboxToLong((Object)this.dataCountState().value());
            List retractList = null;
            long retractTs = Long.MAX_VALUE;
            int retractCnt = 0;
            for (int i = 0; i < inputs.size(); ++i) {
                Row input = (Row)inputs.get(i);
                if (accumulators == null) {
                    accumulators = this.function().createAccumulators();
                }
                Row retractRow = null;
                if (dataCount >= this.precedingOffset) {
                    if (retractList == null) {
                        retractTs = Long.MAX_VALUE;
                        Iterator dataTimestampIt = this.dataState().keys().iterator();
                        while (dataTimestampIt.hasNext()) {
                            long dataTs = BoxesRunTime.unboxToLong(dataTimestampIt.next());
                            if (dataTs >= retractTs) continue;
                            retractTs = dataTs;
                        }
                        retractList = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)retractTs));
                    }
                    retractRow = (Row)retractList.get(retractCnt);
                    if (retractList.size() == ++retractCnt) {
                        this.dataState().remove((Object)BoxesRunTime.boxToLong((long)retractTs));
                        retractList = null;
                        retractCnt = 0;
                    }
                } else {
                    ++dataCount;
                }
                this.function().setForwardedFields(input, this.output().row());
                if (retractRow != null) {
                    this.function().retract(accumulators, retractRow);
                }
                this.function().accumulate(accumulators, input);
                this.function().setAggregationResults(accumulators, this.output().row());
                out.collect((Object)this.output());
            }
            if (this.dataState().contains((Object)BoxesRunTime.boxToLong((long)retractTs)) && retractCnt > 0) {
                retractList.subList(0, retractCnt).clear();
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)retractTs), (Object)retractList);
            }
            this.dataCountState().update((Object)BoxesRunTime.boxToLong((long)dataCount));
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        this.function().close();
    }

    public RowTimeBoundedRowsOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

