/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.aggregate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.flink.api.common.state.MapState;
import org.apache.flink.api.common.state.MapStateDescriptor;
import org.apache.flink.api.common.state.State;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.BasicTypeInfo;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.typeutils.ListTypeInfo;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.api.StreamQueryConfig;
import org.apache.flink.table.codegen.Compiler;
import org.apache.flink.table.codegen.Compiler$class;
import org.apache.flink.table.codegen.GeneratedAggregationsFunction;
import org.apache.flink.table.runtime.aggregate.GeneratedAggregations;
import org.apache.flink.table.runtime.aggregate.ProcessFunctionWithCleanupState;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.table.runtime.types.CRowTypeInfo;
import org.apache.flink.table.util.Logging;
import org.apache.flink.table.util.Logging$class;
import org.apache.flink.types.Row;
import org.apache.flink.util.Collector;
import org.apache.flink.util.Preconditions;
import org.codehaus.commons.compiler.CompileException;
import org.slf4j.Logger;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001=\u0011qCU8x)&lWMQ8v]\u0012,GMU1oO\u0016|e/\u001a:\u000b\u0005\r!\u0011!C1hOJ,w-\u0019;f\u0015\t)a!A\u0004sk:$\u0018.\\3\u000b\u0005\u001dA\u0011!\u0002;bE2,'BA\u0005\u000b\u0003\u00151G.\u001b8l\u0015\tYA\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M!\u0001\u0001\u0005\u000e$!\u0011\t\"\u0003\u0006\u000b\u000e\u0003\tI!a\u0005\u0002\u0003?A\u0013xnY3tg\u001a+hn\u0019;j_:<\u0016\u000e\u001e5DY\u0016\fg.\u001e9Ti\u0006$X\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\t\u0005)A/\u001f9fg&\u0011\u0011D\u0006\u0002\u0005\u0007J{w\u000fE\u0002\u001c=\u0001j\u0011\u0001\b\u0006\u0003;\u0019\tqaY8eK\u001e,g.\u0003\u0002 9\tA1i\\7qS2,'\u000f\u0005\u0002\u0012C%\u0011!E\u0001\u0002\u0016\u000f\u0016tWM]1uK\u0012\fum\u001a:fO\u0006$\u0018n\u001c8t!\t!s%D\u0001&\u0015\t1c!\u0001\u0003vi&d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001eD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\u0010O\u0016t\u0017iZ4sK\u001e\fG/[8ogB\u00111\u0004L\u0005\u0003[q\u0011QdR3oKJ\fG/\u001a3BO\u001e\u0014XmZ1uS>t7OR;oGRLwN\u001c\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005!\u0012mZ4sK\u001e\fG/[8o'R\fG/\u001a+za\u0016\u0004\"!\r\u001d\u000e\u0003IR!a\r\u001b\u0002\u0013QL\b/Z;uS2\u001c(BA\u001b7\u0003\u0011Q\u0017M^1\u000b\u0005]B\u0011aA1qS&\u0011\u0011H\r\u0002\f%><H+\u001f9f\u0013:4w\u000e\u0003\u0005<\u0001\t\u0005\t\u0015!\u0003=\u00031Ig\u000e];u%><H+\u001f9f!\t)R(\u0003\u0002?-\ta1IU8x)f\u0004X-\u00138g_\"A\u0001\t\u0001B\u0001B\u0003%\u0011)A\bqe\u0016\u001cW\rZ5oO>3gm]3u!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0011auN\\4\t\u0011!\u0003!\u0011!Q\u0001\n%\u000b!B]8x)&lW-\u00133y!\t\u0011%*\u0003\u0002L\u0007\n\u0019\u0011J\u001c;\t\u00115\u0003!\u0011!Q\u0001\n9\u000b1\"];fef\u001cuN\u001c4jOB\u0011q*U\u0007\u0002!*\u0011qGB\u0005\u0003%B\u0013\u0011c\u0015;sK\u0006l\u0017+^3ss\u000e{gNZ5h\u0011\u0015!\u0006\u0001\"\u0001V\u0003\u0019a\u0014N\\5u}Q9ak\u0016-Z5nc\u0006CA\t\u0001\u0011\u0015Q3\u000b1\u0001,\u0011\u0015y3\u000b1\u00011\u0011\u0015Y4\u000b1\u0001=\u0011\u0015\u00015\u000b1\u0001B\u0011\u0015A5\u000b1\u0001J\u0011\u0015i5\u000b1\u0001O\u0011%q\u0006\u00011AA\u0002\u0013%q,\u0001\u0004pkR\u0004X\u000f^\u000b\u0002)!I\u0011\r\u0001a\u0001\u0002\u0004%IAY\u0001\u000b_V$\b/\u001e;`I\u0015\fHCA2g!\t\u0011E-\u0003\u0002f\u0007\n!QK\\5u\u0011\u001d9\u0007-!AA\u0002Q\t1\u0001\u001f\u00132\u0011\u0019I\u0007\u0001)Q\u0005)\u00059q.\u001e;qkR\u0004\u0003\"C6\u0001\u0001\u0004\u0005\r\u0011\"\u0003m\u0003Ua\u0017m\u001d;Ue&<w-\u001a:j]\u001e$6o\u0015;bi\u0016,\u0012!\u001c\t\u0004]N\fU\"A8\u000b\u0005A\f\u0018!B:uCR,'B\u0001:7\u0003\u0019\u0019w.\\7p]&\u0011Ao\u001c\u0002\u000b-\u0006dW/Z*uCR,\u0007\"\u0003<\u0001\u0001\u0004\u0005\r\u0011\"\u0003x\u0003ea\u0017m\u001d;Ue&<w-\u001a:j]\u001e$6o\u0015;bi\u0016|F%Z9\u0015\u0005\rD\bbB4v\u0003\u0003\u0005\r!\u001c\u0005\u0007u\u0002\u0001\u000b\u0015B7\u0002-1\f7\u000f\u001e+sS\u001e<WM]5oOR\u001b8\u000b^1uK\u0002B\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011B?\u0002!\u0005\u001c7-^7vY\u0006$xN]*uCR,W#\u0001@\u0011\u00079\u001cx\u0010\u0005\u0003\u0002\u0002\u0005\u0015QBAA\u0002\u0015\t9\u0002\"\u0003\u0003\u0002\b\u0005\r!a\u0001*po\"Y\u00111\u0002\u0001A\u0002\u0003\u0007I\u0011BA\u0007\u0003Q\t7mY;nk2\fGo\u001c:Ti\u0006$Xm\u0018\u0013fcR\u00191-a\u0004\t\u0011\u001d\fI!!AA\u0002yDq!a\u0005\u0001A\u0003&a0A\tbG\u000e,X.\u001e7bi>\u00148\u000b^1uK\u0002B1\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\u001a\u0005IA-\u0019;b'R\fG/Z\u000b\u0003\u00037\u0001bA\\A\u000f\u0003\u0006\u0005\u0012bAA\u0010_\nAQ*\u00199Ti\u0006$X\rE\u0003\u0002$\u0005%r0\u0004\u0002\u0002&)\u0019a%a\n\u000b\u0003UJA!a\u000b\u0002&\t!A*[:u\u0011-\ty\u0003\u0001a\u0001\u0002\u0004%I!!\r\u0002\u001b\u0011\fG/Y*uCR,w\fJ3r)\r\u0019\u00171\u0007\u0005\nO\u00065\u0012\u0011!a\u0001\u00037A\u0001\"a\u000e\u0001A\u0003&\u00111D\u0001\u000bI\u0006$\u0018m\u0015;bi\u0016\u0004\u0003bCA\u001e\u0001\u0001\u0007\t\u0019!C\u0005\u0003{\t\u0001BZ;oGRLwN\\\u000b\u0002A!Y\u0011\u0011\t\u0001A\u0002\u0003\u0007I\u0011BA\"\u000311WO\\2uS>tw\fJ3r)\r\u0019\u0017Q\t\u0005\tO\u0006}\u0012\u0011!a\u0001A!9\u0011\u0011\n\u0001!B\u0013\u0001\u0013!\u00034v]\u000e$\u0018n\u001c8!\u0011\u001d\ti\u0005\u0001C!\u0003\u001f\nAa\u001c9f]R\u00191-!\u0015\t\u0011\u0005M\u00131\na\u0001\u0003+\naaY8oM&<\u0007\u0003BA,\u0003;j!!!\u0017\u000b\u0007\u0005m\u0003\"A\u0007d_:4\u0017nZ;sCRLwN\\\u0005\u0005\u0003?\nIFA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\b\u0003G\u0002A\u0011IA3\u00039\u0001(o\\2fgN,E.Z7f]R$raYA4\u0003W\n9\tC\u0004\u0002j\u0005\u0005\u0004\u0019\u0001\u000b\u0002\r%t\u0007/\u001e;D\u0011!\ti'!\u0019A\u0002\u0005=\u0014aA2uqB!\u0011\u0011OAB!\u0019\t\u0019(a \u0015)5\u0011\u0011Q\u000f\u0006\u0005\u0003o\nI(A\u0005gk:\u001cG/[8og*\u0019q'a\u001f\u000b\u0007\u0005u\u0004\"A\u0005tiJ,\u0017-\\5oO&!\u0011\u0011QA;\u0005=\u0001&o\\2fgN4UO\\2uS>t\u0017\u0002BAC\u0003\u007f\u0012qaQ8oi\u0016DH\u000f\u0003\u0005\u0002\n\u0006\u0005\u0004\u0019AAF\u0003\ryW\u000f\u001e\t\u0006\u0003\u001b\u000b\t\nF\u0007\u0003\u0003\u001fS!A\n\u0005\n\t\u0005M\u0015q\u0012\u0002\n\u0007>dG.Z2u_JDq!a&\u0001\t\u0003\nI*A\u0004p]RKW.\u001a:\u0015\u000f\r\fY*a(\u0002(\"9\u0011QTAK\u0001\u0004\t\u0015!\u0003;j[\u0016\u001cH/Y7q\u0011!\ti'!&A\u0002\u0005\u0005\u0006\u0003BA9\u0003GKA!!*\u0002\u0000\tqqJ\u001c+j[\u0016\u00148i\u001c8uKb$\b\u0002CAE\u0003+\u0003\r!a#\t\u000f\u0005-\u0006\u0001\"\u0011\u0002.\u0006)1\r\\8tKR\t1\r")
public class RowTimeBoundedRangeOver
extends ProcessFunctionWithCleanupState<CRow, CRow>
implements Compiler<GeneratedAggregations>,
Logging {
    private final GeneratedAggregationsFunction genAggregations;
    private final RowTypeInfo aggregationStateType;
    private final CRowTypeInfo inputRowType;
    private final long precedingOffset;
    private final int rowTimeIdx;
    private CRow output;
    private ValueState<Object> lastTriggeringTsState;
    private ValueState<Row> accumulatorState;
    private MapState<Object, List<Row>> dataState;
    private GeneratedAggregations function;
    private final transient Logger LOG;
    private volatile transient boolean bitmap$trans$0;

    private Logger LOG$lzycompute() {
        RowTimeBoundedRangeOver rowTimeBoundedRangeOver = this;
        synchronized (rowTimeBoundedRangeOver) {
            if (!this.bitmap$trans$0) {
                this.LOG = Logging$class.LOG(this);
                this.bitmap$trans$0 = true;
            }
            return this.LOG;
        }
    }

    @Override
    public Logger LOG() {
        return this.bitmap$trans$0 ? this.LOG : this.LOG$lzycompute();
    }

    @Override
    public Class<GeneratedAggregations> compile(ClassLoader cl, String name, String code) throws CompileException {
        return Compiler$class.compile(this, cl, name, code);
    }

    private CRow output() {
        return this.output;
    }

    private void output_$eq(CRow x$1) {
        this.output = x$1;
    }

    private ValueState<Object> lastTriggeringTsState() {
        return this.lastTriggeringTsState;
    }

    private void lastTriggeringTsState_$eq(ValueState<Object> x$1) {
        this.lastTriggeringTsState = x$1;
    }

    private ValueState<Row> accumulatorState() {
        return this.accumulatorState;
    }

    private void accumulatorState_$eq(ValueState<Row> x$1) {
        this.accumulatorState = x$1;
    }

    private MapState<Object, List<Row>> dataState() {
        return this.dataState;
    }

    private void dataState_$eq(MapState<Object, List<Row>> x$1) {
        this.dataState = x$1;
    }

    private GeneratedAggregations function() {
        return this.function;
    }

    private void function_$eq(GeneratedAggregations x$1) {
        this.function = x$1;
    }

    public void open(Configuration config) {
        this.LOG().debug(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Compiling AggregateHelper: ", " \\n\\n"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.name()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Code:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.genAggregations.code()}))).toString());
        Class<GeneratedAggregations> clazz = this.compile(this.getRuntimeContext().getUserCodeClassLoader(), this.genAggregations.name(), this.genAggregations.code());
        this.LOG().debug("Instantiating AggregateHelper.");
        this.function_$eq(clazz.newInstance());
        this.function().open(this.getRuntimeContext());
        this.output_$eq(new CRow(this.function().createOutputRow(), true));
        ValueStateDescriptor lastTriggeringTsDescriptor = new ValueStateDescriptor("lastTriggeringTsState", Long.TYPE);
        this.lastTriggeringTsState_$eq((ValueState<Object>)this.getRuntimeContext().getState(lastTriggeringTsDescriptor));
        ValueStateDescriptor accumulatorStateDescriptor = new ValueStateDescriptor("accumulatorState", (TypeInformation)this.aggregationStateType);
        this.accumulatorState_$eq((ValueState<Row>)this.getRuntimeContext().getState(accumulatorStateDescriptor));
        BasicTypeInfo keyTypeInformation = BasicTypeInfo.LONG_TYPE_INFO;
        ListTypeInfo valueTypeInformation = new ListTypeInfo((TypeInformation)this.inputRowType.rowType());
        MapStateDescriptor mapStateDescriptor = new MapStateDescriptor("dataState", (TypeInformation)keyTypeInformation, (TypeInformation)valueTypeInformation);
        this.dataState_$eq((MapState<Object, List<Row>>)this.getRuntimeContext().getMapState(mapStateDescriptor));
        this.initCleanupTimeState("RowTimeBoundedRangeOverCleanupTime");
    }

    public void processElement(CRow inputC, ProcessFunction.Context ctx, Collector<CRow> out) {
        Row input = inputC.row();
        this.registerProcessingCleanupTimer(ctx, ctx.timerService().currentProcessingTime());
        long triggeringTs = BoxesRunTime.unboxToLong((Object)input.getField(this.rowTimeIdx));
        long lastTriggeringTs = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
        if (triggeringTs > lastTriggeringTs) {
            List data = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)triggeringTs));
            if (data == null) {
                ArrayList<Row> data2 = new ArrayList<Row>();
                data2.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), data2);
                ctx.timerService().registerEventTimeTimer(triggeringTs);
            } else {
                data.add(input);
                this.dataState().put((Object)BoxesRunTime.boxToLong((long)triggeringTs), (Object)data);
            }
        }
    }

    public void onTimer(long timestamp, ProcessFunction.OnTimerContext ctx, Collector<CRow> out) {
        if (this.isProcessingTimeTimer(ctx)) {
            if (this.needToCleanupState(timestamp)) {
                Iterator keysIt = this.dataState().keys().iterator();
                long lastProcessedTime = BoxesRunTime.unboxToLong((Object)this.lastTriggeringTsState().value());
                boolean noRecordsToProcess = true;
                while (keysIt.hasNext() && noRecordsToProcess) {
                    if (BoxesRunTime.unboxToLong(keysIt.next()) <= lastProcessedTime) continue;
                    noRecordsToProcess = false;
                }
                if (noRecordsToProcess) {
                    this.cleanupState((Seq<State>)Predef$.MODULE$.wrapRefArray((Object[])new State[]{this.dataState(), this.accumulatorState(), this.lastTriggeringTsState()}));
                    this.function().cleanup();
                } else {
                    this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
                }
            }
            return;
        }
        ((TimestampedCollector)out).eraseTimestamp();
        List inputs = (List)this.dataState().get((Object)BoxesRunTime.boxToLong((long)timestamp));
        if (inputs != null) {
            Row accumulators = (Row)this.accumulatorState().value();
            int dataListIndex = 0;
            boolean aggregatesIndex = false;
            if (accumulators == null) {
                accumulators = this.function().createAccumulators();
                aggregatesIndex = false;
            }
            ArrayList<Long> retractTsList = new ArrayList<Long>();
            for (Map.Entry entry : this.dataState()) {
                Object object;
                long dataTs = BoxesRunTime.unboxToLong(entry.getKey());
                long offset = timestamp - dataTs;
                if (offset > this.precedingOffset) {
                    List retractDataList = (List)entry.getValue();
                    for (dataListIndex = 0; dataListIndex < retractDataList.size(); ++dataListIndex) {
                        Row retractRow = (Row)retractDataList.get(dataListIndex);
                        this.function().retract(accumulators, retractRow);
                    }
                    object = BoxesRunTime.boxToBoolean((boolean)retractTsList.add(BoxesRunTime.boxToLong((long)dataTs)));
                    continue;
                }
                object = BoxedUnit.UNIT;
            }
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                Row curRow = (Row)inputs.get(dataListIndex);
                this.function().accumulate(accumulators, curRow);
            }
            this.function().setAggregationResults(accumulators, this.output().row());
            for (dataListIndex = 0; dataListIndex < inputs.size(); ++dataListIndex) {
                aggregatesIndex = false;
                this.function().setForwardedFields((Row)inputs.get(dataListIndex), this.output().row());
                out.collect((Object)this.output());
            }
            for (dataListIndex = 0; dataListIndex < retractTsList.size(); ++dataListIndex) {
                this.dataState().remove(retractTsList.get(dataListIndex));
            }
            this.accumulatorState().update((Object)accumulators);
        }
        this.lastTriggeringTsState().update((Object)BoxesRunTime.boxToLong((long)timestamp));
        this.registerProcessingCleanupTimer((ProcessFunction.Context)ctx, ctx.timerService().currentProcessingTime());
    }

    public void close() {
        this.function().close();
    }

    public RowTimeBoundedRangeOver(GeneratedAggregationsFunction genAggregations, RowTypeInfo aggregationStateType, CRowTypeInfo inputRowType, long precedingOffset, int rowTimeIdx, StreamQueryConfig queryConfig) {
        this.genAggregations = genAggregations;
        this.aggregationStateType = aggregationStateType;
        this.inputRowType = inputRowType;
        this.precedingOffset = precedingOffset;
        this.rowTimeIdx = rowTimeIdx;
        super(queryConfig);
        Compiler$class.$init$(this);
        Logging$class.$init$(this);
        Preconditions.checkNotNull((Object)aggregationStateType);
        Preconditions.checkNotNull((Object)BoxesRunTime.boxToLong((long)precedingOffset));
    }
}

