/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime;

import java.sql.Timestamp;
import org.apache.calcite.runtime.SqlFunctions;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.functions.util.FunctionUtils;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.streaming.api.functions.ProcessFunction;
import org.apache.flink.streaming.api.operators.TimestampedCollector;
import org.apache.flink.table.runtime.types.CRow;
import org.apache.flink.util.Collector;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u001b\tar*\u001e;qkR\u0014vn\u001e;j[\u0016\u0004&o\\2fgN4UO\\2uS>t'BA\u0002\u0005\u0003\u001d\u0011XO\u001c;j[\u0016T!!\u0002\u0004\u0002\u000bQ\f'\r\\3\u000b\u0005\u001dA\u0011!\u00024mS:\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001!\u0006\u0002\u000fCM\u0011\u0001a\u0004\t\u0005!]Ir$D\u0001\u0012\u0015\t\u00112#A\u0005gk:\u001cG/[8og*\u0011A#F\u0001\u0004CBL'B\u0001\f\u0007\u0003%\u0019HO]3b[&tw-\u0003\u0002\u0019#\ty\u0001K]8dKN\u001ch)\u001e8di&|g\u000e\u0005\u0002\u001b;5\t1D\u0003\u0002\u001d\u0005\u0005)A/\u001f9fg&\u0011ad\u0007\u0002\u0005\u0007J{w\u000f\u0005\u0002!C1\u0001A!\u0002\u0012\u0001\u0005\u0004\u0019#aA(V)F\u0011AE\u000b\t\u0003K!j\u0011A\n\u0006\u0002O\u0005)1oY1mC&\u0011\u0011F\n\u0002\b\u001d>$\b.\u001b8h!\t)3&\u0003\u0002-M\t\u0019\u0011I\\=\t\u00119\u0002!\u0011!Q\u0001\n=\n\u0001BZ;oGRLwN\u001c\t\u0005aUJr$D\u00012\u0015\t\u0011\"G\u0003\u00024i\u000511m\\7n_:T!\u0001\u0006\u0004\n\u0005Y\n$aC'ba\u001a+hn\u0019;j_:D\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!O\u0001\u000be><H/[7f\u0013\u0012D\bCA\u0013;\u0013\tYdEA\u0002J]RDQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtDcA B\u0005B\u0019\u0001\tA\u0010\u000e\u0003\tAQA\f\u001fA\u0002=BQ\u0001\u000f\u001fA\u0002eBQ\u0001\u0012\u0001\u0005B\u0015\u000bAa\u001c9f]R\u0011a)\u0013\t\u0003K\u001dK!\u0001\u0013\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0015\u000e\u0003\raS\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\bC\u0001'P\u001b\u0005i%B\u0001(\u0007\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]&\u0011\u0001+\u0014\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000bI\u0003A\u0011I*\u0002\u001dA\u0014xnY3tg\u0016cW-\\3oiR!a\t\u0016,\\\u0011\u0015)\u0016\u000b1\u0001\u001a\u0003\tIg\u000eC\u0003X#\u0002\u0007\u0001,A\u0002dib\u0004\"aD-\n\u0005i;\"aB\"p]R,\u0007\u0010\u001e\u0005\u00069F\u0003\r!X\u0001\u0004_V$\bc\u00010b?5\tqL\u0003\u0002a\r\u0005!Q\u000f^5m\u0013\t\u0011wLA\u0005D_2dWm\u0019;pe\u0002")
public class OutputRowtimeProcessFunction<OUT>
extends ProcessFunction<CRow, OUT> {
    private final MapFunction<CRow, OUT> function;
    private final int rowtimeIdx;

    public void open(Configuration parameters) {
        FunctionUtils.setFunctionRuntimeContext(this.function, (RuntimeContext)this.getRuntimeContext());
        FunctionUtils.openFunction(this.function, (Configuration)parameters);
    }

    public void processElement(CRow in, ProcessFunction.Context ctx, Collector<OUT> out) {
        long timestamp = BoxesRunTime.unboxToLong((Object)in.row().getField(this.rowtimeIdx));
        ((TimestampedCollector)out).setAbsoluteTimestamp(timestamp);
        Timestamp convertedTimestamp = SqlFunctions.internalToTimestamp(timestamp);
        in.row().setField(this.rowtimeIdx, (Object)convertedTimestamp);
        out.collect(this.function.map((Object)in));
    }

    public OutputRowtimeProcessFunction(MapFunction<CRow, OUT> function, int rowtimeIdx) {
        this.function = function;
        this.rowtimeIdx = rowtimeIdx;
    }
}

