/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway.local.result;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.accumulators.SerializedListAccumulator;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.table.client.gateway.SqlExecutionException;
import org.apache.flink.table.client.gateway.TypedResult;
import org.apache.flink.table.client.gateway.local.CollectBatchTableSink;
import org.apache.flink.table.client.gateway.local.ProgramDeployer;
import org.apache.flink.table.client.gateway.local.result.BasicResult;
import org.apache.flink.table.client.gateway.local.result.MaterializedResult;
import org.apache.flink.table.sinks.TableSink;
import org.apache.flink.types.Row;
import org.apache.flink.util.AbstractID;

public class MaterializedCollectBatchResult<C>
extends BasicResult<C>
implements MaterializedResult<C> {
    private final TypeInformation<Row> outputType;
    private final String accumulatorName;
    private final CollectBatchTableSink tableSink;
    private final Object resultLock;
    private final Thread retrievalThread;
    private ProgramDeployer<C> deployer;
    private int pageSize;
    private int pageCount;
    private SqlExecutionException executionException;
    private List<Row> resultTable;
    private volatile boolean snapshotted = false;

    public MaterializedCollectBatchResult(TypeInformation<Row> outputType, ExecutionConfig config) {
        this.outputType = outputType;
        this.accumulatorName = new AbstractID().toString();
        this.tableSink = new CollectBatchTableSink(this.accumulatorName, (TypeSerializer<Row>)outputType.createSerializer(config));
        this.resultLock = new Object();
        this.retrievalThread = new ResultRetrievalThread();
        this.pageCount = 0;
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public TypeInformation<Row> getOutputType() {
        return this.outputType;
    }

    @Override
    public void startRetrieval(ProgramDeployer<C> deployer) {
        this.deployer = deployer;
        this.retrievalThread.start();
    }

    @Override
    public TableSink<?> getTableSink() {
        return this.tableSink;
    }

    @Override
    public void close() {
        this.retrievalThread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Row> retrievePage(int page) {
        Object object = this.resultLock;
        synchronized (object) {
            if (page <= 0 || page > this.pageCount) {
                throw new SqlExecutionException("Invalid page '" + page + "'.");
            }
            return this.resultTable.subList(this.pageSize * (page - 1), Math.min(this.resultTable.size(), page * this.pageSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypedResult<Integer> snapshot(int pageSize) {
        Object object = this.resultLock;
        synchronized (object) {
            if (this.retrievalThread.isAlive() && null == this.resultTable) {
                return TypedResult.empty();
            }
            if (this.executionException != null) {
                throw this.executionException;
            }
            if (!this.snapshotted) {
                this.snapshotted = true;
                this.pageSize = pageSize;
                this.pageCount = Math.max(1, (int)Math.ceil((double)this.resultTable.size() / (double)pageSize));
                return TypedResult.payload(this.pageCount);
            }
            return TypedResult.endOfStream();
        }
    }

    private class ResultRetrievalThread
    extends Thread {
        private ResultRetrievalThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                MaterializedCollectBatchResult.this.deployer.run();
                JobExecutionResult result = MaterializedCollectBatchResult.this.deployer.fetchExecutionResult();
                ArrayList accResult = (ArrayList)result.getAccumulatorResult(MaterializedCollectBatchResult.this.accumulatorName);
                if (accResult == null) {
                    throw new SqlExecutionException("The accumulator could not retrieve the result.");
                }
                List resultTable = SerializedListAccumulator.deserializeList((ArrayList)accResult, MaterializedCollectBatchResult.this.tableSink.getSerializer());
                Object object = MaterializedCollectBatchResult.this.resultLock;
                synchronized (object) {
                    MaterializedCollectBatchResult.this.resultTable = resultTable;
                }
            }
            catch (IOException | ClassNotFoundException e2) {
                MaterializedCollectBatchResult.this.executionException = new SqlExecutionException("Serialization error while deserializing collected data.", e2);
            }
            catch (SqlExecutionException e3) {
                MaterializedCollectBatchResult.this.executionException = e3;
            }
        }
    }
}

