/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.gateway;

import java.util.Objects;

public class TypedResult<P> {
    private ResultType type;
    private P payload;

    private TypedResult(ResultType type, P payload) {
        this.type = type;
        this.payload = payload;
    }

    public void setType(ResultType type) {
        this.type = type;
    }

    public void setPayload(P payload) {
        this.payload = payload;
    }

    public ResultType getType() {
        return this.type;
    }

    public P getPayload() {
        return this.payload;
    }

    public String toString() {
        return "TypedResult<" + (Object)((Object)this.type) + ">";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedResult that = (TypedResult)o;
        return this.type == that.type && Objects.equals(this.payload, that.payload);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.payload});
    }

    public static <T> TypedResult<T> empty() {
        return new TypedResult<Object>(ResultType.EMPTY, null);
    }

    public static <T> TypedResult<T> payload(T payload) {
        return new TypedResult<T>(ResultType.PAYLOAD, payload);
    }

    public static <T> TypedResult<T> endOfStream() {
        return new TypedResult<Object>(ResultType.EOS, null);
    }

    public static enum ResultType {
        PAYLOAD,
        EMPTY,
        EOS;

    }
}

