/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.config.ConfigUtil;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.FunctionDescriptor;

public class UserDefinedFunction
extends FunctionDescriptor {
    private String name;
    private Map<String, String> properties;
    private static final String NAME = "name";

    private UserDefinedFunction(String name, Map<String, String> properties) {
        this.name = name;
        this.properties = properties;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public static UserDefinedFunction create(Map<String, Object> config) {
        if (!config.containsKey(NAME)) {
            throw new SqlClientException("The 'name' attribute of a function is missing.");
        }
        Object name = config.get(NAME);
        if (name == null || !(name instanceof String) || ((String)name).trim().length() <= 0) {
            throw new SqlClientException("Invalid function name '" + name + "'.");
        }
        HashMap<String, Object> properties = new HashMap<String, Object>(config);
        properties.remove(NAME);
        return new UserDefinedFunction((String)name, ConfigUtil.normalizeYaml(properties));
    }

    @Override
    public void addProperties(DescriptorProperties properties) {
        this.properties.forEach(properties::putString);
    }
}

