/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client.config;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.config.ConfigUtil;
import org.apache.flink.table.client.config.Deployment;
import org.apache.flink.table.client.config.Execution;
import org.apache.flink.table.client.config.Sink;
import org.apache.flink.table.client.config.Source;
import org.apache.flink.table.client.config.SourceSink;
import org.apache.flink.table.client.config.UserDefinedFunction;
import org.apache.flink.table.descriptors.DescriptorProperties;
import org.apache.flink.table.descriptors.TableDescriptor;

public class Environment {
    private Map<String, TableDescriptor> tables = Collections.emptyMap();
    private Map<String, UserDefinedFunction> functions = Collections.emptyMap();
    private Execution execution = new Execution();
    private Deployment deployment = new Deployment();
    private static final String TABLE_NAME = "name";
    private static final String TABLE_TYPE = "type";
    private static final String TABLE_TYPE_VALUE_SOURCE = "source";
    private static final String TABLE_TYPE_VALUE_SINK = "sink";
    private static final String TABLE_TYPE_VALUE_BOTH = "both";

    public Map<String, TableDescriptor> getTables() {
        return this.tables;
    }

    public void setTables(List<Map<String, Object>> tables) {
        this.tables = new HashMap<String, TableDescriptor>(tables.size());
        tables.forEach(config -> {
            if (!config.containsKey(TABLE_NAME)) {
                throw new SqlClientException("The 'name' attribute of a table is missing.");
            }
            Object nameObject = config.get(TABLE_NAME);
            if (nameObject == null || !(nameObject instanceof String) || ((String)nameObject).length() <= 0) {
                throw new SqlClientException("Invalid table name '" + nameObject + "'.");
            }
            String name = (String)nameObject;
            HashMap<String, Object> properties = new HashMap<String, Object>((Map<String, Object>)config);
            properties.remove(TABLE_NAME);
            if (this.tables.containsKey(name)) {
                throw new SqlClientException("Duplicate table name '" + name + "'.");
            }
            this.tables.put(name, Environment.createTableDescriptor(name, properties));
        });
    }

    public Map<String, UserDefinedFunction> getFunctions() {
        return this.functions;
    }

    public void setFunctions(List<Map<String, Object>> functions) {
        this.functions = new HashMap<String, UserDefinedFunction>(functions.size());
        functions.forEach(config -> {
            UserDefinedFunction f = UserDefinedFunction.create(config);
            if (this.tables.containsKey(f.getName())) {
                throw new SqlClientException("Duplicate function name '" + f.getName() + "'.");
            }
            this.functions.put(f.getName(), f);
        });
    }

    public void setExecution(Map<String, Object> config) {
        this.execution = Execution.create(config);
    }

    public Execution getExecution() {
        return this.execution;
    }

    public void setDeployment(Map<String, Object> config) {
        this.deployment = Deployment.create(config);
    }

    public Deployment getDeployment() {
        return this.deployment;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("===================== Tables =====================\n");
        this.tables.forEach((name, table) -> {
            sb.append("- name: ").append((String)name).append("\n");
            DescriptorProperties props = new DescriptorProperties(true);
            table.addProperties(props);
            props.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("=================== Functions ====================\n");
        this.functions.forEach((name, function) -> {
            sb.append("- name: ").append((String)name).append("\n");
            DescriptorProperties props = new DescriptorProperties(true);
            function.addProperties(props);
            props.asMap().forEach((k, v) -> sb.append("  ").append((String)k).append(": ").append((String)v).append('\n'));
        });
        sb.append("=================== Execution ====================\n");
        this.execution.toProperties().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        sb.append("=================== Deployment ===================\n");
        this.deployment.toProperties().forEach((k, v) -> sb.append((String)k).append(": ").append((String)v).append('\n'));
        return sb.toString();
    }

    public static Environment parse(URL url) throws IOException {
        return (Environment)new ConfigUtil.LowerCaseYamlMapper().readValue(url, Environment.class);
    }

    public static Environment parse(String content) throws IOException {
        return (Environment)new ConfigUtil.LowerCaseYamlMapper().readValue(content, Environment.class);
    }

    public static Environment merge(Environment env1, Environment env2) {
        Environment mergedEnv = new Environment();
        HashMap<String, TableDescriptor> tables = new HashMap<String, TableDescriptor>(env1.getTables());
        tables.putAll(env2.getTables());
        mergedEnv.tables = tables;
        HashMap<String, UserDefinedFunction> functions = new HashMap<String, UserDefinedFunction>(env1.getFunctions());
        functions.putAll(env2.getFunctions());
        mergedEnv.functions = functions;
        mergedEnv.execution = Execution.merge(env1.getExecution(), env2.getExecution());
        mergedEnv.deployment = Deployment.merge(env1.getDeployment(), env2.getDeployment());
        return mergedEnv;
    }

    public static Environment enrich(Environment env, Map<String, String> properties) {
        Environment enrichedEnv = new Environment();
        enrichedEnv.tables = new HashMap<String, TableDescriptor>(env.getTables());
        enrichedEnv.functions = new HashMap<String, UserDefinedFunction>(env.getFunctions());
        enrichedEnv.execution = Execution.enrich(env.execution, properties);
        enrichedEnv.deployment = Deployment.enrich(env.deployment, properties);
        return enrichedEnv;
    }

    private static TableDescriptor createTableDescriptor(String name, Map<String, Object> config) {
        Object typeObject = config.get(TABLE_TYPE);
        if (typeObject == null || !(typeObject instanceof String)) {
            throw new SqlClientException("Invalid 'type' attribute for table '" + name + "'.");
        }
        String type = (String)typeObject;
        HashMap<String, Object> configCopy = new HashMap<String, Object>(config);
        configCopy.remove(TABLE_TYPE);
        Map<String, String> normalizedConfig = ConfigUtil.normalizeYaml(configCopy);
        switch (type) {
            case "source": {
                return new Source(name, normalizedConfig);
            }
            case "sink": {
                return new Sink(name, normalizedConfig);
            }
            case "both": {
                return new SourceSink(name, normalizedConfig);
            }
        }
        throw new SqlClientException(String.format("Invalid 'type' attribute for table '%s'. Only 'source', 'sink', and 'both' are supported. But was '%s'.", name, type));
    }
}

