/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.client;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.flink.table.client.SqlClientException;
import org.apache.flink.table.client.cli.CliClient;
import org.apache.flink.table.client.cli.CliOptions;
import org.apache.flink.table.client.cli.CliOptionsParser;
import org.apache.flink.table.client.config.Environment;
import org.apache.flink.table.client.gateway.Executor;
import org.apache.flink.table.client.gateway.SessionContext;
import org.apache.flink.table.client.gateway.local.LocalExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlClient {
    private static final Logger LOG = LoggerFactory.getLogger(SqlClient.class);
    private final boolean isEmbedded;
    private final CliOptions options;
    public static final String MODE_EMBEDDED = "embedded";
    public static final String MODE_GATEWAY = "gateway";
    public static final String DEFAULT_SESSION_ID = "default";

    public SqlClient(boolean isEmbedded, CliOptions options) {
        this.isEmbedded = isEmbedded;
        this.options = options;
    }

    private void start() {
        if (!this.isEmbedded) {
            throw new SqlClientException("Gateway mode is not supported yet.");
        }
        List<URL> jars = this.options.getJars() != null ? this.options.getJars() : Collections.emptyList();
        List<URL> libDirs = this.options.getLibraryDirs() != null ? this.options.getLibraryDirs() : Collections.emptyList();
        LocalExecutor executor = new LocalExecutor(this.options.getDefaults(), jars, libDirs);
        executor.start();
        Environment sessionEnv = SqlClient.readSessionEnvironment(this.options.getEnvironment());
        SessionContext context = this.options.getSessionId() == null ? new SessionContext(DEFAULT_SESSION_ID, sessionEnv) : new SessionContext(this.options.getSessionId(), sessionEnv);
        Runtime.getRuntime().addShutdownHook(new EmbeddedShutdownThread(context, executor));
        this.openCli(context, executor);
    }

    private void openCli(SessionContext context, Executor executor) {
        CliClient cli = new CliClient(context, executor);
        if (this.options.getUpdateStatement() == null) {
            cli.open();
        } else {
            boolean success = cli.submitUpdate(this.options.getUpdateStatement());
            if (!success) {
                throw new SqlClientException("Could not submit given SQL update statement to cluster.");
            }
        }
    }

    private static void shutdown(SessionContext context, Executor executor) {
        System.out.println();
        System.out.print("Shutting down executor...");
        executor.stop(context);
        System.out.println("done.");
    }

    private static Environment readSessionEnvironment(URL envUrl) {
        if (envUrl == null) {
            System.out.println("No session environment specified.");
            return new Environment();
        }
        System.out.println("Reading session environment from: " + envUrl);
        LOG.info("Using session environment file: {}", (Object)envUrl);
        try {
            return Environment.parse(envUrl);
        }
        catch (IOException e2) {
            throw new SqlClientException("Could not read session environment file at: " + envUrl, e2);
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            CliOptionsParser.printHelpClient();
            return;
        }
        switch (args[0]) {
            case "embedded": {
                String[] modeArgs = Arrays.copyOfRange(args, 1, args.length);
                CliOptions options = CliOptionsParser.parseEmbeddedModeClient(modeArgs);
                if (options.isPrintHelp()) {
                    CliOptionsParser.printHelpEmbeddedModeClient();
                    break;
                }
                try {
                    SqlClient client = new SqlClient(true, options);
                    client.start();
                    break;
                }
                catch (SqlClientException e2) {
                    System.out.println();
                    System.out.println();
                    LOG.error("SQL Client must stop.", (Throwable)e2);
                    throw e2;
                }
                catch (Throwable t) {
                    System.out.println();
                    System.out.println();
                    LOG.error("SQL Client must stop. Unexpected exception. This is a bug. Please consider filing an issue.", t);
                    throw new SqlClientException("Unexpected exception. This is a bug. Please consider filing an issue.", t);
                }
            }
            case "gateway": {
                throw new SqlClientException("Gateway mode is not supported yet.");
            }
            default: {
                CliOptionsParser.printHelpClient();
            }
        }
    }

    private class EmbeddedShutdownThread
    extends Thread {
        private final SessionContext context;
        private final Executor executor;

        public EmbeddedShutdownThread(SessionContext context, Executor executor) {
            this.context = context;
            this.executor = executor;
        }

        @Override
        public void run() {
            SqlClient.shutdown(this.context, this.executor);
        }
    }
}

