/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.api;

import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.java.operators.join.JoinType;
import org.apache.flink.table.api.BatchTableEnvironment;
import org.apache.flink.table.api.GroupedTable;
import org.apache.flink.table.api.OverWindow;
import org.apache.flink.table.api.OverWindowedTable;
import org.apache.flink.table.api.QueryConfig;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableException$;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.api.Types$;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.api.ValidationException$;
import org.apache.flink.table.api.Window;
import org.apache.flink.table.api.WindowedTable;
import org.apache.flink.table.calcite.FlinkRelBuilder;
import org.apache.flink.table.calcite.FlinkTypeFactory$;
import org.apache.flink.table.expressions.Alias;
import org.apache.flink.table.expressions.Alias$;
import org.apache.flink.table.expressions.Asc;
import org.apache.flink.table.expressions.Attribute;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.expressions.ExpressionParser$;
import org.apache.flink.table.expressions.NamedExpression;
import org.apache.flink.table.expressions.Ordering;
import org.apache.flink.table.expressions.UnresolvedAlias$;
import org.apache.flink.table.expressions.UnresolvedFieldReference;
import org.apache.flink.table.functions.utils.UserDefinedFunctionUtils$;
import org.apache.flink.table.plan.ProjectionTranslator$;
import org.apache.flink.table.plan.logical.Aggregate;
import org.apache.flink.table.plan.logical.AliasNode;
import org.apache.flink.table.plan.logical.BinaryNode;
import org.apache.flink.table.plan.logical.Distinct;
import org.apache.flink.table.plan.logical.Filter;
import org.apache.flink.table.plan.logical.Intersect;
import org.apache.flink.table.plan.logical.Join;
import org.apache.flink.table.plan.logical.LeafNode;
import org.apache.flink.table.plan.logical.Limit;
import org.apache.flink.table.plan.logical.Limit$;
import org.apache.flink.table.plan.logical.LogicalNode;
import org.apache.flink.table.plan.logical.LogicalTableFunctionCall;
import org.apache.flink.table.plan.logical.Minus;
import org.apache.flink.table.plan.logical.Project;
import org.apache.flink.table.plan.logical.Project$;
import org.apache.flink.table.plan.logical.Sort;
import org.apache.flink.table.plan.logical.UnaryNode;
import org.apache.flink.table.plan.logical.Union;
import org.apache.flink.table.sinks.TableSink;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\tMh\u0001B\u0001\u0003\u00015\u0011Q\u0001V1cY\u0016T!a\u0001\u0003\u0002\u0007\u0005\u0004\u0018N\u0003\u0002\u0006\r\u0005)A/\u00192mK*\u0011q\u0001C\u0001\u0006M2Lgn\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\rC\u0005\u0016\u0001\t\u0015\r\u0011\"\u0001\u0007-\u0005AA/\u00192mK\u0016sg/F\u0001\u0018!\tA\u0012$D\u0001\u0003\u0013\tQ\"A\u0001\tUC\ndW-\u00128wSJ|g.\\3oi\"AA\u0004\u0001B\u0001B\u0003%q#A\u0005uC\ndW-\u00128wA!Ia\u0004\u0001BC\u0002\u0013\u0005aaH\u0001\fY><\u0017nY1m!2\fg.F\u0001!!\t\tc%D\u0001#\u0015\t\u0019C%A\u0004m_\u001eL7-\u00197\u000b\u0005\u0015\"\u0011\u0001\u00029mC:L!a\n\u0012\u0003\u00171{w-[2bY:{G-\u001a\u0005\tS\u0001\u0011\t\u0011)A\u0005A\u0005aAn\\4jG\u0006d\u0007\u000b\\1oA!)1\u0006\u0001C\u0001Y\u00051A(\u001b8jiz\"2!\f\u00180!\tA\u0002\u0001C\u0003\u0016U\u0001\u0007q\u0003C\u0003\u001fU\u0001\u0007\u0001\u0005C\u0003,\u0001\u0011\u0005\u0011\u0007F\u0002.eMBQ!\u0006\u0019A\u0002]AQ\u0001\u000e\u0019A\u0002U\n\u0001\"\u001e3uM\u000e\u000bG\u000e\u001c\t\u0003mer!aD\u001c\n\u0005a\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002;w\t11\u000b\u001e:j]\u001eT!\u0001\u000f\t\t\u0011u\u0002\u0001R1A\u0005\ny\n1\u0002^1cY\u0016\u001c6\r[3nCV\tq\b\u0005\u0002\u0019\u0001&\u0011\u0011I\u0001\u0002\f)\u0006\u0014G.Z*dQ\u0016l\u0017\r\u0003\u0005D\u0001!\u0005\t\u0015)\u0003@\u00031!\u0018M\u00197f'\u000eDW-\\1!\u0011\u0015)\u0005\u0001\"\u0001G\u0003)\u0011X\r\u001c\"vS2$WM]\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nB\u0001\bG\u0006d7-\u001b;f\u0013\ta\u0015JA\bGY&t7NU3m\u0005VLG\u000eZ3s\u0011\u0015q\u0005\u0001\"\u0001P\u0003)9W\r\u001e*fY:{G-Z\u000b\u0002!B\u0011\u0011+V\u0007\u0002%*\u00111\u000bV\u0001\u0004e\u0016d'B\u0001&\t\u0013\t1&KA\u0004SK2tu\u000eZ3\t\u000ba\u0003A\u0011\u0001 \u0002\u0013\u001d,GoU2iK6\f\u0007\"\u0002.\u0001\t\u0003Y\u0016a\u00039sS:$8k\u00195f[\u0006$\u0012\u0001\u0018\t\u0003\u001fuK!A\u0018\t\u0003\tUs\u0017\u000e\u001e\u0005\u0006A\u0002!\t!Y\u0001\u0007g\u0016dWm\u0019;\u0015\u00055\u0012\u0007\"B2`\u0001\u0004!\u0017A\u00024jK2$7\u000fE\u0002\u0010K\u001eL!A\u001a\t\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u0005\u0002iW6\t\u0011N\u0003\u0002k\t\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0013\ta\u0017N\u0001\u0006FqB\u0014Xm]:j_:DQ\u0001\u0019\u0001\u0005\u00029$\"!L8\t\u000b\rl\u0007\u0019A\u001b\t\u000bE\u0004A\u0011\u0001:\u0002\u0005\u0005\u001cHCA\u0017t\u0011\u0015\u0019\u0007\u000f1\u0001e\u0011\u0015\t\b\u0001\"\u0001v)\tic\u000fC\u0003di\u0002\u0007Q\u0007C\u0003y\u0001\u0011\u0005\u00110\u0001\u0004gS2$XM\u001d\u000b\u0003[iDQa_<A\u0002\u001d\f\u0011\u0002\u001d:fI&\u001c\u0017\r^3\t\u000ba\u0004A\u0011A?\u0015\u00055r\b\"B>}\u0001\u0004)\u0004bBA\u0001\u0001\u0011\u0005\u00111A\u0001\u0006o\",'/\u001a\u000b\u0004[\u0005\u0015\u0001\"B>\u0000\u0001\u00049\u0007bBA\u0001\u0001\u0011\u0005\u0011\u0011\u0002\u000b\u0004[\u0005-\u0001BB>\u0002\b\u0001\u0007Q\u0007C\u0004\u0002\u0010\u0001!\t!!\u0005\u0002\u000f\u001d\u0014x.\u001e9CsR!\u00111CA\r!\rA\u0012QC\u0005\u0004\u0003/\u0011!\u0001D$s_V\u0004X\r\u001a+bE2,\u0007BB2\u0002\u000e\u0001\u0007A\rC\u0004\u0002\u0010\u0001!\t!!\b\u0015\t\u0005M\u0011q\u0004\u0005\u0007G\u0006m\u0001\u0019A\u001b\t\u000f\u0005\r\u0002\u0001\"\u0001\u0002&\u0005AA-[:uS:\u001cG\u000fF\u0001.\u0011\u001d\tI\u0003\u0001C\u0001\u0003W\tAA[8j]R\u0019Q&!\f\t\u000f\u0005=\u0012q\u0005a\u0001[\u0005)!/[4ii\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005MB#B\u0017\u00026\u0005]\u0002bBA\u0018\u0003c\u0001\r!\f\u0005\b\u0003s\t\t\u00041\u00016\u00035Qw.\u001b8Qe\u0016$\u0017nY1uK\"9\u0011\u0011\u0006\u0001\u0005\u0002\u0005uB#B\u0017\u0002@\u0005\u0005\u0003bBA\u0018\u0003w\u0001\r!\f\u0005\b\u0003s\tY\u00041\u0001h\u0011\u001d\t)\u0005\u0001C\u0001\u0003\u000f\nQ\u0002\\3gi>+H/\u001a:K_&tGcA\u0017\u0002J!9\u0011qFA\"\u0001\u0004i\u0003bBA#\u0001\u0011\u0005\u0011Q\n\u000b\u0006[\u0005=\u0013\u0011\u000b\u0005\b\u0003_\tY\u00051\u0001.\u0011\u001d\tI$a\u0013A\u0002UBq!!\u0012\u0001\t\u0003\t)\u0006F\u0003.\u0003/\nI\u0006C\u0004\u00020\u0005M\u0003\u0019A\u0017\t\u000f\u0005e\u00121\u000ba\u0001O\"9\u0011Q\f\u0001\u0005\u0002\u0005}\u0013A\u0004:jO\"$x*\u001e;fe*{\u0017N\u001c\u000b\u0006[\u0005\u0005\u00141\r\u0005\b\u0003_\tY\u00061\u0001.\u0011\u001d\tI$a\u0017A\u0002UBq!!\u0018\u0001\t\u0003\t9\u0007F\u0003.\u0003S\nY\u0007C\u0004\u00020\u0005\u0015\u0004\u0019A\u0017\t\u000f\u0005e\u0012Q\ra\u0001O\"9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0014!\u00044vY2|U\u000f^3s\u0015>Lg\u000eF\u0003.\u0003g\n)\bC\u0004\u00020\u00055\u0004\u0019A\u0017\t\u000f\u0005e\u0012Q\u000ea\u0001k!9\u0011q\u000e\u0001\u0005\u0002\u0005eD#B\u0017\u0002|\u0005u\u0004bBA\u0018\u0003o\u0002\r!\f\u0005\b\u0003s\t9\b1\u0001h\u0011\u001d\tI\u0003\u0001C\u0005\u0003\u0003#r!LAB\u0003\u000b\u000b9\tC\u0004\u00020\u0005}\u0004\u0019A\u0017\t\u000f\u0005e\u0012q\u0010a\u0001k!A\u0011\u0011RA@\u0001\u0004\tY)\u0001\u0005k_&tG+\u001f9f!\u0011\ti)a'\u000e\u0005\u0005=%\u0002BA\u0015\u0003#SA!a%\u0002\u0016\u0006Iq\u000e]3sCR|'o\u001d\u0006\u0005\u0003/\u000bI*\u0001\u0003kCZ\f'BA\u0002\u0007\u0013\u0011\ti*a$\u0003\u0011){\u0017N\u001c+za\u0016Dq!!\u000b\u0001\t\u0013\t\t\u000bF\u0004.\u0003G\u000b)+!,\t\u000f\u0005=\u0012q\u0014a\u0001[!A\u0011\u0011HAP\u0001\u0004\t9\u000b\u0005\u0003\u0010\u0003S;\u0017bAAV!\t1q\n\u001d;j_:D\u0001\"!#\u0002 \u0002\u0007\u00111\u0012\u0005\b\u0003c\u0003A\u0011AAZ\u0003\u0015i\u0017N\\;t)\ri\u0013Q\u0017\u0005\b\u0003_\ty\u000b1\u0001.\u0011\u001d\tI\f\u0001C\u0001\u0003w\u000b\u0001\"\\5okN\fE\u000e\u001c\u000b\u0004[\u0005u\u0006bBA\u0018\u0003o\u0003\r!\f\u0005\b\u0003\u0003\u0004A\u0011AAb\u0003\u0015)h.[8o)\ri\u0013Q\u0019\u0005\b\u0003_\ty\f1\u0001.\u0011\u001d\tI\r\u0001C\u0001\u0003\u0017\f\u0001\"\u001e8j_:\fE\u000e\u001c\u000b\u0004[\u00055\u0007bBA\u0018\u0003\u000f\u0004\r!\f\u0005\b\u0003#\u0004A\u0011AAj\u0003%Ig\u000e^3sg\u0016\u001cG\u000fF\u0002.\u0003+Dq!a\f\u0002P\u0002\u0007Q\u0006C\u0004\u0002Z\u0002!\t!a7\u0002\u0019%tG/\u001a:tK\u000e$\u0018\t\u001c7\u0015\u00075\ni\u000eC\u0004\u00020\u0005]\u0007\u0019A\u0017\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\u00069qN\u001d3fe\nKHcA\u0017\u0002f\"11-a8A\u0002\u0011Dq!!9\u0001\t\u0003\tI\u000fF\u0002.\u0003WDaaYAt\u0001\u0004)\u0004bBAx\u0001\u0011\u0005\u0011\u0011_\u0001\u0006Y&l\u0017\u000e\u001e\u000b\u0004[\u0005M\b\u0002CA{\u0003[\u0004\r!a>\u0002\r=4gm]3u!\ry\u0011\u0011`\u0005\u0004\u0003w\u0004\"aA%oi\"B\u0011Q^A\u0000\u0005\u000b\u0011I\u0001E\u0002\u0010\u0005\u0003I1Aa\u0001\u0011\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0005\u000f\tq\u0007R3qe\u0016\u001c\u0017\r^3eA%t\u0007EZ1w_J\u0004sN\u001a\u0011UC\ndWML8gMN,G\u000fK\u0015!C:$\u0007\u0005V1cY\u0016tc-\u001a;dQ\"J\u0013E\u0001B\u0006\u0003\u0015\td\u0006\u000e\u00181Q\u0011\tiOa\u0004\u0011\t\tE!\u0011D\u0007\u0003\u0005'QAA!\u0006\u0003\u0018\u0005!A.\u00198h\u0015\t\t9*\u0003\u0003\u0003\u001c\tM!A\u0003#faJ,7-\u0019;fI\"9\u0011q\u001e\u0001\u0005\u0002\t}A#B\u0017\u0003\"\t\r\u0002\u0002CA{\u0005;\u0001\r!a>\t\u0011\t\u0015\"Q\u0004a\u0001\u0003o\fQAZ3uG\"D\u0003B!\b\u0002\u0000\n%\"\u0011B\u0011\u0003\u0005W\tq\u0007Z3qe\u0016\u001c\u0017\r^3eA%t\u0007EZ1w_J\u0004sN\u001a\u0011UC\ndWML8gMN,G\u000fK\u0015!C:$\u0007\u0005V1cY\u0016tc-\u001a;dQ\"J\u0003\u0006\u0002B\u000f\u0005\u001fAq!!>\u0001\t\u0003\u0011\t\u0004F\u0002.\u0005gA\u0001\"!>\u00030\u0001\u0007\u0011q\u001f\u0005\b\u0005K\u0001A\u0011\u0001B\u001c)\ri#\u0011\b\u0005\t\u0005K\u0011)\u00041\u0001\u0002x\"9!Q\b\u0001\u0005\u0002\t}\u0012aC<sSR,Gk\\*j].,BA!\u0011\u0003XQ\u0019ALa\u0011\t\u0011\t\u0015#1\ba\u0001\u0005\u000f\nAa]5oWB1!\u0011\nB(\u0005'j!Aa\u0013\u000b\u0007\t5C!A\u0003tS:\\7/\u0003\u0003\u0003R\t-#!\u0003+bE2,7+\u001b8l!\u0011\u0011)Fa\u0016\r\u0001\u0011A!\u0011\fB\u001e\u0005\u0004\u0011YFA\u0001U#\u0011\u0011iFa\u0019\u0011\u0007=\u0011y&C\u0002\u0003bA\u0011qAT8uQ&tw\rE\u0002\u0010\u0005KJ1Aa\u001a\u0011\u0005\r\te.\u001f\u0005\b\u0005{\u0001A\u0011\u0001B6+\u0011\u0011iG!\u001e\u0015\u000bq\u0013yGa\u001e\t\u0011\t\u0015#\u0011\u000ea\u0001\u0005c\u0002bA!\u0013\u0003P\tM\u0004\u0003\u0002B+\u0005k\"\u0001B!\u0017\u0003j\t\u0007!1\f\u0005\t\u0005s\u0012I\u00071\u0001\u0003|\u0005!1m\u001c8g!\rA\"QP\u0005\u0004\u0005\u007f\u0012!aC)vKJL8i\u001c8gS\u001eDqAa!\u0001\t\u0003\u0011))\u0001\u0006j]N,'\u000f^%oi>$2\u0001\u0018BD\u0011\u001d\u0011II!!A\u0002U\n\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000f\t\r\u0005\u0001\"\u0001\u0003\u000eR)ALa$\u0003\u0012\"9!\u0011\u0012BF\u0001\u0004)\u0004\u0002\u0003B=\u0005\u0017\u0003\rAa\u001f\t\u000f\tU\u0005\u0001\"\u0001\u0003\u0018\u00061q/\u001b8e_^$BA!'\u0003 B\u0019\u0001Da'\n\u0007\tu%AA\u0007XS:$wn^3e)\u0006\u0014G.\u001a\u0005\t\u0005+\u0013\u0019\n1\u0001\u0003\"B\u0019\u0001Da)\n\u0007\t\u0015&A\u0001\u0004XS:$wn\u001e\u0005\b\u0005+\u0003A\u0011\u0001BU)\u0011\u0011YK!-\u0011\u0007a\u0011i+C\u0002\u00030\n\u0011\u0011c\u0014<fe^Kg\u000eZ8xK\u0012$\u0016M\u00197f\u0011!\u0011\u0019La*A\u0002\tU\u0016aC8wKJ<\u0016N\u001c3poN\u0004BaD3\u00038B\u0019\u0001D!/\n\u0007\tm&A\u0001\u0006Pm\u0016\u0014x+\u001b8e_^DCAa*\u0003@B!!\u0011\u0019Bd\u001b\t\u0011\u0019MC\u0002\u0003FB\t!\"\u00198o_R\fG/[8o\u0013\u0011\u0011IMa1\u0003\u000fY\f'/\u0019:hg\"Y!\u0011\u0012\u0001A\u0002\u0003\u0007I\u0011\u0001Bg+\u0005)\u0004b\u0003Bi\u0001\u0001\u0007\t\u0019!C\u0001\u0005'\fQ\u0002^1cY\u0016t\u0015-\\3`I\u0015\fHc\u0001/\u0003V\"I!q\u001bBh\u0003\u0003\u0005\r!N\u0001\u0004q\u0012\n\u0004b\u0002Bn\u0001\u0001\u0006K!N\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0003b\u0002Bp\u0001\u0011\u0005#\u0011]\u0001\ti>\u001cFO]5oOR\tQ\u0007C\u0004\u0003f\u0002!IAa:\u00023\r|g\u000e^1j]N,fNY8v]\u0012,G-\u0016#U\r\u000e\u000bG\u000e\u001c\u000b\u0005\u0005S\u0014y\u000fE\u0002\u0010\u0005WL1A!<\u0011\u0005\u001d\u0011un\u001c7fC:DqA!=\u0003d\u0002\u0007\u0001%A\u0001o\u0001")
public class Table {
    private final TableEnvironment tableEnv;
    private final LogicalNode logicalPlan;
    private TableSchema tableSchema;
    private String tableName;
    private volatile boolean bitmap$0;

    private TableSchema tableSchema$lzycompute() {
        Table table = this;
        synchronized (table) {
            if (!this.bitmap$0) {
                this.tableSchema = new TableSchema((String[])((TraversableOnce)this.logicalPlan().output().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Attribute x$1) {
                        return x$1.name();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)), (TypeInformation[])((TraversableOnce)this.logicalPlan().output().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TypeInformation<?> apply(Attribute x$2) {
                        return x$2.resultType();
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class)));
                this.bitmap$0 = true;
            }
            return this.tableSchema;
        }
    }

    public OverWindowedTable window(OverWindow ... overWindows) {
        return this.window((Seq<OverWindow>)Predef$.MODULE$.wrapRefArray((Object[])overWindows));
    }

    public TableEnvironment tableEnv() {
        return this.tableEnv;
    }

    public LogicalNode logicalPlan() {
        return this.logicalPlan;
    }

    private TableSchema tableSchema() {
        return this.bitmap$0 ? this.tableSchema : this.tableSchema$lzycompute();
    }

    public FlinkRelBuilder relBuilder() {
        return this.tableEnv().getRelBuilder();
    }

    public RelNode getRelNode() {
        if (this.containsUnboundedUDTFCall(this.logicalPlan())) {
            throw new ValidationException("Cannot translate a query with an unbounded table function call.");
        }
        return this.logicalPlan().toRelNode(this.relBuilder());
    }

    public TableSchema getSchema() {
        return this.tableSchema();
    }

    public void printSchema() {
        Predef$.MODULE$.print((Object)this.tableSchema().toString());
    }

    public Table select(Seq<Expression> fields) {
        Seq<Expression> expandedFields = ProjectionTranslator$.MODULE$.expandProjectList(fields, this.logicalPlan(), this.tableEnv());
        Tuple2<Map<Expression, String>, Map<Expression, String>> tuple2 = ProjectionTranslator$.MODULE$.extractAggregationsAndProperties(expandedFields, this.tableEnv());
        if (tuple2 != null) {
            Table table;
            Tuple2 tuple22;
            Map aggNames = (Map)tuple2._1();
            Map propNames = (Map)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)aggNames, (Object)propNames);
            Map aggNames2 = (Map)tuple23._1();
            Map propNames2 = (Map)tuple23._2();
            if (propNames2.nonEmpty()) {
                throw ValidationException$.MODULE$.apply("Window properties can only be used on windowed tables.");
            }
            if (aggNames2.nonEmpty()) {
                Seq<NamedExpression> projectsOnAgg = ProjectionTranslator$.MODULE$.replaceAggregationsAndProperties(expandedFields, this.tableEnv(), (Map<Expression, String>)aggNames2, (Map<Expression, String>)propNames2);
                Seq<NamedExpression> projectFields = ProjectionTranslator$.MODULE$.extractFieldReferences(expandedFields);
                table = new Table(this.tableEnv(), new Project(projectsOnAgg, new Aggregate((Seq<Expression>)Nil$.MODULE$, (Seq<NamedExpression>)((TraversableOnce)aggNames2.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Alias apply(Tuple2<Expression, String> a) {
                        return new Alias((Expression)a._1(), (String)a._2(), Alias$.MODULE$.apply$default$3());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSeq(), new Project(projectFields, this.logicalPlan(), Project$.MODULE$.apply$default$3()).validate(this.tableEnv())).validate(this.tableEnv()), Project$.MODULE$.apply$default$3()).validate(this.tableEnv()));
            } else {
                table = new Table(this.tableEnv(), new Project((Seq<NamedExpression>)((Seq)expandedFields.map((Function1)UnresolvedAlias$.MODULE$, Seq$.MODULE$.canBuildFrom())), this.logicalPlan(), Project$.MODULE$.apply$default$3()).validate(this.tableEnv()));
            }
            return table;
        }
        throw new MatchError(tuple2);
    }

    public Table select(String fields) {
        List<Expression> fieldExprs = ExpressionParser$.MODULE$.parseExpressionList(fields);
        List withResolvedAggFunctionCall = (List)fieldExprs.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Table $outer;

            public final Expression apply(Expression x$4) {
                return ProjectionTranslator$.MODULE$.replaceAggFunctionCall(x$4, this.$outer.tableEnv());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        return this.select((Seq<Expression>)withResolvedAggFunctionCall);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table as(Seq<Expression> fields) {
        LogicalNode logicalNode = this.logicalPlan();
        if (!(logicalNode instanceof LogicalTableFunctionCall)) return new Table(this.tableEnv(), new AliasNode(fields, this.logicalPlan()).validate(this.tableEnv()));
        LogicalTableFunctionCall logicalTableFunctionCall = (LogicalTableFunctionCall)logicalNode;
        if (logicalTableFunctionCall.child() != null) return new Table(this.tableEnv(), new AliasNode(fields, this.logicalPlan()).validate(this.tableEnv()));
        if (fields.length() != logicalTableFunctionCall.output().length()) {
            throw new ValidationException("List of column aliases must have same degree as TableFunction's output");
        }
        if (!fields.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Expression x$5) {
                return x$5 instanceof UnresolvedFieldReference;
            }
        })) throw new ValidationException("Alias field must be an instance of UnresolvedFieldReference");
        return new Table(this.tableEnv(), new LogicalTableFunctionCall(logicalTableFunctionCall.functionName(), logicalTableFunctionCall.tableFunction(), logicalTableFunctionCall.parameters(), logicalTableFunctionCall.resultType(), (String[])((TraversableOnce)fields.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Expression x$6) {
                return ((UnresolvedFieldReference)x$6).name();
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class)), logicalTableFunctionCall.child()));
    }

    public Table as(String fields) {
        List<Expression> fieldExprs = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.as((Seq<Expression>)fieldExprs);
    }

    public Table filter(Expression predicate) {
        return new Table(this.tableEnv(), new Filter(predicate, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table filter(String predicate) {
        Expression predicateExpr = ExpressionParser$.MODULE$.parseExpression(predicate);
        return this.filter(predicateExpr);
    }

    public Table where(Expression predicate) {
        return this.filter(predicate);
    }

    public Table where(String predicate) {
        return this.filter(predicate);
    }

    public GroupedTable groupBy(Seq<Expression> fields) {
        return new GroupedTable(this, fields);
    }

    public GroupedTable groupBy(String fields) {
        List<Expression> fieldsExpr = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.groupBy((Seq<Expression>)fieldsExpr);
    }

    public Table distinct() {
        return new Table(this.tableEnv(), new Distinct(this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table join(Table right) {
        return this.join(right, (Option<Expression>)None$.MODULE$, JoinType.INNER);
    }

    public Table join(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.INNER);
    }

    public Table join(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.INNER);
    }

    public Table leftOuterJoin(Table right) {
        return this.join(right, (Option<Expression>)None$.MODULE$, JoinType.LEFT_OUTER);
    }

    public Table leftOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.LEFT_OUTER);
    }

    public Table leftOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.LEFT_OUTER);
    }

    public Table rightOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.RIGHT_OUTER);
    }

    public Table rightOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.RIGHT_OUTER);
    }

    public Table fullOuterJoin(Table right, String joinPredicate) {
        return this.join(right, joinPredicate, JoinType.FULL_OUTER);
    }

    public Table fullOuterJoin(Table right, Expression joinPredicate) {
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicate), JoinType.FULL_OUTER);
    }

    private Table join(Table right, String joinPredicate, JoinType joinType) {
        Expression joinPredicateExpr = ExpressionParser$.MODULE$.parseExpression(joinPredicate);
        return this.join(right, (Option<Expression>)new Some((Object)joinPredicateExpr), joinType);
    }

    private Table join(Table right, Option<Expression> joinPredicate, JoinType joinType) {
        block6: {
            Table table;
            block5: {
                block2: {
                    block4: {
                        block3: {
                            if (!this.containsUnboundedUDTFCall(right.logicalPlan())) break block2;
                            JoinType joinType2 = joinType;
                            JoinType joinType3 = JoinType.INNER;
                            if (!(joinType2 == null ? joinType3 != null : !joinType2.equals(joinType3))) break block3;
                            JoinType joinType4 = joinType;
                            JoinType joinType5 = JoinType.LEFT_OUTER;
                            if (joinType4 != null ? !joinType4.equals(joinType5) : joinType5 != null) break block4;
                        }
                        LogicalTableFunctionCall udtf = (LogicalTableFunctionCall)right.logicalPlan();
                        LogicalNode udtfCall = new LogicalTableFunctionCall(udtf.functionName(), udtf.tableFunction(), udtf.parameters(), udtf.resultType(), udtf.fieldNames(), this.logicalPlan()).validate(this.tableEnv());
                        table = new Table(this.tableEnv(), new Join(this.logicalPlan(), udtfCall, joinType, joinPredicate, true).validate(this.tableEnv()));
                        break block5;
                    }
                    throw new ValidationException("TableFunctions are currently supported for join and leftOuterJoin.");
                }
                TableEnvironment tableEnvironment = right.tableEnv();
                TableEnvironment tableEnvironment2 = this.tableEnv();
                if (tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null) break block6;
                table = new Table(this.tableEnv(), new Join(this.logicalPlan(), right.logicalPlan(), joinType, joinPredicate, false).validate(this.tableEnv()));
            }
            return table;
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be joined.");
    }

    public Table minus(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Minus(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be subtracted.");
    }

    public Table minusAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Minus(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be subtracted.");
    }

    public Table union(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Union(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be unioned.");
    }

    public Table unionAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Union(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be unioned.");
    }

    public Table intersect(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Intersect(this.logicalPlan(), right.logicalPlan(), false).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be intersected.");
    }

    public Table intersectAll(Table right) {
        TableEnvironment tableEnvironment = right.tableEnv();
        TableEnvironment tableEnvironment2 = this.tableEnv();
        if (!(tableEnvironment != null ? !tableEnvironment.equals(tableEnvironment2) : tableEnvironment2 != null)) {
            return new Table(this.tableEnv(), new Intersect(this.logicalPlan(), right.logicalPlan(), true).validate(this.tableEnv()));
        }
        throw new ValidationException("Only tables from the same TableEnvironment can be intersected.");
    }

    public Table orderBy(Seq<Expression> fields) {
        Seq order = (Seq)fields.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Ordering apply(Expression x0$1) {
                Ordering ordering;
                Expression expression2 = x0$1;
                Ordering ordering2 = expression2 instanceof Ordering ? (ordering = (Ordering)expression2) : new Asc(expression2);
                return ordering2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new Table(this.tableEnv(), new Sort((Seq<Ordering>)order, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table orderBy(String fields) {
        List<Expression> parsedFields = ExpressionParser$.MODULE$.parseExpressionList(fields);
        return this.orderBy((Seq<Expression>)parsedFields);
    }

    @Deprecated
    public Table limit(int offset) {
        int x$14 = offset;
        LogicalNode x$15 = this.logicalPlan();
        int x$16 = Limit$.MODULE$.apply$default$2();
        return new Table(this.tableEnv(), new Limit(x$14, x$16, x$15).validate(this.tableEnv()));
    }

    @Deprecated
    public Table limit(int offset, int fetch) {
        return new Table(this.tableEnv(), new Limit(offset, fetch, this.logicalPlan()).validate(this.tableEnv()));
    }

    public Table offset(int offset) {
        return new Table(this.tableEnv(), new Limit(offset, -1, this.logicalPlan()).validate(this.tableEnv()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Table fetch(int fetch) {
        if (fetch < 0) {
            throw ValidationException$.MODULE$.apply("FETCH count must be equal or larger than 0.");
        }
        boolean bl = false;
        Limit limit = null;
        LogicalNode logicalNode = this.logicalPlan();
        if (logicalNode instanceof Limit) {
            bl = true;
            limit = (Limit)logicalNode;
            int o = limit.offset();
            int n = limit.fetch();
            LogicalNode c = limit.child();
            if (-1 == n) {
                return new Table(this.tableEnv(), new Limit(o, fetch, c).validate(this.tableEnv()));
            }
        }
        if (!bl) return new Table(this.tableEnv(), new Limit(0, fetch, this.logicalPlan()).validate(this.tableEnv()));
        throw ValidationException$.MODULE$.apply("FETCH is already defined.");
    }

    public <T> void writeToSink(TableSink<T> sink) {
        Option option = Option$.MODULE$.apply((Object)this.tableEnv());
        QueryConfig queryConfig = None$.MODULE$.equals(option) ? null : this.tableEnv().queryConfig();
        QueryConfig queryConfig2 = queryConfig;
        this.writeToSink(sink, queryConfig2);
    }

    public <T> void writeToSink(TableSink<T> sink, QueryConfig conf) {
        RelDataType rowType = this.getRelNode().getRowType();
        String[] fieldNames = (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldNames()).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
        TypeInformation[] fieldTypes = (TypeInformation[])((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rowType.getFieldList()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(RelDataTypeField field2) {
                return FlinkTypeFactory$.MODULE$.toTypeInfo(field2.getType());
            }
        }, Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TypeInformation<?> apply(TypeInformation<?> x0$2) {
                TypeInformation<?> typeInformation;
                block4: {
                    Object object;
                    block3: {
                        TypeInformation<?> typeInformation2;
                        block2: {
                            TypeInformation<?> typeInformation3;
                            typeInformation = x0$2;
                            if (typeInformation == null || !FlinkTypeFactory$.MODULE$.isTimeIndicatorType(typeInformation3 = typeInformation)) break block2;
                            object = Types$.MODULE$.SQL_TIMESTAMP();
                            break block3;
                        }
                        if (typeInformation == null) break block4;
                        object = typeInformation2 = typeInformation;
                    }
                    return object;
                }
                throw new MatchError(typeInformation);
            }
        }, Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(TypeInformation.class));
        TableSink<T> configuredSink = sink.configure(fieldNames, fieldTypes);
        this.tableEnv().writeToSink(this, configuredSink, conf);
    }

    public void insertInto(String tableName) {
        this.tableEnv().insertInto(this, tableName, this.tableEnv().queryConfig());
    }

    public void insertInto(String tableName, QueryConfig conf) {
        this.tableEnv().insertInto(this, tableName, conf);
    }

    public WindowedTable window(Window window) {
        return new WindowedTable(this, window);
    }

    public OverWindowedTable window(Seq<OverWindow> overWindows) {
        if (this.tableEnv() instanceof BatchTableEnvironment) {
            throw TableException$.MODULE$.apply("Over-windows for batch tables are currently not supported.");
        }
        if (overWindows.size() != 1) {
            throw TableException$.MODULE$.apply("Over-Windows are currently only supported single window.");
        }
        return new OverWindowedTable(this, (OverWindow[])overWindows.toArray(ClassTag$.MODULE$.apply(OverWindow.class)));
    }

    public String tableName() {
        return this.tableName;
    }

    public void tableName_$eq(String x$1) {
        this.tableName = x$1;
    }

    public String toString() {
        if (this.tableName() == null) {
            this.tableName_$eq(new StringBuilder().append((Object)"UnnamedTable$").append((Object)BoxesRunTime.boxToInteger((int)this.tableEnv().attrNameCntr().getAndIncrement())).toString());
            this.tableEnv().registerTable(this.tableName(), this);
        }
        return this.tableName();
    }

    private boolean containsUnboundedUDTFCall(LogicalNode n) {
        LogicalNode logicalNode;
        block9: {
            boolean bl;
            block8: {
                while (true) {
                    LogicalTableFunctionCall logicalTableFunctionCall;
                    if ((logicalNode = n) instanceof LogicalTableFunctionCall && (logicalTableFunctionCall = (LogicalTableFunctionCall)logicalNode).child() == null) {
                        bl = true;
                        break block8;
                    }
                    if (logicalNode instanceof UnaryNode) {
                        UnaryNode unaryNode = (UnaryNode)logicalNode;
                        n = unaryNode.child();
                        continue;
                    }
                    if (!(logicalNode instanceof BinaryNode)) break;
                    BinaryNode binaryNode = (BinaryNode)logicalNode;
                    if (this.containsUnboundedUDTFCall(binaryNode.left())) {
                        bl = true;
                        break block8;
                    }
                    n = binaryNode.right();
                }
                if (!(logicalNode instanceof LeafNode)) break block9;
                bl = false;
            }
            return bl;
        }
        throw new MatchError((Object)logicalNode);
    }

    public Table(TableEnvironment tableEnv, LogicalNode logicalPlan) {
        this.tableEnv = tableEnv;
        this.logicalPlan = logicalPlan;
        if (this.containsUnboundedUDTFCall(logicalPlan) && !(logicalPlan instanceof LogicalTableFunctionCall)) {
            throw new ValidationException("TableFunction can only be used in join and leftOuterJoin.");
        }
    }

    public Table(TableEnvironment tableEnv, String udtfCall) {
        this(tableEnv, UserDefinedFunctionUtils$.MODULE$.createLogicalFunctionCall(tableEnv, udtfCall));
    }
}

