/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.calcite.shaded.com.esri.core.geometry;

import java.io.Serializable;
import org.apache.flink.calcite.shaded.com.esri.core.geometry.NumberUtils;

public final class Envelope1D
implements Serializable {
    private static final long serialVersionUID = 1L;
    public double vmin;
    public double vmax;

    public Envelope1D() {
    }

    public Envelope1D(double _vmin, double _vmax) {
        this.setCoords(_vmin, _vmax);
    }

    public Envelope1D(Envelope1D other) {
        this.setCoords(other);
    }

    public void setCoords(double _vmin, double _vmax) {
        this.vmin = _vmin;
        this.vmax = _vmax;
        this.normalize();
    }

    public void setCoords(Envelope1D other) {
        this.setCoords(other.vmin, other.vmax);
    }

    public void normalize() {
        if (NumberUtils.isNaN(this.vmin)) {
            return;
        }
        if (this.vmin > this.vmax) {
            double v = this.vmin;
            this.vmin = this.vmax;
            this.vmax = v;
        }
        if (NumberUtils.isNaN(this.vmax)) {
            this.setEmpty();
        }
    }

    public void setEmpty() {
        this.vmin = NumberUtils.NaN();
        this.vmax = NumberUtils.NaN();
    }

    public boolean isEmpty() {
        return NumberUtils.isNaN(this.vmin) || NumberUtils.isNaN(this.vmax);
    }

    public void setInfinite() {
        this.vmin = NumberUtils.negativeInf();
        this.vmax = NumberUtils.positiveInf();
    }

    public void merge(double v) {
        if (this.isEmpty()) {
            this.vmin = v;
            this.vmax = v;
            return;
        }
        this.mergeNE(v);
    }

    public void merge(Envelope1D other) {
        if (other.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.vmin = other.vmin;
            this.vmax = other.vmax;
            return;
        }
        if (this.vmin > other.vmin) {
            this.vmin = other.vmin;
        }
        if (this.vmax < other.vmax) {
            this.vmax = other.vmax;
        }
        if (this.vmin > this.vmax) {
            this.setEmpty();
        }
    }

    public void mergeNE(double v) {
        if (v < this.vmin) {
            this.vmin = v;
        } else if (v > this.vmax) {
            this.vmax = v;
        }
    }

    public boolean contains(double v) {
        return v >= this.vmin && v <= this.vmax;
    }

    public boolean contains(Envelope1D other) {
        return other.vmin >= this.vmin && other.vmax <= this.vmax;
    }

    public void intersect(Envelope1D other) {
        if (this.isEmpty() || other.isEmpty()) {
            this.setEmpty();
            return;
        }
        if (this.vmin < other.vmin) {
            this.vmin = other.vmin;
        }
        if (this.vmax > other.vmax) {
            this.vmax = other.vmax;
        }
        if (this.vmin > this.vmax) {
            this.setEmpty();
        }
    }

    public void inflate(double delta) {
        if (this.isEmpty()) {
            return;
        }
        this.vmin -= delta;
        this.vmax += delta;
        if (this.vmax < this.vmin) {
            this.setEmpty();
        }
    }

    double _calculateToleranceFromEnvelope() {
        if (this.isEmpty()) {
            return NumberUtils.doubleEps() * 100.0;
        }
        double r = Math.abs(this.vmin) + Math.abs(this.vmax) + 1.0;
        return r * NumberUtils.doubleEps() * 100.0;
    }

    void normalizeNoNaN_() {
        if (this.vmin > this.vmax) {
            double v = this.vmin;
            this.vmin = this.vmax;
            this.vmax = v;
        }
    }

    void setCoordsNoNaN_(double vmin_, double vmax_) {
        this.vmin = vmin_;
        this.vmax = vmax_;
        this.normalizeNoNaN_();
    }

    public double snapClip(double v) {
        return NumberUtils.snap(v, this.vmin, this.vmax);
    }

    public double getWidth() {
        return this.vmax - this.vmin;
    }

    public double getCenter() {
        return 0.5 * (this.vmin + this.vmax);
    }

    public boolean equals(Object _other) {
        if (_other == this) {
            return true;
        }
        if (!(_other instanceof Envelope1D)) {
            return false;
        }
        Envelope1D other = (Envelope1D)_other;
        if (this.isEmpty() && other.isEmpty()) {
            return true;
        }
        return this.vmin == other.vmin && this.vmax == other.vmax;
    }

    public int hashCode() {
        return NumberUtils.hash(NumberUtils.hash(this.vmin), this.vmax);
    }
}

