/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.schema.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.apache.calcite.adapter.enumerable.AggImplementor;
import org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.AggregateFunction;
import org.apache.calcite.schema.FunctionParameter;
import org.apache.calcite.schema.ImplementableAggFunction;
import org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.Static;
import org.apache.flink.calcite.shaded.com.google.common.base.Preconditions;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class AggregateFunctionImpl
implements AggregateFunction,
ImplementableAggFunction {
    public final boolean isStatic;
    public final Method initMethod;
    public final Method addMethod;
    public final Method mergeMethod;
    public final Method resultMethod;
    public final ImmutableList<Class<?>> valueTypes;
    private final List<FunctionParameter> parameters;
    public final Class<?> accumulatorType;
    public final Class<?> resultType;
    public final Class<?> declaringClass;

    private AggregateFunctionImpl(Class<?> declaringClass, List<FunctionParameter> params, List<Class<?>> valueTypes, Class<?> accumulatorType, Class<?> resultType2, Method initMethod, Method addMethod, Method mergeMethod, Method resultMethod) {
        this.declaringClass = declaringClass;
        this.valueTypes = ImmutableList.copyOf(valueTypes);
        this.parameters = params;
        this.accumulatorType = accumulatorType;
        this.resultType = resultType2;
        this.initMethod = Preconditions.checkNotNull(initMethod);
        this.addMethod = Preconditions.checkNotNull(addMethod);
        this.mergeMethod = mergeMethod;
        this.resultMethod = resultMethod;
        this.isStatic = Modifier.isStatic(initMethod.getModifiers());
        assert (resultMethod != null || accumulatorType == resultType2);
    }

    public static AggregateFunctionImpl create(Class<?> clazz) {
        Method initMethod = ReflectiveFunctionBase.findMethod(clazz, "init");
        Method addMethod = ReflectiveFunctionBase.findMethod(clazz, "add");
        Method mergeMethod = null;
        Method resultMethod = ReflectiveFunctionBase.findMethod(clazz, "result");
        if (initMethod != null && addMethod != null) {
            Class<?> accumulatorType = initMethod.getReturnType();
            Class<?> resultType2 = resultMethod != null ? resultMethod.getReturnType() : accumulatorType;
            ImmutableList<Class<?>> addParamTypes = ImmutableList.copyOf(addMethod.getParameterTypes());
            if (addParamTypes.isEmpty() || addParamTypes.get(0) != accumulatorType) {
                throw Static.RESOURCE.firstParameterOfAdd(clazz.getName()).ex();
            }
            ReflectiveFunctionBase.ParameterListBuilder params = ReflectiveFunctionBase.builder();
            ImmutableList.Builder valueTypes = ImmutableList.builder();
            for (int i = 1; i < addParamTypes.size(); ++i) {
                Class type = (Class)addParamTypes.get(i);
                String name = ReflectUtil.getParameterName(addMethod, i);
                boolean optional = ReflectUtil.isParameterOptional(addMethod, i);
                params.add(type, name, optional);
                valueTypes.add(type);
            }
            return new AggregateFunctionImpl(clazz, (List<FunctionParameter>)params.build(), (List<Class<?>>)((Object)valueTypes.build()), accumulatorType, resultType2, initMethod, addMethod, mergeMethod, resultMethod);
        }
        return null;
    }

    @Override
    public List<FunctionParameter> getParameters() {
        return this.parameters;
    }

    @Override
    public RelDataType getReturnType(RelDataTypeFactory typeFactory) {
        return typeFactory.createJavaType(this.resultType);
    }

    @Override
    public AggImplementor getImplementor(boolean windowContext) {
        return new RexImpTable.UserDefinedAggReflectiveImplementor(this);
    }
}

