/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.externalize.RelWriterImpl;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexChecker;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgramBuilder;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Permutation;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;
import org.apache.flink.calcite.shaded.com.google.common.collect.Ordering;

public class RexProgram {
    private final List<RexNode> exprs;
    private final List<RexLocalRef> projects;
    private final RexLocalRef condition;
    private final RelDataType inputRowType;
    private final RelDataType outputRowType;
    private int[] refCounts;

    public RexProgram(RelDataType inputRowType, List<? extends RexNode> exprs, List<RexLocalRef> projects, RexLocalRef condition, RelDataType outputRowType) {
        this.inputRowType = inputRowType;
        this.exprs = ImmutableList.copyOf(exprs);
        this.projects = ImmutableList.copyOf(projects);
        this.condition = condition;
        this.outputRowType = outputRowType;
        assert (this.isValid(Litmus.THROW, null));
    }

    public List<RexNode> getExprList() {
        return this.exprs;
    }

    public List<RexLocalRef> getProjectList() {
        return this.projects;
    }

    public List<Pair<RexLocalRef, String>> getNamedProjects() {
        return new AbstractList<Pair<RexLocalRef, String>>(){

            @Override
            public int size() {
                return RexProgram.this.projects.size();
            }

            @Override
            public Pair<RexLocalRef, String> get(int index) {
                return Pair.of(RexProgram.this.projects.get(index), RexProgram.this.outputRowType.getFieldList().get(index).getName());
            }
        };
    }

    public RexLocalRef getCondition() {
        return this.condition;
    }

    public static RexProgram create(RelDataType inputRowType, List<? extends RexNode> projectExprs, RexNode conditionExpr, RelDataType outputRowType, RexBuilder rexBuilder) {
        return RexProgram.create(inputRowType, projectExprs, conditionExpr, outputRowType.getFieldNames(), rexBuilder);
    }

    public static RexProgram create(RelDataType inputRowType, List<? extends RexNode> projectExprs, RexNode conditionExpr, List<String> fieldNames, RexBuilder rexBuilder) {
        if (fieldNames == null) {
            fieldNames = Collections.nCopies(projectExprs.size(), null);
        } else assert (fieldNames.size() == projectExprs.size()) : "fieldNames=" + fieldNames + ", exprs=" + projectExprs;
        RexProgramBuilder programBuilder = new RexProgramBuilder(inputRowType, rexBuilder);
        for (int i = 0; i < projectExprs.size(); ++i) {
            programBuilder.addProject(projectExprs.get(i), fieldNames.get(i));
        }
        if (conditionExpr != null) {
            programBuilder.addCondition(conditionExpr);
        }
        return programBuilder.getProgram();
    }

    public String toString() {
        RelWriterImpl pw = new RelWriterImpl(new PrintWriter(new StringWriter()));
        this.collectExplainTerms("", pw);
        return pw.simple();
    }

    public RelWriter explainCalc(RelWriter pw) {
        return this.collectExplainTerms("", pw, pw.getDetailLevel());
    }

    public RelWriter collectExplainTerms(String prefix, RelWriter pw) {
        return this.collectExplainTerms(prefix, pw, SqlExplainLevel.EXPPLAN_ATTRIBUTES);
    }

    public RelWriter collectExplainTerms(String prefix, RelWriter pw, SqlExplainLevel level) {
        List<RelDataTypeField> inFields = this.inputRowType.getFieldList();
        List<RelDataTypeField> outFields = this.outputRowType.getFieldList();
        assert (outFields.size() == this.projects.size()) : "outFields.length=" + outFields.size() + ", projects.length=" + this.projects.size();
        pw.item(prefix + "expr#0" + (inFields.size() > 1 ? ".." + (inFields.size() - 1) : ""), "{inputs}");
        for (int i = inFields.size(); i < this.exprs.size(); ++i) {
            pw.item(prefix + "expr#" + i, this.exprs.get(i));
        }
        int trivialCount = 0;
        if (level != SqlExplainLevel.DIGEST_ATTRIBUTES) {
            trivialCount = RexProgram.countTrivial(this.projects);
        }
        switch (trivialCount) {
            case 0: {
                break;
            }
            case 1: {
                trivialCount = 0;
                break;
            }
            default: {
                pw.item(prefix + "proj#0.." + (trivialCount - 1), "{exprs}");
            }
        }
        for (int i = trivialCount; i < this.projects.size(); ++i) {
            pw.item(prefix + outFields.get(i).getName(), this.projects.get(i));
        }
        if (this.condition != null) {
            pw.item(prefix + "$condition", this.condition);
        }
        return pw;
    }

    private static int countTrivial(List<RexLocalRef> refs) {
        for (int i = 0; i < refs.size(); ++i) {
            RexLocalRef ref = refs.get(i);
            if (ref.getIndex() == i) continue;
            return i;
        }
        return refs.size();
    }

    public int getExprCount() {
        return this.exprs.size() + this.projects.size() + (this.condition == null ? 0 : 1);
    }

    public static RexProgram createIdentity(RelDataType rowType) {
        return RexProgram.createIdentity(rowType, rowType);
    }

    public static RexProgram createIdentity(RelDataType rowType, RelDataType outputRowType) {
        if (rowType != outputRowType && !Pair.right(rowType.getFieldList()).equals(Pair.right(outputRowType.getFieldList()))) {
            throw new IllegalArgumentException("field type mismatch: " + rowType + " vs. " + outputRowType);
        }
        List<RelDataTypeField> fields = rowType.getFieldList();
        ArrayList<RexLocalRef> projectRefs = new ArrayList<RexLocalRef>();
        ArrayList<RexInputRef> refs = new ArrayList<RexInputRef>();
        for (int i = 0; i < fields.size(); ++i) {
            RexInputRef ref = RexInputRef.of(i, fields);
            refs.add(ref);
            projectRefs.add(new RexLocalRef(i, ref.getType()));
        }
        return new RexProgram(rowType, refs, projectRefs, null, outputRowType);
    }

    public RelDataType getInputRowType() {
        return this.inputRowType;
    }

    public boolean containsAggs() {
        return RexOver.containsOver(this);
    }

    public RelDataType getOutputRowType() {
        return this.outputRowType;
    }

    public boolean isValid(Litmus litmus, RelNode.Context context) {
        if (this.inputRowType == null) {
            return litmus.fail(null, new Object[0]);
        }
        if (this.exprs == null) {
            return litmus.fail(null, new Object[0]);
        }
        if (this.projects == null) {
            return litmus.fail(null, new Object[0]);
        }
        if (this.outputRowType == null) {
            return litmus.fail(null, new Object[0]);
        }
        if (this.inputRowType.isStruct()) {
            if (!RexUtil.containIdentity(this.exprs, this.inputRowType, litmus)) {
                return litmus.fail(null, new Object[0]);
            }
            for (int i = this.inputRowType.getFieldCount(); i < this.exprs.size(); ++i) {
                RexNode expr = this.exprs.get(i);
                if (!(expr instanceof RexInputRef)) continue;
                return litmus.fail(null, new Object[0]);
            }
        }
        if (!RexUtil.containNoForwardRefs(this.exprs, this.inputRowType, litmus)) {
            return litmus.fail(null, new Object[0]);
        }
        if (!RexUtil.containNoNonTrivialAggs(this.exprs, litmus)) {
            return litmus.fail(null, new Object[0]);
        }
        Checker checker = new Checker(this.inputRowType, RexUtil.types(this.exprs), null, litmus);
        if (this.condition != null) {
            if (!SqlTypeUtil.inBooleanFamily(this.condition.getType())) {
                return litmus.fail("condition must be boolean", new Object[0]);
            }
            this.condition.accept(checker);
            if (checker.failCount > 0) {
                return litmus.fail(null, new Object[0]);
            }
        }
        for (RexLocalRef project : this.projects) {
            project.accept(checker);
            if (checker.failCount <= 0) continue;
            return litmus.fail(null, new Object[0]);
        }
        for (RexNode expr : this.exprs) {
            expr.accept(checker);
            if (checker.failCount <= 0) continue;
            return litmus.fail(null, new Object[0]);
        }
        return litmus.succeed();
    }

    public boolean isNull(RexNode expr) {
        switch (expr.getKind()) {
            case LITERAL: {
                return ((RexLiteral)expr).getValue2() == null;
            }
            case LOCAL_REF: {
                RexLocalRef inputRef = (RexLocalRef)expr;
                return this.isNull(this.exprs.get(inputRef.index));
            }
            case CAST: {
                return this.isNull((RexNode)((RexCall)expr).operands.get(0));
            }
        }
        return false;
    }

    public RexNode expandLocalRef(RexLocalRef ref) {
        return ref.accept(new ExpansionShuttle(this.exprs));
    }

    public Pair<ImmutableList<RexNode>, ImmutableList<RexNode>> split() {
        ArrayList<RexNode> filters = Lists.newArrayList();
        if (this.condition != null) {
            RelOptUtil.decomposeConjunction(this.expandLocalRef(this.condition), filters);
        }
        ImmutableList.Builder projects = ImmutableList.builder();
        for (RexLocalRef project : this.projects) {
            projects.add(this.expandLocalRef(project));
        }
        return Pair.of(projects.build(), ImmutableList.copyOf(filters));
    }

    public List<RelCollation> getCollations(List<RelCollation> inputCollations) {
        ArrayList<RelCollation> outputCollations = new ArrayList<RelCollation>();
        RexProgram.deduceCollations(outputCollations, this.inputRowType.getFieldCount(), this.projects, inputCollations);
        return outputCollations;
    }

    public static void deduceCollations(List<RelCollation> outputCollations, int sourceCount, List<RexLocalRef> refs, List<RelCollation> inputCollations) {
        int[] targets = new int[sourceCount];
        Arrays.fill(targets, -1);
        for (int i = 0; i < refs.size(); ++i) {
            RexLocalRef ref = refs.get(i);
            int source = ref.getIndex();
            if (source >= sourceCount || targets[source] != -1) continue;
            targets[source] = i;
        }
        block1: for (RelCollation collation : inputCollations) {
            ArrayList<RelFieldCollation> fieldCollations = new ArrayList<RelFieldCollation>(0);
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                int source = fieldCollation.getFieldIndex();
                int target = targets[source];
                if (target < 0) continue block1;
                fieldCollations.add(fieldCollation.copy(target));
            }
            outputCollations.add(RelCollations.of(fieldCollations));
        }
        Collections.sort(outputCollations, Ordering.natural());
    }

    public boolean projectsIdentity(boolean fail) {
        int fieldCount = this.inputRowType.getFieldCount();
        if (this.projects.size() < fieldCount) {
            assert (!fail) : "program '" + this.toString() + "' does not project identity for input row type '" + this.inputRowType + "'";
            return false;
        }
        for (int i = 0; i < fieldCount; ++i) {
            RexLocalRef project = this.projects.get(i);
            if (project.index == i) continue;
            assert (!fail) : "program " + this.toString() + "' does not project identity for input row type '" + this.inputRowType + "', field #" + i;
            return false;
        }
        return true;
    }

    public boolean projectsOnlyIdentity() {
        if (this.projects.size() != this.inputRowType.getFieldCount()) {
            return false;
        }
        for (int i = 0; i < this.projects.size(); ++i) {
            RexLocalRef project = this.projects.get(i);
            if (project.index == i) continue;
            return false;
        }
        return true;
    }

    public boolean isTrivial() {
        return this.getCondition() == null && this.projectsOnlyIdentity();
    }

    public int[] getReferenceCounts() {
        if (this.refCounts != null) {
            return this.refCounts;
        }
        this.refCounts = new int[this.exprs.size()];
        ReferenceCounter refCounter = new ReferenceCounter();
        RexUtil.apply((RexVisitor<Void>)refCounter, this.exprs, null);
        if (this.condition != null) {
            refCounter.visitLocalRef(this.condition);
        }
        for (RexLocalRef project : this.projects) {
            refCounter.visitLocalRef(project);
        }
        return this.refCounts;
    }

    public boolean isConstant(RexNode ref) {
        return ref.accept(new ConstantFinder());
    }

    public RexNode gatherExpr(RexNode expr) {
        return expr.accept(new Marshaller());
    }

    public int getSourceField(int outputOrdinal) {
        RexNode expr;
        assert (outputOrdinal >= 0 && outputOrdinal < this.projects.size());
        RexLocalRef project = this.projects.get(outputOrdinal);
        int index = project.index;
        while (true) {
            if ((expr = this.exprs.get(index)) instanceof RexCall && ((RexCall)expr).getOperator() == SqlStdOperatorTable.IN_FENNEL) {
                expr = ((RexCall)expr).getOperands().get(0);
            }
            if (!(expr instanceof RexLocalRef)) break;
            index = ((RexLocalRef)expr).index;
        }
        if (expr instanceof RexInputRef) {
            return ((RexInputRef)expr).index;
        }
        return -1;
    }

    public boolean isPermutation() {
        if (this.projects.size() != this.inputRowType.getFieldList().size()) {
            return false;
        }
        for (int i = 0; i < this.projects.size(); ++i) {
            if (this.getSourceField(i) >= 0) continue;
            return false;
        }
        return true;
    }

    public Permutation getPermutation() {
        Permutation permutation = new Permutation(this.projects.size());
        if (this.projects.size() != this.inputRowType.getFieldList().size()) {
            return null;
        }
        for (int i = 0; i < this.projects.size(); ++i) {
            int sourceField = this.getSourceField(i);
            if (sourceField < 0) {
                return null;
            }
            permutation.set(i, sourceField);
        }
        return permutation;
    }

    public Set<String> getCorrelVariableNames() {
        final HashSet<String> paramIdSet = new HashSet<String>();
        RexUtil.apply((RexVisitor<Void>)new RexVisitorImpl<Void>(true){

            @Override
            public Void visitCorrelVariable(RexCorrelVariable correlVariable) {
                paramIdSet.add(correlVariable.getName());
                return null;
            }
        }, this.exprs, null);
        return paramIdSet;
    }

    public boolean isNormalized(Litmus litmus, RexBuilder rexBuilder) {
        String string;
        RexProgram normalizedProgram = this.normalize(rexBuilder, null);
        String normalized = normalizedProgram.toString();
        if (!normalized.equals(string = this.toString())) {
            String message = "Program is not normalized:\nprogram:    {}\nnormalized: {}\n";
            return litmus.fail("Program is not normalized:\nprogram:    {}\nnormalized: {}\n", string, normalized);
        }
        return litmus.succeed();
    }

    public RexProgram normalize(RexBuilder rexBuilder, RexSimplify simplify) {
        assert (this.isValid(Litmus.THROW, null));
        RexProgramBuilder builder = RexProgramBuilder.create(rexBuilder, this.inputRowType, this.exprs, this.projects, (RexNode)this.condition, this.outputRowType, true, simplify);
        return builder.getProgram(false);
    }

    @Deprecated
    public RexProgram normalize(RexBuilder rexBuilder, boolean simplify) {
        RelOptPredicateList predicates = RelOptPredicateList.EMPTY;
        return this.normalize(rexBuilder, simplify ? new RexSimplify(rexBuilder, predicates, false, RexUtil.EXECUTOR) : null);
    }

    private class ReferenceCounter
    extends RexVisitorImpl<Void> {
        ReferenceCounter() {
            super(true);
        }

        @Override
        public Void visitLocalRef(RexLocalRef localRef) {
            int index = localRef.getIndex();
            int[] nArray = RexProgram.this.refCounts;
            int n = index;
            nArray[n] = nArray[n] + 1;
            return null;
        }
    }

    private class Marshaller
    extends RexVisitorImpl<RexNode> {
        Marshaller() {
            super(false);
        }

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            return inputRef;
        }

        @Override
        public RexNode visitLocalRef(RexLocalRef localRef) {
            RexNode expr = (RexNode)RexProgram.this.exprs.get(localRef.index);
            return expr.accept(this);
        }

        @Override
        public RexNode visitLiteral(RexLiteral literal) {
            return literal;
        }

        @Override
        public RexNode visitCall(RexCall call) {
            ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
            for (RexNode operand : call.getOperands()) {
                newOperands.add(operand.accept(this));
            }
            return call.clone(call.getType(), newOperands);
        }

        @Override
        public RexNode visitOver(RexOver over2) {
            return this.visitCall(over2);
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable correlVariable) {
            return correlVariable;
        }

        @Override
        public RexNode visitDynamicParam(RexDynamicParam dynamicParam) {
            return dynamicParam;
        }

        @Override
        public RexNode visitRangeRef(RexRangeRef rangeRef) {
            return rangeRef;
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode referenceExpr = fieldAccess.getReferenceExpr().accept(this);
            return new RexFieldAccess(referenceExpr, fieldAccess.getField());
        }
    }

    private class ConstantFinder
    extends RexUtil.ConstantFinder {
        private ConstantFinder() {
        }

        @Override
        public Boolean visitLocalRef(RexLocalRef localRef) {
            RexNode expr = (RexNode)RexProgram.this.exprs.get(localRef.index);
            return expr.accept(this);
        }

        @Override
        public Boolean visitOver(RexOver over2) {
            return false;
        }

        @Override
        public Boolean visitCorrelVariable(RexCorrelVariable correlVariable) {
            return true;
        }
    }

    static class ExpansionShuttle
    extends RexShuttle {
        private final List<RexNode> exprs;

        ExpansionShuttle(List<RexNode> exprs) {
            this.exprs = exprs;
        }

        @Override
        public RexNode visitLocalRef(RexLocalRef localRef) {
            RexNode tree = this.exprs.get(localRef.getIndex());
            return tree.accept(this);
        }
    }

    static class Checker
    extends RexChecker {
        private final List<RelDataType> internalExprTypeList;

        Checker(RelDataType inputRowType, List<RelDataType> internalExprTypeList, RelNode.Context context, Litmus litmus) {
            super(inputRowType, context, litmus);
            this.internalExprTypeList = internalExprTypeList;
        }

        @Override
        public Boolean visitLocalRef(RexLocalRef localRef) {
            int index = localRef.getIndex();
            if (index < 0 || index >= this.internalExprTypeList.size()) {
                ++this.failCount;
                return this.litmus.fail(null, new Object[0]);
            }
            if (!RelOptUtil.eq("type1", localRef.getType(), "type2", this.internalExprTypeList.get(index), this.litmus)) {
                ++this.failCount;
                return this.litmus.fail(null, new Object[0]);
            }
            return this.litmus.succeed();
        }
    }
}

