/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import java.util.List;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.BiRel;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributions;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.SingleRel;
import org.apache.calcite.rel.core.Exchange;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.core.Values;
import org.apache.calcite.rel.metadata.BuiltInMetadata;
import org.apache.calcite.rel.metadata.MetadataDef;
import org.apache.calcite.rel.metadata.MetadataHandler;
import org.apache.calcite.rel.metadata.ReflectiveRelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;

public class RelMdDistribution
implements MetadataHandler<BuiltInMetadata.Distribution> {
    public static final RelMetadataProvider SOURCE = ReflectiveRelMetadataProvider.reflectiveSource(BuiltInMethod.DISTRIBUTION.method, new RelMdDistribution());

    private RelMdDistribution() {
    }

    @Override
    public MetadataDef<BuiltInMetadata.Distribution> getDef() {
        return BuiltInMetadata.Distribution.DEF;
    }

    public RelDistribution distribution(RelNode rel, RelMetadataQuery mq) {
        return RelDistributions.SINGLETON;
    }

    public RelDistribution distribution(SingleRel rel, RelMetadataQuery mq) {
        return mq.distribution(rel.getInput());
    }

    public RelDistribution distribution(BiRel rel, RelMetadataQuery mq) {
        return mq.distribution(rel.getLeft());
    }

    public RelDistribution distribution(SetOp rel, RelMetadataQuery mq) {
        return mq.distribution(rel.getInputs().get(0));
    }

    public RelDistribution distribution(TableScan scan, RelMetadataQuery mq) {
        return RelMdDistribution.table(scan.getTable());
    }

    public RelDistribution distribution(Project project, RelMetadataQuery mq) {
        return RelMdDistribution.project(mq, project.getInput(), project.getProjects());
    }

    public RelDistribution distribution(Values values, RelMetadataQuery mq) {
        return RelMdDistribution.values(values.getRowType(), values.getTuples());
    }

    public RelDistribution distribution(Exchange exchange, RelMetadataQuery mq) {
        return RelMdDistribution.exchange(exchange.distribution);
    }

    public RelDistribution distribution(HepRelVertex rel, RelMetadataQuery mq) {
        return mq.distribution(rel.getCurrentRel());
    }

    public static RelDistribution table(RelOptTable table) {
        return table.getDistribution();
    }

    public static RelDistribution sort(RelMetadataQuery mq, RelNode input) {
        return mq.distribution(input);
    }

    public static RelDistribution filter(RelMetadataQuery mq, RelNode input) {
        return mq.distribution(input);
    }

    public static RelDistribution limit(RelMetadataQuery mq, RelNode input) {
        return mq.distribution(input);
    }

    public static RelDistribution calc(RelMetadataQuery mq, RelNode input, RexProgram program) {
        throw new AssertionError();
    }

    public static RelDistribution project(RelMetadataQuery mq, RelNode input, List<? extends RexNode> projects) {
        RelDistribution inputDistribution = mq.distribution(input);
        Mappings.TargetMapping mapping = Project.getPartialMapping(input.getRowType().getFieldCount(), projects);
        return inputDistribution.apply(mapping);
    }

    public static RelDistribution values(RelDataType rowType, ImmutableList<ImmutableList<RexLiteral>> tuples) {
        return RelDistributions.BROADCAST_DISTRIBUTED;
    }

    public static RelDistribution exchange(RelDistribution distribution) {
        return distribution;
    }
}

