/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RexImplicationChecker;
import org.apache.calcite.plan.Strong;
import org.apache.calcite.rel.RelHomogeneousShuttle;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rel.core.SemiJoin;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.externalize.RelJsonWriter;
import org.apache.calcite.rel.externalize.RelWriterImpl;
import org.apache.calcite.rel.externalize.RelXmlWriter;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.AggregateProjectPullUpConstantsRule;
import org.apache.calcite.rel.rules.DateRangeRules;
import org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.calcite.rel.rules.IntersectToDistinctRule;
import org.apache.calcite.rel.rules.MultiJoin;
import org.apache.calcite.rel.rules.ProjectToWindowRule;
import org.apache.calcite.rel.rules.PruneEmptyRules;
import org.apache.calcite.rel.rules.UnionMergeRule;
import org.apache.calcite.rel.rules.UnionPullUpConstantsRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexSqlStandardConvertletTable;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexToSqlNodeConverterImpl;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.runtime.PredicateImpl;
import org.apache.calcite.schema.ModifiableView;
import org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Permutation;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.flink.calcite.shaded.com.google.common.base.Function;
import org.apache.flink.calcite.shaded.com.google.common.base.Predicate;
import org.apache.flink.calcite.shaded.com.google.common.base.Supplier;
import org.apache.flink.calcite.shaded.com.google.common.collect.ImmutableList;
import org.apache.flink.calcite.shaded.com.google.common.collect.Iterables;
import org.apache.flink.calcite.shaded.com.google.common.collect.LinkedHashMultimap;
import org.apache.flink.calcite.shaded.com.google.common.collect.Lists;
import org.apache.flink.calcite.shaded.com.google.common.collect.Maps;
import org.apache.flink.calcite.shaded.com.google.common.collect.Multimap;

public abstract class RelOptUtil {
    public static final double EPSILON = 1.0E-5;
    public static final Predicate<Filter> FILTER_PREDICATE = new PredicateImpl<Filter>(){

        @Override
        public boolean test(Filter filter) {
            return !RexOver.containsOver(filter.getCondition());
        }
    };
    public static final Predicate<Project> PROJECT_PREDICATE = new PredicateImpl<Project>(){

        @Override
        public boolean test(Project project) {
            return !RexOver.containsOver(project.getProjects(), null);
        }
    };
    public static final Predicate<Calc> CALC_PREDICATE = new PredicateImpl<Calc>(){

        @Override
        public boolean test(Calc calc) {
            return !calc.getProgram().containsAggs();
        }
    };
    static final boolean B = false;
    private static final Function<RelDataTypeField, RelDataType> GET_TYPE = new Function<RelDataTypeField, RelDataType>(){

        @Override
        public RelDataType apply(RelDataTypeField field2) {
            return field2.getType();
        }
    };

    public static boolean isPureLimit(RelNode rel) {
        return RelOptUtil.isLimit(rel) && !RelOptUtil.isOrder(rel);
    }

    public static boolean isPureOrder(RelNode rel) {
        return !RelOptUtil.isLimit(rel) && RelOptUtil.isOrder(rel);
    }

    public static boolean isLimit(RelNode rel) {
        return rel instanceof Sort && ((Sort)rel).fetch != null;
    }

    public static boolean isOrder(RelNode rel) {
        return rel instanceof Sort && !((Sort)rel).getCollation().getFieldCollations().isEmpty();
    }

    public static Set<RelOptTable> findTables(RelNode rel) {
        return new LinkedHashSet<RelOptTable>(RelOptUtil.findAllTables(rel));
    }

    public static List<RelOptTable> findAllTables(RelNode rel) {
        Multimap<Class<? extends RelNode>, RelNode> nodes = RelMetadataQuery.instance().getNodeTypes(rel);
        ArrayList<RelOptTable> usedTables = new ArrayList<RelOptTable>();
        for (Map.Entry<Class<? extends RelNode>, Collection<RelNode>> e2 : nodes.asMap().entrySet()) {
            if (!TableScan.class.isAssignableFrom(e2.getKey())) continue;
            for (RelNode node : e2.getValue()) {
                usedTables.add(node.getTable());
            }
        }
        return usedTables;
    }

    public static List<String> findAllTableQualifiedNames(RelNode rel) {
        return Lists.transform(RelOptUtil.findAllTables(rel), new Function<RelOptTable, String>(){

            @Override
            public String apply(RelOptTable arg0) {
                return arg0.getQualifiedName().toString();
            }
        });
    }

    public static Set<CorrelationId> getVariablesSet(RelNode rel) {
        VariableSetVisitor visitor = new VariableSetVisitor();
        RelOptUtil.go(visitor, rel);
        return visitor.variables;
    }

    @Deprecated
    public static List<CorrelationId> getVariablesSetAndUsed(RelNode rel0, RelNode rel1) {
        Set<CorrelationId> set = RelOptUtil.getVariablesSet(rel0);
        if (set.size() == 0) {
            return ImmutableList.of();
        }
        Set<CorrelationId> used = RelOptUtil.getVariablesUsed(rel1);
        if (used.size() == 0) {
            return ImmutableList.of();
        }
        ArrayList<CorrelationId> result = new ArrayList<CorrelationId>();
        for (CorrelationId s : set) {
            if (!used.contains(s) || result.contains(s)) continue;
            result.add(s);
        }
        return result;
    }

    public static Set<CorrelationId> getVariablesUsed(RelNode rel) {
        CorrelationCollector visitor = new CorrelationCollector();
        rel.accept(visitor);
        return ((CorrelationCollector)visitor).vuv.variables;
    }

    public static ImmutableBitSet correlationColumns(CorrelationId id, RelNode rel) {
        CorrelationCollector collector = new CorrelationCollector();
        rel.accept(collector);
        ImmutableBitSet.Builder builder = ImmutableBitSet.builder();
        for (int field2 : ((CorrelationCollector)collector).vuv.variableFields.get(id)) {
            if (field2 < 0) continue;
            builder.set(field2);
        }
        return builder.build();
    }

    public static boolean notContainsCorrelation(RelNode r, CorrelationId correlationId, Litmus litmus) {
        Set<CorrelationId> set = RelOptUtil.getVariablesUsed(r);
        if (!set.contains(correlationId)) {
            return litmus.succeed();
        }
        return litmus.fail("contains {}", correlationId);
    }

    public static void go(RelVisitor visitor, RelNode p) {
        try {
            visitor.go(p);
        }
        catch (Exception e2) {
            throw new RuntimeException("while visiting tree", e2);
        }
    }

    public static List<RelDataType> getFieldTypeList(RelDataType type) {
        return Lists.transform(type.getFieldList(), GET_TYPE);
    }

    public static boolean areRowTypesEqual(RelDataType rowType1, RelDataType rowType2, boolean compareNames) {
        if (rowType1 == rowType2) {
            return true;
        }
        if (compareNames) {
            return false;
        }
        if (rowType2.getFieldCount() != rowType1.getFieldCount()) {
            return false;
        }
        List<RelDataTypeField> f1 = rowType1.getFieldList();
        List<RelDataTypeField> f2 = rowType2.getFieldList();
        for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(f1, f2)) {
            RelDataType type1 = ((RelDataTypeField)pair.left).getType();
            RelDataType type2 = ((RelDataTypeField)pair.right).getType();
            if (type1.getSqlTypeName() == SqlTypeName.ANY || type2.getSqlTypeName() == SqlTypeName.ANY || type1.equals(type2)) continue;
            return false;
        }
        return true;
    }

    public static void verifyTypeEquivalence(RelNode originalRel, RelNode newRel, Object equivalenceClass) {
        RelDataType actualRowType;
        RelDataType expectedRowType = originalRel.getRowType();
        if (RelOptUtil.areRowTypesEqual(expectedRowType, actualRowType = newRel.getRowType(), false)) {
            return;
        }
        String s = "Cannot add expression of different type to set:\nset type is " + expectedRowType.getFullTypeString() + "\nexpression type is " + actualRowType.getFullTypeString() + "\nset is " + equivalenceClass.toString() + "\nexpression is " + newRel.toString();
        throw new AssertionError((Object)s);
    }

    public static Mappings.TargetMapping permutationIgnoreCast(List<RexNode> nodes, RelDataType inputRowType) {
        Mapping mapping = Mappings.create(MappingType.PARTIAL_FUNCTION, nodes.size(), inputRowType.getFieldCount());
        for (Ord<RexNode> node : Ord.zip(nodes)) {
            RexNode operand;
            if (node.e instanceof RexInputRef) {
                mapping.set(node.i, ((RexInputRef)node.e).getIndex());
                continue;
            }
            if (!((RexNode)node.e).isA(SqlKind.CAST) || !((operand = ((RexCall)node.e).getOperands().get(0)) instanceof RexInputRef)) continue;
            mapping.set(node.i, ((RexInputRef)operand).getIndex());
        }
        return mapping;
    }

    public static Mappings.TargetMapping permutation(List<RexNode> nodes, RelDataType inputRowType) {
        Mapping mapping = Mappings.create(MappingType.PARTIAL_FUNCTION, nodes.size(), inputRowType.getFieldCount());
        for (Ord<RexNode> node : Ord.zip(nodes)) {
            if (!(node.e instanceof RexInputRef)) continue;
            mapping.set(node.i, ((RexInputRef)node.e).getIndex());
        }
        return mapping;
    }

    @Deprecated
    public static RelNode createExistsPlan(RelOptCluster cluster, RelNode seekRel, List<RexNode> conditions, RexLiteral extraExpr, String extraName) {
        assert (extraExpr == null || extraName != null);
        RelNode ret = seekRel;
        if (conditions != null && conditions.size() > 0) {
            RexNode conditionExp = RexUtil.composeConjunction(cluster.getRexBuilder(), conditions, true);
            RelFactories.FilterFactory factory = RelFactories.DEFAULT_FILTER_FACTORY;
            ret = factory.createFilter(ret, conditionExp);
        }
        if (extraExpr != null) {
            RexBuilder rexBuilder = cluster.getRexBuilder();
            RelDataTypeFactory typeFactory = rexBuilder.getTypeFactory();
            assert (extraExpr == rexBuilder.makeLiteral(true));
            ret = RelOptUtil.createProject(ret, ImmutableList.of(extraExpr), null);
            AggregateCall aggCall = AggregateCall.create(SqlStdOperatorTable.MIN, false, false, ImmutableList.of(Integer.valueOf(0)), -1, 0, ret, null, extraName);
            ret = LogicalAggregate.create(ret, ImmutableBitSet.of(), null, ImmutableList.of(aggCall));
        }
        return ret;
    }

    public static Exists createExistsPlan(RelNode seekRel, SubQueryType subQueryType, Logic logic2, boolean notIn) {
        boolean outerJoin;
        switch (subQueryType) {
            case SCALAR: {
                return new Exists(seekRel, false, true);
            }
        }
        switch (logic2) {
            case TRUE_FALSE_UNKNOWN: 
            case UNKNOWN_AS_TRUE: {
                if (!notIn || RelOptUtil.containsNullableFields(seekRel)) break;
                logic2 = Logic.TRUE_FALSE;
            }
        }
        RelNode ret = seekRel;
        RelOptCluster cluster = seekRel.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        int keyCount = ret.getRowType().getFieldCount();
        boolean bl = outerJoin = notIn || logic2 == Logic.TRUE_FALSE_UNKNOWN;
        if (!outerJoin) {
            LogicalAggregate aggregate = LogicalAggregate.create(ret, ImmutableBitSet.range(keyCount), null, ImmutableList.of());
            return new Exists(aggregate, false, false);
        }
        ArrayList<RexNode> exprs = new ArrayList<RexNode>();
        if (subQueryType == SubQueryType.IN) {
            for (int i = 0; i < keyCount; ++i) {
                exprs.add(rexBuilder.makeInputRef(ret, i));
            }
        }
        int projectedKeyCount = exprs.size();
        exprs.add(rexBuilder.makeLiteral(true));
        ret = RelOptUtil.createProject(ret, exprs, null);
        AggregateCall aggCall = AggregateCall.create(SqlStdOperatorTable.MIN, false, false, ImmutableList.of(Integer.valueOf(projectedKeyCount)), -1, projectedKeyCount, ret, null, null);
        ret = LogicalAggregate.create(ret, ImmutableBitSet.range(projectedKeyCount), null, ImmutableList.of(aggCall));
        switch (logic2) {
            case TRUE_FALSE_UNKNOWN: 
            case UNKNOWN_AS_TRUE: {
                return new Exists(ret, true, true);
            }
        }
        return new Exists(ret, false, true);
    }

    @Deprecated
    public static RelNode createRenameRel(RelDataType outputType, RelNode rel) {
        RelDataType inputType = rel.getRowType();
        List<RelDataTypeField> inputFields = inputType.getFieldList();
        int n = inputFields.size();
        List<RelDataTypeField> outputFields = outputType.getFieldList();
        assert (outputFields.size() == n) : "rename: field count mismatch: in=" + inputType + ", out" + outputType;
        ArrayList<Pair<RexInputRef, String>> renames = new ArrayList<Pair<RexInputRef, String>>();
        for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(inputFields, outputFields)) {
            RelDataTypeField inputField = (RelDataTypeField)pair.left;
            RelDataTypeField outputField = (RelDataTypeField)pair.right;
            assert (inputField.getType().equals(outputField.getType()));
            RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
            renames.add(Pair.of(rexBuilder.makeInputRef(inputField.getType(), inputField.getIndex()), outputField.getName()));
        }
        return RelOptUtil.createProject(rel, Pair.left(renames), Pair.right(renames));
    }

    @Deprecated
    public static RelNode createFilter(RelNode child, RexNode condition) {
        RelFactories.FilterFactory factory = RelFactories.DEFAULT_FILTER_FACTORY;
        return factory.createFilter(child, condition);
    }

    @Deprecated
    public static RelNode createFilter(RelNode child, RexNode condition, RelFactories.FilterFactory filterFactory) {
        return filterFactory.createFilter(child, condition);
    }

    public static RelNode createFilter(RelNode child, Iterable<? extends RexNode> conditions) {
        return RelOptUtil.createFilter(child, conditions, RelFactories.DEFAULT_FILTER_FACTORY);
    }

    public static RelNode createFilter(RelNode child, Iterable<? extends RexNode> conditions, RelFactories.FilterFactory filterFactory) {
        RelOptCluster cluster = child.getCluster();
        RexNode condition = RexUtil.composeConjunction(cluster.getRexBuilder(), conditions, true);
        if (condition == null) {
            return child;
        }
        return filterFactory.createFilter(child, condition);
    }

    @Deprecated
    public static RelNode createNullFilter(RelNode rel, Integer[] fieldOrdinals) {
        RexNode condition = null;
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        RelDataType rowType = rel.getRowType();
        int n = fieldOrdinals != null ? fieldOrdinals.length : rowType.getFieldCount();
        List<RelDataTypeField> fields = rowType.getFieldList();
        for (int i = 0; i < n; ++i) {
            int iField = fieldOrdinals != null ? fieldOrdinals[i] : i;
            RelDataType type = fields.get(iField).getType();
            if (!type.isNullable()) continue;
            RexNode newCondition = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, rexBuilder.makeInputRef(type, iField));
            condition = condition == null ? newCondition : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, condition, newCondition);
        }
        if (condition == null) {
            return rel;
        }
        RelFactories.FilterFactory factory = RelFactories.DEFAULT_FILTER_FACTORY;
        return factory.createFilter(rel, condition);
    }

    public static RelNode createCastRel(RelNode rel, RelDataType castRowType, boolean rename) {
        return RelOptUtil.createCastRel(rel, castRowType, rename, RelFactories.DEFAULT_PROJECT_FACTORY);
    }

    public static RelNode createCastRel(RelNode rel, RelDataType castRowType, boolean rename, RelFactories.ProjectFactory projectFactory) {
        assert (projectFactory != null);
        RelDataType rowType = rel.getRowType();
        if (RelOptUtil.areRowTypesEqual(rowType, castRowType, rename)) {
            return rel;
        }
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        List<RexNode> castExps = RexUtil.generateCastExpressions(rexBuilder, castRowType, rowType);
        if (rename) {
            return projectFactory.createProject(rel, castExps, castRowType.getFieldNames());
        }
        return projectFactory.createProject(rel, castExps, rowType.getFieldNames());
    }

    public static RelNode createSingleValueAggRel(RelOptCluster cluster, RelNode rel) {
        int aggCallCnt = rel.getRowType().getFieldCount();
        ArrayList<AggregateCall> aggCalls = new ArrayList<AggregateCall>();
        for (int i = 0; i < aggCallCnt; ++i) {
            aggCalls.add(AggregateCall.create(SqlStdOperatorTable.SINGLE_VALUE, false, false, ImmutableList.of(Integer.valueOf(i)), -1, 0, rel, null, null));
        }
        return LogicalAggregate.create(rel, ImmutableBitSet.of(), null, aggCalls);
    }

    @Deprecated
    public static RelNode createDistinctRel(RelNode rel) {
        return LogicalAggregate.create(rel, ImmutableBitSet.range(rel.getRowType().getFieldCount()), null, ImmutableList.of());
    }

    @Deprecated
    public static boolean analyzeSimpleEquiJoin(LogicalJoin join, int[] joinFieldOrdinals) {
        RexNode joinExp = join.getCondition();
        if (joinExp.getKind() != SqlKind.EQUALS) {
            return false;
        }
        RexCall binaryExpression = (RexCall)joinExp;
        RexNode leftComparand = (RexNode)binaryExpression.operands.get(0);
        RexNode rightComparand = (RexNode)binaryExpression.operands.get(1);
        if (!(leftComparand instanceof RexInputRef)) {
            return false;
        }
        if (!(rightComparand instanceof RexInputRef)) {
            return false;
        }
        int leftFieldCount = join.getLeft().getRowType().getFieldCount();
        RexInputRef leftFieldAccess = (RexInputRef)leftComparand;
        if (leftFieldAccess.getIndex() >= leftFieldCount) {
            return false;
        }
        RexInputRef rightFieldAccess = (RexInputRef)rightComparand;
        if (rightFieldAccess.getIndex() < leftFieldCount) {
            return false;
        }
        joinFieldOrdinals[0] = leftFieldAccess.getIndex();
        joinFieldOrdinals[1] = rightFieldAccess.getIndex() - leftFieldCount;
        return true;
    }

    public static RexNode splitJoinCondition(RelNode left, RelNode right, RexNode condition, List<Integer> leftKeys, List<Integer> rightKeys, List<Boolean> filterNulls) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitJoinCondition(left.getCluster().getRexBuilder(), left.getRowType().getFieldCount(), condition, leftKeys, rightKeys, filterNulls, nonEquiList);
        return RexUtil.composeConjunction(left.getCluster().getRexBuilder(), nonEquiList, false);
    }

    @Deprecated
    public static boolean isEqui(RelNode left, RelNode right, RexNode condition) {
        ArrayList<Integer> leftKeys = new ArrayList<Integer>();
        ArrayList<Integer> rightKeys = new ArrayList<Integer>();
        ArrayList<Boolean> filterNulls = new ArrayList<Boolean>();
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitJoinCondition(left.getCluster().getRexBuilder(), left.getRowType().getFieldCount(), condition, leftKeys, rightKeys, filterNulls, nonEquiList);
        return nonEquiList.size() == 0;
    }

    public static RexNode splitJoinCondition(List<RelDataTypeField> sysFieldList, RelNode leftRel, RelNode rightRel, RexNode condition, List<RexNode> leftJoinKeys, List<RexNode> rightJoinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp) {
        return RelOptUtil.splitJoinCondition(sysFieldList, ImmutableList.of(leftRel, rightRel), condition, ImmutableList.of(leftJoinKeys, rightJoinKeys), filterNulls, rangeOp);
    }

    public static RexNode splitJoinCondition(List<RelDataTypeField> sysFieldList, List<RelNode> inputs, RexNode condition, List<List<RexNode>> joinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitJoinCondition(sysFieldList, inputs, condition, joinKeys, filterNulls, rangeOp, nonEquiList);
        return RexUtil.composeConjunction(inputs.get(0).getCluster().getRexBuilder(), nonEquiList, false);
    }

    @Deprecated
    public static RexNode splitCorrelatedFilterCondition(LogicalFilter filter, List<RexInputRef> joinKeys, List<RexNode> correlatedJoinKeys) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitCorrelatedFilterCondition(filter, filter.getCondition(), joinKeys, correlatedJoinKeys, nonEquiList);
        return RexUtil.composeConjunction(filter.getCluster().getRexBuilder(), nonEquiList, true);
    }

    public static RexNode splitCorrelatedFilterCondition(LogicalFilter filter, List<RexNode> joinKeys, List<RexNode> correlatedJoinKeys, boolean extractCorrelatedFieldAccess) {
        ArrayList<RexNode> nonEquiList = new ArrayList<RexNode>();
        RelOptUtil.splitCorrelatedFilterCondition(filter, filter.getCondition(), joinKeys, correlatedJoinKeys, nonEquiList, extractCorrelatedFieldAccess);
        return RexUtil.composeConjunction(filter.getCluster().getRexBuilder(), nonEquiList, true);
    }

    private static void splitJoinCondition(List<RelDataTypeField> sysFieldList, List<RelNode> inputs, RexNode condition, List<List<RexNode>> joinKeys, List<Integer> filterNulls, List<SqlOperator> rangeOp, List<RexNode> nonEquiList) {
        int sysFieldCount = sysFieldList.size();
        RelOptCluster cluster = inputs.get(0).getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        ImmutableBitSet[] inputsRange = new ImmutableBitSet[inputs.size()];
        int totalFieldCount = 0;
        for (int i = 0; i < inputs.size(); ++i) {
            int firstField = totalFieldCount + sysFieldCount;
            totalFieldCount = firstField + inputs.get(i).getRowType().getFieldCount();
            inputsRange[i] = ImmutableBitSet.range(firstField, totalFieldCount);
        }
        int[] adjustments = new int[totalFieldCount];
        for (int i = 0; i < inputs.size(); ++i) {
            int adjustment;
            for (int j2 = adjustment = inputsRange[i].nextSetBit(0); j2 < inputsRange[i].length(); ++j2) {
                adjustments[j2] = -adjustment;
            }
        }
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getKind() == SqlKind.AND) {
                for (RexNode operand : call.getOperands()) {
                    RelOptUtil.splitJoinCondition(sysFieldList, inputs, operand, joinKeys, filterNulls, rangeOp, nonEquiList);
                }
                return;
            }
            RexNode leftKey = null;
            RexNode rightKey = null;
            int leftInput = 0;
            int rightInput = 0;
            List<RelDataTypeField> leftFields = null;
            List<RelDataTypeField> rightFields = null;
            boolean reverse = false;
            SqlKind kind = (call = RelOptUtil.collapseExpandedIsNotDistinctFromExpr(call, rexBuilder)).getKind();
            if (kind == SqlKind.EQUALS || filterNulls != null && kind == SqlKind.IS_NOT_DISTINCT_FROM || rangeOp != null && rangeOp.isEmpty() && (kind == SqlKind.GREATER_THAN || kind == SqlKind.GREATER_THAN_OR_EQUAL || kind == SqlKind.LESS_THAN || kind == SqlKind.LESS_THAN_OR_EQUAL)) {
                List<RexNode> operands = call.getOperands();
                RexNode op0 = operands.get(0);
                RexNode op1 = operands.get(1);
                ImmutableBitSet projRefs0 = InputFinder.bits(op0);
                ImmutableBitSet projRefs1 = InputFinder.bits(op1);
                boolean foundBothInputs = false;
                for (int i = 0; i < inputs.size() && !foundBothInputs; ++i) {
                    if (projRefs0.intersects(inputsRange[i]) && projRefs0.union(inputsRange[i]).equals(inputsRange[i])) {
                        if (leftKey == null) {
                            leftKey = op0;
                            leftInput = i;
                            leftFields = inputs.get(leftInput).getRowType().getFieldList();
                            continue;
                        }
                        rightKey = op0;
                        rightInput = i;
                        rightFields = inputs.get(rightInput).getRowType().getFieldList();
                        reverse = true;
                        foundBothInputs = true;
                        continue;
                    }
                    if (!projRefs1.intersects(inputsRange[i]) || !projRefs1.union(inputsRange[i]).equals(inputsRange[i])) continue;
                    if (leftKey == null) {
                        leftKey = op1;
                        leftInput = i;
                        leftFields = inputs.get(leftInput).getRowType().getFieldList();
                        continue;
                    }
                    rightKey = op1;
                    rightInput = i;
                    rightFields = inputs.get(rightInput).getRowType().getFieldList();
                    foundBothInputs = true;
                }
                if (leftKey != null && rightKey != null) {
                    RelDataType rightKeyType;
                    rightKey = rightKey.accept(new RexInputConverter(rexBuilder, rightFields, rightFields, adjustments));
                    RelDataType leftKeyType = (leftKey = leftKey.accept(new RexInputConverter(rexBuilder, leftFields, leftFields, adjustments))).getType();
                    if (leftKeyType != (rightKeyType = rightKey.getType())) {
                        RelDataType targetKeyType = typeFactory.leastRestrictive(ImmutableList.of(leftKeyType, rightKeyType));
                        if (targetKeyType == null) {
                            throw new AssertionError((Object)("Cannot find common type for join keys " + leftKey + " (type " + leftKeyType + ") and " + rightKey + " (type " + rightKeyType + ")"));
                        }
                        if (leftKeyType != targetKeyType) {
                            leftKey = rexBuilder.makeCast(targetKeyType, leftKey);
                        }
                        if (rightKeyType != targetKeyType) {
                            rightKey = rexBuilder.makeCast(targetKeyType, rightKey);
                        }
                    }
                }
            }
            if (rangeOp == null && (leftKey == null || rightKey == null)) {
                ImmutableBitSet projRefs = InputFinder.bits(condition);
                leftKey = null;
                rightKey = null;
                boolean foundInput = false;
                for (int i = 0; i < inputs.size() && !foundInput; ++i) {
                    if (!inputsRange[i].contains(projRefs)) continue;
                    leftInput = i;
                    leftFields = inputs.get(leftInput).getRowType().getFieldList();
                    leftKey = condition.accept(new RexInputConverter(rexBuilder, leftFields, leftFields, adjustments));
                    rightKey = rexBuilder.makeLiteral(true);
                    kind = SqlKind.EQUALS;
                    foundInput = true;
                }
            }
            if (leftKey != null && rightKey != null) {
                RelOptUtil.addJoinKey(joinKeys.get(leftInput), leftKey, rangeOp != null && !rangeOp.isEmpty());
                RelOptUtil.addJoinKey(joinKeys.get(rightInput), rightKey, rangeOp != null && !rangeOp.isEmpty());
                if (filterNulls != null && kind == SqlKind.EQUALS) {
                    filterNulls.add(joinKeys.get(leftInput).size() - 1);
                }
                if (rangeOp != null && kind != SqlKind.EQUALS && kind != SqlKind.IS_DISTINCT_FROM) {
                    if (reverse) {
                        kind = kind.reverse();
                    }
                    rangeOp.add(RelOptUtil.op(kind, call.getOperator()));
                }
                return;
            }
        }
        nonEquiList.add(condition);
    }

    public static RexNode createEquiJoinCondition(RelNode left, final List<Integer> leftKeys, RelNode right, final List<Integer> rightKeys, final RexBuilder rexBuilder) {
        final List<RelDataType> leftTypes = RelOptUtil.getFieldTypeList(left.getRowType());
        final List<RelDataType> rightTypes = RelOptUtil.getFieldTypeList(right.getRowType());
        return RexUtil.composeConjunction(rexBuilder, (Iterable<? extends RexNode>)new AbstractList<RexNode>(){

            @Override
            public RexNode get(int index) {
                int leftKey = (Integer)leftKeys.get(index);
                int rightKey = (Integer)rightKeys.get(index);
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, rexBuilder.makeInputRef((RelDataType)leftTypes.get(leftKey), leftKey), rexBuilder.makeInputRef((RelDataType)rightTypes.get(rightKey), leftTypes.size() + rightKey));
            }

            @Override
            public int size() {
                return leftKeys.size();
            }
        }, false);
    }

    public static SqlOperator op(SqlKind kind, SqlOperator operator) {
        switch (kind) {
            case EQUALS: {
                return SqlStdOperatorTable.EQUALS;
            }
            case NOT_EQUALS: {
                return SqlStdOperatorTable.NOT_EQUALS;
            }
            case GREATER_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case IS_DISTINCT_FROM: {
                return SqlStdOperatorTable.IS_DISTINCT_FROM;
            }
            case IS_NOT_DISTINCT_FROM: {
                return SqlStdOperatorTable.IS_NOT_DISTINCT_FROM;
            }
        }
        return operator;
    }

    private static void addJoinKey(List<RexNode> joinKeyList, RexNode key, boolean preserveLastElementInList) {
        if (!joinKeyList.isEmpty() && preserveLastElementInList) {
            joinKeyList.add(joinKeyList.size() - 1, key);
        } else {
            joinKeyList.add(key);
        }
    }

    private static void splitCorrelatedFilterCondition(LogicalFilter filter, RexNode condition, List<RexInputRef> joinKeys, List<RexNode> correlatedJoinKeys, List<RexNode> nonEquiList) {
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getOperator().getKind() == SqlKind.AND) {
                for (RexNode operand : call.getOperands()) {
                    RelOptUtil.splitCorrelatedFilterCondition(filter, operand, joinKeys, correlatedJoinKeys, nonEquiList);
                }
                return;
            }
            if (call.getOperator().getKind() == SqlKind.EQUALS) {
                List<RexNode> operands = call.getOperands();
                RexNode op0 = operands.get(0);
                RexNode op1 = operands.get(1);
                if (!RexUtil.containsInputRef(op0) && op1 instanceof RexInputRef) {
                    correlatedJoinKeys.add(op0);
                    joinKeys.add((RexInputRef)op1);
                    return;
                }
                if (op0 instanceof RexInputRef && !RexUtil.containsInputRef(op1)) {
                    joinKeys.add((RexInputRef)op0);
                    correlatedJoinKeys.add(op1);
                    return;
                }
            }
        }
        nonEquiList.add(condition);
    }

    private static void splitCorrelatedFilterCondition(LogicalFilter filter, RexNode condition, List<RexNode> joinKeys, List<RexNode> correlatedJoinKeys, List<RexNode> nonEquiList, boolean extractCorrelatedFieldAccess) {
        if (condition instanceof RexCall) {
            RexCall call = (RexCall)condition;
            if (call.getOperator().getKind() == SqlKind.AND) {
                for (RexNode operand : call.getOperands()) {
                    RelOptUtil.splitCorrelatedFilterCondition(filter, operand, joinKeys, correlatedJoinKeys, nonEquiList, extractCorrelatedFieldAccess);
                }
                return;
            }
            if (call.getOperator().getKind() == SqlKind.EQUALS) {
                List<RexNode> operands = call.getOperands();
                RexNode op0 = operands.get(0);
                RexNode op1 = operands.get(1);
                if (extractCorrelatedFieldAccess) {
                    if (!RexUtil.containsFieldAccess(op0) && op1 instanceof RexFieldAccess) {
                        joinKeys.add(op0);
                        correlatedJoinKeys.add(op1);
                        return;
                    }
                    if (op0 instanceof RexFieldAccess && !RexUtil.containsFieldAccess(op1)) {
                        correlatedJoinKeys.add(op0);
                        joinKeys.add(op1);
                        return;
                    }
                } else {
                    if (!RexUtil.containsInputRef(op0) && op1 instanceof RexInputRef) {
                        correlatedJoinKeys.add(op0);
                        joinKeys.add(op1);
                        return;
                    }
                    if (op0 instanceof RexInputRef && !RexUtil.containsInputRef(op1)) {
                        joinKeys.add(op0);
                        correlatedJoinKeys.add(op1);
                        return;
                    }
                }
            }
        }
        nonEquiList.add(condition);
    }

    private static void splitJoinCondition(RexBuilder rexBuilder, int leftFieldCount, RexNode condition, List<Integer> leftKeys, List<Integer> rightKeys, List<Boolean> filterNulls, List<RexNode> nonEquiList) {
        if (condition instanceof RexCall) {
            List<RexNode> operands;
            RexCall call = (RexCall)condition;
            SqlKind kind = call.getKind();
            if (kind == SqlKind.AND) {
                for (RexNode operand : call.getOperands()) {
                    RelOptUtil.splitJoinCondition(rexBuilder, leftFieldCount, operand, leftKeys, rightKeys, filterNulls, nonEquiList);
                }
                return;
            }
            if (filterNulls != null) {
                call = RelOptUtil.collapseExpandedIsNotDistinctFromExpr(call, rexBuilder);
                kind = call.getKind();
            }
            if ((kind == SqlKind.EQUALS || filterNulls != null && kind == SqlKind.IS_NOT_DISTINCT_FROM) && (operands = call.getOperands()).get(0) instanceof RexInputRef && operands.get(1) instanceof RexInputRef) {
                RexInputRef rightField;
                RexInputRef leftField;
                RexInputRef op0 = (RexInputRef)operands.get(0);
                RexInputRef op1 = (RexInputRef)operands.get(1);
                if (op0.getIndex() < leftFieldCount && op1.getIndex() >= leftFieldCount) {
                    leftField = op0;
                    rightField = op1;
                } else if (op1.getIndex() < leftFieldCount && op0.getIndex() >= leftFieldCount) {
                    leftField = op1;
                    rightField = op0;
                } else {
                    nonEquiList.add(condition);
                    return;
                }
                leftKeys.add(leftField.getIndex());
                rightKeys.add(rightField.getIndex() - leftFieldCount);
                if (filterNulls != null) {
                    filterNulls.add(kind == SqlKind.EQUALS);
                }
                return;
            }
        }
        if (!condition.isAlwaysTrue()) {
            nonEquiList.add(condition);
        }
    }

    private static RexCall collapseExpandedIsNotDistinctFromExpr(RexCall call, RexBuilder rexBuilder) {
        if (call.getKind() != SqlKind.OR || call.getOperands().size() != 2) {
            return call;
        }
        RexNode op0 = call.getOperands().get(0);
        RexNode op1 = call.getOperands().get(1);
        if (!(op0 instanceof RexCall) || !(op1 instanceof RexCall)) {
            return call;
        }
        RexCall opEqCall = (RexCall)op0;
        RexCall opNullEqCall = (RexCall)op1;
        if (opEqCall.getKind() == SqlKind.AND && opNullEqCall.getKind() == SqlKind.EQUALS) {
            RexCall temp = opEqCall;
            opEqCall = opNullEqCall;
            opNullEqCall = temp;
        }
        if (opNullEqCall.getKind() != SqlKind.AND || opNullEqCall.getOperands().size() != 2 || opEqCall.getKind() != SqlKind.EQUALS) {
            return call;
        }
        RexNode op10 = opNullEqCall.getOperands().get(0);
        RexNode op11 = opNullEqCall.getOperands().get(1);
        if (op10.getKind() != SqlKind.IS_NULL || op11.getKind() != SqlKind.IS_NULL) {
            return call;
        }
        RexNode isNullInput0 = ((RexCall)op10).getOperands().get(0);
        RexNode isNullInput1 = ((RexCall)op11).getOperands().get(0);
        String isNullInput0Digest = isNullInput0.toString();
        String isNullInput1Digest = isNullInput1.toString();
        String equalsInput0Digest = opEqCall.getOperands().get(0).toString();
        String equalsInput1Digest = opEqCall.getOperands().get(1).toString();
        if (isNullInput0Digest.equals(equalsInput0Digest) && isNullInput1Digest.equals(equalsInput1Digest) || isNullInput1Digest.equals(equalsInput0Digest) && isNullInput0Digest.equals(equalsInput1Digest)) {
            return (RexCall)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM, ImmutableList.of(isNullInput0, isNullInput1));
        }
        return call;
    }

    @Deprecated
    public static void projectJoinInputs(RelNode[] inputRels, List<RexNode> leftJoinKeys, List<RexNode> rightJoinKeys, int systemColCount, List<Integer> leftKeys, List<Integer> rightKeys, List<Integer> outputProj) {
        int i;
        RelNode leftRel = inputRels[0];
        RelNode rightRel = inputRels[1];
        RelOptCluster cluster = leftRel.getCluster();
        RexBuilder rexBuilder = cluster.getRexBuilder();
        RelDataTypeSystem typeSystem = cluster.getTypeFactory().getTypeSystem();
        int origLeftInputSize = leftRel.getRowType().getFieldCount();
        int origRightInputSize = rightRel.getRowType().getFieldCount();
        ArrayList<RexNode> newLeftFields = new ArrayList<RexNode>();
        ArrayList<String> newLeftFieldNames = new ArrayList<String>();
        ArrayList<RexNode> newRightFields = new ArrayList<RexNode>();
        ArrayList<String> newRightFieldNames = new ArrayList<String>();
        int leftKeyCount = leftJoinKeys.size();
        int rightKeyCount = rightJoinKeys.size();
        for (i = 0; i < systemColCount; ++i) {
            outputProj.add(i);
        }
        for (i = 0; i < origLeftInputSize; ++i) {
            RelDataTypeField field2 = leftRel.getRowType().getFieldList().get(i);
            newLeftFields.add(rexBuilder.makeInputRef(field2.getType(), i));
            newLeftFieldNames.add(field2.getName());
            outputProj.add(systemColCount + i);
        }
        int newLeftKeyCount = 0;
        for (i = 0; i < leftKeyCount; ++i) {
            RexNode leftKey = leftJoinKeys.get(i);
            if (leftKey instanceof RexInputRef) {
                leftKeys.add(((RexInputRef)leftKey).getIndex());
                continue;
            }
            newLeftFields.add(leftKey);
            newLeftFieldNames.add(null);
            leftKeys.add(origLeftInputSize + newLeftKeyCount);
            ++newLeftKeyCount;
        }
        int leftFieldCount = origLeftInputSize + newLeftKeyCount;
        for (i = 0; i < origRightInputSize; ++i) {
            RelDataTypeField field3 = rightRel.getRowType().getFieldList().get(i);
            newRightFields.add(rexBuilder.makeInputRef(field3.getType(), i));
            newRightFieldNames.add(field3.getName());
            outputProj.add(systemColCount + leftFieldCount + i);
        }
        int newRightKeyCount = 0;
        for (i = 0; i < rightKeyCount; ++i) {
            RexNode rightKey = rightJoinKeys.get(i);
            if (rightKey instanceof RexInputRef) {
                rightKeys.add(((RexInputRef)rightKey).getIndex());
                continue;
            }
            newRightFields.add(rightKey);
            newRightFieldNames.add(null);
            rightKeys.add(origRightInputSize + newRightKeyCount);
            ++newRightKeyCount;
        }
        if (newLeftKeyCount > 0) {
            leftRel = RelOptUtil.createProject(leftRel, newLeftFields, SqlValidatorUtil.uniquify(newLeftFieldNames, typeSystem.isSchemaCaseSensitive()));
        }
        if (newRightKeyCount > 0) {
            rightRel = RelOptUtil.createProject(rightRel, newRightFields, SqlValidatorUtil.uniquify(newRightFieldNames, typeSystem.isSchemaCaseSensitive()));
        }
        inputRels[0] = leftRel;
        inputRels[1] = rightRel;
    }

    @Deprecated
    public static RelNode createProjectJoinRel(List<Integer> outputProj, RelNode joinRel) {
        int newProjectOutputSize = outputProj.size();
        List<RelDataTypeField> joinOutputFields = joinRel.getRowType().getFieldList();
        if (newProjectOutputSize > 0 && newProjectOutputSize < joinOutputFields.size()) {
            ArrayList<Pair<RexInputRef, String>> newProjects = new ArrayList<Pair<RexInputRef, String>>();
            RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
            for (int fieldIndex : outputProj) {
                RelDataTypeField field2 = joinOutputFields.get(fieldIndex);
                newProjects.add(Pair.of(rexBuilder.makeInputRef(field2.getType(), fieldIndex), field2.getName()));
            }
            return RelOptUtil.createProject(joinRel, Pair.left(newProjects), Pair.right(newProjects));
        }
        return joinRel;
    }

    public static void registerAbstractRels(RelOptPlanner planner) {
        planner.addRule(AggregateProjectPullUpConstantsRule.INSTANCE2);
        planner.addRule(UnionPullUpConstantsRule.INSTANCE);
        planner.addRule(PruneEmptyRules.UNION_INSTANCE);
        planner.addRule(PruneEmptyRules.INTERSECT_INSTANCE);
        planner.addRule(PruneEmptyRules.MINUS_INSTANCE);
        planner.addRule(PruneEmptyRules.PROJECT_INSTANCE);
        planner.addRule(PruneEmptyRules.FILTER_INSTANCE);
        planner.addRule(PruneEmptyRules.SORT_INSTANCE);
        planner.addRule(PruneEmptyRules.AGGREGATE_INSTANCE);
        planner.addRule(PruneEmptyRules.JOIN_LEFT_INSTANCE);
        planner.addRule(PruneEmptyRules.JOIN_RIGHT_INSTANCE);
        planner.addRule(PruneEmptyRules.SORT_FETCH_ZERO_INSTANCE);
        planner.addRule(UnionMergeRule.INSTANCE);
        planner.addRule(UnionMergeRule.INTERSECT_INSTANCE);
        planner.addRule(UnionMergeRule.MINUS_INSTANCE);
        planner.addRule(ProjectToWindowRule.PROJECT);
        planner.addRule(FilterMergeRule.INSTANCE);
        planner.addRule(DateRangeRules.FILTER_INSTANCE);
        planner.addRule(IntersectToDistinctRule.INSTANCE);
    }

    public static String dumpPlan(String header, RelNode rel, SqlExplainFormat format, SqlExplainLevel detailLevel) {
        RelWriterImpl planWriter;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (!header.equals("")) {
            pw.println(header);
        }
        switch (format) {
            case XML: {
                planWriter = new RelXmlWriter(pw, detailLevel);
                break;
            }
            case JSON: {
                RelJsonWriter planWriter2 = new RelJsonWriter();
                rel.explain(planWriter2);
                return planWriter2.asString();
            }
            default: {
                planWriter = new RelWriterImpl(pw, detailLevel, false);
            }
        }
        rel.explain(planWriter);
        pw.flush();
        return sw.toString();
    }

    @Deprecated
    public static String dumpPlan(String header, RelNode rel, boolean asXml, SqlExplainLevel detailLevel) {
        return RelOptUtil.dumpPlan(header, rel, asXml ? SqlExplainFormat.XML : SqlExplainFormat.TEXT, detailLevel);
    }

    public static RelDataType createDmlRowType(SqlKind kind, RelDataTypeFactory typeFactory) {
        switch (kind) {
            case INSERT: 
            case DELETE: 
            case UPDATE: {
                return typeFactory.createStructType(ImmutableList.of(Pair.of("ROWCOUNT", typeFactory.createSqlType(SqlTypeName.BIGINT))));
            }
            case EXPLAIN: {
                return typeFactory.createStructType(ImmutableList.of(Pair.of("PLAN", typeFactory.createSqlType(SqlTypeName.VARCHAR, -1))));
            }
        }
        throw Util.unexpected(kind);
    }

    public static boolean eq(String desc1, RelDataType type1, String desc2, RelDataType type2, Litmus litmus) {
        if (type1.getSqlTypeName() == SqlTypeName.ANY || type2.getSqlTypeName() == SqlTypeName.ANY) {
            return litmus.succeed();
        }
        if (type1 != type2) {
            return litmus.fail("type mismatch:\n{}:\n{}\n{}:\n{}", desc1, type1.getFullTypeString(), desc2, type2.getFullTypeString());
        }
        return litmus.succeed();
    }

    public static boolean equal(String desc1, RelDataType type1, String desc2, RelDataType type2, Litmus litmus) {
        if (!RelOptUtil.areRowTypesEqual(type1, type2, false)) {
            return litmus.fail("Type mismatch:\n{}:\n{}\n{}:\n{}", desc1, type1.getFullTypeString(), desc2, type2.getFullTypeString());
        }
        return litmus.succeed();
    }

    public static boolean equalType(String desc0, RelNode rel0, String desc1, RelNode rel1, Litmus litmus) {
        return RelOptUtil.equal(desc0, rel0.getRowType(), desc1, rel1.getRowType(), litmus);
    }

    public static RexNode isDistinctFrom(RexBuilder rexBuilder, RexNode x, RexNode y, boolean neg) {
        RexNode ret = null;
        if (x.getType().isStruct()) {
            assert (y.getType().isStruct());
            List<RelDataTypeField> xFields = x.getType().getFieldList();
            List<RelDataTypeField> yFields = y.getType().getFieldList();
            assert (xFields.size() == yFields.size());
            for (Pair<RelDataTypeField, RelDataTypeField> pair : Pair.zip(xFields, yFields)) {
                RelDataTypeField xField = (RelDataTypeField)pair.left;
                RelDataTypeField yField = (RelDataTypeField)pair.right;
                RexNode newX = rexBuilder.makeFieldAccess(x, xField.getIndex());
                RexNode newY = rexBuilder.makeFieldAccess(y, yField.getIndex());
                RexNode newCall = RelOptUtil.isDistinctFromInternal(rexBuilder, newX, newY, neg);
                if (ret == null) {
                    ret = newCall;
                    continue;
                }
                ret = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, ret, newCall);
            }
        } else {
            ret = RelOptUtil.isDistinctFromInternal(rexBuilder, x, y, neg);
        }
        assert (ret != null);
        assert (!ret.getType().isNullable());
        return ret;
    }

    private static RexNode isDistinctFromInternal(RexBuilder rexBuilder, RexNode x, RexNode y, boolean neg) {
        SqlBinaryOperator eqOp;
        SqlPostfixOperator nullOp;
        if (neg) {
            nullOp = SqlStdOperatorTable.IS_NULL;
            eqOp = SqlStdOperatorTable.EQUALS;
        } else {
            nullOp = SqlStdOperatorTable.IS_NOT_NULL;
            eqOp = SqlStdOperatorTable.NOT_EQUALS;
        }
        RexNode[] whenThenElse = new RexNode[]{rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, x), rexBuilder.makeCall((SqlOperator)nullOp, y), rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, y), rexBuilder.makeCall((SqlOperator)nullOp, x), rexBuilder.makeCall((SqlOperator)eqOp, rexBuilder.makeNotNull(x), rexBuilder.makeNotNull(y))};
        return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, whenThenElse);
    }

    public static String toString(RelNode rel) {
        return RelOptUtil.toString(rel, SqlExplainLevel.EXPPLAN_ATTRIBUTES);
    }

    public static String toString(RelNode rel, SqlExplainLevel detailLevel) {
        if (rel == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        RelWriterImpl planWriter = new RelWriterImpl(new PrintWriter(sw), detailLevel, false);
        rel.explain(planWriter);
        return sw.toString();
    }

    @Deprecated
    public static RelNode renameIfNecessary(RelNode rel, RelDataType desiredRowType) {
        RelDataType rowType = rel.getRowType();
        if (rowType == desiredRowType) {
            return rel;
        }
        assert (!rowType.equals(desiredRowType));
        if (!RelOptUtil.areRowTypesEqual(rowType, desiredRowType, false)) {
            return rel;
        }
        rel = RelOptUtil.createRename(rel, desiredRowType.getFieldNames());
        return rel;
    }

    public static String dumpType(RelDataType type) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        TypeDumper typeDumper = new TypeDumper(pw);
        if (type.isStruct()) {
            typeDumper.acceptFields(type.getFieldList());
        } else {
            typeDumper.accept(type);
        }
        pw.flush();
        return sw.toString();
    }

    public static List<RelDataTypeField> deduplicateColumns(List<RelDataTypeField> baseColumns, List<RelDataTypeField> extendedColumns) {
        HashSet<String> dedupedFieldNames = new HashSet<String>();
        ImmutableList.Builder dedupedFields = ImmutableList.builder();
        for (RelDataTypeField f : Iterables.concat(baseColumns, extendedColumns)) {
            if (!dedupedFieldNames.add(f.getName())) continue;
            dedupedFields.add(f);
        }
        return dedupedFields.build();
    }

    public static void decomposeConjunction(RexNode rexPredicate, List<RexNode> rexList) {
        if (rexPredicate == null || rexPredicate.isAlwaysTrue()) {
            return;
        }
        if (rexPredicate.isA(SqlKind.AND)) {
            for (RexNode operand : ((RexCall)rexPredicate).getOperands()) {
                RelOptUtil.decomposeConjunction(operand, rexList);
            }
        } else {
            rexList.add(rexPredicate);
        }
    }

    public static void decomposeConjunction(RexNode rexPredicate, List<RexNode> rexList, List<RexNode> notList) {
        if (rexPredicate == null || rexPredicate.isAlwaysTrue()) {
            return;
        }
        block0 : switch (rexPredicate.getKind()) {
            case AND: {
                for (RexNode operand : ((RexCall)rexPredicate).getOperands()) {
                    RelOptUtil.decomposeConjunction(operand, rexList, notList);
                }
                break;
            }
            case NOT: {
                RexNode e2 = ((RexCall)rexPredicate).getOperands().get(0);
                if (e2.isAlwaysFalse()) {
                    return;
                }
                switch (e2.getKind()) {
                    case OR: {
                        ArrayList<RexNode> ors = new ArrayList<RexNode>();
                        RelOptUtil.decomposeDisjunction(e2, ors);
                        block12: for (RexNode or : ors) {
                            switch (or.getKind()) {
                                case NOT: {
                                    rexList.add((RexNode)((RexCall)or).operands.get(0));
                                    continue block12;
                                }
                            }
                            notList.add(or);
                        }
                        break block0;
                    }
                    default: {
                        notList.add(e2);
                        break;
                    }
                }
                break;
            }
            case LITERAL: {
                if (!RexLiteral.isNullLiteral(rexPredicate) && RexLiteral.booleanValue(rexPredicate)) {
                    return;
                }
            }
            default: {
                rexList.add(rexPredicate);
            }
        }
    }

    public static void decomposeDisjunction(RexNode rexPredicate, List<RexNode> rexList) {
        if (rexPredicate == null || rexPredicate.isAlwaysFalse()) {
            return;
        }
        if (rexPredicate.isA(SqlKind.OR)) {
            for (RexNode operand : ((RexCall)rexPredicate).getOperands()) {
                RelOptUtil.decomposeDisjunction(operand, rexList);
            }
        } else {
            rexList.add(rexPredicate);
        }
    }

    public static List<RexNode> conjunctions(RexNode rexPredicate) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RelOptUtil.decomposeConjunction(rexPredicate, list);
        return list;
    }

    public static List<RexNode> disjunctions(RexNode rexPredicate) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RelOptUtil.decomposeDisjunction(rexPredicate, list);
        return list;
    }

    public static RexNode andJoinFilters(RexBuilder rexBuilder, RexNode left, RexNode right) {
        if (left != null && !left.isAlwaysTrue()) {
            if (right != null && !right.isAlwaysTrue()) {
                left = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, left, right);
            }
        } else {
            left = right;
        }
        if (left == null) {
            left = rexBuilder.makeLiteral(true);
        }
        return left;
    }

    public static void inferViewPredicates(Map<Integer, RexNode> projectMap, List<RexNode> filters, RexNode constraint) {
        block3: for (RexNode node : RelOptUtil.conjunctions(constraint)) {
            switch (node.getKind()) {
                case EQUALS: {
                    int index;
                    List<RexNode> operands = ((RexCall)node).getOperands();
                    RexNode o0 = operands.get(0);
                    RexNode o1 = operands.get(1);
                    if (o0 instanceof RexLiteral) {
                        o0 = operands.get(1);
                        o1 = operands.get(0);
                    }
                    if (o0.getKind() == SqlKind.CAST) {
                        o0 = ((RexCall)o0).getOperands().get(0);
                    }
                    if (!(o0 instanceof RexInputRef) || !(o1 instanceof RexLiteral) || projectMap.get(index = ((RexInputRef)o0).getIndex()) != null) break;
                    projectMap.put(index, o1);
                    continue block3;
                }
            }
            filters.add(node);
        }
    }

    public static Map<Integer, RexNode> getColumnConstraints(ModifiableView modifiableViewTable, RelDataType targetRowType, RelDataTypeFactory typeFactory) {
        RexBuilder rexBuilder = new RexBuilder(typeFactory);
        RexNode constraint = modifiableViewTable.getConstraint(rexBuilder, targetRowType);
        HashMap<Integer, RexNode> projectMap = Maps.newHashMap();
        ArrayList<RexNode> filters = new ArrayList<RexNode>();
        RelOptUtil.inferViewPredicates(projectMap, filters, constraint);
        assert (filters.isEmpty());
        return projectMap;
    }

    public static void validateValueAgainstConstraint(SqlNode sourceValue, RexNode targetConstraint, Supplier<CalciteContextException> errorSupplier) {
        if (!(sourceValue instanceof SqlLiteral)) {
            throw errorSupplier.get();
        }
        SqlLiteral insertValue = (SqlLiteral)sourceValue;
        RexSqlStandardConvertletTable convertletTable = new RexSqlStandardConvertletTable();
        RexToSqlNodeConverterImpl sqlNodeToRexConverter = new RexToSqlNodeConverterImpl(convertletTable);
        RexLiteral columnConstraint = (RexLiteral)targetConstraint;
        SqlLiteral constraintValue = (SqlLiteral)sqlNodeToRexConverter.convertLiteral(columnConstraint);
        if (!insertValue.equals(constraintValue)) {
            throw errorSupplier.get();
        }
    }

    public static List<Integer> adjustKeys(List<Integer> keys, int adjustment) {
        if (adjustment == 0) {
            return keys;
        }
        ArrayList<Integer> newKeys = new ArrayList<Integer>();
        for (int key : keys) {
            newKeys.add(key + adjustment);
        }
        return newKeys;
    }

    public static JoinRelType simplifyJoin(RelNode joinRel, ImmutableList<RexNode> aboveFilters, JoinRelType joinType) {
        int nTotalFields = joinRel.getRowType().getFieldCount();
        boolean nSysFields = false;
        int nFieldsLeft = joinRel.getInputs().get(0).getRowType().getFieldCount();
        int nFieldsRight = joinRel.getInputs().get(1).getRowType().getFieldCount();
        assert (nTotalFields == 0 + nFieldsLeft + nFieldsRight);
        ImmutableBitSet leftBitmap = ImmutableBitSet.range(0, 0 + nFieldsLeft);
        ImmutableBitSet rightBitmap = ImmutableBitSet.range(0 + nFieldsLeft, nTotalFields);
        for (RexNode filter : aboveFilters) {
            if (joinType.generatesNullsOnLeft() && Strong.isNotTrue(filter, leftBitmap)) {
                joinType = joinType.cancelNullsOnLeft();
            }
            if (joinType.generatesNullsOnRight() && Strong.isNotTrue(filter, rightBitmap)) {
                joinType = joinType.cancelNullsOnRight();
            }
            if (joinType != JoinRelType.INNER) continue;
            break;
        }
        return joinType;
    }

    public static boolean classifyFilters(RelNode joinRel, List<RexNode> filters, JoinRelType joinType, boolean pushInto, boolean pushLeft, boolean pushRight, List<RexNode> joinFilters, List<RexNode> leftFilters, List<RexNode> rightFilters) {
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        List<RelDataTypeField> joinFields = joinRel.getRowType().getFieldList();
        int nTotalFields = joinFields.size();
        boolean nSysFields = false;
        List<RelDataTypeField> leftFields = joinRel.getInputs().get(0).getRowType().getFieldList();
        int nFieldsLeft = leftFields.size();
        List<RelDataTypeField> rightFields = joinRel.getInputs().get(1).getRowType().getFieldList();
        int nFieldsRight = rightFields.size();
        assert (nTotalFields == (joinRel instanceof SemiJoin ? 0 + nFieldsLeft : 0 + nFieldsLeft + nFieldsRight));
        ImmutableBitSet leftBitmap = ImmutableBitSet.range(0, 0 + nFieldsLeft);
        ImmutableBitSet rightBitmap = ImmutableBitSet.range(0 + nFieldsLeft, nTotalFields);
        ArrayList<RexNode> filtersToRemove = Lists.newArrayList();
        for (RexNode filter : filters) {
            RexNode shiftedFilter;
            InputFinder inputFinder = InputFinder.analyze(filter);
            ImmutableBitSet inputBits = inputFinder.inputBitSet.build();
            if (pushLeft && leftBitmap.contains(inputBits)) {
                if (!filter.isAlwaysTrue()) {
                    shiftedFilter = RelOptUtil.shiftFilter(0, 0 + nFieldsLeft, 0, rexBuilder, joinFields, nTotalFields, leftFields, filter);
                    leftFilters.add(shiftedFilter);
                }
                filtersToRemove.add(filter);
                continue;
            }
            if (pushRight && rightBitmap.contains(inputBits)) {
                if (!filter.isAlwaysTrue()) {
                    shiftedFilter = RelOptUtil.shiftFilter(0 + nFieldsLeft, nTotalFields, -(0 + nFieldsLeft), rexBuilder, joinFields, nTotalFields, rightFields, filter);
                    rightFilters.add(shiftedFilter);
                }
                filtersToRemove.add(filter);
                continue;
            }
            if (joinType != JoinRelType.INNER || !pushInto) continue;
            if (!joinFilters.contains(filter)) {
                joinFilters.add(filter);
            }
            filtersToRemove.add(filter);
        }
        if (!filtersToRemove.isEmpty()) {
            filters.removeAll(filtersToRemove);
        }
        return !filtersToRemove.isEmpty();
    }

    private static RexNode shiftFilter(int start, int end, int offset, RexBuilder rexBuilder, List<RelDataTypeField> joinFields, int nTotalFields, List<RelDataTypeField> rightFields, RexNode filter) {
        int[] adjustments = new int[nTotalFields];
        for (int i = start; i < end; ++i) {
            adjustments[i] = offset;
        }
        return filter.accept(new RexInputConverter(rexBuilder, joinFields, rightFields, adjustments));
    }

    public static void splitFilters(ImmutableBitSet childBitmap, RexNode predicate, List<RexNode> pushable, List<RexNode> notPushable) {
        for (RexNode filter : RelOptUtil.conjunctions(predicate)) {
            ImmutableBitSet filterRefs = InputFinder.bits(filter);
            if (childBitmap.contains(filterRefs)) {
                pushable.add(filter);
                continue;
            }
            notPushable.add(filter);
        }
    }

    @Deprecated
    public static boolean checkProjAndChildInputs(Project project, boolean checkNames) {
        int n = project.getProjects().size();
        RelDataType inputType = project.getInput().getRowType();
        if (inputType.getFieldList().size() != n) {
            return false;
        }
        List<RelDataTypeField> projFields = project.getRowType().getFieldList();
        List<RelDataTypeField> inputFields = inputType.getFieldList();
        boolean namesDifferent = false;
        for (int i = 0; i < n; ++i) {
            RexNode exp = project.getProjects().get(i);
            if (!(exp instanceof RexInputRef)) {
                return false;
            }
            RexInputRef fieldAccess = (RexInputRef)exp;
            if (i != fieldAccess.getIndex()) {
                return false;
            }
            if (!checkNames) continue;
            String inputFieldName = inputFields.get(i).getName();
            String projFieldName = projFields.get(i).getName();
            if (projFieldName.equals(inputFieldName)) continue;
            namesDifferent = true;
        }
        return !checkNames || namesDifferent;
    }

    public static List<RexNode> createSwappedJoinExprs(RelNode newJoin, Join origJoin, boolean origOrder) {
        List<RelDataTypeField> newJoinFields = newJoin.getRowType().getFieldList();
        RexBuilder rexBuilder = newJoin.getCluster().getRexBuilder();
        ArrayList<RexNode> exps = new ArrayList<RexNode>();
        int nFields = origOrder ? origJoin.getRight().getRowType().getFieldCount() : origJoin.getLeft().getRowType().getFieldCount();
        for (int i = 0; i < newJoinFields.size(); ++i) {
            int source = (i + nFields) % newJoinFields.size();
            RelDataTypeField field2 = origOrder ? newJoinFields.get(source) : newJoinFields.get(i);
            exps.add(rexBuilder.makeInputRef(field2.getType(), source));
        }
        return exps;
    }

    @Deprecated
    public static RexNode pushFilterPastProject(RexNode filter, Project projRel) {
        return RelOptUtil.pushPastProject(filter, projRel);
    }

    public static RexNode pushPastProject(RexNode node, Project project) {
        return node.accept(RelOptUtil.pushShuttle(project));
    }

    public static List<RexNode> pushPastProject(List<? extends RexNode> nodes, Project project) {
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RelOptUtil.pushShuttle(project).visitList(nodes, list);
        return list;
    }

    private static RexShuttle pushShuttle(final Project project) {
        return new RexShuttle(){

            @Override
            public RexNode visitInputRef(RexInputRef ref) {
                return project.getProjects().get(ref.getIndex());
            }
        };
    }

    public static MultiJoin projectMultiJoin(MultiJoin multiJoin, LogicalProject project) {
        ImmutableBitSet inputRefs = InputFinder.bits(project.getProjects(), multiJoin.getPostJoinFilter());
        List<RelNode> multiJoinInputs = multiJoin.getInputs();
        ArrayList<BitSet> newProjFields = Lists.newArrayList();
        for (RelNode multiJoinInput : multiJoinInputs) {
            newProjFields.add(new BitSet(multiJoinInput.getRowType().getFieldCount()));
        }
        int currInput = -1;
        int startField = 0;
        int nFields = 0;
        for (int bit : inputRefs) {
            while (bit >= startField + nFields) {
                startField += nFields;
                assert (++currInput < multiJoinInputs.size());
                nFields = multiJoinInputs.get(currInput).getRowType().getFieldCount();
            }
            ((BitSet)newProjFields.get(currInput)).set(bit - startField);
        }
        return new MultiJoin(multiJoin.getCluster(), multiJoin.getInputs(), multiJoin.getJoinFilter(), multiJoin.getRowType(), multiJoin.isFullOuterJoin(), multiJoin.getOuterJoinConditions(), multiJoin.getJoinTypes(), Lists.transform(newProjFields, ImmutableBitSet.FROM_BIT_SET), multiJoin.getJoinFieldRefCountsMap(), multiJoin.getPostJoinFilter());
    }

    public static <T extends RelNode> T addTrait(T rel, RelTrait trait) {
        return (T)rel.copy(rel.getTraitSet().replace(trait), rel.getInputs());
    }

    public static RelNode replaceInput(RelNode parent, int ordinal, RelNode newInput) {
        ArrayList<RelNode> inputs = new ArrayList<RelNode>(parent.getInputs());
        if (inputs.get(ordinal) == newInput) {
            return parent;
        }
        inputs.set(ordinal, newInput);
        return parent.copy(parent.getTraitSet(), inputs);
    }

    public static RelNode createProject(RelNode child, Mappings.TargetMapping mapping) {
        return RelOptUtil.createProject(child, Mappings.asList(mapping.inverse()));
    }

    public static RelNode createProject(RelNode child, Mappings.TargetMapping mapping, RelFactories.ProjectFactory projectFactory) {
        return RelOptUtil.createProject(projectFactory, child, Mappings.asList(mapping.inverse()));
    }

    public static boolean contains(RelNode ancestor, final RelNode target) {
        if (ancestor == target) {
            return true;
        }
        try {
            new RelVisitor(){

                @Override
                public void visit(RelNode node, int ordinal, RelNode parent) {
                    if (node == target) {
                        throw Util.FoundOne.NULL;
                    }
                    super.visit(node, ordinal, parent);
                }
            }.go(ancestor);
            return false;
        }
        catch (Util.FoundOne e2) {
            return true;
        }
    }

    public static RelNode replace(RelNode query, RelNode find, RelNode replace) {
        if (find == replace) {
            return query;
        }
        assert (RelOptUtil.equalType("find", find, "replace", replace, Litmus.THROW));
        if (query == find) {
            return replace;
        }
        return RelOptUtil.replaceRecurse(query, find, replace);
    }

    private static RelNode replaceRecurse(RelNode query, RelNode find, RelNode replace) {
        if (query == find) {
            return replace;
        }
        List<RelNode> inputs = query.getInputs();
        if (!inputs.isEmpty()) {
            ArrayList<RelNode> newInputs = new ArrayList<RelNode>();
            for (RelNode input : inputs) {
                newInputs.add(RelOptUtil.replaceRecurse(input, find, replace));
            }
            if (!newInputs.equals(inputs)) {
                return query.copy(query.getTraitSet(), newInputs);
            }
        }
        return query;
    }

    public static RelOptTable.ToRelContext getContext(final RelOptCluster cluster) {
        return new RelOptTable.ToRelContext(){

            @Override
            public RelOptCluster getCluster() {
                return cluster;
            }

            @Override
            public RelRoot expandView(RelDataType rowType, String queryString, List<String> schemaPath, List<String> viewPath) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static int countJoins(RelNode rootRel) {
        class JoinCounter
        extends RelVisitor {
            int joinCount;

            JoinCounter() {
            }

            @Override
            public void visit(RelNode node, int ordinal, RelNode parent) {
                if (node instanceof Join) {
                    ++this.joinCount;
                }
                super.visit(node, ordinal, parent);
            }

            int run(RelNode node) {
                this.go(node);
                return this.joinCount;
            }
        }
        return new JoinCounter().run(rootRel);
    }

    public static RelDataType permute(RelDataTypeFactory typeFactory, RelDataType rowType, Mapping mapping) {
        return typeFactory.createStructType(Mappings.apply3(mapping, rowType.getFieldList()));
    }

    public static RelNode createProject(RelNode child, List<? extends RexNode> exprList, List<String> fieldNameList) {
        return RelOptUtil.createProject(child, exprList, fieldNameList, false);
    }

    public static RelNode createProject(RelNode child, List<Pair<RexNode, String>> projectList, boolean optimize) {
        return RelOptUtil.createProject(child, Pair.left(projectList), Pair.right(projectList), optimize, RelFactories.LOGICAL_BUILDER.create(child.getCluster(), null));
    }

    public static RelNode createProject(RelNode child, List<Integer> posList) {
        return RelOptUtil.createProject(RelFactories.DEFAULT_PROJECT_FACTORY, child, posList);
    }

    public static RelNode createProject(RelNode child, List<? extends RexNode> exprs, List<String> fieldNames, boolean optimize) {
        return RelOptUtil.createProject(child, exprs, fieldNames, optimize, RelFactories.LOGICAL_BUILDER.create(child.getCluster(), null));
    }

    public static RelNode createProject(RelNode child, List<? extends RexNode> exprs, List<String> fieldNames, boolean optimize, RelBuilder relBuilder) {
        RelOptCluster cluster = child.getCluster();
        RelDataType rowType = RexUtil.createStructType(cluster.getTypeFactory(), exprs, fieldNames, SqlValidatorUtil.F_SUGGESTER);
        if (optimize && RexUtil.isIdentity(exprs, child.getRowType())) {
            if (child instanceof Project && fieldNames != null) {
                Project childProject = (Project)child;
                child = childProject.copy(childProject.getTraitSet(), childProject.getInput(), childProject.getProjects(), rowType);
            }
            return child;
        }
        relBuilder.push(child);
        relBuilder.project(exprs, rowType.getFieldNames(), !optimize);
        return relBuilder.build();
    }

    @Deprecated
    public static RelNode createRename(RelNode rel, List<String> fieldNames) {
        final List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        assert (fieldNames.size() == fields.size());
        AbstractList<RexNode> refs = new AbstractList<RexNode>(){

            @Override
            public int size() {
                return fields.size();
            }

            @Override
            public RexNode get(int index) {
                return RexInputRef.of(index, fields);
            }
        };
        return RelOptUtil.createProject(rel, (List<? extends RexNode>)refs, fieldNames, true);
    }

    public static RelNode permute(RelNode rel, Permutation permutation, List<String> fieldNames) {
        Permutation permutation1;
        LogicalCalc calc;
        Permutation permutation12;
        if (permutation.isIdentity()) {
            return rel;
        }
        if (rel instanceof LogicalCalc && (permutation12 = (calc = (LogicalCalc)rel).getProgram().getPermutation()) != null) {
            Permutation permutation2 = permutation.product(permutation12);
            return RelOptUtil.permute(rel, permutation2, null);
        }
        if (rel instanceof LogicalProject && (permutation1 = ((LogicalProject)rel).getPermutation()) != null) {
            Permutation permutation2 = permutation.product(permutation1);
            return RelOptUtil.permute(rel, permutation2, null);
        }
        ArrayList<RelDataType> outputTypeList = new ArrayList<RelDataType>();
        ArrayList<String> outputNameList = new ArrayList<String>();
        ArrayList<RexInputRef> exprList = new ArrayList<RexInputRef>();
        ArrayList<RexLocalRef> projectRefList = new ArrayList<RexLocalRef>();
        List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        RelOptCluster cluster = rel.getCluster();
        for (int i = 0; i < permutation.getTargetCount(); ++i) {
            int target = permutation.getTarget(i);
            RelDataTypeField targetField = fields.get(target);
            outputTypeList.add(targetField.getType());
            outputNameList.add(fieldNames == null || fieldNames.size() <= i || fieldNames.get(i) == null ? targetField.getName() : fieldNames.get(i));
            exprList.add(cluster.getRexBuilder().makeInputRef(fields.get(i).getType(), i));
            int source = permutation.getSource(i);
            projectRefList.add(new RexLocalRef(source, fields.get(source).getType()));
        }
        RelDataTypeFactory typeFactory = cluster.getTypeFactory();
        RexProgram program = new RexProgram(rel.getRowType(), exprList, projectRefList, null, typeFactory.createStructType(outputTypeList, outputNameList));
        return LogicalCalc.create(rel, program);
    }

    public static RelNode createProject(RelFactories.ProjectFactory factory, final RelNode child, final List<Integer> posList) {
        RelDataType rowType = child.getRowType();
        final List<String> fieldNames = rowType.getFieldNames();
        final RexBuilder rexBuilder = child.getCluster().getRexBuilder();
        return RelOptUtil.createProject(child, (List<? extends RexNode>)new AbstractList<RexNode>(){

            @Override
            public int size() {
                return posList.size();
            }

            @Override
            public RexNode get(int index) {
                int pos = (Integer)posList.get(index);
                return rexBuilder.makeInputRef(child, pos);
            }
        }, (List<String>)new AbstractList<String>(){

            @Override
            public int size() {
                return posList.size();
            }

            @Override
            public String get(int index) {
                int pos = (Integer)posList.get(index);
                return (String)fieldNames.get(pos);
            }
        }, true, RelBuilder.proto(factory).create(child.getCluster(), null));
    }

    @Deprecated
    public static RelNode projectMapping(RelNode rel, Mapping mapping, List<String> fieldNames, RelFactories.ProjectFactory projectFactory) {
        assert (mapping.getMappingType().isSingleSource());
        assert (mapping.getMappingType().isMandatorySource());
        if (mapping.isIdentity()) {
            return rel;
        }
        ArrayList<String> outputNameList = Lists.newArrayList();
        ArrayList<RexInputRef> exprList = Lists.newArrayList();
        List<RelDataTypeField> fields = rel.getRowType().getFieldList();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        for (int i = 0; i < mapping.getTargetCount(); ++i) {
            int source = mapping.getSource(i);
            RelDataTypeField sourceField = fields.get(source);
            outputNameList.add(fieldNames == null || fieldNames.size() <= i || fieldNames.get(i) == null ? sourceField.getName() : fieldNames.get(i));
            exprList.add(rexBuilder.makeInputRef(rel, source));
        }
        return projectFactory.createProject(rel, exprList, outputNameList);
    }

    public static RelNode pushDownJoinConditions(Join originalJoin, RelBuilder relBuilder) {
        List<RelDataTypeField> fields;
        RexNode joinCond = originalJoin.getCondition();
        JoinRelType joinType = originalJoin.getJoinType();
        final ArrayList<RexNode> extraLeftExprs = new ArrayList<RexNode>();
        final ArrayList<RexNode> extraRightExprs = new ArrayList<RexNode>();
        final int leftCount = originalJoin.getLeft().getRowType().getFieldCount();
        final int rightCount = originalJoin.getRight().getRowType().getFieldCount();
        if (!RelOptUtil.containsGet(joinCond) && RexUtil.SubQueryFinder.find(joinCond) == null) {
            joinCond = RelOptUtil.pushDownEqualJoinConditions(joinCond, leftCount, rightCount, extraLeftExprs, extraRightExprs);
        }
        relBuilder.push(originalJoin.getLeft());
        if (!extraLeftExprs.isEmpty()) {
            fields = relBuilder.peek().getRowType().getFieldList();
            AbstractList<Pair<RexNode, String>> pairs = new AbstractList<Pair<RexNode, String>>(){

                @Override
                public int size() {
                    return leftCount + extraLeftExprs.size();
                }

                @Override
                public Pair<RexNode, String> get(int index) {
                    if (index < leftCount) {
                        RelDataTypeField field2 = (RelDataTypeField)fields.get(index);
                        return Pair.of(new RexInputRef(index, field2.getType()), field2.getName());
                    }
                    return Pair.of(extraLeftExprs.get(index - leftCount), null);
                }
            };
            relBuilder.project(Pair.left(pairs), Pair.right(pairs));
        }
        relBuilder.push(originalJoin.getRight());
        if (!extraRightExprs.isEmpty()) {
            fields = relBuilder.peek().getRowType().getFieldList();
            final int newLeftCount = leftCount + extraLeftExprs.size();
            AbstractList<Pair<RexNode, String>> pairs = new AbstractList<Pair<RexNode, String>>(){

                @Override
                public int size() {
                    return rightCount + extraRightExprs.size();
                }

                @Override
                public Pair<RexNode, String> get(int index) {
                    if (index < rightCount) {
                        RelDataTypeField field2 = (RelDataTypeField)fields.get(index);
                        return Pair.of(new RexInputRef(index, field2.getType()), field2.getName());
                    }
                    return Pair.of(RexUtil.shift((RexNode)extraRightExprs.get(index - rightCount), -newLeftCount), null);
                }
            };
            relBuilder.project(Pair.left(pairs), Pair.right(pairs));
        }
        RelNode right = relBuilder.build();
        RelNode left = relBuilder.build();
        relBuilder.push(originalJoin.copy(originalJoin.getTraitSet(), joinCond, left, right, joinType, originalJoin.isSemiJoinDone()));
        if (!extraLeftExprs.isEmpty() || !extraRightExprs.isEmpty()) {
            Mappings.TargetMapping mapping = Mappings.createShiftMapping(leftCount + extraLeftExprs.size() + rightCount + extraRightExprs.size(), 0, 0, leftCount, leftCount, leftCount + extraLeftExprs.size(), rightCount);
            relBuilder.project(relBuilder.fields(mapping.inverse()));
        }
        return relBuilder.build();
    }

    @Deprecated
    public static RelNode pushDownJoinConditions(Join originalJoin) {
        return RelOptUtil.pushDownJoinConditions(originalJoin, RelFactories.LOGICAL_BUILDER);
    }

    @Deprecated
    public static RelNode pushDownJoinConditions(Join originalJoin, RelFactories.ProjectFactory projectFactory) {
        return RelOptUtil.pushDownJoinConditions(originalJoin, RelBuilder.proto(projectFactory));
    }

    private static RelNode pushDownJoinConditions(Join originalJoin, RelBuilderFactory relBuilderFactory) {
        return RelOptUtil.pushDownJoinConditions(originalJoin, relBuilderFactory.create(originalJoin.getCluster(), null));
    }

    private static boolean containsGet(RexNode node) {
        try {
            node.accept(new RexVisitorImpl<Void>(true){

                @Override
                public Void visitCall(RexCall call) {
                    if (call.getOperator() == RexBuilder.GET_OPERATOR) {
                        throw Util.FoundOne.NULL;
                    }
                    return (Void)super.visitCall(call);
                }
            });
            return false;
        }
        catch (Util.FoundOne e2) {
            return true;
        }
    }

    private static RexNode pushDownEqualJoinConditions(RexNode node, int leftCount, int rightCount, List<RexNode> extraLeftExprs, List<RexNode> extraRightExprs) {
        switch (node.getKind()) {
            case EQUALS: 
            case AND: {
                RexCall call = (RexCall)node;
                ArrayList<RexNode> list = new ArrayList<RexNode>();
                ArrayList<RexNode> operands = Lists.newArrayList(call.getOperands());
                for (int i = 0; i < operands.size(); ++i) {
                    RexNode operand = (RexNode)operands.get(i);
                    int left2 = leftCount + extraLeftExprs.size();
                    int right2 = rightCount + extraRightExprs.size();
                    RexNode e2 = RelOptUtil.pushDownEqualJoinConditions(operand, leftCount, rightCount, extraLeftExprs, extraRightExprs);
                    List<RexNode> remainingOperands = Util.skip(operands, i + 1);
                    int left3 = leftCount + extraLeftExprs.size();
                    RelOptUtil.fix(remainingOperands, left2, left3);
                    RelOptUtil.fix(list, left2, left3);
                    list.add(e2);
                }
                if (!list.equals(call.getOperands())) {
                    return call.clone(call.getType(), list);
                }
                return call;
            }
            case OR: 
            case LITERAL: 
            case INPUT_REF: {
                return node;
            }
        }
        ImmutableBitSet bits = InputFinder.bits(node);
        int mid = leftCount + extraLeftExprs.size();
        switch (Side.of(bits, mid)) {
            case LEFT: {
                RelOptUtil.fix(extraRightExprs, mid, mid + 1);
                extraLeftExprs.add(node);
                return new RexInputRef(mid, node.getType());
            }
            case RIGHT: {
                int index2 = mid + rightCount + extraRightExprs.size();
                extraRightExprs.add(node);
                return new RexInputRef(index2, node.getType());
            }
        }
        return node;
    }

    private static void fix(List<RexNode> operands, int before, int after) {
        if (before == after) {
            return;
        }
        for (int i = 0; i < operands.size(); ++i) {
            RexNode node = operands.get(i);
            operands.set(i, RexUtil.shift(node, before, after - before));
        }
    }

    private static boolean containsNullableFields(RelNode r) {
        RexNode second;
        RexBuilder rexBuilder = r.getCluster().getRexBuilder();
        RelDataType rowType = r.getRowType();
        ArrayList<RexNode> list = new ArrayList<RexNode>();
        RelMetadataQuery mq = r.getCluster().getMetadataQuery();
        for (RelDataTypeField field2 : rowType.getFieldList()) {
            if (!field2.getType().isNullable()) continue;
            list.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, rexBuilder.makeInputRef(field2.getType(), field2.getIndex())));
        }
        if (list.isEmpty()) {
            return false;
        }
        RelOptPredicateList predicates = mq.getPulledUpPredicates(r);
        if (predicates.pulledUpPredicates.isEmpty()) {
            return true;
        }
        RexExecutor executor = r.getCluster().getPlanner().getExecutor();
        if (!(executor instanceof RexExecutorImpl)) {
            return true;
        }
        RexImplicationChecker checker = new RexImplicationChecker(rexBuilder, (RexExecutorImpl)executor, rowType);
        RexNode first = RexUtil.composeConjunction(rexBuilder, predicates.pulledUpPredicates, false);
        return !checker.implies(first, second = RexUtil.composeConjunction(rexBuilder, list, false));
    }

    public static class Exists {
        public final RelNode r;
        public final boolean indicator;
        public final boolean outerJoin;

        private Exists(RelNode r, boolean indicator, boolean outerJoin) {
            this.r = r;
            this.indicator = indicator;
            this.outerJoin = outerJoin;
        }
    }

    private static class CorrelationCollector
    extends RelHomogeneousShuttle {
        private final VariableUsedVisitor vuv = new VariableUsedVisitor(this);

        private CorrelationCollector() {
        }

        @Override
        public RelNode visit(RelNode other) {
            other.collectVariablesUsed(this.vuv.variables);
            other.accept(this.vuv);
            RelNode result = super.visit(other);
            this.vuv.variables.removeAll(other.getVariablesSet());
            return result;
        }
    }

    static enum Side {
        LEFT,
        RIGHT,
        BOTH,
        EMPTY;


        static Side of(ImmutableBitSet bitSet, int middle) {
            int firstBit = bitSet.nextSetBit(0);
            if (firstBit < 0) {
                return EMPTY;
            }
            if (firstBit >= middle) {
                return RIGHT;
            }
            if (bitSet.nextSetBit(middle) < 0) {
                return LEFT;
            }
            return BOTH;
        }
    }

    public static enum SubQueryType {
        EXISTS,
        IN,
        SCALAR;

    }

    public static class RexInputConverter
    extends RexShuttle {
        protected final RexBuilder rexBuilder;
        private final List<RelDataTypeField> srcFields;
        protected final List<RelDataTypeField> destFields;
        private final List<RelDataTypeField> leftDestFields;
        private final List<RelDataTypeField> rightDestFields;
        private final int nLeftDestFields;
        private final int[] adjustments;

        private RexInputConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields, List<RelDataTypeField> leftDestFields, List<RelDataTypeField> rightDestFields, int[] adjustments) {
            this.rexBuilder = rexBuilder;
            this.srcFields = srcFields;
            this.destFields = destFields;
            this.adjustments = adjustments;
            this.leftDestFields = leftDestFields;
            this.rightDestFields = rightDestFields;
            if (leftDestFields == null) {
                this.nLeftDestFields = 0;
            } else {
                assert (destFields == null);
                this.nLeftDestFields = leftDestFields.size();
            }
        }

        public RexInputConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, List<RelDataTypeField> leftDestFields, List<RelDataTypeField> rightDestFields, int[] adjustments) {
            this(rexBuilder, srcFields, null, leftDestFields, rightDestFields, adjustments);
        }

        public RexInputConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, List<RelDataTypeField> destFields, int[] adjustments) {
            this(rexBuilder, srcFields, destFields, null, null, adjustments);
        }

        public RexInputConverter(RexBuilder rexBuilder, List<RelDataTypeField> srcFields, int[] adjustments) {
            this(rexBuilder, srcFields, null, null, null, adjustments);
        }

        @Override
        public RexNode visitInputRef(RexInputRef var) {
            int srcIndex = var.getIndex();
            int destIndex = srcIndex + this.adjustments[srcIndex];
            RelDataType type = this.destFields != null ? this.destFields.get(destIndex).getType() : (this.leftDestFields != null ? (destIndex < this.nLeftDestFields ? this.leftDestFields.get(destIndex).getType() : this.rightDestFields.get(destIndex - this.nLeftDestFields).getType()) : this.srcFields.get(srcIndex).getType());
            if (this.adjustments[srcIndex] != 0 || this.srcFields == null || type != this.srcFields.get(srcIndex).getType()) {
                return this.rexBuilder.makeInputRef(type, destIndex);
            }
            return var;
        }
    }

    public static class InputFinder
    extends RexVisitorImpl<Void> {
        public final ImmutableBitSet.Builder inputBitSet = ImmutableBitSet.builder();
        private final Set<RelDataTypeField> extraFields;

        public InputFinder() {
            this(null);
        }

        public InputFinder(Set<RelDataTypeField> extraFields) {
            super(true);
            this.extraFields = extraFields;
        }

        public static InputFinder analyze(RexNode node) {
            InputFinder inputFinder = new InputFinder();
            node.accept(inputFinder);
            return inputFinder;
        }

        public static ImmutableBitSet bits(RexNode node) {
            return InputFinder.analyze((RexNode)node).inputBitSet.build();
        }

        public static ImmutableBitSet bits(List<RexNode> exprs, RexNode expr) {
            InputFinder inputFinder = new InputFinder();
            RexUtil.apply((RexVisitor<Void>)inputFinder, exprs, expr);
            return inputFinder.inputBitSet.build();
        }

        @Override
        public Void visitInputRef(RexInputRef inputRef) {
            this.inputBitSet.set(inputRef.getIndex());
            return null;
        }

        @Override
        public Void visitCall(RexCall call) {
            if (call.getOperator() == RexBuilder.GET_OPERATOR) {
                RexLiteral literal = (RexLiteral)call.getOperands().get(1);
                this.extraFields.add(new RelDataTypeFieldImpl((String)literal.getValue2(), -1, call.getType()));
            }
            return (Void)super.visitCall(call);
        }
    }

    public static class TypeDumper {
        private final String extraIndent = "  ";
        private String indent;
        private final PrintWriter pw;

        TypeDumper(PrintWriter pw) {
            this.pw = pw;
            this.indent = "";
        }

        void accept(RelDataType type) {
            if (type.isStruct()) {
                List<RelDataTypeField> fields = type.getFieldList();
                this.pw.println("RECORD (");
                String prevIndent = this.indent;
                this.indent = this.indent + "  ";
                this.acceptFields(fields);
                this.indent = prevIndent;
                this.pw.print(")");
                if (!type.isNullable()) {
                    this.pw.print(" NOT NULL");
                }
            } else if (type instanceof MultisetSqlType) {
                this.accept(type.getComponentType());
                this.pw.print(" MULTISET");
                if (!type.isNullable()) {
                    this.pw.print(" NOT NULL");
                }
            } else {
                this.pw.print(type.getFullTypeString());
            }
        }

        private void acceptFields(List<RelDataTypeField> fields) {
            for (int i = 0; i < fields.size(); ++i) {
                RelDataTypeField field2 = fields.get(i);
                if (i > 0) {
                    this.pw.println(",");
                }
                this.pw.print(this.indent);
                this.pw.print(field2.getName());
                this.pw.print(" ");
                this.accept(field2.getType());
            }
        }
    }

    public static class InputReferencedVisitor
    extends RexShuttle {
        public final SortedSet<Integer> inputPosReferenced = new TreeSet<Integer>();

        @Override
        public RexNode visitInputRef(RexInputRef inputRef) {
            this.inputPosReferenced.add(inputRef.getIndex());
            return inputRef;
        }
    }

    public static class VariableUsedVisitor
    extends RexShuttle {
        public final Set<CorrelationId> variables = new LinkedHashSet<CorrelationId>();
        public final Multimap<CorrelationId, Integer> variableFields = LinkedHashMultimap.create();
        private final RelShuttle relShuttle;

        public VariableUsedVisitor(RelShuttle relShuttle) {
            this.relShuttle = relShuttle;
        }

        @Override
        public RexNode visitCorrelVariable(RexCorrelVariable p) {
            this.variables.add(p.id);
            this.variableFields.put(p.id, -1);
            return p;
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            if (fieldAccess.getReferenceExpr() instanceof RexCorrelVariable) {
                RexCorrelVariable v = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                this.variableFields.put(v.id, fieldAccess.getField().getIndex());
            }
            return super.visitFieldAccess(fieldAccess);
        }

        @Override
        public RexNode visitSubQuery(RexSubQuery subQuery) {
            if (this.relShuttle != null) {
                subQuery.rel.accept(this.relShuttle);
            }
            return super.visitSubQuery(subQuery);
        }
    }

    private static class VariableSetVisitor
    extends RelVisitor {
        final Set<CorrelationId> variables = new HashSet<CorrelationId>();

        private VariableSetVisitor() {
        }

        @Override
        public void visit(RelNode p, int ordinal, RelNode parent) {
            super.visit(p, ordinal, parent);
            p.collectVariablesUsed(this.variables);
            this.variables.removeAll(p.getVariablesSet());
        }
    }

    public static enum Logic {
        TRUE_FALSE_UNKNOWN,
        TRUE_FALSE,
        UNKNOWN_AS_FALSE,
        UNKNOWN_AS_TRUE,
        TRUE,
        FALSE;


        public Logic negate() {
            switch (this) {
                case UNKNOWN_AS_FALSE: 
                case TRUE: {
                    return UNKNOWN_AS_TRUE;
                }
                case UNKNOWN_AS_TRUE: {
                    return UNKNOWN_AS_FALSE;
                }
            }
            return this;
        }

        public Logic negate2() {
            switch (this) {
                case FALSE: {
                    return TRUE;
                }
                case TRUE: {
                    return FALSE;
                }
                case UNKNOWN_AS_FALSE: {
                    return UNKNOWN_AS_TRUE;
                }
                case UNKNOWN_AS_TRUE: {
                    return UNKNOWN_AS_FALSE;
                }
            }
            return this;
        }
    }
}

