/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica;

import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.avatica.AvaticaClientRuntimeException;
import org.apache.calcite.avatica.AvaticaFactory;
import org.apache.calcite.avatica.AvaticaPreparedStatement;
import org.apache.calcite.avatica.AvaticaResultSet;
import org.apache.calcite.avatica.AvaticaSpecificDatabaseMetaData;
import org.apache.calcite.avatica.AvaticaStatement;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.ConnectionConfig;
import org.apache.calcite.avatica.ConnectionConfigImpl;
import org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.calcite.avatica.Helper;
import org.apache.calcite.avatica.InternalProperty;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.NoSuchStatementException;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.SqlType;
import org.apache.calcite.avatica.UnregisteredDriver;
import org.apache.calcite.avatica.remote.KerberosConnection;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.avatica.util.ArrayFactoryImpl;

public abstract class AvaticaConnection
implements Connection {
    public static final String ROWCOUNT_COLUMN_NAME = "ROWCOUNT";
    public static final String NUM_EXECUTE_RETRIES_KEY = "avatica.statement.retries";
    public static final String NUM_EXECUTE_RETRIES_DEFAULT = "5";
    public static final String PLAN_COLUMN_NAME = "PLAN";
    protected int statementCount;
    private boolean closed;
    private int holdability;
    private int networkTimeout;
    private KerberosConnection kerberosConnection;
    private Service service;
    public final String id;
    public final Meta.ConnectionHandle handle;
    protected final UnregisteredDriver driver;
    protected final AvaticaFactory factory;
    final String url;
    protected final Properties info;
    protected final Meta meta;
    protected final AvaticaSpecificDatabaseMetaData metaData;
    public final Helper helper = Helper.INSTANCE;
    public final Map<InternalProperty, Object> properties = new HashMap<InternalProperty, Object>();
    public final Map<Integer, AvaticaStatement> statementMap = new ConcurrentHashMap<Integer, AvaticaStatement>();
    final Map<Integer, AtomicBoolean> flagMap = new ConcurrentHashMap<Integer, AtomicBoolean>();
    protected final long maxRetriesPerExecute;

    protected AvaticaConnection(UnregisteredDriver driver, AvaticaFactory factory, String url, Properties info) {
        this.id = UUID.randomUUID().toString();
        this.handle = new Meta.ConnectionHandle(this.id);
        this.driver = driver;
        this.factory = factory;
        this.url = url;
        this.info = info;
        this.meta = driver.createMeta(this);
        this.metaData = factory.newDatabaseMetaData(this);
        try {
            this.holdability = this.metaData.getResultSetHoldability();
        }
        catch (SQLException e2) {
            throw new RuntimeException(e2);
        }
        this.maxRetriesPerExecute = this.getNumStatementRetries(info);
    }

    long getNumStatementRetries(Properties props) {
        return Long.valueOf(Objects.requireNonNull(props).getProperty(NUM_EXECUTE_RETRIES_KEY, NUM_EXECUTE_RETRIES_DEFAULT));
    }

    public ConnectionConfig config() {
        return new ConnectionConfigImpl(this.info);
    }

    public void openConnection() {
        this.meta.openConnection(this.handle, Service.OpenConnectionRequest.serializeProperties(this.info));
    }

    @Override
    public AvaticaStatement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, this.holdability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.prepareStatement(sql, 1003, 1007, this.holdability);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setAutoCommit(autoCommit));
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.unbox(this.sync().isAutoCommit(), true);
    }

    @Override
    public void commit() throws SQLException {
        this.meta.commit(this.handle);
    }

    @Override
    public void rollback() throws SQLException {
        this.meta.rollback(this.handle);
    }

    @Override
    public void close() throws SQLException {
        if (!this.closed) {
            this.closed = true;
            try {
                this.meta.closeConnection(this.handle);
                this.driver.handler.onConnectionClose(this);
                if (null != this.kerberosConnection) {
                    this.kerberosConnection.stopRenewalThread();
                }
            }
            catch (RuntimeException e2) {
                throw this.helper.createException("While closing connection", e2);
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setReadOnly(readOnly));
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return this.unbox(this.sync().isReadOnly(), true);
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setCatalog(catalog));
    }

    @Override
    public String getCatalog() {
        return this.sync().getCatalog();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setTransactionIsolation(level));
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return this.unbox(this.sync().getTransactionIsolation(), 0);
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, this.holdability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, this.holdability);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map2) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        if (holdability != 2 && holdability != 1) {
            throw new SQLException("invalid value");
        }
        this.holdability = holdability;
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.holdability;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public AvaticaStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.factory.newStatement(this, null, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            Meta.StatementHandle h = this.meta.prepare(this.handle, sql, -1L);
            return this.factory.newPreparedStatement(this, h, h.signature, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (RuntimeException e2) {
            throw this.helper.createException("while preparing SQL: " + sql, e2);
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        throw this.helper.clientInfo();
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        throw this.helper.clientInfo();
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        SqlType type;
        List<Object> elementList = AvaticaUtils.primitiveList(elements);
        try {
            type = SqlType.valueOf(typeName);
        }
        catch (IllegalArgumentException e2) {
            throw new SQLException("Could not find JDBC type for '" + typeName + "'");
        }
        ColumnMetaData.ScalarType avaticaType = null;
        switch (type) {
            case ARRAY: {
                throw this.helper.createException("Cannot create an ARRAY of ARRAY's");
            }
            case STRUCT: {
                throw this.helper.createException("Cannot create an ARRAY of STRUCT's");
            }
        }
        avaticaType = ColumnMetaData.scalar(type.id, typeName, ColumnMetaData.Rep.nonPrimitiveRepOf(type));
        ArrayFactoryImpl arrayFactory = new ArrayFactoryImpl(this.getTimeZone());
        return arrayFactory.createArray(avaticaType, elementList);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public void setSchema(String schema2) throws SQLException {
        this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl().setSchema(schema2));
    }

    @Override
    public String getSchema() {
        return this.sync().getSchema();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw this.helper.unsupported();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        this.networkTimeout = milliseconds;
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return this.networkTimeout;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isInstance(this)) {
            return iface.cast(this);
        }
        throw this.helper.createException("does not implement '" + iface + "'");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    public TimeZone getTimeZone() {
        String timeZoneName = this.config().timeZone();
        return timeZoneName == null ? TimeZone.getDefault() : TimeZone.getTimeZone(timeZoneName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet executeQueryInternal(AvaticaStatement statement, Meta.Signature signature, Meta.Frame firstFrame, QueryState state, boolean isUpdate) throws SQLException {
        Meta.Frame frame = firstFrame;
        Meta.Signature signature2 = signature;
        AvaticaStatement avaticaStatement = statement;
        synchronized (avaticaStatement) {
            if (statement.openResultSet != null) {
                AvaticaResultSet rs = statement.openResultSet;
                statement.openResultSet = null;
                try {
                    rs.close();
                }
                catch (Exception e2) {
                    throw this.helper.createException("Error while closing previous result set", e2);
                }
            }
            try {
                if (statement.isWrapperFor(AvaticaPreparedStatement.class)) {
                    AvaticaPreparedStatement pstmt = (AvaticaPreparedStatement)statement;
                    Meta.StatementHandle handle = pstmt.handle;
                    if (isUpdate) {
                        handle = new Meta.StatementHandle(handle.connectionId, handle.id, null);
                    }
                    Meta.ExecuteResult executeResult = this.meta.execute(handle, pstmt.getParameterValues(), statement.getFetchSize());
                    Meta.MetaResultSet metaResultSet = executeResult.resultSets.get(0);
                    frame = metaResultSet.firstFrame;
                    statement.updateCount = metaResultSet.updateCount;
                    signature2 = executeResult.resultSets.get((int)0).signature;
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
                throw this.helper.createException(e3.getMessage(), e3);
            }
            TimeZone timeZone = this.getTimeZone();
            statement.openResultSet = frame == null && signature2 == null && statement.updateCount != -1L ? null : this.factory.newResultSet(statement, state, signature2, timeZone, frame);
        }
        try {
            if (statement.openResultSet != null) {
                statement.openResultSet.execute();
                this.isUpdateCapable(statement);
            }
        }
        catch (Exception e4) {
            throw this.helper.createException("exception while executing query: " + e4.getMessage(), e4);
        }
        return statement.openResultSet;
    }

    protected long[] executeBatchUpdateInternal(AvaticaPreparedStatement pstmt) throws SQLException {
        try {
            Meta.StatementHandle handle = pstmt.handle;
            return this.meta.executeBatch((Meta.StatementHandle)handle, pstmt.getParameterValueBatch()).updateCounts;
        }
        catch (Exception e2) {
            throw this.helper.createException(e2.getMessage(), e2);
        }
    }

    private void isUpdateCapable(AvaticaStatement statement) throws SQLException {
        Meta.Signature signature = statement.getSignature();
        if (signature == null || signature.statementType == null) {
            return;
        }
        if (signature.statementType.canUpdate() && statement.updateCount == -1L) {
            statement.openResultSet.next();
            Object obj = statement.openResultSet.getObject(ROWCOUNT_COLUMN_NAME);
            if (obj instanceof Number) {
                statement.updateCount = ((Number)obj).intValue();
            } else if (obj instanceof List) {
                List numbers = (List)obj;
                statement.updateCount = ((Number)numbers.get(0)).intValue();
            } else {
                throw this.helper.createException("Not a valid return result.");
            }
            statement.openResultSet = null;
        }
    }

    protected Meta.ExecuteResult prepareAndExecuteInternal(final AvaticaStatement statement, final String sql, long maxRowCount) throws SQLException, NoSuchStatementException {
        Meta.PrepareCallback callback = new Meta.PrepareCallback(){

            @Override
            public Object getMonitor() {
                return statement;
            }

            @Override
            public void clear() throws SQLException {
                if (statement.openResultSet != null) {
                    AvaticaResultSet rs = statement.openResultSet;
                    statement.openResultSet = null;
                    try {
                        rs.close();
                    }
                    catch (Exception e2) {
                        throw AvaticaConnection.this.helper.createException("Error while closing previous result set", e2);
                    }
                }
            }

            @Override
            public void assign(Meta.Signature signature, Meta.Frame firstFrame, long updateCount) throws SQLException {
                statement.setSignature(signature);
                if (updateCount != -1L) {
                    statement.updateCount = updateCount;
                } else {
                    TimeZone timeZone = AvaticaConnection.this.getTimeZone();
                    statement.openResultSet = AvaticaConnection.this.factory.newResultSet(statement, new QueryState(sql), signature, timeZone, firstFrame);
                }
            }

            @Override
            public void execute() throws SQLException {
                if (statement.openResultSet != null) {
                    statement.openResultSet.execute();
                    AvaticaConnection.this.isUpdateCapable(statement);
                }
            }
        };
        return this.meta.prepareAndExecute(statement.handle, sql, maxRowCount, AvaticaUtils.toSaturatedInt(maxRowCount), callback);
    }

    protected Meta.ExecuteBatchResult prepareAndUpdateBatch(AvaticaStatement statement, List<String> queries) throws NoSuchStatementException, SQLException {
        return this.meta.prepareAndExecuteBatch(statement.handle, queries);
    }

    protected ResultSet createResultSet(Meta.MetaResultSet metaResultSet, QueryState state) throws SQLException {
        Meta.StatementHandle h = new Meta.StatementHandle(metaResultSet.connectionId, metaResultSet.statementId, null);
        AvaticaStatement statement = this.lookupStatement(h);
        ResultSet resultSet = this.executeQueryInternal(statement, metaResultSet.signature.sanitize(), metaResultSet.firstFrame, state, false);
        if (metaResultSet.ownStatement) {
            resultSet.getStatement().closeOnCompletion();
        }
        return resultSet;
    }

    protected AvaticaStatement lookupStatement(Meta.StatementHandle h) throws SQLException {
        AvaticaStatement statement = this.statementMap.get(h.id);
        if (statement != null) {
            return statement;
        }
        return this.factory.newStatement(this, Objects.requireNonNull(h), 1003, 1007, this.holdability);
    }

    protected static Trojan createTrojan() {
        return new Trojan();
    }

    private boolean unbox(Boolean b, boolean defaultValue) {
        return b == null ? defaultValue : b;
    }

    private int unbox(Integer i, int defaultValue) {
        return i == null ? defaultValue : i;
    }

    private Meta.ConnectionProperties sync() {
        return this.meta.connectionSync(this.handle, new ConnectionPropertiesImpl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AtomicBoolean getCancelFlag(Meta.StatementHandle h) throws NoSuchStatementException {
        AvaticaUtils.upgrade("after dropping JDK 1.7, use Map.computeIfAbsent");
        Map<Integer, AtomicBoolean> map2 = this.flagMap;
        synchronized (map2) {
            AtomicBoolean b = this.flagMap.get(h.id);
            if (b == null) {
                b = new AtomicBoolean();
                this.flagMap.put(h.id, b);
            }
            return b;
        }
    }

    public <T> T invokeWithRetries(CallableWithoutException<T> callable) {
        AvaticaClientRuntimeException lastException = null;
        int i = 0;
        while ((long)i < this.maxRetriesPerExecute) {
            try {
                return callable.call();
            }
            catch (AvaticaClientRuntimeException e2) {
                lastException = e2;
                if (1 != e2.getErrorCode()) {
                    throw e2;
                }
                this.openConnection();
                ++i;
            }
        }
        if (null != lastException) {
            throw lastException;
        }
        throw new IllegalStateException();
    }

    public void setKerberosConnection(KerberosConnection kerberosConnection) {
        this.kerberosConnection = Objects.requireNonNull(kerberosConnection);
    }

    public KerberosConnection getKerberosConnection() {
        return this.kerberosConnection;
    }

    public Service getService() {
        assert (null != this.service);
        return this.service;
    }

    public void setService(Service service) {
        this.service = Objects.requireNonNull(service);
    }

    public static interface CallableWithoutException<T> {
        public T call();
    }

    public static class Trojan {
        private Trojan() {
        }

        public ResultSet execute(AvaticaResultSet resultSet) throws SQLException {
            return resultSet.execute();
        }

        public List<TypedValue> getParameterValues(AvaticaStatement statement) {
            return statement.getParameterValues();
        }

        public Meta getMeta(AvaticaConnection connection) {
            return connection.meta;
        }
    }
}

